/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.support.gui.guilib.infra;

import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.border.EtchedBorder;
import se.ericsson.wcdma.support.gui.guilib.infra.ApplicationDefaultView;

class ApplicationToolBar
extends JToolBar {
    private ToolBarComponent[] compArray;
    private ApplicationDefaultView defaultView;

    void dispose() {
        this.defaultView = null;
    }

    ApplicationToolBar(ApplicationDefaultView applicationDefaultView) {
        this.defaultView = applicationDefaultView;
        this.setBorderPainted(true);
        this.setBorder(new EtchedBorder());
        JComponent[] jComponentArray = applicationDefaultView.getToolBarComponents();
        if (jComponentArray.length > 0) {
            this.compArray = new ToolBarComponent[jComponentArray.length];
            for (int i = 0; i < jComponentArray.length; ++i) {
                this.compArray[i] = new ToolBarComponent(jComponentArray[i], true);
            }
        }
        this.buildToolBar();
    }

    void setComponentsVisible(JComponent[] jComponentArray, boolean bl) {
        block0: for (int i = 0; i < jComponentArray.length; ++i) {
            for (int j = 0; j < this.compArray.length; ++j) {
                ToolBarComponent toolBarComponent = this.compArray[j];
                if (toolBarComponent.getComponent() != jComponentArray[i]) continue;
                toolBarComponent.setVisible(bl);
                continue block0;
            }
        }
        this.buildToolBar();
    }

    private void buildToolBar() {
        if (this.compArray == null) {
            return;
        }
        this.removeAll();
        for (int i = 0; i < this.compArray.length; ++i) {
            if (!this.compArray[i].isVisible()) continue;
            this.compArray[i].getComponent().setRequestFocusEnabled(false);
            this.add(this.compArray[i].getComponent());
        }
    }

    JComponent getCutButton() {
        return this.defaultView.getCutButton();
    }

    JComponent getCopyButton() {
        return this.defaultView.getCopyButton();
    }

    JComponent getPasteButton() {
        return this.defaultView.getPasteButton();
    }

    public boolean isFocusTraversable() {
        return false;
    }

    private static class ToolBarComponent {
        private JComponent comp;
        private boolean visible;

        public ToolBarComponent(JComponent jComponent, boolean bl) {
            this.comp = jComponent;
            this.visible = bl;
        }

        public JComponent getComponent() {
            return this.comp;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean bl) {
            this.visible = bl;
        }
    }
}

