/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.managedelement;

import se.ericsson.cello.managedelement.DataCollectionGenerationMoFactory;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.pri.LongSystemParameter;
import se.ericsson.cello.pri.PriJavaProxy;
import se.ericsson.cello.pri.PriJavaProxyFactory;
import se.ericsson.cello.pri.PriProcessNotFoundException;
import se.ericsson.cello.pri.SystemParameterNotFoundException;
import se.ericsson.cello.pri.WrongSystemParameterTypeException;
import se.ericsson.cello.support.debug.MessageLog;

public class DataCollectionGenerationMoFactoryImpl
extends DataCollectionGenerationMoFactory {
    protected DataCollectionGenerationMoFactoryImpl(FroProxy froProxy) {
        super(froProxy);
    }

    public ManagedObject getMo() {
        if (!this.isRbsNode()) {
            return null;
        }
        if (this.dataCollectionGenerationMo == null) {
            MoIterator moIterator = this.initialMaoContext.getMoAccessor().lookupType("DataCollectionGeneration");
            if (moIterator == null || !moIterator.hasMoreElements()) {
                this.createMo();
            } else {
                this.dataCollectionGenerationMo = moIterator.nextMo();
            }
        }
        return this.dataCollectionGenerationMo;
    }

    private boolean isRbsNode() {
        int n = -1;
        int n2 = 1;
        try {
            PriJavaProxy priJavaProxy = PriJavaProxyFactory.createPriJavaProxy();
            if (priJavaProxy != null) {
                LongSystemParameter longSystemParameter = priJavaProxy.getLongSystemParameter((long)n2);
                if (longSystemParameter != null && longSystemParameter.isValid()) {
                    n = (int)longSystemParameter.getValue();
                    MessageLog.info(this.getClass(), (String)("Using system parameter " + n2 + ", System parameter value" + " = " + n));
                }
            } else {
                MessageLog.info(this.getClass(), (String)"No PriJavaProxy available,using default value ");
            }
        }
        catch (WrongSystemParameterTypeException wrongSystemParameterTypeException) {
            MessageLog.info(this.getClass(), (String)("Parameter " + n2 + " has wrong type, using default value"));
        }
        catch (SystemParameterNotFoundException systemParameterNotFoundException) {
            MessageLog.info(this.getClass(), (String)("Parameter " + n2 + " not found, using default value"));
        }
        catch (PriProcessNotFoundException priProcessNotFoundException) {
            MessageLog.info(this.getClass(), (String)("Parameter " + n2 + " not found, using default value"));
        }
        return n == 0;
    }
}

