/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.managedelement;

import enea.ose.system.Signal;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.StringTokenizer;
import java.util.TimeZone;
import se.ericsson.cello.ipoam.IpMo;
import se.ericsson.cello.managedelement.AutoConfigurationObserver;
import se.ericsson.cello.managedelement.ManagedElementDataMo;
import se.ericsson.cello.managedelement.ManagedElementMoImpl;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.managedelement.NtpServerMo;
import se.ericsson.cello.managedelement.PfmUnitBuildIF;
import se.ericsson.cello.managedelement.SlotBuildIF;
import se.ericsson.cello.managedelement.TimeSettingMo;
import se.ericsson.cello.managedelement.fropxy.OsaMeGetDiskDataRsp;
import se.ericsson.cello.managedelement.fropxy.OsaMeGetDiskLimitRsp;
import se.ericsson.cello.managedelement.fropxy.OsaMeGetPiuGroupEscTypeRsp;
import se.ericsson.cello.managedelement.fropxy.OsaMeMgmntProxy;
import se.ericsson.cello.managedelement.fropxy.OsaMeSetDiskLimitRsp;
import se.ericsson.cello.managedelement.fropxy.OsaMeSetPiuGroupEscTypeRsp;
import se.ericsson.cello.managedelement.meaccess.AutoConfigurationCvHandlerAccess;
import se.ericsson.cello.managedelement.meaccess.SystemUpgradeAgent;
import se.ericsson.cello.managedelement.suaccess.ManagedElementDataMoSU_Access;
import se.ericsson.cello.mao.ActionNotAllowedException;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.mao.IpAddressValidation;
import se.ericsson.cello.mao.Ipv4AddressValidation;
import se.ericsson.cello.mao.Ipv6AddressValidation;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.NoDiskException;
import se.ericsson.cello.mao.OperationNotAllowedException;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.BooleanAttribute;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.nia.NIAAddressInfo;
import se.ericsson.cello.nia.NIAListener;
import se.ericsson.cello.nia.NIAMgr;
import se.ericsson.cello.nia.NIAMgrFactory;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.support.util.ExceptionHelper;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.Resource;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.transaction.TransactionServiceImpl;

public class ManagedElementDataMoImpl
extends CelloMao
implements ManagedElementDataMo,
ManagedElementDataMoSU_Access {
    private MoData data;
    private BooleanAttribute autoConfigurationAllowed;
    private BooleanAttribute daylightSavingTime;
    private StringAttribute documentServerAddress;
    private StringAttribute logonServerAddress;
    private StringAttribute nodeLocalTimeZone;
    private StringAttribute nodeUniqueID;
    private StringAttribute swServerUrlList;
    private StringAttribute docLibUserDefined;
    private StringAttribute docLibSystemSettable;
    private static final String managedElementDataId = "1";
    private static final int PRIMARY = 0;
    private static final int SECONDARY = 1;
    private static final int THIRD = 2;
    public static final String DOC_LIB_SYSTEM_DEFINED = "docLibSystemDefined";
    public static final String DOC_LIB_USER_DEFINED = "docLibUserDefined";
    public static final String DOC_LIB_SYSTEM_SETTABLE = "docLibSystemSettable";
    private static final int FREESPACE_LIMIT_MIN = 0;
    private static final int FREESPACE_LIMIT_MAX = 999;
    private static final int DEFAULT_NTP_MAX_POLL = 1024;
    private static final int DEFAULT_NTP_MIN_POLL = 64;
    private static final String DEFAULT_NTP_SERVER_ADDRESS = "0.0.0.0";
    private static final int COLD_AT_PIU_FAULT = 1;
    private static final int WARM_AT_PIU_RESTART = 4;
    private static final int NONE = 0;
    private static final int AUTO_CV = 1;
    private static final int AUTO_CONFIG = 2;
    private static final int RETRY_INTERVAL = 1000;
    protected static final String CMA_AUTOCONFIG_SLOT_SCAN_THREAD = "Cma_AutoConfig_Slot_Scan_Thread";
    private static final String CMA_AUTOCONFIG_CV_THREAD = "Cma_AutoConfig_CV_Thread";
    private static final String SLS_CONFIG_FILE = "/c/configuration/sls_address.cfg";
    private static final String SWSERVER_ADDRESS_FILE = "/c/configuration/swserver_address.cfg";
    private static final int NTP_PRIMARY = 1;
    private static final int NTP_SECONDARY = 2;
    private static final int NTP_THIRD = 3;
    private static ManagedElementDataMoImpl instance = null;
    private Coordinator coordinator = null;
    private TxResource txResource = null;
    private OsaMeMgmntProxy meProxy = OsaMeMgmntProxy.instance();
    private static NotificationSender notificationSender = NotificationSender.instance();
    private static final String[] SUPPORTED_VERSIONS = new String[]{"SU_1", "SU_2"};
    private static final int MO_DATA_REVISION_7 = 7000;
    private static final int MO_DATA_REVISION_LATEST = 7000;

    public static synchronized ManagedElementDataMoImpl instance() {
        try {
            if (instance == null) {
                instance = new ManagedElementDataMoImpl();
            }
        }
        catch (MoNameAlreadyTakenException moNameAlreadyTakenException) {
            MessageLog.traceError((Class)ManagedElementDataMoImpl.class, (String)"Create instance of ManagedElementData MO failed", (Throwable)moNameAlreadyTakenException);
        }
        return instance;
    }

    private ManagedElementDataMoImpl() throws MoNameAlreadyTakenException {
        super((ManagedObject)ManagedElementMoImpl.instance(), "ManagedElementData", managedElementDataId, null);
        ServiceLocatorFacade.getRepository().addService((Object)this, ManagedElementDataMoSU_Access.class, null);
    }

    synchronized void registerData() {
        if (this.data == null) {
            try {
                TransactionFactory transactionFactory = TransactionServiceImpl.instance().getTransactionFactory();
                Control control = transactionFactory.create(3600);
                Coordinator coordinator = control.getCoordinator();
                MessageLog.trace((int)5, this.getClass(), (String)("Cello_CMA txId = " + coordinator.getTransactionID() + ", timeout = 3600 sec"));
                this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
                this.autoConfigurationAllowed = new BooleanAttribute("autoConfigurationAllowed", true, true);
                this.data.registerPersistentAttr((Attribute)this.autoConfigurationAllowed);
                this.documentServerAddress = new StringAttribute("documentServerAddress", true);
                this.data.registerPersistentAttr((Attribute)this.documentServerAddress);
                this.logonServerAddress = new StringAttribute("logonServerAddress", true);
                this.data.registerPersistentAttr((Attribute)this.logonServerAddress);
                TimeZone timeZone = TimeZone.getDefault();
                this.nodeLocalTimeZone = new StringAttribute("nodeLocalTimeZone", true, timeZone.getID());
                this.data.registerPersistentAttr((Attribute)this.nodeLocalTimeZone);
                this.daylightSavingTime = new BooleanAttribute("daylightSavingTime", true, false);
                this.data.registerPersistentAttr((Attribute)this.daylightSavingTime);
                this.nodeUniqueID = new StringAttribute("nodeUniqueID", false, "");
                this.data.registerPersistentAttr((Attribute)this.nodeUniqueID);
                this.docLibUserDefined = new StringAttribute(DOC_LIB_USER_DEFINED, true, "");
                this.data.registerPersistentAttr((Attribute)this.docLibUserDefined);
                this.docLibSystemSettable = new StringAttribute(DOC_LIB_SYSTEM_SETTABLE, false, "");
                this.data.registerPersistentAttr((Attribute)this.docLibSystemSettable);
                this.swServerUrlList = new StringAttribute("swServerUrlList", true);
                this.data.registerPersistentAttr((Attribute)this.swServerUrlList);
                this.data.setRevision(7000);
                this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
                control.getTerminator().commit();
            }
            catch (TransactionRequiredException transactionRequiredException) {
                MessageLog.traceError(this.getClass(), (String)"start of ManagedElementData failed", (Throwable)transactionRequiredException);
            }
            catch (TransactionRolledBackException transactionRolledBackException) {
                MessageLog.traceError(this.getClass(), (String)"start of ManagedElementData failed", (Throwable)transactionRolledBackException);
            }
            catch (InactiveTransactionException inactiveTransactionException) {
                MessageLog.traceError(this.getClass(), (String)"start of ManagedElementData failed", (Throwable)inactiveTransactionException);
            }
            catch (MoAccessException moAccessException) {
                MessageLog.traceError(this.getClass(), (String)"start of ManagedElementData failed", (Throwable)moAccessException);
            }
        }
    }

    synchronized void recover(MoData moData) {
        this.data = moData;
        File file = new File("/c");
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, this);
        moDataRecoveryHelper.assertMoDataRevision(7000);
        moDataRecoveryHelper.assertAttribute("autoConfigurationAllowed");
        moDataRecoveryHelper.assertAttribute("documentServerAddress");
        moDataRecoveryHelper.assertAttribute("logonServerAddress");
        moDataRecoveryHelper.assertAttribute("nodeLocalTimeZone");
        moDataRecoveryHelper.assertAttribute("daylightSavingTime");
        moDataRecoveryHelper.assertAttribute("swServerUrlList");
        moDataRecoveryHelper.assertAttribute("nodeUniqueID");
        moDataRecoveryHelper.assertAttribute(DOC_LIB_USER_DEFINED);
        moDataRecoveryHelper.assertAttribute(DOC_LIB_SYSTEM_SETTABLE);
        this.autoConfigurationAllowed = (BooleanAttribute)moData.getAttribute("autoConfigurationAllowed");
        this.documentServerAddress = (StringAttribute)moData.getAttribute("documentServerAddress");
        this.getSlsFile(file);
        this.nodeLocalTimeZone = (StringAttribute)moData.getAttribute("nodeLocalTimeZone");
        this.daylightSavingTime = (BooleanAttribute)moData.getAttribute("daylightSavingTime");
        this.swServerUrlList = (StringAttribute)moData.getAttribute("swServerUrlList");
        this.nodeUniqueID = (StringAttribute)moData.getAttribute("nodeUniqueID");
        this.docLibUserDefined = (StringAttribute)moData.getAttribute(DOC_LIB_USER_DEFINED);
        this.docLibSystemSettable = (StringAttribute)moData.getAttribute(DOC_LIB_SYSTEM_SETTABLE);
        TimeZone timeZone = TimeZone.getDefault();
        timeZone.setID(this.nodeLocalTimeZone.getValue(null));
        TimeZone.setDefault(timeZone);
        try {
            if (System.getProperty("SIM") == null && file.exists()) {
                PrintWriter printWriter = null;
                printWriter = new PrintWriter(new BufferedWriter(new FileWriter(SWSERVER_ADDRESS_FILE)));
                printWriter.print(this.swServerUrlList.getValue(null));
                printWriter.close();
            }
        }
        catch (IOException iOException) {
            MessageLog.info(this.getClass(), (String)" Failed to write to file: /c/configuration/swserver_address.cfg");
        }
    }

    public void subscribeForNodeIpAddressChange() {
        NIASubscriber nIASubscriber = new NIASubscriber(this);
        nIASubscriber.subscribe();
    }

    public void writeSlsAddressCfgFile(File file, String string) {
        String string2 = SLS_CONFIG_FILE;
        try {
            Object object;
            if (System.getProperty("SIM") != null) {
                object = System.getProperty("oms.javasim.root.dir", "/host");
                file = new File((String)object);
                string2 = (String)object + "/sls_address.cfg";
            }
            while (!file.exists()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    MessageLog.traceError(this.getClass(), (String)"Thread interupted", (Throwable)interruptedException);
                }
            }
            object = null;
            object = new PrintWriter(new BufferedWriter(new FileWriter(string2)));
            MoIterator moIterator = MoRepository.instance().lookupType("Ip");
            String string3 = "";
            String string4 = "";
            if (moIterator != null && moIterator.hasMoreElements()) {
                IpMo ipMo = (IpMo)moIterator.nextElement();
                try {
                    string3 = ipMo.getNodeIpAddress(null);
                    string4 = ipMo.getNodeIpv6Address(null);
                }
                catch (MoAccessException moAccessException) {
                    MessageLog.info(this.getClass(), (String)" Failed to getNode from IpMo ");
                }
                if (!string3.equals("") && string4.equals("")) {
                    string = string + ",https://" + string3 + ":8443/sls" + ",https://" + string3 + ":8443/sls";
                } else if (string3.equals("") && !string4.equals("")) {
                    string = string + ",https://[" + string4 + "]:8443/sls" + ",https://[" + string4 + "]:8443/sls";
                } else if (!string3.equals("") && !string4.equals("")) {
                    string = string + ",https://" + string3 + ":8443/sls" + ",https://[" + string4 + "]:8443/sls";
                }
            } else if (Ipv6AddressValidation.isIpv6((String)Inet6Address.getLocalHost().getHostAddress())) {
                string = string + ",https://" + InetAddress.getLocalHost().getHostAddress() + ":8443/sls" + ",https://[" + Inet6Address.getLocalHost().getHostAddress() + "]:8443/sls";
            } else if (Ipv4AddressValidation.isIpv4((String)Inet6Address.getLocalHost().getHostAddress())) {
                string = string + ",https://" + InetAddress.getLocalHost().getHostAddress() + ":8443/sls" + ",https://" + InetAddress.getLocalHost().getHostAddress() + ":8443/sls";
            }
            ((PrintWriter)object).print(string);
            ((PrintWriter)object).close();
        }
        catch (IOException iOException) {
            MessageLog.info(this.getClass(), (String)(" Failed to write to file: " + string2));
        }
    }

    private void getSlsFile(File file) {
        String string = SLS_CONFIG_FILE;
        try {
            Object object;
            if (System.getProperty("SIM") != null) {
                object = System.getProperty("oms.javasim.root.dir", "/host");
                file = new File((String)object);
                string = (String)object + "/sls_address.cfg";
            }
            while (!file.exists()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    MessageLog.traceError(this.getClass(), (String)"Thread interupted", (Throwable)interruptedException);
                }
            }
            object = new File(string);
            if (!((File)object).exists()) {
                this.logonServerAddress = (StringAttribute)this.data.getAttribute("logonServerAddress");
                return;
            }
            this.logonServerAddress = new StringAttribute("logonServerAddress", true);
            String string2 = "";
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string3 = bufferedReader.readLine();
            if (string3 != null) {
                String string4 = string3.substring(0, string3.lastIndexOf(","));
                string2 = string4.substring(0, string4.lastIndexOf(","));
                this.logonServerAddress.setValue(string2);
            } else {
                this.logonServerAddress.setValue(string2);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            this.logonServerAddress = (StringAttribute)this.data.getAttribute("logonServerAddress");
            MessageLog.info(this.getClass(), (String)("Failed to read slsConfig file: " + exception.toString() + ExceptionHelper.stackToString((StackTraceElement[])exception.getStackTrace())));
        }
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        throw new UndeletableMoException((ManagedObject)this);
    }

    public String[] getSupportedVersions() {
        return SUPPORTED_VERSIONS;
    }

    public int getAutoConfigurationStatus(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return AutoConfigurationObserver.getAutoConfigurationStatus();
    }

    public boolean getAutoConfigurationAllowed(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.autoConfigurationAllowed.getValue(coordinator);
    }

    public boolean getAutoConfigurationAllowedForSU(Coordinator coordinator) throws MoAccessException {
        return this.getAutoConfigurationAllowed(coordinator);
    }

    public void setAutoConfigurationAllowedWithoutCreatingCV(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.setAutoConfiguration(false, bl, coordinator);
    }

    public void setAutoConfigurationAllowed(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.setAutoConfiguration(true, bl, coordinator);
    }

    public String getDocumentServerAddress(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.documentServerAddress.getValue(coordinator);
    }

    public synchronized void setDocumentServerAddress(String string, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.documentServerAddress.setValue(string);
    }

    public synchronized void setDocLibUserDefined(String string, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.docLibUserDefined.setValue(string);
    }

    public synchronized void setDocLibSystemSettable(String string, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.docLibSystemSettable.setValue(string);
    }

    public String getLogonServerAddress(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.logonServerAddress.getValue(coordinator);
    }

    public synchronized void setLogonServerAddress(String string, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String string2 = null;
        if (string.equals("")) {
            this.logonServerAddress.setValue(string);
            this.writeSlsAddressCfgFile(new File("/c"), string);
        } else {
            string2 = this.checkSlsAddresses(string);
            this.logonServerAddress.setValue(string2);
            this.writeSlsAddressCfgFile(new File("/c"), string2);
        }
    }

    private String checkSlsAddresses(String string) throws MoAccessException {
        if (string.equals("")) {
            return string;
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = stringTokenizer.countTokens();
        if (n > 3) {
            throw new IllegalAttributeValueException("More then 3 logonServerAddresses is not acceptable", "logonServerAddress", "ManagedElementData");
        }
        while (stringTokenizer.hasMoreElements()) {
            linkedHashSet.add(stringTokenizer.nextToken());
        }
        String[] stringArray = linkedHashSet.toArray(new String[linkedHashSet.size()]);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.checklogonServersValue(stringArray[0], "logonServerAddress"));
        for (int i = 1; i < stringArray.length; ++i) {
            String string2 = this.checklogonServersValue(stringArray[i], "logonServerAddress");
            stringBuffer.append(",");
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private String checkslsServersValue(String string, String string2) throws MoAccessException {
        String string3 = null;
        String string4 = "http://";
        String string5 = "https://";
        String string6 = "ftp://";
        if (string.startsWith(string5)) {
            string3 = string.substring(8);
        } else if (string.startsWith(string4)) {
            string3 = string.substring(7);
        } else if (string.startsWith(string6)) {
            string3 = string.substring(6);
        } else {
            throw new IllegalAttributeValueException(string2 + " has to start with http:// or https:// or ftp://", string2, "ManagedElementData");
        }
        IpAddressValidation.validateServerURL((String)string3, (String)string2, (String)"ManagedElementData");
        return string;
    }

    private String checklogonServersValue(String string, String string2) throws MoAccessException {
        String string3 = null;
        String string4 = "http://";
        String string5 = "https://";
        if (string.startsWith(string5)) {
            string3 = string.substring(8);
        } else if (string.startsWith(string4)) {
            string3 = string.substring(7);
        } else {
            throw new IllegalAttributeValueException(string2 + " has to start with http:// or https:// ", string2, "ManagedElementData");
        }
        IpAddressValidation.validateServerURL((String)string3, (String)string2, (String)"ManagedElementData");
        return string;
    }

    public int getHdVolumeCSize(Coordinator coordinator) throws MoAccessException {
        OsaMeGetDiskDataRsp osaMeGetDiskDataRsp = this.retrieveFroAttributes(coordinator);
        return osaMeGetDiskDataRsp.getTotalSizeC();
    }

    public int getHdVolumeCFreespace(Coordinator coordinator) throws MoAccessException {
        OsaMeGetDiskDataRsp osaMeGetDiskDataRsp = this.retrieveFroAttributes(coordinator);
        return osaMeGetDiskDataRsp.getFreeSpaceC();
    }

    public long getHdVolumeCSizeExt(Coordinator coordinator) throws MoAccessException {
        OsaMeGetDiskDataRsp osaMeGetDiskDataRsp = this.retrieveFroAttributes(coordinator);
        return osaMeGetDiskDataRsp.getTotalSizeCExt();
    }

    public long getHdVolumeCFreespaceExt(Coordinator coordinator) throws MoAccessException {
        OsaMeGetDiskDataRsp osaMeGetDiskDataRsp = this.retrieveFroAttributes(coordinator);
        return osaMeGetDiskDataRsp.getFreeSpaceCExt();
    }

    public String getNodeUniqueID(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.nodeUniqueID.getValue(coordinator);
    }

    public String getDocLibUserDefined(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.docLibUserDefined.getValue(coordinator);
    }

    public String getDocLibSystemDefined(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.docLibSystemSettable.getValue(coordinator);
    }

    public String getNodeLocalTimeZone(Coordinator coordinator) throws MoAccessException {
        TimeZone timeZone = TimeZone.getDefault();
        String string = timeZone.getID();
        if (string.equals(this.nodeLocalTimeZone.getValue(null))) {
            return string;
        }
        return this.nodeLocalTimeZone.getValue(null);
    }

    public void setNodeLocalTimeZone(String string, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        TimeZone timeZone = TimeZone.getDefault();
        if (string.length() == 3) {
            String[] stringArray = TimeZone.getAvailableIDs();
            String[] stringArray2 = new String[]{"AFT", "MMT", "VET", "MET", "AET", "EET", "MET", "CAT", "AGT", "IET", "ACT", "PNT", "EST", "SST"};
            String[] stringArray3 = this.combineArrays(stringArray, stringArray2);
            for (int i = 0; i < stringArray3.length; ++i) {
                if (!string.equals(stringArray3[i])) continue;
                timeZone.setID(string);
                TimeZone.setDefault(timeZone);
                this.nodeLocalTimeZone.setValue(string);
                return;
            }
            throw new ValueOutOfRangeException("nodeLocalTimeZone", "ManagedElementData");
        }
        if (string.length() == 6 && (string.charAt(0) == '+' || string.charAt(0) == '-') && string.charAt(3) == ':') {
            String string2 = string.substring(1, 3);
            int n = Integer.parseInt(string2);
            String string3 = string.substring(4, 6);
            int n2 = Integer.parseInt(string3);
            if (n < 24 && n2 < 60) {
                this.nodeLocalTimeZone.setValue(string);
                return;
            }
        }
        throw new ValueOutOfRangeException("nodeLocalTimeZone", "ManagedElementData");
    }

    private String[] combineArrays(String[] stringArray, String[] stringArray2) {
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        return stringArray3;
    }

    public String getNtpServerAddressPrimary(Coordinator coordinator) throws MoAccessException {
        return this.getNtpServerAddress(1, coordinator);
    }

    public void setNtpServerAddressPrimary(String string, Coordinator coordinator) throws MoAccessException {
        String string2 = this.checkIfIpAddressIsEmptyString(string);
        this.setNtpServerAddress(1, string2, coordinator);
        String[] stringArray = new String[]{"ntpServerAddressPrimary"};
        Object[] objectArray = new Object[]{string2};
        notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public boolean getNtpServiceActivePrimary(Coordinator coordinator) throws MoAccessException {
        return this.getNtpServiceActive(1, coordinator);
    }

    public void setNtpServiceActivePrimary(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.setNtpServiceActive(bl, 1, coordinator);
        String[] stringArray = new String[]{"ntpServiceActivePrimary"};
        Object[] objectArray = new Object[]{bl};
        notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public int getNtpMinPollPrimary(Coordinator coordinator) throws MoAccessException {
        return 64;
    }

    public void setNtpMinPollPrimary(int n, Coordinator coordinator) throws MoAccessException {
    }

    public int getNtpMaxPollPrimary(Coordinator coordinator) throws MoAccessException {
        return 1024;
    }

    public void setNtpMaxPollPrimary(int n, Coordinator coordinator) throws MoAccessException {
    }

    public boolean getNtpBurstFlagPrimary(Coordinator coordinator) throws MoAccessException {
        return false;
    }

    public void setNtpBurstFlagPrimary(boolean bl, Coordinator coordinator) throws MoAccessException {
    }

    public String getNtpServerAddressSecondary(Coordinator coordinator) throws MoAccessException {
        return this.getNtpServerAddress(2, coordinator);
    }

    public void setNtpServerAddressSecondary(String string, Coordinator coordinator) throws MoAccessException {
        String string2 = this.checkIfIpAddressIsEmptyString(string);
        this.setNtpServerAddress(2, string2, coordinator);
        String[] stringArray = new String[]{"ntpServerAddressSecondary"};
        Object[] objectArray = new Object[]{string2};
        notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public boolean getNtpServiceActiveSecondary(Coordinator coordinator) throws MoAccessException {
        return this.getNtpServiceActive(2, coordinator);
    }

    public void setNtpServiceActiveSecondary(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.setNtpServiceActive(bl, 2, coordinator);
        String[] stringArray = new String[]{"ntpServiceActiveSecondary"};
        Object[] objectArray = new Object[]{bl};
        notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public int getNtpMinPollSecondary(Coordinator coordinator) throws MoAccessException {
        return 64;
    }

    public void setNtpMinPollSecondary(int n, Coordinator coordinator) throws MoAccessException {
    }

    public int getNtpMaxPollSecondary(Coordinator coordinator) throws MoAccessException {
        return 1024;
    }

    public void setNtpMaxPollSecondary(int n, Coordinator coordinator) throws MoAccessException {
    }

    public boolean getNtpBurstFlagSecondary(Coordinator coordinator) throws MoAccessException {
        return false;
    }

    public void setNtpBurstFlagSecondary(boolean bl, Coordinator coordinator) throws MoAccessException {
    }

    public String getNtpServerAddressThird(Coordinator coordinator) throws MoAccessException {
        return this.getNtpServerAddress(3, coordinator);
    }

    public void setNtpServerAddressThird(String string, Coordinator coordinator) throws MoAccessException {
        String string2 = this.checkIfIpAddressIsEmptyString(string);
        this.setNtpServerAddress(3, string2, coordinator);
        String[] stringArray = new String[]{"ntpServerAddressThird"};
        Object[] objectArray = new Object[]{string};
        notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public boolean getNtpServiceActiveThird(Coordinator coordinator) throws MoAccessException {
        return this.getNtpServiceActive(3, coordinator);
    }

    public void setNtpServiceActiveThird(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.setNtpServiceActive(bl, 3, coordinator);
        String[] stringArray = new String[]{"ntpServiceActiveThird"};
        Object[] objectArray = new Object[]{bl};
        notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public int getNtpMinPollThird(Coordinator coordinator) throws MoAccessException {
        return 64;
    }

    public void setNtpMinPollThird(int n, Coordinator coordinator) throws MoAccessException {
    }

    public int getNtpMaxPollThird(Coordinator coordinator) throws MoAccessException {
        return 1024;
    }

    public void setNtpMaxPollThird(int n, Coordinator coordinator) throws MoAccessException {
    }

    public boolean getNtpBurstFlagThird(Coordinator coordinator) throws MoAccessException {
        return false;
    }

    public void setNtpBurstFlagThird(boolean bl, Coordinator coordinator) throws MoAccessException {
    }

    public long getNodeUTCTime(Coordinator coordinator) throws MoAccessException {
        TimeSettingMo timeSettingMo = this.getTimeSetting();
        long l = timeSettingMo.getNodeUTCTime(coordinator);
        return l;
    }

    public void setNodeUTCTime(long l, Coordinator coordinator) throws MoAccessException, ActionNotAllowedException {
        TimeSettingMo timeSettingMo = this.getTimeSetting();
        timeSettingMo.actionSetNodeUTCTime(l, coordinator);
        String[] stringArray = new String[]{"nodeUTCTime"};
        Object[] objectArray = new Object[]{new Long(l)};
        notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    private String checkIfIpAddressIsEmptyString(String string) {
        if (string == null || string.equals("")) {
            return DEFAULT_NTP_SERVER_ADDRESS;
        }
        return string;
    }

    private boolean isDefaultAddress(String string) {
        String string2 = this.checkIfIpAddressIsEmptyString(string);
        return string2.equals(DEFAULT_NTP_SERVER_ADDRESS);
    }

    private void setNtpServerAddress(int n, String string, Coordinator coordinator) throws MoAccessException {
        if (this.isNtpServerExisting(n)) {
            NtpServerMo ntpServerMo = this.getNtpServerForSet(n, coordinator);
            if (string.equals(DEFAULT_NTP_SERVER_ADDRESS)) {
                this.deleteNtpServerIfExists(n, coordinator);
            } else {
                ntpServerMo.setServerAddress(string, coordinator);
            }
        } else if (!string.equals(DEFAULT_NTP_SERVER_ADDRESS)) {
            this.createNtpServer(n, string, coordinator);
        }
    }

    private String getNtpServerAddress(int n, Coordinator coordinator) throws MoAccessException {
        NtpServerMo ntpServerMo = (NtpServerMo)MoRepository.instance().lookup("ManagedElement=1,SystemFunctions=1,TimeSetting=1,NtpServer=" + n);
        if (ntpServerMo == null) {
            return DEFAULT_NTP_SERVER_ADDRESS;
        }
        return ntpServerMo.getServerAddress(coordinator);
    }

    private boolean getNtpServiceActive(int n, Coordinator coordinator) throws MoAccessException {
        NtpServerMo ntpServerMo = (NtpServerMo)MoRepository.instance().lookup("ManagedElement=1,SystemFunctions=1,TimeSetting=1,NtpServer=" + n);
        if (ntpServerMo == null) {
            return false;
        }
        return ntpServerMo.getServiceActive(coordinator);
    }

    private void setNtpServiceActive(boolean bl, int n, Coordinator coordinator) throws MoAccessException {
        NtpServerMo ntpServerMo = this.getNtpServerForSet(n, coordinator);
        ntpServerMo.setServiceActive(bl, coordinator);
    }

    private NtpServerMo getNtpServerForSet(int n, Coordinator coordinator) throws MoAccessException {
        NtpServerMo ntpServerMo = (NtpServerMo)MoRepository.instance().lookup("ManagedElement=1,SystemFunctions=1,TimeSetting=1,NtpServer=" + n);
        if (ntpServerMo == null) {
            throw new OperationNotAllowedException("All NTP attributes and actions in ManagedElementData is depricated. NtpServer=" + n + " must exist.", "ManagedElementData");
        }
        return ntpServerMo;
    }

    private void createNtpServer(int n, String string, Coordinator coordinator) throws MoAccessException {
        AttrListImpl attrListImpl = new AttrListImpl();
        attrListImpl.addElement("serverAddress", (Object)string);
        TimeSettingMo timeSettingMo = this.getTimeSetting();
        MoFactory moFactory = MoFactoryMgr.instance().lookup("NtpServer");
        moFactory.createMo((ManagedObject)timeSettingMo, (AttrList)attrListImpl, n + "", null, coordinator);
    }

    private void actionCreateNtpServer(int n, String string, boolean bl, Coordinator coordinator) throws MoAccessException {
        if (string.equals(DEFAULT_NTP_SERVER_ADDRESS)) {
            return;
        }
        NtpServerMo ntpServerMo = (NtpServerMo)MoRepository.instance().lookup("ManagedElement=1,SystemFunctions=1,TimeSetting=1,NtpServer=" + n);
        if (ntpServerMo != null) {
            ntpServerMo.setServerAddress(string, coordinator);
            ntpServerMo.setServiceActive(bl, coordinator);
        } else {
            AttrListImpl attrListImpl = new AttrListImpl();
            attrListImpl.addElement("serverAddress", (Object)string);
            attrListImpl.addElement("serviceActive", (Object)bl);
            TimeSettingMo timeSettingMo = this.getTimeSetting();
            MoFactory moFactory = MoFactoryMgr.instance().lookup("NtpServer");
            moFactory.createMo((ManagedObject)timeSettingMo, (AttrList)attrListImpl, n + "", null, coordinator);
        }
    }

    private TimeSettingMo getTimeSetting() throws MoAccessException {
        TimeSettingMo timeSettingMo = (TimeSettingMo)MoRepository.instance().lookup("ManagedElement=1,SystemFunctions=1,TimeSetting=1");
        return timeSettingMo;
    }

    private boolean isNtpServerExisting(int n) {
        NtpServerMo ntpServerMo = (NtpServerMo)MoRepository.instance().lookup("ManagedElement=1,SystemFunctions=1,TimeSetting=1,NtpServer=" + n);
        return ntpServerMo != null;
    }

    private void deleteNtpServerIfExists(int n, Coordinator coordinator) throws MoAccessException {
        NtpServerMo ntpServerMo = (NtpServerMo)MoRepository.instance().lookup("ManagedElement=1,SystemFunctions=1,TimeSetting=1,NtpServer=" + n);
        if (ntpServerMo != null) {
            ntpServerMo.delete(coordinator);
        }
    }

    public boolean getDaylightSavingTime(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.daylightSavingTime.getValue(coordinator);
    }

    public void setDaylightSavingTime(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.daylightSavingTime.setValue(bl);
    }

    public void setSwServerUrlList(String string, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.checkSwServerUrlList(string);
        this.swServerUrlList.setValue(string);
        if (System.getProperty("SIM") == null) {
            PrintWriter printWriter = null;
            try {
                printWriter = new PrintWriter(new BufferedWriter(new FileWriter(SWSERVER_ADDRESS_FILE)));
                printWriter.print(string);
                printWriter.close();
            }
            catch (IOException iOException) {
                MessageLog.info(this.getClass(), (String)"failed to write to file: /c/configuration/swserver_address.cfg");
            }
        }
    }

    private String checkSwServerUrlList(String string) throws MoAccessException {
        if (string.equals("")) {
            return string;
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreElements()) {
            linkedHashSet.add(stringTokenizer.nextToken());
        }
        String[] stringArray = linkedHashSet.toArray(new String[linkedHashSet.size()]);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.checkslsServersValue(stringArray[0], "swServerUrlList"));
        for (int i = 1; i < stringArray.length; ++i) {
            String string2 = this.checkslsServersValue(stringArray[i], "swServerUrlList");
            stringBuffer.append(",");
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public String getSwServerUrlList(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.swServerUrlList.getValue(coordinator);
    }

    public void actionCreateNtpPrimary(String string, int n, int n2, boolean bl, boolean bl2, Coordinator coordinator) throws MoAccessException {
        this.actionCreateNtpServer(1, string, bl2, coordinator);
    }

    public void actionDeleteNtpPrimary(Coordinator coordinator) throws MoAccessException {
        this.deleteNtpServerIfExists(1, coordinator);
    }

    public void actionCreateNtpSecondary(String string, int n, int n2, boolean bl, boolean bl2, Coordinator coordinator) throws MoAccessException {
        this.actionCreateNtpServer(2, string, bl2, coordinator);
    }

    public void actionDeleteNtpSecondary(Coordinator coordinator) throws MoAccessException {
        this.deleteNtpServerIfExists(2, coordinator);
    }

    public void actionCreateNtpThird(String string, int n, int n2, boolean bl, boolean bl2, Coordinator coordinator) throws MoAccessException {
        this.actionCreateNtpServer(3, string, bl2, coordinator);
    }

    public void actionDeleteNtpThird(Coordinator coordinator) throws MoAccessException {
        this.deleteNtpServerIfExists(3, coordinator);
    }

    public void actionSetNodeUniqueId(String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.nodeUniqueID.setValue(string);
    }

    public void setPiuGroupEscalationType(int n, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        MoAttributeValidator.checkIntegerAttribute((String)"piuGroupEscalationType", (int)n, (int)1, (int)4, (String)"ManagedElementData");
        OsaMeSetPiuGroupEscTypeRsp osaMeSetPiuGroupEscTypeRsp = this.meProxy.sendOsaMeSetPiuGroupEscTypeReq(coordinator.getTransactionID(), n);
        this.checkSignal((Signal)osaMeSetPiuGroupEscTypeRsp, "ME fRO");
    }

    public int getPiuGroupEscalationType(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        int n = 0;
        if (coordinator != null) {
            n = coordinator.getTransactionID();
        }
        OsaMeGetPiuGroupEscTypeRsp osaMeGetPiuGroupEscTypeRsp = this.meProxy.sendOsaMeGetPiuGroupEscTypeReq(n);
        this.checkSignal((Signal)osaMeGetPiuGroupEscTypeRsp, "ME fRO");
        return osaMeGetPiuGroupEscTypeRsp.getPiuGroupEscalationType();
    }

    public int getMinimumHdVolumeCFreespace(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        int n = 0;
        if (coordinator != null) {
            n = coordinator.getTransactionID();
        }
        OsaMeGetDiskLimitRsp osaMeGetDiskLimitRsp = this.meProxy.sendOsaMeGetDiskLimitReq(n);
        this.checkSignal((Signal)osaMeGetDiskLimitRsp, "ME fRO");
        int n2 = osaMeGetDiskLimitRsp.getResult();
        if (n2 != 1) {
            throw new FroRequestFailedException("ManagedElementData", "ManagedElementDataProxy", "OsaMeGetDiskLimitReq", n2);
        }
        return osaMeGetDiskLimitRsp.getCVolFreeSpace();
    }

    public void setMinimumHdVolumeCFreespace(int n, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        MoAttributeValidator.checkIntegerAttribute((String)"minimumHdVolumeCFreespace", (int)n, (int)0, (int)999, (String)"ManagedElementData");
        OsaMeSetDiskLimitRsp osaMeSetDiskLimitRsp = this.meProxy.sendOsaMeSetDiskLimitReq(coordinator.getTransactionID(), n);
        this.checkSignal((Signal)osaMeSetDiskLimitRsp, "ME fRO");
        int n2 = osaMeSetDiskLimitRsp.getResult();
        if (n2 != 1) {
            throw new FroRequestFailedException("ManagedElementData", "ManagedElementDataProxy", "OsaMeGetDiskLimitReq", n2);
        }
        String[] stringArray = new String[]{"minimumHdVolumeCFreespace"};
        Object[] objectArray = new Object[]{new Integer(n)};
        notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public String getType() {
        return "ManagedElementData";
    }

    private void checkSignal(Signal signal, String string) throws MoAccessException {
        if (signal == null) {
            throw new FroNotAccessibleException("ManagedElementData", string);
        }
    }

    private OsaMeGetDiskDataRsp retrieveFroAttributes(Coordinator coordinator) throws FroRequestFailedException, FroNotAccessibleException, TransactionRequiredException, NoDiskException, MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        OsaMeGetDiskDataRsp osaMeGetDiskDataRsp = this.meProxy.sendOsaMeGetDiskDataReq();
        if (osaMeGetDiskDataRsp == null) {
            FroNotAccessibleException froNotAccessibleException = new FroNotAccessibleException("ManagedElementData", "ManagedElementDataProxy");
            MessageLog.traceError((Class)ManagedElementDataMoImpl.class, (String)"checkSignal() : No signal received from FRO!", (Throwable)froNotAccessibleException);
            throw froNotAccessibleException;
        }
        int n = osaMeGetDiskDataRsp.getResult();
        if (n != 1) {
            throw new FroRequestFailedException("ManagedElementData", "ManagedElementDataProxy", "GetOsaMeDiskDataReq", n);
        }
        if (n == 2) {
            throw new NoDiskException("ManagedElementData", "NoDisk", n);
        }
        return osaMeGetDiskDataRsp;
    }

    private void setAutoConfiguration(boolean bl, boolean bl2, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        boolean bl3 = this.autoConfigurationAllowed.getValue(coordinator);
        if (bl3 && !bl2 && bl) {
            this.registerResource(coordinator, 1);
        } else if (!bl3 && bl2) {
            this.registerResource(coordinator, 2);
        }
        this.autoConfigurationAllowed.setValue(bl2);
    }

    private void registerResource(Coordinator coordinator, int n) throws MoAccessException {
        if (this.coordinator != null && this.coordinator.isSameTransaction(coordinator)) {
            if (this.txResource != null) {
                this.txResource.setOperation(n);
            }
        } else {
            this.coordinator = coordinator;
            try {
                this.txResource = new TxResource(n);
                this.coordinator.registerResource((Resource)this.txResource);
            }
            catch (InactiveTransactionException inactiveTransactionException) {
                this.txResource = null;
                MessageLog.traceError(this.getClass(), (String)"Failed registerResource due to exception:", (Throwable)inactiveTransactionException);
            }
        }
    }

    public synchronized void startAutoConfiguration() {
        this.delayUntilUpgradeIsFinished();
        Iterator iterator = this.getMaoContext().getServiceRepository().getServices(SlotBuildIF.class);
        SlotBuildIF slotBuildIF = null;
        if (iterator != null) {
            while (iterator.hasNext()) {
                slotBuildIF = (SlotBuildIF)iterator.next();
                slotBuildIF.startAutoConfiguration();
            }
        }
        Iterator iterator2 = this.getMaoContext().getServiceRepository().getServices(PfmUnitBuildIF.class);
        PfmUnitBuildIF pfmUnitBuildIF = null;
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                pfmUnitBuildIF = (PfmUnitBuildIF)iterator2.next();
                pfmUnitBuildIF.startAutoConfiguration();
            }
        }
    }

    private void delayUntilUpgradeIsFinished() {
        SystemUpgradeAgent systemUpgradeAgent = (SystemUpgradeAgent)this.getMaoContext().getServiceRepository().getService(SystemUpgradeAgent.class);
        if (systemUpgradeAgent != null) {
            while (systemUpgradeAgent.isUpgradeExecuting()) {
                try {
                    UpgradeTrace.debug(this.getClass(), (int)72, (String)"delayUntilUpgradeIsFinished()", (String)"AutoConfiguration will wait for 5 sec before trying to start.");
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    MessageLog.info(this.getClass(), (String)("delayUntilUpgradeIsFinished(), interrupted " + interruptedException));
                }
            }
        } else {
            MessageLog.traceError(this.getClass(), (String)"Failed to locate SystemUpgradeAgent in ServiceRepository. PnP might start during upgrade.");
        }
    }

    private void createAutoCV() {
        while (AutoConfigurationObserver.getAutoConfigurationStatus() == 1) {
            try {
                UpgradeTrace.debug(this.getClass(), (int)72, (String)"createAutoCV()", (String)"AutoConfiguration is set to disable while still in progress. Wating for 5 sec before checking the state again.");
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                MessageLog.info(this.getClass(), (String)("createAutoCV(), interrupted." + interruptedException));
            }
        }
        try {
            AutoConfigurationCvHandlerAccess autoConfigurationCvHandlerAccess = (AutoConfigurationCvHandlerAccess)ServiceLocatorFacade.getRepository().getService(AutoConfigurationCvHandlerAccess.class);
            autoConfigurationCvHandlerAccess.createPlugAndPlayCV_AndSetStartableFromMe("AutoConfigurationAllowed turned OFF");
        }
        catch (Exception exception) {
            MessageLog.traceError(this.getClass(), (String)"Caught exception when trying to create autoConfigurationAllowed-CV", (Throwable)exception);
        }
    }

    private void throwIllegalAttributeValueException(String string) throws MoAccessException {
        throw new IllegalAttributeValueException("The format of performanceDataVolume, " + string + ", is invalid", "performanceDataVolume", "ManagedElementData");
    }

    private class NIASubscriber
    implements NIAListener {
        ManagedElementDataMoImpl meDataMo;
        private static final int MAX_NO_OF_RETRIES = 40;
        private static final int RETRY_INTERVAL = 2000;

        public NIASubscriber(ManagedElementDataMoImpl managedElementDataMoImpl2) {
            this.meDataMo = managedElementDataMoImpl2;
        }

        public void subscribe() {
            NIAMgr nIAMgr = NIAMgrFactory.createNIAMgr();
            nIAMgr.registerSubscriber((NIAListener)this);
        }

        public void notifyIpAddressChanged(String string, String string2) {
            String string3 = "";
            boolean bl = true;
            int n = 0;
            try {
                string3 = InetAddress.getLocalHost().getHostAddress();
                while (!string3.equals(string) && n < 40) {
                    string3 = InetAddress.getLocalHost().getHostAddress();
                    ++n;
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (UnknownHostException unknownHostException) {
                MessageLog.traceError(this.getClass(), (String)("notifyIpAddressChanged, caught exception: " + unknownHostException));
                bl = false;
            }
            if (n == 40) {
                MessageLog.info(this.getClass(), (String)("notifyIpAddressChanged called, but JVM never changed address. New IP address: " + string + ". Old IP address: " + string3 + ". Interface name: " + string2));
                bl = false;
            }
            if (bl) {
                ManagedElementDataMoImpl.this.writeSlsAddressCfgFile(new File("/c"), this.meDataMo.logonServerAddress.getValue(null));
            }
        }

        public void notifyIpAddressChanged(NIAAddressInfo[] nIAAddressInfoArray) {
            ManagedElementDataMoImpl.this.writeSlsAddressCfgFile(new File("/c"), this.meDataMo.logonServerAddress.getValue(null));
        }
    }

    private class TxResource
    implements Resource,
    Runnable {
        private int operation = 0;

        public TxResource(int n) {
            this.operation = n;
        }

        public void setOperation(int n) {
            this.operation = n;
        }

        public void commit() {
            Thread thread = null;
            switch (this.operation) {
                case 1: {
                    thread = new Thread((Runnable)this, ManagedElementDataMoImpl.CMA_AUTOCONFIG_CV_THREAD);
                    thread.start();
                    break;
                }
                case 2: {
                    thread = new Thread((Runnable)this, ManagedElementDataMoImpl.CMA_AUTOCONFIG_SLOT_SCAN_THREAD);
                    thread.start();
                    break;
                }
                default: {
                    MessageLog.traceError(this.getClass(), (String)("TxResource, unknown operation :" + this.operation));
                }
            }
            ManagedElementDataMoImpl.this.coordinator = null;
            ManagedElementDataMoImpl.this.txResource = null;
        }

        public boolean prepare() {
            return true;
        }

        public void rollback() {
            ManagedElementDataMoImpl.this.coordinator = null;
            ManagedElementDataMoImpl.this.txResource = null;
            this.operation = 0;
        }

        public void run() {
            switch (this.operation) {
                case 1: {
                    ManagedElementDataMoImpl.this.createAutoCV();
                    break;
                }
                case 2: {
                    ManagedElementDataMoImpl.this.startAutoConfiguration();
                    break;
                }
                default: {
                    MessageLog.traceError(this.getClass(), (String)("TxResource, run(), unknown operation :" + this.operation));
                }
            }
            this.operation = 0;
        }
    }
}

