/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.managedelement;

import se.ericsson.cello.support.scheduler.ScheduleEntry;
import se.ericsson.cello.support.scheduler.ScheduleTime;
import se.ericsson.cello.support.scheduler.ScheduledTask;
import se.ericsson.cello.support.scheduler.Scheduler;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.Resource;

public class ScheduleManager {
    private String name;
    private ScheduledTask task;
    private Scheduler scheduler;
    private ScheduleEntry currentSchedule = null;

    public ScheduleManager(String string, ScheduledTask scheduledTask, Scheduler scheduler) {
        this.name = string;
        this.task = scheduledTask;
        this.scheduler = scheduler;
    }

    public void setSchedule(ScheduleTime[] scheduleTimeArray, Coordinator coordinator) throws InactiveTransactionException {
        if (coordinator == null) {
            this.setSchedule(scheduleTimeArray);
        } else {
            coordinator.registerResource((Resource)new TxResource(scheduleTimeArray));
        }
    }

    public void setSchedule(ScheduleTime[] scheduleTimeArray) {
        if (this.currentSchedule != null) {
            this.currentSchedule.cancel();
        }
        this.currentSchedule = scheduleTimeArray.length > 0 ? this.scheduler.createSchedule(this.name, scheduleTimeArray, this.task, true) : null;
    }

    private class TxResource
    implements Resource {
        private ScheduleTime[] times;

        public TxResource(ScheduleTime[] scheduleTimeArray) {
            this.times = scheduleTimeArray;
        }

        public boolean prepare() {
            return true;
        }

        public void rollback() {
        }

        public void commit() {
            ScheduleManager.this.setSchedule(this.times);
        }
    }
}

