/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.managedelement;

import se.ericsson.cello.managedelement.ManagedElementMoImpl;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.managedelement.SystemFunctionsMo;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.ManagedObjectBase;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.transaction.TransactionServiceImpl;

public class SystemFunctionsMoImpl
extends ManagedObjectBase
implements SystemFunctionsMo {
    private static final String systemFunctionsId = "1";
    private StringAttribute userLabel = null;
    private MoData data = null;
    private static SystemFunctionsMoImpl instance = null;
    private static final int MO_DATA_REVISION_42 = 4200;
    private static final int MO_DATA_REVISION_LATEST = 4200;

    public String getType() {
        return "SystemFunctions";
    }

    public String getSystemFunctionsId(Coordinator coordinator) throws MoAccessException {
        return systemFunctionsId;
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"SystemFunctions", (int)128, (int)0);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        throw new UndeletableMoException((ManagedObject)this);
    }

    static synchronized SystemFunctionsMoImpl instance() {
        try {
            if (instance == null) {
                instance = new SystemFunctionsMoImpl();
            }
        }
        catch (MoNameAlreadyTakenException moNameAlreadyTakenException) {
            MessageLog.traceError((Class)SystemFunctionsMoImpl.class, (String)"Create instance of SystemFunctions MO failed", (Throwable)moNameAlreadyTakenException);
        }
        return instance;
    }

    void recover(MoData moData) {
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, this);
        moDataRecoveryHelper.assertMoDataRevision(4200);
        moDataRecoveryHelper.assertAttribute("userLabel");
        this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
    }

    private SystemFunctionsMoImpl() throws MoNameAlreadyTakenException {
        super((ManagedObject)ManagedElementMoImpl.instance(), "SystemFunctions", systemFunctionsId, null);
    }

    synchronized void registerData() {
        if (this.data == null) {
            try {
                TransactionFactory transactionFactory = TransactionServiceImpl.instance().getTransactionFactory();
                Control control = transactionFactory.create(3600);
                Coordinator coordinator = control.getCoordinator();
                MessageLog.trace((int)5, this.getClass(), (String)("Cello_CMA txId = " + coordinator.getTransactionID() + ", timeout = 3600 sec"));
                this.data = new MoData(this.getLocalDistinguishedName(), "SystemFunctions", true, coordinator);
                this.userLabel = new StringAttribute("userLabel", true, "");
                this.data.registerPersistentAttr((Attribute)this.userLabel);
                this.data.setRevision(4200);
                this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
                control.getTerminator().commit();
            }
            catch (TransactionRequiredException transactionRequiredException) {
                MessageLog.traceError(this.getClass(), (String)"start of SystemFunction failed", (Throwable)transactionRequiredException);
            }
            catch (TransactionRolledBackException transactionRolledBackException) {
                MessageLog.traceError(this.getClass(), (String)"start of SystemFunction failed", (Throwable)transactionRolledBackException);
            }
            catch (InactiveTransactionException inactiveTransactionException) {
                MessageLog.traceError(this.getClass(), (String)"start of SystemFunction failed", (Throwable)inactiveTransactionException);
            }
            catch (MoAccessException moAccessException) {
                MessageLog.traceError(this.getClass(), (String)"start of SystemFunction failed", (Throwable)moAccessException);
            }
        }
    }
}

