/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.empatcher;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.MessageDigest;
import java.util.Iterator;
import java.util.SortedSet;
import se.ericsson.security.empatcher.Java14FileCopy;
import se.ericsson.security.empatcher.MsgBuffer;
import se.ericsson.security.launcher.cache.CacheAccessException;
import se.ericsson.security.launcher.cache.CacheException;
import se.ericsson.security.launcher.cache.VerifyException;
import se.ericsson.security.launcher.util.EmasUtilities;

public class JarFileWriter {
    private static final Class THIS_CLASS = JarFileWriter.class;
    private final String LAUNCHER_JAR_SOURCE = JarFileWriter.findLauncherJarFile();
    private final String LAUNCHER_JAR_MD5SUM = JarFileWriter.getMd5sum(new File(this.LAUNCHER_JAR_SOURCE));

    String getNewMd5sum() {
        return this.LAUNCHER_JAR_MD5SUM;
    }

    public String writeLaunchers(SortedSet dirsToWriteLauncherTo) {
        MsgBuffer problemLog = new MsgBuffer();
        problemLog.setIndent("      ");
        if (this.LAUNCHER_JAR_SOURCE == null) {
            problemLog.nl().print("INTERNAL ERROR! Could not find launcher.jar to copy into cache!");
            return problemLog.toString();
        }
        Iterator iter = dirsToWriteLauncherTo.iterator();
        while (iter.hasNext()) {
            String directory = null;
            try {
                directory = (String)iter.next();
                if (File.separatorChar == '\\') {
                    directory = directory.replaceAll("\\]", "");
                    directory = directory.replaceAll("\\[", "");
                    directory = directory.replaceAll("/", "\\");
                    directory = directory.replaceAll("\"", "");
                }
                File toFile = new File(directory, "launcher.jar");
                MsgBuffer buf = this.writeLauncher(toFile);
                problemLog.append(buf);
            }
            catch (Exception e) {
                problemLog.nl().print("Failed to copy launcher.jar to cache dir '" + directory + File.separator + "launcher.jar" + "'!");
                problemLog.nl().print("   " + e.toString());
                e.printStackTrace();
            }
        }
        return problemLog.toString();
    }

    public String old_writeLaunchers(SortedSet dirsToWriteLauncherTo) {
        MsgBuffer problemLog = new MsgBuffer();
        problemLog.setIndent("      ");
        if (this.LAUNCHER_JAR_SOURCE == null) {
            problemLog.nl().print("INTERNAL ERROR! Could not find launcher.jar to copy into cache!");
            return problemLog.toString();
        }
        File fromFile = new File(this.LAUNCHER_JAR_SOURCE);
        Iterator iter = dirsToWriteLauncherTo.iterator();
        while (iter.hasNext()) {
            Object objDir = null;
            try {
                objDir = iter.next();
                File toDir = objDir;
                File toFile = new File(toDir, "launcher.jar");
                File newFile = new File(toFile.toString() + ".EmPatcher.new");
                File bakFile = new File(toFile.toString() + ".EmPatcher.bak");
                if (!toDir.isDirectory() && !toDir.mkdirs()) {
                    problemLog.nl().print("ERROR! Failed to create dir '" + toDir + "'!");
                    return problemLog.toString();
                }
                MsgBuffer copyProblems = Java14FileCopy.copy(fromFile, newFile);
                problemLog.append(copyProblems);
                if (!newFile.exists()) {
                    problemLog.nl().print("ERROR! Failed to create file '" + newFile + "'!");
                    return problemLog.toString();
                }
                if (!bakFile.exists()) {
                    toFile.renameTo(bakFile);
                } else {
                    toFile.delete();
                }
                if (toFile.exists()) {
                    problemLog.nl().print("Failed to remove old file " + toFile);
                    newFile.deleteOnExit();
                    newFile.delete();
                    return problemLog.toString();
                }
                newFile.renameTo(toFile);
            }
            catch (Exception e) {
                problemLog.nl().print("Failed to copy launcher.jar to cache dir '" + objDir + "'!");
                problemLog.nl().print("   " + e.toString());
            }
        }
        return problemLog.toString();
    }

    public MsgBuffer writeLauncher(File toFile) throws VerifyException, CacheException, IOException {
        MsgBuffer problemLog = new MsgBuffer();
        problemLog.setIndent("      ");
        File fromFile = new File(this.LAUNCHER_JAR_SOURCE);
        File newFile = new File(toFile.toString() + ".EmPatcher.new");
        File bakFile = new File(toFile.toString() + ".EmPatcher.bak");
        String action = "";
        try {
            boolean created = toFile.getParentFile().mkdirs();
            if (!toFile.getParentFile().isDirectory()) {
                problemLog.nl().print("Failed creating directory " + toFile.getParentFile());
                return problemLog;
            }
            MsgBuffer copyProblems = Java14FileCopy.copy(fromFile, newFile);
            problemLog.append(copyProblems);
            if (!newFile.isFile()) {
                problemLog.nl().print("Failed temp file " + newFile);
                return problemLog;
            }
            String newMd5sum = JarFileWriter.getMd5sum(newFile);
            if (!this.LAUNCHER_JAR_MD5SUM.equals(newMd5sum)) {
                problemLog.nl().print("ERROR! md5sums differ between source file and target file!");
                problemLog.nl().print("   Source : " + this.LAUNCHER_JAR_MD5SUM + " - " + this.LAUNCHER_JAR_SOURCE);
                problemLog.nl().print("   Target : " + newMd5sum + " - " + newFile);
                newFile.deleteOnExit();
                newFile.delete();
                return problemLog;
            }
            if (created) {
                this.chmodCreated(newFile);
            }
            if (!bakFile.exists()) {
                this.renameFile(toFile, bakFile);
            } else {
                toFile.delete();
            }
            if (toFile.exists()) {
                problemLog.nl().print("Failed to remove old file " + toFile);
                newFile.deleteOnExit();
                newFile.delete();
                return problemLog;
            }
            action = "Renaming the tempfile " + newFile.getName() + " to " + toFile.getName();
            if (!this.renameFile(newFile, toFile)) {
                throw new CacheException(action + " failed.");
            }
            action = "Setting read permission on " + toFile.getAbsolutePath();
            this.chmodFileForReading(toFile);
        }
        catch (VerifyException ve) {
            this.deleteFileIfPossible(newFile);
            String message = action + " failed.\n";
            throw new VerifyException(message, (Throwable)ve);
        }
        catch (Exception e) {
            this.deleteFileIfPossible(newFile);
            String message = action + " failed.\n";
            throw new CacheException(message, (Throwable)e);
        }
        return problemLog;
    }

    private boolean renameFile(File fileToRename, File newFile) {
        for (int i = 0; i < 20; ++i) {
            if (fileToRename.renameTo(newFile)) {
                return true;
            }
            System.gc();
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        return false;
    }

    private void chmodCreated(File file) throws CacheAccessException {
        if (!EmasUtilities.runningOnWindows()) {
            Runtime rt = Runtime.getRuntime();
            String parent = file.getParentFile().toString();
            String grandParent = file.getParentFile().getParentFile().toString();
            try {
                rt.exec("chmod 775 " + grandParent);
                rt.exec("chmod 775 " + parent);
            }
            catch (Exception e) {
                String message = "Could not do 'chmod 775' on " + parent + " or on " + grandParent + ". ";
                throw new CacheAccessException(message, (Throwable)e);
            }
        }
    }

    private void chmodFileForReading(File file) throws Exception {
        if (!EmasUtilities.runningOnWindows()) {
            Runtime rt = Runtime.getRuntime();
            rt.exec("chmod a+r " + file.toString());
        }
    }

    private void deleteFileIfPossible(File file) {
        if (file != null) {
            try {
                file.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static String selectIdentifytingResource() {
        if (Boolean.getBoolean("se.ericsson.security.empatcher.executed.from.debugger")) {
            return "se/ericsson/security/empatcher/empatcher.properties";
        }
        String fullClassName = THIS_CLASS.getName();
        fullClassName = fullClassName.replace('.', '/') + ".class";
        return fullClassName;
    }

    private static String findLauncherJarFile() {
        try {
            String identifyingResource;
            URL classFileUrl;
            ClassLoader cl = THIS_CLASS.getClassLoader();
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
            if ((classFileUrl = cl.getResource(identifyingResource = JarFileWriter.selectIdentifytingResource())) == null) {
                throw new FileNotFoundException("Unable to find jar file from which em_patcher was executed");
            }
            URI uriWithoutJarScheme = null;
            try {
                uriWithoutJarScheme = new URI(classFileUrl.getPath());
            }
            catch (URISyntaxException ex) {
                throw new FileNotFoundException("Unable to find jar file from which demobem was executed");
            }
            String urlWithoutScheme = uriWithoutJarScheme.getPath();
            int endIndex = urlWithoutScheme.indexOf("!/");
            return urlWithoutScheme.substring(0, endIndex);
        }
        catch (IOException e) {
            System.out.print("\n      ERROR! Can't find source launcher.jar!");
            System.out.print("\n         " + e.toString());
            return null;
        }
    }

    private static String getMd5sum(File file) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            FileInputStream fis = new FileInputStream(file);
            byte[] dataBytes = new byte[1024];
            int nread = 0;
            while ((nread = fis.read(dataBytes)) != -1) {
                md.update(dataBytes, 0, nread);
            }
            fis.close();
            byte[] mdbytes = md.digest();
            StringBuffer sb = new StringBuffer("");
            for (int i = 0; i < mdbytes.length; ++i) {
                sb.append(Integer.toString((mdbytes[i] & 0xFF) + 256, 16).substring(1));
            }
            return sb.toString();
        }
        catch (Exception e) {
            System.out.print("\n      ERROR! Can't caluculate MD5SUM for source launcher.jar!");
            System.out.print("\n         " + e.toString());
            return e.toString();
        }
    }
}

