/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.launcher;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import se.ericsson.security.launcher.ExceptionHandlerInterface;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.utils.EmLogger;

public class LauncherEventDispatcher
extends EventQueue {
    private static final EmLogger LOG = EmLogger.LAUNCHER;
    private ExceptionHandlerInterface excHandler = null;
    private Launchable theSetter = null;

    public void setExceptionHandler(Launchable appl, ExceptionHandlerInterface eh) {
        if (this.theSetter == null) {
            this.theSetter = appl;
            this.excHandler = eh;
        } else if (this.theSetter.equals(appl)) {
            this.excHandler = eh;
        }
    }

    public void push(EventQueue eq) {
        if (!(Toolkit.getDefaultToolkit().getSystemEventQueue() instanceof LauncherEventDispatcher)) {
            Toolkit.getDefaultToolkit().getSystemEventQueue().push(eq);
        }
    }

    protected void dispatchEvent(AWTEvent evt) {
        try {
            super.dispatchEvent(evt);
        }
        catch (Throwable t) {
            System.out.println("==========================");
            System.out.println("LED: evt=" + evt.toString());
            Object src = evt.getSource();
            System.out.println("LED: src=" + src.toString());
            System.out.println("==========================");
            Class<?> dc = src.getClass().getDeclaringClass();
            System.out.println("LED: dc=" + (dc == null ? "<null>" : dc.toString()));
            if (this.excHandler != null) {
                this.excHandler.handleException(t);
            }
            LOG.severe("An exception occured in the Event Dispatcher Thread; no exception handler registered", new Object[0]);
            t.printStackTrace();
        }
    }
}

