/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.launcher.cache;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import se.ericsson.security.launcher.ApplicationFile;
import se.ericsson.security.launcher.cache.CacheException;
import se.ericsson.security.launcher.cache.CachedFile;
import se.ericsson.security.utils.EmLogger;

public class CachedJarFile
extends CachedFile {
    private static final EmLogger LOG = EmLogger.LAUNCHER;

    public CachedJarFile(String fileName, boolean setDataFromManifest) throws CacheException {
        super(fileName);
        if (setDataFromManifest) {
            this.readRevisionFromFile();
        } else {
            this.readRevisionFromPath();
        }
        LOG.fine("Found " + this.getAttributes().getProductNumber() + " " + this.getAttributes().getRevision() + " for " + fileName, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void readRevisionFromFile() throws CacheException {
        block29: {
            Exception ioe22;
            JarInputStream jis;
            FileInputStream in;
            File file;
            block26: {
                file = new File(this.getFileName());
                if (file.isDirectory()) {
                    this.setAttributes(new ApplicationFile(file.getName(), file.getPath(), "UNKNOWN", "UNKNOWN"));
                    LOG.fine("readRevisionFromFile() failed - got directory, not file: " + file, new Object[0]);
                    return;
                }
                if (!file.isFile() || !file.canRead()) {
                    this.setAttributes(new ApplicationFile(file.getName(), file.getPath(), "UNKNOWN", "UNKNOWN"));
                    LOG.warning("readRevisionFromFile() failed - Can't read file: " + file, new Object[0]);
                    throw new CacheException("Can't read jar file '" + file + "'!");
                }
                in = null;
                jis = null;
                in = new FileInputStream(file);
                jis = new JarInputStream(in);
                Manifest mf = jis.getManifest();
                if (mf == null) {
                    throw new CacheException("No manifest found in " + file.getName());
                }
                Attributes mainattributes = mf.getMainAttributes();
                String productNumber = mainattributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
                String revision = mainattributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                if (revision == null) {
                    throw new CacheException("No revision info found in manifest of " + file.getName());
                }
                if (productNumber == null) {
                    throw new CacheException("No product number found in manifest of " + file.getName());
                }
                this.setAttributes(new ApplicationFile(file.getName(), file.getPath(), productNumber, revision));
                LOG.fine("Found " + this.getAttributes().getProductNumber() + " " + this.getAttributes().getRevision() + " in " + file.getName(), new Object[0]);
                Object var9_9 = null;
                if (jis == null) break block26;
                try {
                    try {
                        jis.close();
                    }
                    catch (IOException ioe22) {
                        LOG.warning("Failed to close jarinputstream for " + file.getName(), new Object[0]);
                        Object var12_12 = null;
                        jis = null;
                        break block26;
                    }
                    Object var12_11 = null;
                    jis = null;
                }
                catch (Throwable throwable) {
                    Object var12_13 = null;
                    jis = null;
                    throw throwable;
                }
            }
            if (in != null) {
                try {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException ioe22) {
                        LOG.warning("Failed to close inpustream for " + file.getName(), new Object[0]);
                        Object var14_22 = null;
                        in = null;
                    }
                    catch (NullPointerException ioe22) {
                        LOG.fine("Triggered bug in jvm for " + file.getName(), new Object[0]);
                        Object var14_23 = null;
                        in = null;
                    }
                    Object var14_21 = null;
                    in = null;
                }
                catch (Throwable throwable) {
                    Object var14_24 = null;
                    in = null;
                    throw throwable;
                }
            }
            break block29;
            {
                catch (IOException ioe3) {
                    throw new CacheException("Failed to get read versionfile " + file.getName(), (Throwable)ioe3);
                }
            }
            catch (Throwable throwable) {
                block28: {
                    Exception ioe22;
                    Object var9_10 = null;
                    if (jis != null) {
                        try {
                            try {
                                jis.close();
                            }
                            catch (IOException ioe22) {
                                LOG.warning("Failed to close jarinputstream for " + file.getName(), new Object[0]);
                                Object var12_15 = null;
                                jis = null;
                            }
                            Object var12_14 = null;
                            jis = null;
                        }
                        catch (Throwable throwable2) {
                            Object var12_16 = null;
                            jis = null;
                            throw throwable2;
                        }
                    }
                    if (in != null) {
                        try {
                            try {
                                ((InputStream)in).close();
                            }
                            catch (IOException ioe22) {
                                LOG.warning("Failed to close inpustream for " + file.getName(), new Object[0]);
                                Object var14_26 = null;
                                in = null;
                                break block28;
                            }
                            catch (NullPointerException ioe22) {
                                LOG.fine("Triggered bug in jvm for " + file.getName(), new Object[0]);
                                Object var14_27 = null;
                                in = null;
                            }
                            Object var14_25 = null;
                            in = null;
                        }
                        catch (Throwable throwable3) {
                            Object var14_28 = null;
                            in = null;
                            throw throwable3;
                        }
                    }
                }
                throw throwable;
            }
        }
    }

    protected void readRevisionFromPath() throws CacheException {
        File prodDir;
        String productNumber = "UNKNOWN";
        String revision = "UNKNOWN";
        File jarFile = new File(this.getFileName());
        File revDir = jarFile.getParentFile();
        if (revDir != null && (prodDir = revDir.getParentFile()) != null) {
            productNumber = prodDir.getName();
            revision = revDir.getName();
        }
        this.setAttributes(new ApplicationFile(jarFile.getName(), jarFile.getPath(), productNumber, revision));
    }
}

