/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.launcher.download;

import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import javax.net.ssl.SSLHandshakeException;
import se.ericsson.security.launcher.download.DownloadException;
import se.ericsson.security.launcher.download.DownloadFeedbackListener;
import se.ericsson.security.launcher.download.DownloadListener;
import se.ericsson.security.launcher.download.FileNotFoundException;
import se.ericsson.security.launcher.util.EmasUtilities;
import se.ericsson.security.launcher.util.PropertyManager;
import se.ericsson.security.utils.EmLogger;

public class DownloadManager {
    private static final EmLogger LOG = EmLogger.LAUNCHER;
    private int SOCKET_TIMEOUT;

    public DownloadManager() {
        PropertyManager properties = PropertyManager.getInstance(this.getClass().getClassLoader());
        this.SOCKET_TIMEOUT = properties.getInt("se.ericsson.security.launcher.connecttimeout", true, 20000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public void downloadToFile(URL remoteFile, File localFile, DownloadListener listener) throws DownloadException, SocketTimeoutException, IOException {
        block63: {
            in = null;
            fos = null;
            willDoReadOperation = true;
            fileChannel = null;
            urlConnection = null;
            lastModified = -1L;
            port = -1;
            failed = false;
            remoteFileName = remoteFile.toExternalForm();
            path = remoteFile.getPath();
            inRbs = null;
            try {
                block62: {
                    block61: {
                        block60: {
                            try {
                                ret = this.doConnect(remoteFile, listener);
                                urlConnection = ret.urlConnection;
                                lastModified = ret.lastModified;
                                in = urlConnection.getInputStream();
                                totalLength = urlConnection.getContentLength();
                                fos = new FileOutputStream(localFile);
                                inRbs = Channels.newChannel(in);
                                bb = ByteBuffer.allocate(32768);
                                fileChannel = fos.getChannel();
                                progress = 0;
                                read = 0;
                                while ((read = inRbs.read(bb)) >= 0) {
                                    bb.flip();
                                    willDoReadOperation = false;
                                    fileChannel.write(bb);
                                    bb.clear();
                                    willDoReadOperation = true;
                                    listener.downloading(remoteFile.getFile(), progress += read, totalLength);
                                }
                                willDoReadOperation = false;
                            }
                            catch (IOException e) {
                                failed = true;
                                message = willDoReadOperation == false ? "Failed to write data to " + localFile.getAbsolutePath() + " during download from " + remoteFileName : "Failed reading data from " + remoteFileName + " during download to " + localFile.getAbsolutePath();
                                DownloadManager.LOG.severe(message, new Object[0]);
                                if (!(listener instanceof DownloadFeedbackListener)) {
                                    listener.downloadFailed(path.substring(path.lastIndexOf("/") + 1));
                                    throw new DownloadException(message, (Throwable)e);
                                }
                                ((DownloadFeedbackListener)listener).downloadFailed(path.substring(path.lastIndexOf("/") + 1), remoteFile.getHost() + (port != -1 ? ":" + String.valueOf(port) : ""));
                                throw new DownloadException(message, (Throwable)e);
                            }
                            var22_22 = null;
                            if (!failed) {
                                if (listener instanceof DownloadFeedbackListener) {
                                    ((DownloadFeedbackListener)listener).finished(path.substring(path.lastIndexOf("/") + 1), remoteFile.getHost() + (port != -1 ? ":" + String.valueOf(port) : ""));
                                } else {
                                    listener.finished(path.substring(path.lastIndexOf("/") + 1));
                                }
                            }
                            if (fileChannel != null) {
                                try {
                                    try {
                                        fileChannel.close();
                                    }
                                    catch (IOException ioe) {
                                        DownloadManager.LOG.warning("Failed to close fileChannel.", new Object[0]);
                                        var25_25 = null;
                                        in = null;
                                        break block60;
                                    }
                                    var25_24 = null;
                                    in = null;
                                }
                                catch (Throwable var24_32) {
                                    var25_26 = null;
                                    in = null;
                                    throw var24_32;
                                }
                            }
                        }
                        if (inRbs != null) {
                            try {
                                try {
                                    inRbs.close();
                                }
                                catch (IOException ioe) {
                                    DownloadManager.LOG.warning("Failed to close ReadableByteChannel.", new Object[0]);
                                    var27_35 = null;
                                    in = null;
                                    break block61;
                                }
                                var27_34 = null;
                                in = null;
                            }
                            catch (Throwable var26_40) {
                                var27_36 = null;
                                in = null;
                                throw var26_40;
                            }
                        }
                    }
                    if (in != null) {
                        try {
                            try {
                                in.close();
                            }
                            catch (IOException ioe) {
                                DownloadManager.LOG.warning("Failed to close inputstream.", new Object[0]);
                                var29_43 = null;
                                in = null;
                                break block62;
                            }
                            var29_42 = null;
                            in = null;
                        }
                        catch (Throwable var28_48) {
                            var29_44 = null;
                            in = null;
                            throw var28_48;
                        }
                    }
                }
                if (fos == null) break block63;
                try {
                    block64: {
                        try {
                            fos.close();
                        }
                        catch (IOException ioe) {
                            block68: {
                                DownloadManager.LOG.warning("Failed to close outputstream.", new Object[0]);
                                var31_51 = null;
                                ** try [egrp 10[TRYBLOCK] [19 : 723->818)] { 
lbl122:
                                // 1 sources

                                if (failed && localFile.exists()) {
                                    DownloadManager.LOG.info("Will remove the incomplete file " + localFile.getAbsolutePath(), new Object[0]);
                                    deleteOk = localFile.delete();
                                    if (!deleteOk) {
                                        DownloadManager.LOG.warning("Could not remove the incomplete file " + localFile.getAbsolutePath() + ". You should try to remove it manually.", new Object[0]);
                                    }
                                }
                                break block68;
lbl129:
                                // 1 sources

                                catch (SecurityException e) {
                                    DownloadManager.LOG.warning("Failed to remove the incomplete file " + localFile.getAbsolutePath() + ". You should try to remove it manually.", new Object[0]);
                                }
                            }
                            fos = null;
                        }
                        var31_50 = null;
                        try {
                            if (!failed || !localFile.exists()) break block64;
                            DownloadManager.LOG.info("Will remove the incomplete file " + localFile.getAbsolutePath(), new Object[0]);
                            deleteOk = localFile.delete();
                            if (!deleteOk) {
                                DownloadManager.LOG.warning("Could not remove the incomplete file " + localFile.getAbsolutePath() + ". You should try to remove it manually.", new Object[0]);
                            }
                        }
                        catch (SecurityException e) {
                            DownloadManager.LOG.warning("Failed to remove the incomplete file " + localFile.getAbsolutePath() + ". You should try to remove it manually.", new Object[0]);
                        }
                    }
                    fos = null;
                }
                catch (Throwable var30_68) {
                    block69: {
                        var31_52 = null;
                        ** try [egrp 10[TRYBLOCK] [19 : 723->818)] { 
lbl152:
                        // 1 sources

                        if (failed && localFile.exists()) {
                            DownloadManager.LOG.info("Will remove the incomplete file " + localFile.getAbsolutePath(), new Object[0]);
                            deleteOk = localFile.delete();
                            if (!deleteOk) {
                                DownloadManager.LOG.warning("Could not remove the incomplete file " + localFile.getAbsolutePath() + ". You should try to remove it manually.", new Object[0]);
                            }
                        }
                        break block69;
lbl159:
                        // 1 sources

                        catch (SecurityException e) {
                            DownloadManager.LOG.warning("Failed to remove the incomplete file " + localFile.getAbsolutePath() + ". You should try to remove it manually.", new Object[0]);
                        }
                    }
                    fos = null;
                    throw var30_68;
                }
            }
            catch (Throwable var21_70) {
                block72: {
                    block67: {
                        block66: {
                            block65: {
                                var22_23 = null;
                                if (!failed) {
                                    if (listener instanceof DownloadFeedbackListener) {
                                        ((DownloadFeedbackListener)listener).finished(path.substring(path.lastIndexOf("/") + 1), remoteFile.getHost() + (port != -1 ? ":" + String.valueOf(port) : ""));
                                    } else {
                                        listener.finished(path.substring(path.lastIndexOf("/") + 1));
                                    }
                                }
                                if (fileChannel != null) {
                                    try {}
                                    catch (Throwable var24_33) {
                                        var25_29 = null;
                                        in = null;
                                        throw var24_33;
                                    }
                                    try {}
                                    catch (IOException ioe) {
                                        DownloadManager.LOG.warning("Failed to close fileChannel.", new Object[0]);
                                        var25_28 = null;
                                        in = null;
                                        break block65;
                                    }
                                    fileChannel.close();
                                    var25_27 = null;
                                    in = null;
                                }
                            }
                            if (inRbs != null) {
                                try {}
                                catch (Throwable var26_41) {
                                    var27_39 = null;
                                    in = null;
                                    throw var26_41;
                                }
                                try {}
                                catch (IOException ioe) {
                                    DownloadManager.LOG.warning("Failed to close ReadableByteChannel.", new Object[0]);
                                    var27_38 = null;
                                    in = null;
                                    break block66;
                                }
                                inRbs.close();
                                var27_37 = null;
                                in = null;
                            }
                        }
                        if (in != null) {
                            try {}
                            catch (Throwable var28_49) {
                                var29_47 = null;
                                in = null;
                                throw var28_49;
                            }
                            try {}
                            catch (IOException ioe) {
                                DownloadManager.LOG.warning("Failed to close inputstream.", new Object[0]);
                                var29_46 = null;
                                in = null;
                                break block67;
                            }
                            in.close();
                            var29_45 = null;
                            in = null;
                        }
                    }
                    if (fos == null) throw var21_70;
                    try {}
                    catch (Throwable var30_69) {
                        block70: {
                            var31_55 = null;
                            ** try [egrp 10[TRYBLOCK] [19 : 723->818)] { 
lbl238:
                            // 1 sources

                            if (failed && localFile.exists()) {
                                DownloadManager.LOG.info("Will remove the incomplete file " + localFile.getAbsolutePath(), new Object[0]);
                                deleteOk = localFile.delete();
                                if (!deleteOk) {
                                    DownloadManager.LOG.warning("Could not remove the incomplete file " + localFile.getAbsolutePath() + ". You should try to remove it manually.", new Object[0]);
                                }
                            }
                            break block70;
lbl245:
                            // 1 sources

                            catch (SecurityException e) {
                                DownloadManager.LOG.warning("Failed to remove the incomplete file " + localFile.getAbsolutePath() + ". You should try to remove it manually.", new Object[0]);
                            }
                        }
                        fos = null;
                        throw var30_69;
                    }
                    try {}
                    catch (IOException ioe) {
                        block71: {
                            DownloadManager.LOG.warning("Failed to close outputstream.", new Object[0]);
                            var31_54 = null;
                            ** try [egrp 10[TRYBLOCK] [19 : 723->818)] { 
lbl256:
                            // 1 sources

                            if (failed && localFile.exists()) {
                                DownloadManager.LOG.info("Will remove the incomplete file " + localFile.getAbsolutePath(), new Object[0]);
                                deleteOk = localFile.delete();
                                if (!deleteOk) {
                                    DownloadManager.LOG.warning("Could not remove the incomplete file " + localFile.getAbsolutePath() + ". You should try to remove it manually.", new Object[0]);
                                }
                            }
                            break block71;
lbl263:
                            // 1 sources

                            catch (SecurityException e) {
                                DownloadManager.LOG.warning("Failed to remove the incomplete file " + localFile.getAbsolutePath() + ". You should try to remove it manually.", new Object[0]);
                            }
                        }
                        fos = null;
                        throw var21_70;
                    }
                    fos.close();
                    var31_53 = null;
                    ** try [egrp 10[TRYBLOCK] [19 : 723->818)] { 
lbl272:
                    // 1 sources

                    if (failed && localFile.exists()) {
                        DownloadManager.LOG.info("Will remove the incomplete file " + localFile.getAbsolutePath(), new Object[0]);
                        deleteOk = localFile.delete();
                        if (!deleteOk) {
                            DownloadManager.LOG.warning("Could not remove the incomplete file " + localFile.getAbsolutePath() + ". You should try to remove it manually.", new Object[0]);
                        }
                    }
                    break block72;
lbl279:
                    // 1 sources

                    catch (SecurityException e) {
                        DownloadManager.LOG.warning("Failed to remove the incomplete file " + localFile.getAbsolutePath() + ". You should try to remove it manually.", new Object[0]);
                    }
                }
                fos = null;
                throw var21_70;
            }
        }
        if (lastModified <= 0L) return;
        if (localFile.isFile() == false) return;
        if (localFile.setLastModified(lastModified) != false) return;
        DownloadManager.LOG.warning("Failed to set last modified of " + localFile, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String downloadToString(URL remoteFile, DownloadListener listener) throws DownloadException, SocketTimeoutException, IOException {
        String string;
        InputStream in;
        block19: {
            in = null;
            URLConnection urlConnection = null;
            boolean failed = false;
            String remoteFileName = remoteFile.toExternalForm();
            String path = remoteFile.toExternalForm();
            ReadableByteChannel inRbs = null;
            StringBuffer strBuffCont = null;
            try {
                try {
                    ConnectReturn ret = this.doConnect(remoteFile, listener);
                    urlConnection = ret.urlConnection;
                    in = urlConnection.getInputStream();
                    int totalLength = urlConnection.getContentLength();
                    ByteBuffer bb = ByteBuffer.allocate(4096);
                    Charset charset = Charset.forName("UTF-8");
                    CharsetDecoder decoder = charset.newDecoder();
                    CharBuffer charBuffer = null;
                    inRbs = Channels.newChannel(in);
                    strBuffCont = new StringBuffer();
                    int progress = 0;
                    int read = 0;
                    while ((read = inRbs.read(bb)) >= 0) {
                        bb.flip();
                        charBuffer = decoder.decode(bb);
                        strBuffCont.append(charBuffer.toString());
                        bb.clear();
                        listener.downloading(remoteFile.getFile(), progress += read, totalLength);
                    }
                    string = strBuffCont.toString();
                    Object var20_22 = null;
                    if (failed) break block19;
                }
                catch (IOException e) {
                    failed = true;
                    if (e instanceof SSLHandshakeException) {
                        throw (SSLHandshakeException)e;
                    }
                    String message = "Failed reading data from " + remoteFileName;
                    LOG.severe(message, new Object[0]);
                    if (!(listener instanceof DownloadFeedbackListener)) {
                        listener.downloadFailed(path.substring(path.lastIndexOf("/") + 1));
                        throw new DownloadException(message, (Throwable)e);
                    }
                    ((DownloadFeedbackListener)((Object)listener)).downloadFailed(path.substring(path.lastIndexOf("/") + 1), remoteFile.getHost() + (remoteFile.getPort() != -1 ? ":" + String.valueOf(remoteFile.getPort()) : ""));
                    throw new DownloadException(message, (Throwable)e);
                }
                catch (Exception e) {
                    failed = true;
                    throw new DownloadException(e.getMessage(), (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                Object var20_23 = null;
                if (!failed) {
                    if (listener instanceof DownloadFeedbackListener) {
                        ((DownloadFeedbackListener)((Object)listener)).finished(path.substring(path.lastIndexOf("/") + 1), remoteFile.getHost() + (remoteFile.getPort() != -1 ? ":" + String.valueOf(remoteFile.getPort()) : ""));
                    } else {
                        listener.finished(path.substring(path.lastIndexOf("/") + 1));
                    }
                }
                if (in == null) throw throwable;
                try {
                    try {
                        in.close();
                    }
                    catch (IOException ioe) {
                        LOG.warning("Failed to close inputstream.", new Object[0]);
                        Object var23_28 = null;
                        in = null;
                        throw throwable;
                    }
                    Object var23_27 = null;
                    in = null;
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    Object var23_29 = null;
                    in = null;
                    throw throwable2;
                }
            }
            if (listener instanceof DownloadFeedbackListener) {
                ((DownloadFeedbackListener)((Object)listener)).finished(path.substring(path.lastIndexOf("/") + 1), remoteFile.getHost() + (remoteFile.getPort() != -1 ? ":" + String.valueOf(remoteFile.getPort()) : ""));
            } else {
                listener.finished(path.substring(path.lastIndexOf("/") + 1));
            }
        }
        if (in == null) return string;
        try {}
        catch (Throwable throwable) {
            Object var23_26 = null;
            in = null;
            throw throwable;
        }
        try {}
        catch (IOException ioe) {
            LOG.warning("Failed to close inputstream.", new Object[0]);
            return string;
        }
        in.close();
        return string;
    }

    private ConnectReturn doConnect(URL remoteFile, DownloadListener listener) throws SocketTimeoutException, SSLHandshakeException, IOException, FileNotFoundException, DownloadException {
        LOG.fine("Opening connection to url: " + remoteFile.toExternalForm(), new Object[0]);
        URLConnection urlConnection = remoteFile.openConnection();
        ConnectReturn ret = new ConnectReturn(urlConnection, -1L);
        EmasUtilities.getInstance().enableNECertificateValidation(urlConnection);
        urlConnection.setConnectTimeout(this.SOCKET_TIMEOUT);
        urlConnection.setUseCaches(false);
        urlConnection.setReadTimeout(this.SOCKET_TIMEOUT);
        String path = remoteFile.getFile();
        int port = remoteFile.getPort();
        try {
            if (listener instanceof DownloadFeedbackListener) {
                ((DownloadFeedbackListener)((Object)listener)).connecting(remoteFile.getHost() + (port != -1 ? String.valueOf(port) : ""), path.substring(path.lastIndexOf("/") + 1));
            }
            LOG.fine("Doing urlConnection.connect()...", new Object[0]);
            urlConnection.connect();
            LOG.fine("Done urlConnection.connect()", new Object[0]);
        }
        catch (SocketTimeoutException e) {
            throw this.createWrappedSocketTimeoutException(remoteFile, e);
        }
        catch (SSLHandshakeException e) {
            LOG.warning("Failed to connect to: " + urlConnection.getURL().toExternalForm(), e);
            if (e.getCause() instanceof EOFException) {
                this.retryConnect(urlConnection, e);
            }
            throw e;
        }
        catch (SocketException e) {
            this.retryConnect(urlConnection, e);
        }
        catch (IOException e) {
            throw this.createWrappedIOException(urlConnection, e);
        }
        if (urlConnection instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)urlConnection;
            ret.lastModified = httpURLConnection.getLastModified();
            int responseCode = httpURLConnection.getResponseCode();
            if (responseCode != 200) {
                if (listener instanceof DownloadFeedbackListener) {
                    ((DownloadFeedbackListener)((Object)listener)).downloadFailed(path.substring(path.lastIndexOf("/") + 1), remoteFile.getHost() + (port != -1 ? ":" + String.valueOf(port) : ""));
                } else {
                    listener.downloadFailed(path.substring(path.lastIndexOf("/") + 1));
                }
                LOG.fine("HTTP Code: " + responseCode, new Object[0]);
                if (responseCode == 404) {
                    throw new FileNotFoundException("File " + remoteFile.toExternalForm() + " not found on server");
                }
                throw new DownloadException("Failed to download " + remoteFile.toExternalForm() + ". HTTP Code: " + responseCode);
            }
        }
        return ret;
    }

    public InputStream downloadToInputStream(URL remoteFile) throws DownloadException {
        try {
            URLConnection connection = remoteFile.openConnection();
            EmasUtilities.getInstance().enableNECertificateValidation(connection);
            InputStream is = connection.getInputStream();
            return is;
        }
        catch (IOException e) {
            throw new DownloadException("Could not download: " + remoteFile.toExternalForm(), (Throwable)e);
        }
    }

    private SocketTimeoutException createWrappedSocketTimeoutException(URL remoteFile, SocketTimeoutException e) {
        LOG.warning("Could not connect (timeout) to: " + remoteFile.getHost(), new Object[0]);
        int port = remoteFile.getPort();
        SocketTimeoutException resentExc = new SocketTimeoutException("Could not connect (timeout) to node " + remoteFile.getHost() + (port != -1 ? ":" + String.valueOf(port) : "") + " to download " + remoteFile.getPath());
        resentExc.setStackTrace(e.getStackTrace());
        resentExc.initCause(e);
        return resentExc;
    }

    private void retryConnect(URLConnection urlConnection, IOException originalException) throws SocketTimeoutException, SocketException, IOException {
        try {
            urlConnection.connect();
        }
        catch (SocketTimeoutException ex) {
            throw this.createWrappedSocketTimeoutException(urlConnection.getURL(), ex);
        }
        catch (SSLHandshakeException ex) {
            LOG.warning("Failed to connect to: " + urlConnection.getURL().toExternalForm(), ex);
            throw originalException;
        }
        catch (IOException ex) {
            throw this.createWrappedIOException(urlConnection, originalException);
        }
    }

    private IOException createWrappedIOException(URLConnection urlConnection, Exception originalException) {
        LOG.warning("Failed to connect to: " + urlConnection.getURL().toExternalForm(), originalException);
        IOException resentExc = new IOException("Could not download " + urlConnection.getURL().toExternalForm());
        resentExc.setStackTrace(originalException.getStackTrace());
        resentExc.initCause(originalException);
        return resentExc;
    }

    private class ConnectReturn {
        long lastModified;
        URLConnection urlConnection;

        private ConnectReturn(URLConnection urlConnection, long lastModified) {
            this.urlConnection = urlConnection;
            this.lastModified = lastModified;
        }
    }
}

