/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.launcher.testmode;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import se.ericsson.security.launcher.eprops.EKEY;
import se.ericsson.security.launcher.eprops.EProps;
import se.ericsson.security.launcher.testmode.TmException;
import se.ericsson.security.launcher.testmode.TmPropertyDefaults;
import se.ericsson.security.launcher.testmode.TmTestMode;
import se.ericsson.security.launcher.testmode.TmUtilities;
import se.ericsson.security.utils.EmLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TmProperty {
    TEST_MODE(""),
    DISABLE_JARS(""),
    DISABLE_SECONDARY_LAUNCHER("false"),
    DISABLE_SPLASH_WINDOW("false"),
    OVERRIDE_LIB(""),
    SEMLA(""),
    HTTP_ROOT(TmPropertyDefaults.DEFAULT_HTTP_ROOT),
    MIB(TmPropertyDefaults.DEFAULT_MIB_FILE),
    MOM(TmPropertyDefaults.DEFAULT_MOM_FILE),
    LOGGING_CONFIG_FILE("");

    private static final EmLogger LOG;
    private static final String EMPTY_STRING = "";
    private static final String MIB_PARSER_JAR = "mibparser.jar";
    private static final String PROBLEM_USER_LEVEL = "Error in test mode configuration data detected at startup";
    private final String defaultValue;
    private boolean isSet = false;
    private String value = null;

    private TmProperty(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getValue() {
        return this.getStringValue();
    }

    public boolean getBoolean() {
        String string = this.getStringValue();
        boolean bool = Boolean.valueOf(string);
        return bool;
    }

    public ArrayList<String> getArray() {
        return new ArrayList<String>(Arrays.asList(this.getStringValue().split(",")));
    }

    public boolean isSet() {
        return this.isSet;
    }

    public void setValue(boolean force, String value) throws TmException {
        if (force || !this.isSet) {
            this.value = this.validateValue(value);
            this.isSet = true;
        }
    }

    public void reset() throws TmException {
        this.value = null;
        this.isSet = false;
    }

    public String toShortString() {
        StringBuilder sb = new StringBuilder(this.name());
        while (sb.length() < 14) {
            sb.append(' ');
        }
        if (this.isSet) {
            sb.append(" = ").append(this.getValue());
        } else {
            sb.append(" : (not set)");
        }
        return sb.toString();
    }

    public String toString() {
        return "TmProperty." + this.toShortString();
    }

    private String getStringValue() {
        if (this.isSet) {
            return this.value;
        }
        return null;
    }

    private String validateValue(String wantedValue) throws TmException {
        String correctValue;
        EProps ep = new EProps();
        ep.put(EKEY.ACTION, "Validating LauncherTestmode configuration data for " + this.name());
        ep.put(EKEY.JAVA_METHOD, "TmProperty.validateValue");
        ep.put(EKEY.JAVA_PARAMS, EMPTY_STRING + this.name() + " = '" + wantedValue + "'");
        ep.put(EKEY.JAVA_INFO, "Old value : " + this.toString());
        ep.append(EKEY.ENV_OTHER_ENV, "\n   ", "TESTMODE_CFG_FILES=" + System.getenv("TESTMODE_CFG_FILES"));
        if (wantedValue == null) {
            throw new TmException("Cannot set value to 'null', use method reset instead");
        }
        this.value = wantedValue.equals(EMPTY_STRING) ? this.defaultValue : wantedValue;
        switch (this) {
            case HTTP_ROOT: {
                ArrayList<String> completeHttpRoots = new ArrayList<String>();
                ArrayList<String> httpRoots = new ArrayList<String>(Arrays.asList(this.value.split(",")));
                for (String httpRoot : httpRoots) {
                    if (httpRoot.equals("DEFAULT")) {
                        httpRoot = TmPropertyDefaults.DEFAULT_HTTP_ROOT;
                    } else if (httpRoot.equals(".")) {
                        httpRoot = this.getCurrentRoot();
                    }
                    this.validatePath(httpRoot, true, null);
                    httpRoot = this.addSlash(httpRoot);
                    completeHttpRoots.add(httpRoot);
                }
                correctValue = (String)completeHttpRoots.get(0);
                for (int i = 1; i < completeHttpRoots.size(); ++i) {
                    correctValue = correctValue + "," + (String)completeHttpRoots.get(i);
                }
                break;
            }
            case LOGGING_CONFIG_FILE: {
                this.validatePath(this.value, false, EMPTY_STRING);
                correctValue = this.value;
                break;
            }
            case MIB: 
            case MOM: {
                this.validatePath(this.value, false, "xml");
                correctValue = this.value;
                break;
            }
            case SEMLA: {
                StringBuilder sb = new StringBuilder();
                if (this.value.equals(EMPTY_STRING) || this.value.equals("DEFAULT")) {
                    sb.append(this.getDefaultOverrideLib());
                } else if (this.value.equals(".")) {
                    sb.append(this.getCurrentBlackLib());
                }
                sb.append(MIB_PARSER_JAR);
                this.value = sb.toString();
                this.validatePath(this.value, false, "jar");
                correctValue = this.value;
                break;
            }
            case OVERRIDE_LIB: {
                if (this.value.equals(EMPTY_STRING)) {
                    this.value = this.getDefaultOverrideLib();
                } else if (this.value.equals(".")) {
                    this.value = this.getCurrentBlackLib();
                }
                this.validatePath(this.value, true, null);
                correctValue = this.addSlash(this.value);
                break;
            }
            case TEST_MODE: {
                this.validateTestMode(this.value);
                correctValue = this.value;
                break;
            }
            case DISABLE_JARS: {
                if (this.value.equals(EMPTY_STRING)) {
                    this.value = Boolean.toString(TmUtilities.runningFromEclipse());
                }
                correctValue = this.value;
                break;
            }
            case DISABLE_SECONDARY_LAUNCHER: 
            case DISABLE_SPLASH_WINDOW: {
                correctValue = this.value;
                break;
            }
            default: {
                ep.put(EKEY.PROBLEM_USER_LEVEL, "Internal programming error in EMAS");
                ep.put(EKEY.PROBLEM_DESIGNER_LEVEL, "No validation implemented for " + this.name());
                throw new TmException(ep);
            }
        }
        return correctValue;
    }

    private String addSlash(String path) {
        if (!path.endsWith(File.separator)) {
            path = path + File.separator;
        }
        return path;
    }

    private void validatePath(String path, boolean directory, String extension) throws TmException {
        EProps ep = new EProps();
        ep.put(EKEY.ACTION, "Validating path for test mode property " + this.name());
        ep.put(EKEY.JAVA_PARAMS, "path=" + path + ", directory=" + directory + ", extension=" + extension);
        StringBuffer sb = new StringBuffer();
        sb.append("Validating property ");
        sb.append(this.name());
        sb.append(" for value: '");
        sb.append(path);
        sb.append("'");
        LOG.finest(TmUtilities.getLogMessage(sb.toString()), new Object[0]);
        try {
            File file = new File(path);
            if (!file.exists()) {
                ep.put(EKEY.PROBLEM_USER_LEVEL, PROBLEM_USER_LEVEL);
                ep.put(EKEY.PROBLEM_DESIGNER_LEVEL, "File/directory doesn't exist, " + path);
                throw new TmException("File/directory doesn't exist, " + path, ep, null);
            }
            if (!file.canRead()) {
                ep.put(EKEY.PROBLEM_USER_LEVEL, PROBLEM_USER_LEVEL);
                ep.put(EKEY.PROBLEM_DESIGNER_LEVEL, "No read access, " + path);
                throw new TmException("No read access, " + path, ep, null);
            }
            if (directory && !file.isDirectory()) {
                ep.put(EKEY.PROBLEM_USER_LEVEL, PROBLEM_USER_LEVEL);
                ep.put(EKEY.PROBLEM_DESIGNER_LEVEL, "Not a directory, " + path);
                throw new TmException("Not a directory, " + path, ep, null);
            }
            if (!(directory || EMPTY_STRING.equals(extension) || path.endsWith(extension))) {
                ep.put(EKEY.PROBLEM_USER_LEVEL, PROBLEM_USER_LEVEL);
                ep.put(EKEY.PROBLEM_DESIGNER_LEVEL, "Expected extension '" + extension + "' not found for " + path);
                throw new TmException("Expected extension '" + extension + "' not found", ep, null);
            }
        }
        catch (TmException e) {
            LOG.warning(TmUtilities.getLogMessage("Failed " + sb.toString()), e);
            throw e;
        }
    }

    private void validateTestMode(String value) throws TmException {
        TmTestMode testMode = TmTestMode.getEnum(value);
        if (testMode == TmTestMode.UNKNOWN) {
            EProps ep = new EProps();
            ep.put(EKEY.ACTION, "Validating value for test mode property " + this.name());
            ep.put(EKEY.JAVA_PARAMS, "value=" + value);
            ep.put(EKEY.PROBLEM_USER_LEVEL, PROBLEM_USER_LEVEL);
            ep.put(EKEY.PROBLEM_DESIGNER_LEVEL, "Expected value should be one of: " + TmTestMode.values());
            throw new TmException("TEST_MODE value '" + value + "' not implemented.", ep, null);
        }
    }

    private String getDefaultOverrideLib() {
        EProps ep = new EProps();
        ep.put(EKEY.ACTION, "Constructing default value for " + this.name());
        StringBuilder sb = new StringBuilder();
        sb.append(System.getProperty("user.home"));
        sb.append(File.separatorChar);
        sb.append("BLACK_LIB");
        sb.append(File.separatorChar);
        return sb.toString();
    }

    private String getCurrentBlackLib() {
        EProps ep = new EProps();
        ep.put(EKEY.ACTION, "Get current black lib directory for " + this.name());
        StringBuilder sb = new StringBuilder();
        sb.append(System.getProperty("user.dir"));
        sb.append(File.separatorChar);
        sb.append("BLACK_LIB");
        sb.append(File.separatorChar);
        return sb.toString();
    }

    private String getCurrentRoot() {
        EProps ep = new EProps();
        ep.put(EKEY.ACTION, "Get current semla root directory for " + this.name());
        StringBuilder sb = new StringBuilder();
        sb.append(System.getProperty("user.dir"));
        sb.append(File.separatorChar);
        sb.append("semla_rbs");
        sb.append(File.separatorChar);
        return sb.toString();
    }

    public static boolean isAnyPropSet() {
        for (TmProperty tmProp : TmProperty.values()) {
            if (!tmProp.isSet()) continue;
            return true;
        }
        return false;
    }

    public static void resetAllProps() {
        for (TmProperty tmProp : TmProperty.values()) {
            tmProp.reset();
        }
    }

    public static String toStringAll() {
        StringBuilder sb = new StringBuilder();
        sb.append("TmProperty:");
        for (TmProperty tmProp : TmProperty.values()) {
            sb.append("\n   ").append(tmProp.toShortString());
        }
        return sb.toString();
    }

    static {
        LOG = EmLogger.STARTER;
    }
}

