/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.launcher.ui;

import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.net.ssl.SSLHandshakeException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.LineBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import se.ericsson.security.launcher.download.FileNotFoundException;
import se.ericsson.security.launcher.ui.AboutDialog;
import se.ericsson.security.launcher.ui.TableSorter;
import se.ericsson.security.launcher.util.Localizer;
import se.ericsson.security.launcher.util.PropertyManager;
import se.ericsson.security.launcher.util.UrlUtilities;
import se.ericsson.security.starter.ResourceLocator;
import se.ericsson.security.starter.investigator.EmApplicationInfo;
import se.ericsson.security.starter.investigator.EmApplicationInfoFactory;
import se.ericsson.security.starter.investigator.NodeType;
import se.ericsson.security.starter.investigator.NodeTypeInvestigator;
import se.ericsson.security.starter.investigator.resource.ResourceInfo;
import se.ericsson.security.starter.investigator.resource.ResourceInfoFactory;
import se.ericsson.security.utils.EmLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NEAddressDialog
implements ActionListener,
WindowListener {
    private static final EmLogger LOG = EmLogger.STARTER;
    private static final String COPYRIGHT_YEAR = "2014";
    private static final String AVAILABLE_STATE = "Available";
    private static final String NOT_AVAILABLE_STATE = "Not available";
    private boolean includeNodeType = false;
    private String address = null;
    private JFrame launchFrame;
    private JLabel rainbowLine;
    private final Hashtable<String, TableElement> visitedURLs;
    private JTable nodeTable;
    private TableSorter tableSorter;
    private static final boolean ALLOW_ROW_SELECTION = true;
    private final int COL_ID_ADDRESS = 0;
    private final int COL_ID_NAME = 1;
    private final int COL_ID_COMMENT = 2;
    private final int COL_ID_STATE;
    private final int COL_ID_TYPE;
    private final int COL_ID_FAVORITE;
    private final StringBuilder emAppAddressBeingContacted = new StringBuilder();
    private volatile double lastEmAppUpdateID;
    private JButton btAdd;
    private JButton btRemove;
    private JButton btFavorite;
    private JButton btConnect;
    private JButton btAbout;
    private EMAppButton defaultEMAppBtn;
    private final String ICON_FILE_RAINBOW = "rainbowline.png";
    private final String ICON_FILE_LOGO = "ericsson_logo.png";
    private final String ICON_FILE_ADD = "icon_add.png";
    private final String ICON_FILE_REMOVE = "icon_remove.png";
    private final String ICON_FILE_FAVORITE_SET = "icon_favorite_set.png";
    private final String ICON_FILE_FAVORITE_UNSET = "icon_favorite_unset.png";
    private final String ICON_FILE_FAVORITE_CELL = "icon_favorite_cell.png";
    private final String ICON_FILE_ABOUT = "icon_about.png";
    private Icon favoriteSetIcon;
    private Icon favoriteUnsetIcon;
    private ImageIcon favoriteCellSetIcon;
    private ImageIcon favoriteCellNotSetIcon;
    private JTextFieldWithHint addressField;
    private JTextFieldWithHint nameField;
    private JTextFieldWithHint commentField;
    private boolean waits = false;
    private boolean waitingToConnect = true;
    private boolean tableListenerIsModifyingTextFields = false;
    private transient PropertyManager pm;
    private JPopupMenu popup = null;
    private JMenuItem cleanMenuItem = null;
    private JPanel availableEmAppsPanel = null;
    private boolean showAllFoundEmApplications = false;
    private boolean hasStartConfigFile = true;
    private JPanel connectAreaPanel = null;
    private JLabel statusMessage = new JLabel();
    private NodeTypeInvestigator nodeTypeInvestigator;
    private ResourceLocator resourceLocator;
    private volatile boolean stopAllThreads = false;

    public NEAddressDialog(String theIcon, String cmdConfigFile) {
        this(theIcon, cmdConfigFile, false);
    }

    public NEAddressDialog(String theIcon, String cmdConfigFile, boolean checkAllEmApplications) {
        this.pm = PropertyManager.getInstance(this.getClass().getClassLoader());
        this.visitedURLs = new Hashtable(203);
        this.showAllFoundEmApplications = checkAllEmApplications;
        this.resourceLocator = new ResourceLocator();
        if (cmdConfigFile == null || "".equals(cmdConfigFile)) {
            this.hasStartConfigFile = false;
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (InstantiationException e) {
            LOG.fine("InstantiationException during setLookAndFeel: " + e.getMessage(), new Object[0]);
        }
        catch (ClassNotFoundException e) {
            LOG.fine("ClassNotFoundException during setLookAndFeel: " + e.getMessage(), new Object[0]);
        }
        catch (UnsupportedLookAndFeelException e) {
            LOG.fine("UnsupportedLookAndFeelException during setLookAndFeel: " + e.getMessage(), new Object[0]);
        }
        catch (IllegalAccessException e) {
            LOG.fine("IllegalAccessException during setLookAndFeel: " + e.getMessage(), new Object[0]);
        }
        this.launchFrame = new JFrame();
        this.launchFrame.setDefaultCloseOperation(3);
        this.launchFrame.setName("Launcher");
        this.launchFrame.setIconImage(new ImageIcon(theIcon).getImage());
        this.launchFrame.setTitle(Localizer.getString("neaddress_title"));
        ArrayList<String> columnNames = new ArrayList<String>();
        columnNames.add(Localizer.getString("address"));
        columnNames.add(Localizer.getString("name"));
        columnNames.add(Localizer.getString("comment"));
        if (this.showAllFoundEmApplications && this.includeNodeType) {
            this.COL_ID_TYPE = columnNames.size();
            columnNames.add(Localizer.getString("type"));
        } else {
            this.COL_ID_TYPE = -1;
        }
        if (this.showAllFoundEmApplications) {
            this.COL_ID_STATE = columnNames.size();
            columnNames.add(Localizer.getString("state"));
        } else {
            this.COL_ID_STATE = -1;
        }
        this.COL_ID_FAVORITE = columnNames.size();
        columnNames.add(Localizer.getString("favorite"));
        this.createRainbowLine();
        this.createTextFields();
        this.createButtons();
        this.createNodeTable(columnNames.toArray(new String[columnNames.size()]));
        this.assembleGui();
        this.updateTraversalPolicy();
        final NEAddressDialog syncObject = this;
        this.launchFrame.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "escapeAction");
        this.launchFrame.getRootPane().getActionMap().put("escapeAction", new AbstractAction(){
            private static final long serialVersionUID = 279140378021263106L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent ae) {
                NEAddressDialog.this.address = null;
                NEAddressDialog nEAddressDialog = syncObject;
                synchronized (nEAddressDialog) {
                    if (NEAddressDialog.this.waits) {
                        syncObject.notify();
                    }
                }
            }
        });
        this.launchFrame.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke("F5"), "myRefreshAction");
        this.launchFrame.getRootPane().getActionMap().put("myRefreshAction", new AbstractAction(){
            private static final long serialVersionUID = 279140378021263106L;

            public void actionPerformed(ActionEvent ae) {
                LOG.finer("F5 pressed. Starting StateUpdater thread called F5_KeyPressed", new Object[0]);
            }
        });
        this.launchFrame.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke("ENTER"), "enterAction");
        this.launchFrame.getRootPane().getActionMap().put("enterAction", new AbstractAction(){
            private static final long serialVersionUID = -4854265056842215560L;

            public void actionPerformed(ActionEvent ae) {
                JButton connectBtn = NEAddressDialog.this.launchFrame.getRootPane().getDefaultButton();
                if (connectBtn != null) {
                    connectBtn.doClick();
                }
            }
        });
        this.nodeTable.getInputMap(1).put(KeyStroke.getKeyStroke("ENTER"), "none");
        this.launchFrame.addWindowListener(this);
        this.launchFrame.pack();
        this.launchFrame.setLocationRelativeTo(null);
        this.launchFrame.setVisible(true);
        this.popup = new JPopupMenu();
        this.cleanMenuItem = new JMenuItem(" Clear all input fields ");
        this.cleanMenuItem.addActionListener(this);
        this.popup.add(this.cleanMenuItem);
        if (this.COL_ID_STATE != -1) {
            this.nodeTypeInvestigator = new NodeTypeInvestigator();
            this.nodeTypeInvestigator.init();
        }
    }

    private void createRainbowLine() {
        URL url = NEAddressDialog.class.getResource("rainbowline.png");
        final Image image = Toolkit.getDefaultToolkit().getImage(url);
        this.rainbowLine = new JLabel(new ImageIcon(image));
        Dimension size = this.rainbowLine.getPreferredSize();
        size.width = 1;
        this.rainbowLine.setPreferredSize(size);
        this.rainbowLine.addComponentListener(new ComponentAdapter(){
            private Image orgImage;
            private Dimension prevSize;
            {
                this.orgImage = image;
                this.prevSize = NEAddressDialog.this.rainbowLine.getSize();
            }

            public void componentResized(ComponentEvent e) {
                JLabel label = (JLabel)e.getComponent();
                Dimension newSize = label.getSize();
                if (newSize.width > 0 && newSize.height > 0 && !newSize.equals(this.prevSize)) {
                    Image scaledImage = this.orgImage.getScaledInstance(newSize.width, newSize.height, 2);
                    label.setIcon(new ImageIcon(scaledImage));
                    this.prevSize = newSize;
                }
            }
        });
    }

    private void createTextFields() {
        this.addressField = new JTextFieldWithHint(Localizer.getString("address_hint") + " *");
        this.nameField = new JTextFieldWithHint(Localizer.getString("name"));
        this.commentField = new JTextFieldWithHint(Localizer.getString("comment"));
        this.addressField.setName("address");
        this.nameField.setName("name");
        this.commentField.setName("comment");
        this.addressField.addFocusListener(new AddressFieldFocusListener());
        this.nameField.addFocusListener(new CommonFocusListener(this.nameField));
        this.commentField.addFocusListener(new CommonFocusListener(this.commentField));
        this.addressField.addCaretListener(new CommonCaretListener(this.addressField, 0));
        this.nameField.addCaretListener(new CommonCaretListener(this.nameField, 1));
        this.commentField.addCaretListener(new CommonCaretListener(this.commentField, 2));
        PopupListener popupListener = new PopupListener();
        this.addressField.addMouseListener(popupListener);
        this.nameField.addMouseListener(popupListener);
        this.commentField.addMouseListener(popupListener);
        this.addressField.setToolTipText(Localizer.getString("address_tooltip"));
        this.nameField.setToolTipText(Localizer.getString("name_tooltip"));
        this.commentField.setToolTipText(Localizer.getString("comment_tooltip"));
    }

    private void createButtons() {
        Dimension buttonSize = new Dimension(this.addressField.getPreferredSize());
        buttonSize.width = buttonSize.height;
        this.favoriteSetIcon = this.getIcon("icon_favorite_set.png", buttonSize);
        this.favoriteUnsetIcon = this.getIcon("icon_favorite_unset.png", buttonSize);
        Icon favCellIcon = this.getIcon("icon_favorite_cell.png", new Dimension(20, 20));
        this.favoriteCellSetIcon = (ImageIcon)favCellIcon;
        this.favoriteCellNotSetIcon = new ImageIcon();
        this.btAbout = new JButton(this.getIcon("icon_about.png", new Dimension(20, 20)));
        this.btAdd = new JButton(this.getIcon("icon_add.png", buttonSize));
        this.btRemove = new JButton(this.getIcon("icon_remove.png", buttonSize));
        this.btFavorite = new JButton(this.favoriteSetIcon);
        this.btConnect = new JButton(Localizer.getString("connect"));
        this.btAbout.addActionListener(this);
        this.btAdd.addActionListener(this);
        this.btRemove.addActionListener(this);
        this.btFavorite.addActionListener(this);
        this.btConnect.addActionListener(this);
        this.btAdd.setMnemonic(Localizer.getString("add_mnemonic").charAt(0));
        this.btRemove.setMnemonic(Localizer.getString("remove_mnemonic").charAt(0));
        this.btFavorite.setMnemonic(Localizer.getString("favorite_mnemonic").charAt(0));
        this.btConnect.setMnemonic(Localizer.getString("connect_mnemonic").charAt(0));
        this.btAbout.setToolTipText(Localizer.getString("about_tooltip") + " " + Localizer.getString("neaddress_title"));
        this.btAdd.setToolTipText(Localizer.getString("add_tooltip"));
        this.btRemove.setToolTipText(Localizer.getString("remove_tooltip"));
        this.btFavorite.setToolTipText(Localizer.getString("favorite_set_tooltip"));
        this.btConnect.setToolTipText(Localizer.getString("connect_tooltip"));
        this.btAbout.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                NEAddressDialog.this.launchFrame.getRootPane().setDefaultButton(NEAddressDialog.this.btAbout);
            }
        });
        this.btAdd.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                NEAddressDialog.this.setDefaultButton(NEAddressDialog.this.btAdd);
            }
        });
        this.btRemove.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                NEAddressDialog.this.setDefaultButton(NEAddressDialog.this.btRemove);
            }
        });
        this.btFavorite.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                NEAddressDialog.this.setDefaultButton(NEAddressDialog.this.btFavorite);
            }
        });
        this.btAbout.setEnabled(true);
        this.btAdd.setEnabled(false);
        this.btRemove.setEnabled(false);
        this.btFavorite.setEnabled(false);
        this.btConnect.setEnabled(false);
    }

    private void createNodeTable(String[] columnNames) {
        File favoriteNodes = new File(this.pm.getString("se.ericsson.security.launcher.visitedfdb", true));
        File normalNodes = new File(this.pm.getString("se.ericsson.security.launcher.visiteddb", false));
        this.readUrlsFromFile(favoriteNodes, true);
        this.readUrlsFromFile(normalNodes, false);
        DefaultTableModel tableModel = new DefaultTableModel(this.getDataForNodeTable(this.visitedURLs), columnNames){
            private static final long serialVersionUID = 9028608921944790715L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }

            @Override
            public Class<?> getColumnClass(int c) {
                Object columnValue = this.getValueAt(0, c);
                if (columnValue == null) {
                    return Object.class;
                }
                return columnValue.getClass();
            }
        };
        this.tableSorter = new TableSorter(tableModel);
        this.tableSorter.setColumnComparator(ImageIcon.class, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (o1 instanceof ImageIcon && o2 instanceof ImageIcon) {
                    Integer width1 = ((ImageIcon)o1).getIconWidth();
                    Integer width2 = ((ImageIcon)o2).getIconWidth();
                    return -width1.compareTo(width2);
                }
                return 0;
            }
        });
        this.nodeTable = new JTable(this.tableSorter);
        this.tableSorter.setTableHeader(this.nodeTable.getTableHeader());
        this.nodeTable.setBorder(new LineBorder(Color.black));
        this.nodeTable.setRowHeight(25);
        TableColumnModel columnModel = this.nodeTable.getColumnModel();
        columnModel.getColumn(0).setPreferredWidth(120);
        columnModel.getColumn(1).setPreferredWidth(120);
        columnModel.getColumn(2).setPreferredWidth(120);
        TableColumn favoriteColumn = columnModel.getColumn(this.COL_ID_FAVORITE);
        favoriteColumn.setMaxWidth(favoriteColumn.getPreferredWidth());
        this.nodeTable.setSelectionMode(0);
        ListSelectionModel rowSM1 = this.nodeTable.getSelectionModel();
        rowSM1.addListSelectionListener(new NodeTableListener());
        KeyStroke tab = KeyStroke.getKeyStroke(9, 0);
        HashSet<AWTKeyStroke> forwardKeys = new HashSet<AWTKeyStroke>();
        forwardKeys.addAll(this.nodeTable.getFocusTraversalKeys(0));
        forwardKeys.add(tab);
        this.nodeTable.setFocusTraversalKeys(0, forwardKeys);
        KeyStroke shiftTab = KeyStroke.getKeyStroke(9, 64);
        HashSet<AWTKeyStroke> backwardKeys = new HashSet<AWTKeyStroke>();
        backwardKeys.addAll(this.nodeTable.getFocusTraversalKeys(1));
        backwardKeys.add(shiftTab);
        this.nodeTable.setFocusTraversalKeys(1, backwardKeys);
    }

    private void assembleGui() {
        Container contentPane = this.launchFrame.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints rainbowGBC = new GridBagConstraints();
        rainbowGBC.anchor = 11;
        rainbowGBC.fill = 2;
        rainbowGBC.gridx = 0;
        rainbowGBC.gridy = 0;
        rainbowGBC.gridwidth = 0;
        contentPane.add((Component)this.rainbowLine, rainbowGBC);
        JLabel logo = new JLabel(this.getIcon("ericsson_logo.png", new Dimension(17, 22)));
        logo.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        GridBagConstraints logoGBC = new GridBagConstraints();
        logoGBC.anchor = 18;
        logoGBC.gridx = 0;
        logoGBC.gridy = 1;
        contentPane.add((Component)logo, logoGBC);
        GridBagConstraints aboutGBC = new GridBagConstraints();
        aboutGBC.anchor = 13;
        aboutGBC.gridx = 2;
        aboutGBC.gridy = 1;
        contentPane.add((Component)this.btAbout, aboutGBC);
        GridBagConstraints fieldGBC = new GridBagConstraints();
        fieldGBC.anchor = 17;
        fieldGBC.fill = 2;
        fieldGBC.gridx = 0;
        fieldGBC.gridy = 2;
        fieldGBC.weightx = 1.0;
        JPanel tfPanel = new JPanel(new GridLayout(1, 0));
        tfPanel.add(this.addressField);
        tfPanel.add(this.nameField);
        tfPanel.add(this.commentField);
        contentPane.add((Component)tfPanel, fieldGBC);
        GridBagConstraints buttonGBC = new GridBagConstraints();
        buttonGBC.anchor = 13;
        buttonGBC.fill = 0;
        buttonGBC.gridx = 1;
        buttonGBC.gridy = 2;
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.btAdd);
        buttonPanel.add(this.btRemove);
        buttonPanel.add(this.btFavorite);
        contentPane.add((Component)buttonPanel, buttonGBC);
        GridBagConstraints nodeTableGBC = new GridBagConstraints();
        nodeTableGBC.anchor = 17;
        nodeTableGBC.fill = 1;
        nodeTableGBC.gridx = 0;
        nodeTableGBC.gridy = 3;
        nodeTableGBC.gridwidth = 2;
        nodeTableGBC.weightx = 1.0;
        nodeTableGBC.weighty = 1.0;
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(this.nodeTable);
        scrollPane.setVerticalScrollBarPolicy(20);
        contentPane.add((Component)scrollPane, nodeTableGBC);
        if (this.showAllFoundEmApplications) {
            this.availableEmAppsPanel = new JPanel(new GridLayout(1, 1));
            this.availableEmAppsPanel.setPreferredSize(new Dimension(220, 100));
            this.availableEmAppsPanel.setMinimumSize(new Dimension(220, 100));
            GridBagConstraints emAppGBC = new GridBagConstraints();
            emAppGBC.anchor = 18;
            emAppGBC.fill = 1;
            emAppGBC.gridx = 2;
            emAppGBC.gridy = 3;
            contentPane.add((Component)this.availableEmAppsPanel, emAppGBC);
        } else {
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 0));
            this.statusMessage.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
            panel.add(this.statusMessage);
            panel.add(this.btConnect);
            this.connectAreaPanel = new JPanel();
            GridBagConstraints connectAreaGBC = new GridBagConstraints();
            connectAreaGBC.anchor = 12;
            connectAreaGBC.fill = 0;
            connectAreaGBC.gridx = 0;
            connectAreaGBC.gridy = 4;
            connectAreaGBC.gridwidth = 2;
            this.connectAreaPanel.add(panel);
            contentPane.add((Component)this.connectAreaPanel, connectAreaGBC);
        }
    }

    private Icon getIcon(String fileName, Dimension size) {
        URL url = NEAddressDialog.class.getResource(fileName);
        Image image = Toolkit.getDefaultToolkit().getImage(url);
        if (size != null) {
            image = image.getScaledInstance(size.width, size.height, 4);
        }
        return new ImageIcon(image);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getAddress() {
        URL url = null;
        if (this.waitingToConnect) {
            try {
                NEAddressDialog nEAddressDialog = this;
                synchronized (nEAddressDialog) {
                    this.waits = true;
                    this.wait();
                    this.waits = false;
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (!this.stopAllThreads) {
            url = UrlUtilities.getURL(this.address);
            if (!this.showAllFoundEmApplications && !this.hasStartConfigFile) {
                LOG.fine("No configuration file on cmd. Fetching emapplication info to determine default configuration file.", new Object[0]);
                this.statusMessage.setText("No configuration file passed as start argument, trying to fetch default file...");
                this.updateButtons();
                try {
                    this.resourceLocator.updateCurrentInfos(url);
                }
                catch (Exception e) {
                    LOG.fine("Could not update ResourceLocator, address = " + this.address, new Object[0]);
                }
            }
        }
        this.launchFrame.setVisible(false);
        this.launchFrame.dispose();
        return url;
    }

    private Object[][] getDataForNodeTable(Hashtable<String, TableElement> urls) {
        Object[][] tableData = new Object[urls.size()][];
        String[] addresses = urls.keySet().toArray(new String[urls.size()]);
        Arrays.sort(addresses, null);
        for (int i = 0; i < addresses.length; ++i) {
            TableElement element = urls.get(addresses[i]);
            ArrayList<Object> rowData = new ArrayList<Object>();
            rowData.add(element.getAddress());
            rowData.add(element.getName());
            rowData.add(element.getComment());
            if (this.COL_ID_TYPE != -1) {
                rowData.add(element.getType());
            }
            if (this.COL_ID_STATE != -1) {
                rowData.add(element.getState());
            }
            rowData.add(element.getFavoriteObject());
            tableData[i] = rowData.toArray(new Object[rowData.size()]);
        }
        return tableData;
    }

    private void readUrlsFromFile(File file, boolean isFavoriteFile) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(file));
            while ((line = br.readLine()) != null) {
                String address_ = "";
                String name_ = "";
                String comment_ = "";
                String type_ = "";
                String state_ = "";
                int spaceDelimiterPos = line.indexOf(" ");
                if (spaceDelimiterPos == -1) {
                    address_ = line;
                } else {
                    address_ = line.substring(0, spaceDelimiterPos);
                    int nameDelimiterPos = line.substring(spaceDelimiterPos + 1).indexOf(59);
                    if (nameDelimiterPos == -1) {
                        name_ = line.substring(spaceDelimiterPos + 1);
                    } else {
                        name_ = line.substring(spaceDelimiterPos + 1, spaceDelimiterPos + 1 + nameDelimiterPos);
                        comment_ = line.substring(spaceDelimiterPos + 1 + nameDelimiterPos + 1);
                        int semi = comment_.indexOf(";");
                        if (semi > -1) {
                            if (comment_.length() > semi + 1) {
                                type_ = comment_.substring(semi + 1);
                            }
                            comment_ = comment_.substring(0, semi);
                        }
                    }
                }
                TableElement element = new TableElement(address_, name_, comment_, type_, state_, isFavoriteFile);
                TableElement savedElement = this.visitedURLs.get(address_);
                if (savedElement != null && !savedElement.getAddress().equals("")) continue;
                this.visitedURLs.put(address_, element);
            }
            br.close();
        }
        catch (IOException e) {
            LOG.fine("Exception when reading visited URLs from file: " + e.getMessage(), new Object[0]);
        }
    }

    private void writeUrlsToFile() {
        LOG.finer("writeUrlsToFile Thread: " + Thread.currentThread().getName(), new Object[0]);
        File favoriteNodes = new File(this.pm.getString("se.ericsson.security.launcher.visitedfdb", true));
        File normalNodes = new File(this.pm.getString("se.ericsson.security.launcher.visiteddb", true));
        this.writeUrlsToFile(favoriteNodes, true);
        this.writeUrlsToFile(normalNodes, false);
    }

    private void writeUrlsToFile(File file, boolean isFavoriteFile) {
        try {
            boolean createdDirs;
            File parentDirectory;
            if (file.exists()) {
                file.delete();
            }
            if ((parentDirectory = file.getParentFile()) != null && !parentDirectory.exists() && !(createdDirs = parentDirectory.mkdirs())) {
                throw new IOException("Could not create visiteddb parent directory: " + parentDirectory.getName());
            }
            file.createNewFile();
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            Enumeration<String> addresses = this.visitedURLs.keys();
            while (addresses.hasMoreElements()) {
                String address_ = addresses.nextElement();
                TableElement element = this.visitedURLs.get(address_);
                if (isFavoriteFile && !element.isFavorite()) continue;
                String name_ = element.getName();
                String comment_ = element.getComment();
                String type_ = element.getType();
                bw.write(address_ + " " + name_ + ";" + comment_ + ";" + type_);
                bw.newLine();
            }
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            LOG.finer("Exception while writing to visited URLs file. " + e.getMessage(), new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btAdd) {
            this.addToNodeTable();
            return;
        }
        if (e.getSource() == this.btRemove) {
            this.removeFromNodeTable();
            this.addressField.setText("");
            this.nameField.setText("");
            this.commentField.setText("");
            return;
        }
        if (e.getSource() == this.btFavorite) {
            if (this.nodeTable.getSelectedRowCount() == 1) {
                this.toggleFavoriteForSelectedRow();
            } else if (this.nodeTable.getSelectedRowCount() == 0) {
                this.toggleFavoriteForTextInput();
            }
            return;
        }
        if (e.getSource() == this.btConnect) {
            String addr = this.addressField.getTextIgnoreHint();
            if (addr.length() == 0) {
                return;
            }
            this.address = addr;
            this.waitingToConnect = false;
        } else {
            if (e.getSource() == this.cleanMenuItem) {
                this.addressField.setText("");
                this.nameField.setText("");
                this.commentField.setText("");
                this.nodeTable.clearSelection();
                this.updateNodeTable(this.visitedURLs);
                return;
            }
            if (e.getSource() == this.btAbout) {
                this.showAboutDialog();
                return;
            }
            if (e.getSource() instanceof EMAppButton) {
                EMAppButton button = (EMAppButton)e.getSource();
                this.address = button.address.toString();
                this.waitingToConnect = false;
                button.emApp.setSelected(true);
            }
        }
        NEAddressDialog nEAddressDialog = this;
        synchronized (nEAddressDialog) {
            if (this.waits) {
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void showAboutDialog() {
        block13: {
            markfile = this.getClass().getResourceAsStream("/markfile");
            mark = "Could not get info";
            if (markfile != null) {
                p = Pattern.compile("(CX[CPS][0-9[/_]]{6,11}) ([PR]\\d{0,4}[A-Z]{0,2}\\d{0,3})", 2);
                br = null;
                try {
                    try {
                        br = new BufferedReader(new InputStreamReader(markfile));
                        while (br.ready()) {
                            line = br.readLine();
                            m = p.matcher(line);
                            if (!m.find()) continue;
                            mark = m.group();
                            break;
                        }
                        var8_9 = null;
                        if (br == null) break block13;
                    }
                    catch (IOException ex) {
                        NEAddressDialog.LOG.warning("Could not read markfile", new Object[0]);
                        var8_10 = null;
                        if (br != null) {
                            try {
                                br.close();
                            }
                            catch (IOException e) {}
                        }
                        break block13;
                    }
                }
                catch (Throwable var7_15) {
                    var8_11 = null;
                    if (br == null) throw var7_15;
                    ** try [egrp 2[TRYBLOCK] [4 : 132->140)] { 
lbl33:
                    // 1 sources

                    br.close();
                    throw var7_15;
lbl35:
                    // 1 sources

                    catch (IOException e) {
                        // empty catch block
                    }
                    throw var7_15;
                }
                try {}
                catch (IOException e) {}
                br.close();
            }
        }
        text = new ArrayList<String>(5);
        text.add("Java (JRE): " + System.getProperty("java.vendor") + " " + System.getProperty("java.version"));
        jarName = "launcher.jar";
        try {
            jarName = new File(NEAddressDialog.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getName();
        }
        catch (Exception e) {
            NEAddressDialog.LOG.fine("Getting name of jar file failed", new Object[0]);
        }
        text.add(jarName + ": " + mark);
        about = new AboutDialog(this.launchFrame, Localizer.getString("neaddress_title"));
        about.initAboutDialog();
        about.fillAboutTextAreaWithContents(Localizer.getString("neaddress_title"), null, "2014", "", text);
        about.pack();
        about.setLocationRelativeTo(this.launchFrame);
        about.setVisible(true);
    }

    private boolean isNodeExistInTable() {
        String address_ = this.addressField.getTextIgnoreHint().trim();
        String name_ = this.nameField.getTextIgnoreHint().trim();
        String comment_ = this.commentField.getTextIgnoreHint().trim();
        boolean returnValue = false;
        TableElement oldElement = this.visitedURLs.get(address_);
        if (oldElement != null && name_.equals(oldElement.getName()) && comment_.equals(oldElement.getComment())) {
            returnValue = true;
        }
        return returnValue;
    }

    private boolean isAddressExistInTable() {
        String address_ = this.addressField.getTextIgnoreHint().trim();
        return this.visitedURLs.get(address_) != null;
    }

    private void updateButtons() {
        boolean remState;
        boolean addState;
        boolean addressIsSet;
        boolean bl = addressIsSet = this.addressField.getTextIgnoreHint().length() > 0;
        if (!this.showAllFoundEmApplications) {
            if (!this.waitingToConnect) {
                this.btConnect.setEnabled(false);
            } else if (addressIsSet != this.btConnect.isEnabled()) {
                this.btConnect.setEnabled(addressIsSet);
            }
        }
        boolean bl2 = addState = addressIsSet && !this.isNodeExistInTable();
        if (addState != this.btAdd.isEnabled()) {
            this.btAdd.setEnabled(addState);
        }
        boolean bl3 = remState = addressIsSet || this.nameField.getTextIgnoreHint().length() > 0 || this.commentField.getTextIgnoreHint().length() > 0;
        if (remState != this.btRemove.isEnabled()) {
            this.btRemove.setEnabled(remState);
        }
        int[] selectedRows = this.nodeTable.getSelectedRows();
        this.btFavorite.setEnabled(addressIsSet);
        if (selectedRows.length == 1) {
            String addr = (String)this.nodeTable.getValueAt(selectedRows[0], 0);
            TableElement element = this.visitedURLs.get(addr);
            if (element.isFavorite()) {
                this.btFavorite.setIcon(this.favoriteUnsetIcon);
                this.btFavorite.setToolTipText(Localizer.getString("favorite_unset_tooltip"));
            } else {
                this.btFavorite.setIcon(this.favoriteSetIcon);
                this.btFavorite.setToolTipText(Localizer.getString("favorite_set_tooltip"));
            }
        } else if (!this.isAddressExistInTable()) {
            this.btFavorite.setIcon(this.favoriteSetIcon);
            this.btFavorite.setToolTipText(Localizer.getString("favorite_set_tooltip"));
        } else {
            String addr = this.addressField.getTextIgnoreHint().trim();
            TableElement element = this.visitedURLs.get(addr);
            if (element.isFavorite()) {
                this.btFavorite.setIcon(this.favoriteUnsetIcon);
                this.btFavorite.setToolTipText(Localizer.getString("favorite_unset_tooltip"));
            } else {
                this.btFavorite.setIcon(this.favoriteSetIcon);
                this.btFavorite.setToolTipText(Localizer.getString("favorite_set_tooltip"));
            }
        }
    }

    private void toggleFavoriteForTextInput() {
        String address_ = this.addressField.getTextIgnoreHint().trim();
        String name_ = this.nameField.getTextIgnoreHint().trim();
        String comment_ = this.commentField.getTextIgnoreHint().trim();
        String type_ = "";
        String state_ = "";
        boolean favorite_ = true;
        address_ = address_.replaceAll(" ", "");
        name_ = name_.replaceAll(";", "");
        comment_ = comment_.replaceAll(";", "");
        if (address_.length() == 0) {
            return;
        }
        this.address = address_;
        TableElement oldElement = this.visitedURLs.get(address_);
        if (oldElement != null) {
            type_ = oldElement.getType();
            state_ = oldElement.getState();
            favorite_ = !oldElement.isFavorite();
        }
        TableElement newElement = new TableElement(address_, name_, comment_, type_, state_, favorite_);
        this.visitedURLs.put(address_, newElement);
        this.writeUrlsToFile();
        this.updateNodeTable(this.visitedURLs);
        this.nodeTable.requestFocus();
        for (int i = 0; i < this.nodeTable.getRowCount(); ++i) {
            String rowAddress = (String)this.nodeTable.getValueAt(i, 0);
            if (!rowAddress.equals(address_)) continue;
            this.nodeTable.setRowSelectionInterval(i, i);
            break;
        }
        this.updateButtons();
    }

    private void toggleFavoriteForSelectedRow() {
        if (this.nodeTable.getSelectedRowCount() != 1) {
            return;
        }
        int selectedRow = this.nodeTable.getSelectedRow();
        String key = (String)this.nodeTable.getValueAt(selectedRow, 0);
        TableElement oldElement = this.visitedURLs.get(key);
        TableElement newElement = new TableElement(oldElement.getAddress(), oldElement.getName(), oldElement.getComment(), oldElement.getType(), oldElement.getState(), !oldElement.isFavorite());
        this.visitedURLs.put(key, newElement);
        this.writeUrlsToFile();
        Object newFavoriteValue = newElement.getFavoriteObject();
        this.nodeTable.setValueAt(newFavoriteValue, selectedRow, this.COL_ID_FAVORITE);
        this.updateButtons();
    }

    private void addToNodeTable() {
        LOG.finer("addToNodeTable Thread: " + Thread.currentThread().getName(), new Object[0]);
        String address_ = this.addressField.getTextIgnoreHint().trim();
        String name_ = this.nameField.getTextIgnoreHint().trim();
        String comment_ = this.commentField.getTextIgnoreHint().trim();
        String type_ = "";
        String state_ = "";
        boolean favorite_ = false;
        address_ = address_.replaceAll(" ", "");
        name_ = name_.replaceAll(";", "");
        comment_ = comment_.replaceAll(";", "");
        if (address_.length() == 0) {
            return;
        }
        TableElement oldElement = this.visitedURLs.get(address_);
        if (oldElement != null) {
            type_ = oldElement.getType();
            state_ = oldElement.getState();
            favorite_ = oldElement.isFavorite();
        }
        TableElement newElement = new TableElement(address_, name_, comment_, type_, state_, favorite_);
        this.visitedURLs.put(address_, newElement);
        this.writeUrlsToFile();
        this.updateNodeTable(this.visitedURLs);
        this.nodeTable.requestFocus();
        for (int i = 0; i < this.nodeTable.getRowCount(); ++i) {
            String rowAddress = (String)this.nodeTable.getValueAt(i, 0);
            if (!rowAddress.equals(address_)) continue;
            this.nodeTable.setRowSelectionInterval(i, i);
            break;
        }
    }

    private void removeFromNodeTable() {
        LOG.finer("removeFromNodeTable Thread: " + Thread.currentThread().getName(), new Object[0]);
        int rowToDelete = this.nodeTable.getSelectedRow();
        if (rowToDelete != -1) {
            String keyToRemove = (String)this.nodeTable.getValueAt(rowToDelete, 0);
            this.visitedURLs.remove(keyToRemove);
            this.writeUrlsToFile();
            this.updateNodeTable(this.visitedURLs);
        }
    }

    private void updateNodeTable(Hashtable<String, TableElement> urls) {
        LOG.finer("updateNodeTable Thread: " + Thread.currentThread().getName(), new Object[0]);
        if (!this.stopAllThreads) {
            Object[][] tableData;
            DefaultTableModel model = (DefaultTableModel)this.tableSorter.getTableModel();
            model.setRowCount(0);
            for (Object[] rowData : tableData = this.getDataForNodeTable(urls)) {
                model.addRow(rowData);
            }
        }
    }

    private void filterNodeTable(int columnId, String filterText) {
        LOG.finer("filterNodeTable columnId:" + columnId + " filterText:" + filterText + " Thread: " + Thread.currentThread().getName(), new Object[0]);
        Hashtable<String, TableElement> filteredUrls = new Hashtable<String, TableElement>(100);
        filterText = filterText.toLowerCase();
        for (TableElement element : this.visitedURLs.values()) {
            String text = "";
            if (columnId == 0) {
                text = element.getAddress();
            } else if (columnId == 1) {
                text = element.getName();
            } else if (columnId == 2) {
                text = element.getComment();
            }
            if (!text.toLowerCase().startsWith(filterText)) continue;
            filteredUrls.put(element.getAddress(), element);
        }
        if (!this.stopAllThreads) {
            this.updateNodeTable(filteredUrls);
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void windowClosing(WindowEvent e) {
        this.address = null;
        this.waitingToConnect = false;
        this.stopAllThreads = true;
        NEAddressDialog nEAddressDialog = this;
        synchronized (nEAddressDialog) {
            if (this.waits) {
                this.notify();
            }
        }
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    private void updatePanelWithAvailableEmApplications(final String anAddress) {
        LOG.finer("updatePanelWithAvailableEmApplications, anAddress: " + anAddress + " Thread: " + Thread.currentThread().getName(), new Object[0]);
        Runnable runner = new Runnable(){

            public void run() {
                LOG.finer("updatePanelWithAvailableEmApplications in runner. " + anAddress + " Thread: " + Thread.currentThread().getName(), new Object[0]);
                final double emAppUpdateID = Math.random();
                NEAddressDialog.this.lastEmAppUpdateID = emAppUpdateID;
                final ArrayList emapps = new ArrayList();
                final ArrayList resources = new ArrayList();
                final JComponent comp = NEAddressDialog.this.getPanelWithAvailableEmApplications(anAddress, emapps, resources);
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        if (NEAddressDialog.this.lastEmAppUpdateID == emAppUpdateID) {
                            LOG.finer("updatePanelWithAvailableEmApplications before updating currentEmAppInfos. " + Thread.currentThread().getName(), new Object[0]);
                            NEAddressDialog.this.resourceLocator.setCurrentEmAppInfos(emapps);
                            NEAddressDialog.this.resourceLocator.setCurrentResourceInfos(resources);
                            NEAddressDialog.this.availableEmAppsPanel.removeAll();
                            NEAddressDialog.this.availableEmAppsPanel.revalidate();
                            NEAddressDialog.this.availableEmAppsPanel.add(comp);
                            NEAddressDialog.this.availableEmAppsPanel.revalidate();
                            NEAddressDialog.this.availableEmAppsPanel.repaint();
                            if (null != emapps && emapps.size() > 0) {
                                NEAddressDialog.this.updateTableCellWithNodeTypeAndState(((EmApplicationInfo)emapps.get(0)).getNodeType(), anAddress, NEAddressDialog.AVAILABLE_STATE);
                            }
                            NEAddressDialog.this.updateTraversalPolicy();
                            StringBuilder stringBuilder = NEAddressDialog.this.emAppAddressBeingContacted;
                            synchronized (stringBuilder) {
                                if (NEAddressDialog.this.emAppAddressBeingContacted.toString().equals(anAddress)) {
                                    LOG.fine("Finished updating EM app panel. Clearing EM app address lock. Thread: " + Thread.currentThread().getName(), new Object[0]);
                                    NEAddressDialog.this.emAppAddressBeingContacted.setLength(0);
                                }
                            }
                        }
                    }
                });
            }
        };
        new Thread(runner, "updatePanelWithAvailableEmApplicationsThread").start();
    }

    private JComponent getPanelWithAvailableEmApplications(String anAddress, ArrayList<EmApplicationInfo> emappsToReturn, ArrayList<ResourceInfo> resourceInfosToReturn) {
        LOG.finer("address: " + anAddress + " Thread: " + Thread.currentThread().getName(), new Object[0]);
        boolean hasInfoError = false;
        Color headerColor = Color.GRAY;
        this.defaultEMAppBtn = null;
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        JLabel nodeTypeLabel = new JLabel();
        nodeTypeLabel.setAlignmentX(0.5f);
        nodeTypeLabel.setForeground(headerColor);
        JSeparator headerSeparator = new JSeparator();
        headerSeparator.setForeground(headerColor);
        headerSeparator.setMaximumSize(new Dimension(Integer.MAX_VALUE, headerSeparator.getPreferredSize().height));
        this.createJLabelAndAddToComp(Localizer.getString("em_apps_for"), headerColor, panel);
        JLabel nodeAddressHeaderLabel = this.createJLabelAndAddToComp(anAddress, headerColor, panel);
        JSeparator headerSeparator2 = new JSeparator();
        headerSeparator2.setForeground(headerColor);
        panel.add(headerSeparator2);
        headerSeparator2.setMaximumSize(new Dimension(Integer.MAX_VALUE, headerSeparator2.getPreferredSize().height));
        panel.add(Box.createRigidArea(new Dimension(10, 10)));
        JPanel contentsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints contentsGbc = new GridBagConstraints();
        contentsGbc.fill = 0;
        contentsGbc.gridx = 0;
        contentsGbc.gridy = -1;
        contentsGbc.anchor = 23;
        JScrollPane scroll = new JScrollPane();
        scroll.setViewportView(contentsPanel);
        scroll.setViewportBorder(BorderFactory.createEmptyBorder());
        scroll.setBorder(BorderFactory.createEmptyBorder());
        URL url = UrlUtilities.getURL(anAddress);
        if (url == null) {
            String message = Localizer.getString("address_invalid_or_unreachable");
            LOG.fine(message, new Object[0]);
            this.addMsgToComponent(contentsPanel, contentsGbc, message);
            this.addFillerToComponent(contentsPanel);
            panel.add(scroll);
            this.setDefaultButton(null);
            this.updateTableCellWithState(anAddress, NOT_AVAILABLE_STATE);
            return panel;
        }
        nodeAddressHeaderLabel.setText(url.toString());
        nodeAddressHeaderLabel.setMaximumSize(nodeAddressHeaderLabel.getPreferredSize());
        String fileContents = "";
        try {
            fileContents = this.nodeTypeInvestigator.getEmApplicationsFileContentsFromNode(url, "/em/emapplications.xml");
        }
        catch (SSLHandshakeException ex) {
            LOG.warning("Got a SSLHandshakeException when downloading emapplications.xml from node.", ex);
            hasInfoError = true;
            this.addMsgToComponent(contentsPanel, contentsGbc, Localizer.getString("ssl_error") + "<br>" + ex.getMessage());
        }
        catch (Exception ex) {
            LOG.finer("caught exception when reading/downloading emapplications.xml from node. " + ex, new Object[0]);
            if (null != ex.getCause() && ex.getCause().getClass().equals(FileNotFoundException.class)) {
                LOG.finer("the emapplications.xml was not found on the node.", new Object[0]);
                NodeType nodeType = this.nodeTypeInvestigator.getNodeType(url);
                if (NodeType.UNKNOWN == nodeType) {
                    hasInfoError = true;
                    this.addMsgToComponent(contentsPanel, contentsGbc, Localizer.getString("could_not_get_file") + "<br>" + ex.getMessage());
                    this.updateTableCellWithState(anAddress, NOT_AVAILABLE_STATE);
                } else {
                    this.addMsgToComponent(contentsPanel, contentsGbc, Localizer.getString("could_not_get_file") + ":<br>" + "/em/emapplications.xml" + "<br>Using default file.");
                    fileContents = this.nodeTypeInvestigator.getDefaultEmApplicationsFileContents(nodeType);
                }
            }
            hasInfoError = true;
            if (ex.getCause() != null && ex.getCause().getClass().equals(SocketTimeoutException.class)) {
                this.addMsgToComponent(contentsPanel, contentsGbc, Localizer.getString("node_socket_timeout"));
            } else {
                String noInfo = "No information available.<br>";
                this.addMsgToComponent(contentsPanel, contentsGbc, noInfo + ex.getMessage());
            }
            this.updateTableCellWithState(anAddress, NOT_AVAILABLE_STATE);
        }
        if (!"".equals(fileContents)) {
            LOG.finest("emapplications.xml file contents:\n    " + fileContents, new Object[0]);
            ArrayList<EmApplicationInfo> emApps = EmApplicationInfoFactory.constructEmAppInfos(fileContents);
            ArrayList<ResourceInfo> resInfos = ResourceInfoFactory.constructResourceInfos(fileContents);
            if (emApps.size() > 0) {
                nodeTypeLabel.setText("Node type: " + emApps.get(0).getNodeType());
                JPanel buttonPanel = this.putEmAppInfoButtonsInPanel(emApps, resInfos, url);
                buttonPanel.setAlignmentX(0.5f);
                contentsGbc.anchor = 19;
                contentsPanel.add((Component)buttonPanel, contentsGbc);
                emappsToReturn.addAll(emApps);
            }
            if (resInfos.size() > 0) {
                resourceInfosToReturn.addAll(resInfos);
            }
        }
        if (!hasInfoError) {
            nodeTypeLabel.setMaximumSize(nodeTypeLabel.getPreferredSize());
            panel.add((Component)nodeTypeLabel, 0);
            panel.add((Component)headerSeparator, 1);
        }
        this.addFillerToComponent(contentsPanel);
        panel.add(scroll);
        this.setDefaultButton(this.defaultEMAppBtn);
        return panel;
    }

    private JLabel createJLabelAndAddToComp(String text, Color foregroundColor, JComponent comp) {
        JLabel label = new JLabel(text);
        label.setForeground(foregroundColor);
        label.setAlignmentX(0.5f);
        label.setMaximumSize(label.getPreferredSize());
        comp.add(label);
        return label;
    }

    private void addFillerToComponent(JComponent comp) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weighty = 1.0;
        gbc.gridheight = 0;
        gbc.fill = 1;
        gbc.anchor = 20;
        gbc.gridy = -1;
        comp.add(Box.createGlue(), gbc);
    }

    private void addMsgToComponent(JComponent comp, Object constraints, String msg) {
        String htmlWordWrap = "<html><body style='width:100%'> ";
        JLabel lbl = new JLabel(htmlWordWrap + msg);
        lbl.setMaximumSize(lbl.getPreferredSize());
        comp.add((Component)lbl, constraints);
    }

    public ResourceLocator getResourceLocator() {
        return this.resourceLocator;
    }

    private void updateTableCellWithNodeTypeAndState(String nodeType, String anAddress, String availability) {
        LOG.finer("updateTableCellWithNodeTypeAndState nodeType: " + nodeType, new Object[0]);
        TableElement element = this.visitedURLs.get(anAddress);
        if (null != element && (element.getType() != nodeType || element.getState() != availability)) {
            TableElement newElement = new TableElement(element.getAddress(), element.getName(), element.getComment(), nodeType, availability, element.isFavorite());
            this.visitedURLs.put(anAddress, newElement);
            this.writeUrlsToFile();
            this.updateTableRow(newElement);
        }
    }

    private void updateTableCellWithState(String anAddress, String availability) {
        LOG.finer("updateTableCellWithState anAddress is: " + anAddress + " availability is:" + availability, new Object[0]);
        TableElement element = this.visitedURLs.get(anAddress);
        if (null != element && element.getState() != availability) {
            TableElement newElement = new TableElement(element.getAddress(), element.getName(), element.getComment(), element.getType(), availability, element.isFavorite());
            this.visitedURLs.put(anAddress, newElement);
            this.updateTableRow(newElement);
        }
    }

    private void updateTableRow(final TableElement element) {
        if (SwingUtilities.isEventDispatchThread()) {
            LOG.finer("updateTableRow, element address: " + element.getAddress(), new Object[0]);
            int selectedRow = this.nodeTable.getSelectedRow();
            String anAddress = element.getAddress();
            DefaultTableModel model = (DefaultTableModel)this.tableSorter.getTableModel();
            Vector<Vector> dataVector = model.getDataVector();
            for (int i = 0; i < dataVector.size() && !this.stopAllThreads; ++i) {
                String tmpAddr = (String)dataVector.elementAt(i).elementAt(0);
                if (!tmpAddr.equalsIgnoreCase(anAddress)) continue;
                model.setValueAt(element.getName(), i, 1);
                model.setValueAt(element.getComment(), i, 2);
                if (this.COL_ID_TYPE != -1) {
                    model.setValueAt(element.getType(), i, this.COL_ID_TYPE);
                }
                if (this.COL_ID_STATE != -1) {
                    model.setValueAt(element.getState(), i, this.COL_ID_STATE);
                }
                model.setValueAt(element.getFavoriteObject(), i, this.COL_ID_FAVORITE);
                break;
            }
            try {
                this.nodeTable.setRowSelectionInterval(selectedRow, selectedRow);
            }
            catch (Exception ex) {
                LOG.fine("Exception in updateTableRow while doing setRowSelectionInterval: " + ex.getMessage(), new Object[0]);
            }
        } else {
            Runnable updater = new Runnable(){

                public void run() {
                    NEAddressDialog.this.updateTableRow(element);
                }
            };
            SwingUtilities.invokeLater(updater);
        }
    }

    private JPanel putEmAppInfoButtonsInPanel(ArrayList<EmApplicationInfo> emAppInfos, ArrayList<ResourceInfo> resources, URL hostUrl) {
        int i;
        LOG.finer("putEmAppInfoButtonsInPanel number of emAppInfos: " + emAppInfos.size() + " hostUrl: " + hostUrl, new Object[0]);
        double maxButtonSize = 0.0;
        EMAppButton[] buttons = new EMAppButton[emAppInfos.size()];
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        for (i = 0; i < emAppInfos.size(); ++i) {
            byte[] iconBytes = this.resourceLocator.getIconBytesForEmApplicationInfo(emAppInfos.get(i), resources, hostUrl);
            buttons[i] = new EMAppButton(emAppInfos.get(i).getPresentationName(), hostUrl, emAppInfos.get(i));
            if (emAppInfos.get(i).isDefault()) {
                this.defaultEMAppBtn = buttons[i];
            }
            buttons[i].setToolTipText(Localizer.getString("launch_tooltip") + " " + emAppInfos.get(i).getPresentationName());
            buttons[i].setAlignmentX(0.5f);
            buttons[i].setHorizontalAlignment(2);
            buttons[i].addActionListener(this);
            if (iconBytes.length > 0) {
                ImageIcon icon = new ImageIcon(iconBytes);
                buttons[i].setIcon(icon);
            }
            if (!(maxButtonSize < buttons[i].getPreferredSize().getWidth())) continue;
            maxButtonSize = buttons[i].getPreferredSize().getWidth();
        }
        if (this.defaultEMAppBtn == null && buttons.length > 0) {
            this.defaultEMAppBtn = buttons[0];
        }
        for (i = 0; i < buttons.length; ++i) {
            Dimension d = new Dimension((int)Math.ceil(maxButtonSize), (int)Math.ceil(buttons[i].getPreferredSize().getHeight()));
            buttons[i].setPreferredSize(d);
            buttons[i].setMinimumSize(d);
            buttons[i].setMaximumSize(d);
            buttonPanel.add(buttons[i]);
        }
        return buttonPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateApplicationsPanel(String anAddress) {
        LOG.finer("updateApplicationsPanel, + anAddress: " + anAddress + " Thread: " + Thread.currentThread().getName(), new Object[0]);
        this.availableEmAppsPanel.removeAll();
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(new JLabel("Searching EM applications..."));
        this.availableEmAppsPanel.add(panel);
        this.availableEmAppsPanel.revalidate();
        this.availableEmAppsPanel.repaint();
        LOG.finest("updateApplicationsPanel before setting currentEmAppInfos to null " + Thread.currentThread().getName(), new Object[0]);
        this.resourceLocator.setCurrentEmAppInfos(null);
        this.resourceLocator.setCurrentResourceInfos(null);
        StringBuilder stringBuilder = this.emAppAddressBeingContacted;
        synchronized (stringBuilder) {
            String oldAddress = this.emAppAddressBeingContacted.toString();
            if (oldAddress.equals(anAddress)) {
                LOG.fine("Address " + anAddress + " is already being contacted. " + "This thread (" + Thread.currentThread().getName() + ") will not update EM app panel.", new Object[0]);
                return;
            }
            LOG.fine("Old EM app address: " + oldAddress + " New EM app address: " + anAddress, new Object[0]);
            this.emAppAddressBeingContacted.setLength(0);
            this.emAppAddressBeingContacted.append(anAddress);
        }
        this.updatePanelWithAvailableEmApplications(anAddress);
    }

    private void setDefaultButton(JButton defaultBtn) {
        this.launchFrame.getRootPane().setDefaultButton(defaultBtn);
    }

    private void updateTraversalPolicy() {
        this.launchFrame.setFocusTraversalPolicy(new NEAddressDialogFocusTraversalPolicy());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NEAddressDialogFocusTraversalPolicy
    extends FocusTraversalPolicy {
        ArrayList<Component> focusOrder = new ArrayList();

        public NEAddressDialogFocusTraversalPolicy() {
            this.focusOrder.add(NEAddressDialog.this.addressField);
            this.focusOrder.add(NEAddressDialog.this.nameField);
            this.focusOrder.add(NEAddressDialog.this.commentField);
            this.focusOrder.add(NEAddressDialog.this.btAdd);
            this.focusOrder.add(NEAddressDialog.this.btRemove);
            this.focusOrder.add(NEAddressDialog.this.btFavorite);
            if (NEAddressDialog.this.showAllFoundEmApplications) {
                if (NEAddressDialog.this.availableEmAppsPanel != null) {
                    this.focusOrder.addAll(this.findEMAppButtons(NEAddressDialog.this.availableEmAppsPanel.getComponents()));
                }
            } else {
                this.focusOrder.add(NEAddressDialog.this.btConnect);
            }
            this.focusOrder.add(NEAddressDialog.this.btAbout);
        }

        private List<JButton> findEMAppButtons(Component[] components) {
            ArrayList<JButton> buttonList = new ArrayList<JButton>();
            for (int i = 0; i < components.length; ++i) {
                if (components[i] instanceof EMAppButton) {
                    buttonList.add((JButton)components[i]);
                    continue;
                }
                if (!(components[i] instanceof Container)) continue;
                buttonList.addAll(this.findEMAppButtons(((Container)components[i]).getComponents()));
            }
            return buttonList;
        }

        @Override
        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            if (this.focusOrder.contains(aComponent)) {
                int nextIndex = (this.focusOrder.indexOf(aComponent) + 1) % this.focusOrder.size();
                Component c = this.focusOrder.get(nextIndex);
                if (c.isEnabled()) {
                    return c;
                }
                return this.getComponentAfter(focusCycleRoot, c);
            }
            return this.getFirstComponent(focusCycleRoot);
        }

        @Override
        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            if (this.focusOrder.contains(aComponent)) {
                int nextIndex = (this.focusOrder.indexOf(aComponent) - 1 + this.focusOrder.size()) % this.focusOrder.size();
                Component c = this.focusOrder.get(nextIndex);
                if (c.isEnabled()) {
                    return c;
                }
                return this.getComponentBefore(focusCycleRoot, c);
            }
            return this.getLastComponent(focusCycleRoot);
        }

        @Override
        public Component getDefaultComponent(Container focusCycleRoot) {
            return NEAddressDialog.this.addressField;
        }

        @Override
        public Component getFirstComponent(Container focusCycleRoot) {
            return NEAddressDialog.this.addressField;
        }

        @Override
        public Component getLastComponent(Container focusCycleRoot) {
            return NEAddressDialog.this.btAbout;
        }
    }

    private class EMAppButton
    extends JButton {
        private static final long serialVersionUID = 2202444459652546901L;
        private EmApplicationInfo emApp;
        private URL address;

        private EMAppButton(String text, URL address, EmApplicationInfo emApp) {
            super(text);
            this.address = address;
            this.emApp = emApp;
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                NEAddressDialog.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private class TableElement {
        private String elementAddress;
        private String elementName;
        private String elementComment;
        private String elementType;
        private String elementState;
        private boolean elementFavorite;

        public TableElement(String anAddress, String aName, String aComment, String aType, String aState, boolean aFavorite) {
            this.elementAddress = anAddress;
            this.elementName = aName;
            this.elementComment = aComment;
            this.elementType = aType;
            this.elementState = aState;
            this.elementFavorite = aFavorite;
        }

        public String getAddress() {
            return this.elementAddress;
        }

        public String getName() {
            return this.elementName;
        }

        public String getComment() {
            return this.elementComment;
        }

        public String getType() {
            return this.elementType;
        }

        public String getState() {
            return this.elementState;
        }

        public boolean isFavorite() {
            return this.elementFavorite;
        }

        public Object getFavoriteObject() {
            if (this.elementFavorite) {
                return NEAddressDialog.this.favoriteCellSetIcon;
            }
            return NEAddressDialog.this.favoriteCellNotSetIcon;
        }
    }

    private class AddressFieldFocusListener
    extends CommonFocusListener {
        public AddressFieldFocusListener() {
            super(NEAddressDialog.this.addressField);
        }

        public void focusGained(FocusEvent e) {
            super.focusGained(e);
            if (NEAddressDialog.this.showAllFoundEmApplications) {
                NEAddressDialog.this.availableEmAppsPanel.removeAll();
                NEAddressDialog.this.availableEmAppsPanel.revalidate();
                NEAddressDialog.this.availableEmAppsPanel.repaint();
            }
        }

        public void focusLost(FocusEvent e) {
            super.focusLost(e);
            String address_ = NEAddressDialog.this.addressField.getTextIgnoreHint().trim();
            if (NEAddressDialog.this.showAllFoundEmApplications && address_.length() != 0) {
                NEAddressDialog.this.updateApplicationsPanel(address_);
            }
        }
    }

    private class CommonFocusListener
    implements FocusListener {
        private final JTextFieldWithHint observedTextField;

        public CommonFocusListener(JTextFieldWithHint textField) {
            this.observedTextField = textField;
        }

        public void focusGained(FocusEvent e) {
            NEAddressDialog.this.updateButtons();
            if (this.observedTextField.isShowingHint()) {
                this.observedTextField.setText("");
            }
            if (NEAddressDialog.this.showAllFoundEmApplications) {
                NEAddressDialog.this.setDefaultButton(NEAddressDialog.this.defaultEMAppBtn);
            } else {
                NEAddressDialog.this.setDefaultButton(NEAddressDialog.this.btConnect);
            }
        }

        public void focusLost(FocusEvent e) {
            if (this.observedTextField.getTextIgnoreHint().length() == 0) {
                this.observedTextField.showHint();
            }
        }
    }

    private class CommonCaretListener
    implements CaretListener {
        private final JTextFieldWithHint observedTextField;
        private final int columnId;

        public CommonCaretListener(JTextFieldWithHint textField, int columnId) {
            this.observedTextField = textField;
            this.columnId = columnId;
        }

        public void caretUpdate(CaretEvent e) {
            NEAddressDialog.this.updateButtons();
            if (NEAddressDialog.this.tableListenerIsModifyingTextFields) {
                return;
            }
            if (!this.observedTextField.isFocusOwner()) {
                return;
            }
            final String text = this.observedTextField.getTextIgnoreHint().trim();
            NEAddressDialog.this.nodeTable.clearSelection();
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class SearchRunner
            implements Runnable {
                SearchRunner() {
                }

                @Override
                public void run() {
                    NEAddressDialog.this.filterNodeTable(CommonCaretListener.this.columnId, text);
                }
            }
            new SearchRunner().run();
        }
    }

    private class JTextFieldWithHint
    extends JTextField {
        private static final long serialVersionUID = -4810084871506586604L;
        private final String hintText;
        private final Color normalColor;
        private final Color hintColor;
        private boolean showingHint;

        public JTextFieldWithHint(String hint) {
            super("");
            this.hintColor = Color.GRAY;
            this.showingHint = false;
            this.hintText = hint;
            this.normalColor = this.getForeground();
            this.showHint();
        }

        public String getTextIgnoreHint() {
            String text = this.getText();
            if (this.showingHint || text == null) {
                text = "";
            }
            return text;
        }

        public void setText(String newText) {
            this.showingHint = false;
            this.setForeground(this.normalColor);
            super.setText(newText);
            if ("".equals(newText) && !this.isFocusOwner()) {
                this.showHint();
            }
        }

        public void showHint() {
            this.showingHint = true;
            this.setForeground(this.hintColor);
            super.setText(this.hintText);
            this.setCaretPosition(0);
        }

        public boolean isShowingHint() {
            return this.showingHint;
        }
    }

    private class NodeTableListener
    implements ListSelectionListener {
        int[] prevSelectedIndices = new int[0];

        private NodeTableListener() {
        }

        private boolean isNewSelection(int[] newSelectedIndices) {
            if (this.prevSelectedIndices.length != newSelectedIndices.length) {
                return true;
            }
            for (int i = 0; i < this.prevSelectedIndices.length; ++i) {
                if (this.prevSelectedIndices[i] == newSelectedIndices[i]) continue;
                return true;
            }
            return false;
        }

        public void valueChanged(ListSelectionEvent e) {
            int[] newSelectedIndices = NEAddressDialog.this.nodeTable.getSelectedRows();
            if (!this.isNewSelection(newSelectedIndices)) {
                return;
            }
            this.prevSelectedIndices = newSelectedIndices;
            if (newSelectedIndices.length == 1) {
                int selectedRow = NEAddressDialog.this.nodeTable.getSelectedRow();
                NEAddressDialog.this.address = (String)NEAddressDialog.this.nodeTable.getValueAt(selectedRow, 0);
                String name = (String)NEAddressDialog.this.nodeTable.getValueAt(selectedRow, 1);
                String comment = (String)NEAddressDialog.this.nodeTable.getValueAt(selectedRow, 2);
                NEAddressDialog.this.tableListenerIsModifyingTextFields = true;
                NEAddressDialog.this.addressField.setText(NEAddressDialog.this.address);
                NEAddressDialog.this.nameField.setText(name);
                NEAddressDialog.this.commentField.setText(comment);
                NEAddressDialog.this.tableListenerIsModifyingTextFields = false;
                LOG.finest("valueChanged, address selected: " + NEAddressDialog.this.address, new Object[0]);
                if (NEAddressDialog.this.showAllFoundEmApplications) {
                    NEAddressDialog.this.updateApplicationsPanel(NEAddressDialog.this.address);
                } else {
                    NEAddressDialog.this.setDefaultButton(NEAddressDialog.this.btConnect);
                }
            } else if (newSelectedIndices.length > 1) {
                NEAddressDialog.this.tableListenerIsModifyingTextFields = true;
                NEAddressDialog.this.addressField.setText("");
                NEAddressDialog.this.nameField.setText("");
                NEAddressDialog.this.commentField.setText("");
                NEAddressDialog.this.tableListenerIsModifyingTextFields = false;
            }
            NEAddressDialog.this.updateButtons();
        }
    }
}

