/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.launcher.util;

import java.awt.Dimension;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.UUID;
import javax.management.InstanceNotFoundException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import se.ericsson.security.launcher.download.DownloadManager;
import se.ericsson.security.launcher.util.PropertyManager;
import se.ericsson.security.utils.EmLogger;

public class DynamicX509TrustManager
implements X509TrustManager {
    private static EmLogger LOG = EmLogger.LAUNCHER;
    private final String NC_TRUST_ANCHOR_PATH;
    private static final String NC_TRUST_ANCHOR_PROP = "se.ericsson.security.launcher.node_credential_trust_anchor";
    private X509TrustManager trustManager;
    private List<Certificate> tempTrustedCerts;
    private List<Certificate> notTrustedCerts;
    private static DynamicX509TrustManager instance;

    private DynamicX509TrustManager() throws NoSuchAlgorithmException, InstanceNotFoundException, KeyStoreException, CertificateException {
        PropertyManager properties = PropertyManager.getInstance(this.getClass().getClassLoader());
        this.NC_TRUST_ANCHOR_PATH = properties.getString(NC_TRUST_ANCHOR_PROP, true);
        if (this.NC_TRUST_ANCHOR_PATH == null) {
            LOG.warning("se.ericsson.security.launcher.node_credential_trust_anchor property not found.\nCertificate validation for nodes with 'Node Credentials' certificate will not be possible.", new Object[0]);
        }
        this.tempTrustedCerts = Collections.synchronizedList(new ArrayList(7));
        this.notTrustedCerts = Collections.synchronizedList(new ArrayList(7));
        this.loadTrustStore();
    }

    public static synchronized DynamicX509TrustManager getInstance() throws InstanceNotFoundException, NoSuchAlgorithmException, KeyStoreException, CertificateException {
        if (instance == null) {
            instance = new DynamicX509TrustManager();
        }
        return instance;
    }

    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.trustManager.checkClientTrusted(chain, authType);
    }

    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        try {
            this.trustManager.checkServerTrusted(chain, authType);
        }
        catch (CertificateException e) {
            LOG.finer("Got a CertificateException for certificate: " + chain[0].toString(), new Object[0]);
            if (this.notTrustedCerts.contains(chain[0])) {
                throw e;
            }
            if (!this.askUserForTrust(chain)) {
                this.notTrustedCerts.add(chain[0]);
                throw e;
            }
            this.tempTrustedCerts.add(chain[0]);
            try {
                this.loadTrustStore();
            }
            catch (Exception e1) {
                LOG.warning("The truststore could not be reloaded. The TrustStore might have to be reloaded before trusted connections will work again.", e1);
            }
        }
    }

    private boolean askUserForTrust(X509Certificate[] chain) {
        int width = 500;
        StringBuilder infoText = new StringBuilder(1024);
        infoText.append("<html><body style='width:").append(width).append("px'>");
        infoText.append("The certificate on the server could not be validated, ");
        infoText.append("it is not issued by a trusted party.<br></br><br></br>");
        infoText.append("If it is normally not a problem to connect towards this NE, this could be ");
        infoText.append("a sign that someone is impersonating the NE ");
        infoText.append("or is monitoring your network connection.<br></br>");
        infoText.append("In order to permanately trust a certificate ");
        infoText.append("it could be added to the folder below:<br></br>");
        infoText.append(this.NC_TRUST_ANCHOR_PATH).append("<br></br><br></br>");
        infoText.append("The server presented the following certificate chain:<br></br>");
        infoText.append("</html>");
        StringBuilder certText = new StringBuilder(768);
        for (int i = 0; i < chain.length; ++i) {
            certText.append(this.certToString(chain[i]));
            if (i + 1 == chain.length) continue;
            certText.append("\n");
        }
        String finalText = "<html><b>Do you want to connect anyway and trust this certificate?</b><br></br>Your choice will be saved for the duration of this session.</html>";
        JTextArea textArea = new JTextArea(certText.toString());
        JScrollPane scrollPane = new JScrollPane(textArea);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setEditable(false);
        if (chain.length == 1) {
            scrollPane.setPreferredSize(new Dimension(width, 130));
        } else {
            scrollPane.setPreferredSize(new Dimension(width, 250));
        }
        final JPanel contents = new JPanel();
        JLabel infoLabel = new JLabel(infoText.toString());
        JLabel finalLabel = new JLabel(finalText);
        contents.setLayout(new BoxLayout(contents, 1));
        infoLabel.setAlignmentX(0.0f);
        scrollPane.setAlignmentX(0.0f);
        finalLabel.setAlignmentX(0.0f);
        contents.add(infoLabel);
        contents.add(Box.createRigidArea(new Dimension(0, 7)));
        contents.add(scrollPane);
        contents.add(Box.createRigidArea(new Dimension(0, 7)));
        contents.add(finalLabel);
        contents.add(Box.createRigidArea(new Dimension(0, 7)));
        final int[] choice = new int[1];
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    Object[] options = new Object[]{UIManager.getString("OptionPane.yesButtonText"), UIManager.getString("OptionPane.noButtonText")};
                    choice[0] = JOptionPane.showOptionDialog(null, contents, "Certificate Validation Error", 0, 2, null, options, options[1]);
                }
            });
        }
        catch (InterruptedException e1) {
            LOG.warning("Showing certificate error message failed, certificate will not be trusted.", new Object[0]);
            return false;
        }
        catch (InvocationTargetException e1) {
            LOG.warning("Showing certificate error message failed, certificate will not be trusted.", new Object[0]);
            return false;
        }
        return choice[0] == 0;
    }

    private String certToString(X509Certificate cert) {
        StringBuilder str = new StringBuilder(768);
        str.append("Issued by: ").append(cert.getIssuerX500Principal().toString()).append("\n");
        str.append("Issued to: ").append(((Object)cert.getSubjectDN()).toString()).append("\n");
        str.append("Valid from ").append(cert.getNotBefore()).append(" until ").append(cert.getNotAfter());
        str.append("\n");
        str.append("Serial nr: ").append(cert.getSerialNumber()).append("\n");
        str.append("Signature algorithm: ").append(cert.getSigAlgName()).append("\n");
        try {
            str.append("Fingerprint (MD5): ").append(DynamicX509TrustManager.bytesToHex(MessageDigest.getInstance("MD5").digest(cert.getEncoded()))).append("\n");
        }
        catch (CertificateEncodingException e) {
            str.append("Fingerprint (MD5): <could not be computed>\n");
        }
        catch (NoSuchAlgorithmException e) {
            str.append("Fingerprint (MD5): <could not be computed>\n");
        }
        try {
            str.append("Fingerprint (SHA-1): ").append(DynamicX509TrustManager.bytesToHex(MessageDigest.getInstance("SHA-1").digest(cert.getEncoded()))).append("\n");
        }
        catch (CertificateEncodingException e) {
            str.append("Fingerprint (SHA-1): <could not be computed>\n");
        }
        catch (NoSuchAlgorithmException e) {
            str.append("Fingerprint (SHA-1): <could not be computed>\n");
        }
        return str.toString();
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexArray = "0123456789ABCDEF".toCharArray();
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.trustManager.getAcceptedIssuers();
    }

    private void loadTrustStore() throws NoSuchAlgorithmException, InstanceNotFoundException, KeyStoreException, CertificateException {
        TrustManager[] trustManagers;
        LOG.finer("Loading truststore sources...", new Object[0]);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        KeyStore trustStore = KeyStore.getInstance("jks");
        try {
            trustStore.load(null, null);
        }
        catch (IOException e) {
            LOG.severe("KeyStore could not be initialized.", new Object[0]);
        }
        this.loadNCTrustStore(trustStore);
        this.loadVCTrustStore(trustStore);
        this.loadTempTrustStore(trustStore);
        if (trustStore.size() > 0) {
            trustManagerFactory.init(trustStore);
        } else {
            LOG.warning("No node credential trust anchors loaded. Certificate validation for nodes with 'Node Credentials' certificate will not be possible.", new Object[0]);
        }
        for (TrustManager t : trustManagers = trustManagerFactory.getTrustManagers()) {
            if (!(t instanceof X509TrustManager)) continue;
            this.trustManager = (X509TrustManager)t;
            break;
        }
        if (this.trustManager == null) {
            throw new InstanceNotFoundException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTempTrustStore(KeyStore trustStore) {
        LOG.finer("Attempting to load temporarily trusted certificates (" + this.tempTrustedCerts.size() + ").", new Object[0]);
        List<Certificate> list = this.tempTrustedCerts;
        synchronized (list) {
            for (Certificate c : this.tempTrustedCerts) {
                try {
                    trustStore.setCertificateEntry("Temp_Trusted_Cert_" + UUID.randomUUID(), c);
                }
                catch (KeyStoreException e) {
                    LOG.warning("A temporarily trusted certificate could not be added to the TrustStore: " + c.toString(), new Object[0]);
                }
            }
        }
    }

    private void loadNCTrustStore(KeyStore ncTrustStore) {
        boolean failed = false;
        LOG.fine("Attempting to load Node Credentials trust anchor from: " + this.NC_TRUST_ANCHOR_PATH, new Object[0]);
        if (this.NC_TRUST_ANCHOR_PATH != null) {
            File trustAnchorPath = new File(this.NC_TRUST_ANCHOR_PATH);
            if (trustAnchorPath.isDirectory()) {
                File[] files;
                for (File file : files = trustAnchorPath.listFiles()) {
                    if (!file.isFile() || !file.getName().toUpperCase().matches(".*\\.JKS|.*\\.PEM|.*\\.DER|.*\\.CRT|.*\\.CER|.*\\.CERT")) continue;
                    this.loadCertificateIntoStore(ncTrustStore, file.getAbsolutePath());
                }
                if (files.length == 0) {
                    failed = true;
                }
            } else if (trustAnchorPath.isFile()) {
                this.loadCertificateIntoStore(ncTrustStore, this.NC_TRUST_ANCHOR_PATH);
            } else {
                LOG.warning("'" + this.NC_TRUST_ANCHOR_PATH + "' neither points to a file or a directory.", new Object[0]);
                failed = true;
            }
        } else {
            LOG.warning("se.ericsson.security.launcher.node_credential_trust_anchor property not found.\nCertificate validation for nodes with 'Node Credentials' certificate will not be possible.", new Object[0]);
        }
        if (failed) {
            LOG.warning("No certificates loaded. Certificate validation for Node Credentials will not be possible.", new Object[0]);
        }
    }

    private void loadVCTrustStore(KeyStore vcTrustStore) {
        LOG.fine("Attempting to load Vendor Credentials trust anchor.", new Object[0]);
        try {
            InputStream is = DownloadManager.class.getResourceAsStream("VC_Root_CA_A1.pem");
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            while (is.available() > 0) {
                Certificate cert = cf.generateCertificate(is);
                vcTrustStore.setCertificateEntry("VENDOR_CREDENTIAL_" + UUID.randomUUID(), cert);
            }
        }
        catch (Exception e) {
            LOG.warning("Truststore for VC certificate could not be initialized.\nCertificate validation for nodes using 'Vendor Credentials' certificate will not be possible.", e);
        }
    }

    private void loadCertificateIntoStore(KeyStore trustStore, String trustAnchorPath) {
        LOG.fine("Attempting to load: " + trustAnchorPath, new Object[0]);
        try {
            try {
                trustStore.size();
            }
            catch (KeyStoreException e) {
                trustStore.load(null, null);
            }
            if (trustAnchorPath.toUpperCase().matches(".*\\.JKS$")) {
                this.loadCertificatesFromJKSStream(trustStore, new FileInputStream(trustAnchorPath), null);
            } else {
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(trustAnchorPath));
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                while (bis.available() > 0) {
                    Certificate cert = cf.generateCertificate(bis);
                    trustStore.setCertificateEntry("NODE_CREDENTIAL_" + UUID.randomUUID(), cert);
                }
            }
        }
        catch (Exception e) {
            LOG.warning("The certificate '" + trustAnchorPath + "' could not be added to the TrustStore." + "Certificate validation for nodes using this certificate will not be possible.", e);
        }
    }

    private void loadCertificatesFromJKSStream(KeyStore trustStore, InputStream stream, char[] pass) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        try {
            trustStore.size();
        }
        catch (KeyStoreException e) {
            trustStore.load(null, null);
        }
        KeyStore tmpStore = KeyStore.getInstance("JKS");
        tmpStore.load(stream, pass);
        Enumeration<String> aliases = tmpStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            Certificate[] certs = tmpStore.getCertificateChain(alias);
            if (certs != null) {
                for (Certificate cert : certs) {
                    trustStore.setCertificateEntry(alias, cert);
                }
                continue;
            }
            Certificate cert = tmpStore.getCertificate(alias);
            if (cert == null) continue;
            trustStore.setCertificateEntry(alias, cert);
        }
    }
}

