/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.launcher.util;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParsePosition;
import java.util.Properties;
import se.ericsson.security.utils.EmLogger;

public final class PropertyManager {
    private static final EmLogger LOG = EmLogger.LAUNCHER;
    private Properties properties = new Properties();

    public static PropertyManager getInstance(ClassLoader cl) {
        try {
            Class<?> c = cl.loadClass("se.ericsson.security.launcher.util.PropertyManager");
            return (PropertyManager)c.newInstance();
        }
        catch (Exception e) {
            LOG.severe("Failed to get PropertyManager instance: " + e.getMessage() + " cause=" + e.getCause(), new Object[0]);
            return null;
        }
    }

    public PropertyManager() {
        InputStream is = this.getClass().getResourceAsStream("launcher.properties");
        if (is == null) {
            LOG.severe("Could not find default launcher properties.", new Object[0]);
        } else {
            try {
                this.properties.load(is);
                is.close();
            }
            catch (IOException ioe) {
                LOG.severe("Could not find default launcher properties.", new Object[0]);
            }
        }
    }

    public String getString(String name, boolean checkSystemProperties) {
        String value = null;
        if (checkSystemProperties) {
            value = System.getProperty(name);
        }
        if (value == null) {
            value = this.properties.getProperty(name);
            if (value == null) {
                LOG.severe("Cannot find internal property: " + name, new Object[0]);
            } else {
                String resolvedvalue = this.resolveReferences(value);
                if (!resolvedvalue.equals(value)) {
                    this.properties.setProperty(name, resolvedvalue);
                    value = resolvedvalue;
                }
            }
        } else {
            value = this.resolveReferences(value);
        }
        return value;
    }

    public boolean getBoolean(String name, boolean checkSystemProperties) {
        boolean value = false;
        if (checkSystemProperties && System.getProperty(name) != null) {
            value = Boolean.getBoolean(name);
            return value;
        }
        if (this.properties.getProperty(name) == null) {
            LOG.severe("Cannot find internal property: " + name, new Object[0]);
        }
        value = Boolean.getBoolean(this.properties.getProperty(name));
        return value;
    }

    public int getInt(String name, boolean checkSystemProperties, int defaultValue) {
        try {
            return Integer.parseInt(this.getString(name, checkSystemProperties));
        }
        catch (NumberFormatException e) {
            LOG.fine("Expected int got something else for property: " + name, e);
            return defaultValue;
        }
    }

    private String resolveReferences(String value) {
        if (value == null) {
            return value;
        }
        StringBuffer sb = new StringBuffer();
        ParsePosition position = new ParsePosition(0);
        while (position.getIndex() < value.length()) {
            int begin = value.indexOf("${", position.getIndex());
            if (begin >= 0) {
                sb.append(value.substring(position.getIndex(), begin));
                int end = value.indexOf("}", begin);
                if (end <= begin) {
                    position.setErrorIndex(begin);
                    LOG.warning("Unkown syntax of property value " + value + " " + position, new Object[0]);
                    return value;
                }
                String name = value.substring(begin + 2, end);
                LOG.finest("Resolving property " + name, new Object[0]);
                sb.append(this.getString(name, true));
                position.setIndex(end + 1);
                continue;
            }
            sb.append(value.substring(position.getIndex()));
            position.setIndex(value.length());
        }
        return sb.toString();
    }

    public String toString() {
        String SPACE = "                                                   ";
        int END = "                                                   ".length() - 1;
        StringBuilder sb = new StringBuilder();
        for (Object keyObj : this.properties.keySet()) {
            String key = (String)keyObj;
            int start = key.length() > END ? END : key.length();
            sb.append("     ").append(key).append("                                                   ", start, END).append(" = ");
            sb.append(this.properties.getProperty(key)).append('\n');
        }
        return sb.toString();
    }
}

