/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.aueframework.collector;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import se.ericsson.cello.aueframework.collector.CollectorContext;
import se.ericsson.cello.aueframework.collector.CollectorHandler;
import se.ericsson.cello.aueframework.collector.DataCollectorAction;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.common.RevisionReader;
import se.ericsson.cello.aueframework.common.TransactionWrapper;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.transaction.Status;

public class ActionCollectorHandler
implements CollectorHandler {
    private RevisionReader revReader;
    private Map actionMap = new HashMap();
    public static final int ACTION_RETRIES = 3;
    public static final long RETRY_DELAY = 10000L;

    public ActionCollectorHandler(RevisionReader revisionReader) {
        this.revReader = revisionReader;
    }

    public void add(DataCollectorAction dataCollectorAction, String string) {
        Vector<DataCollectorAction> vector = (Vector<DataCollectorAction>)this.actionMap.get(string);
        if (vector == null) {
            vector = new Vector<DataCollectorAction>();
            this.actionMap.put(string, vector);
        }
        vector.add(dataCollectorAction);
    }

    public void collect(CollectorContext collectorContext) throws AueException {
        this.performActions(collectorContext);
    }

    private void performActions(CollectorContext collectorContext) throws AueException {
        Collection collection = (Collection)this.actionMap.get(collectorContext.getCurrentTrigger().toString());
        if (collection != null && collection.size() > 0) {
            String string = this.readCurrentRevision(collectorContext);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                DataCollectorAction dataCollectorAction = (DataCollectorAction)iterator.next();
                this.performAction(dataCollectorAction, collectorContext, string, 3);
            }
        }
    }

    private void performAction(DataCollectorAction dataCollectorAction, CollectorContext collectorContext, String string, int n) throws AueException {
        TransactionWrapper transactionWrapper = null;
        try {
            transactionWrapper = this.createTransaction(collectorContext);
            dataCollectorAction.perform(collectorContext, transactionWrapper.getCoordinator(), string);
            this.commit(transactionWrapper, collectorContext);
        }
        catch (AueException aueException) {
            if (aueException.getRootCause() instanceof TransactionRequiredException && transactionWrapper.getCoordinator().getStatus() != Status.ACTIVE && n > 0) {
                this.logAndWaitForAWhile(collectorContext, transactionWrapper);
                this.performAction(dataCollectorAction, collectorContext, string, n - 1);
            }
            throw aueException;
        }
    }

    private void logAndWaitForAWhile(CollectorContext collectorContext, TransactionWrapper transactionWrapper) {
        collectorContext.getLogger().info(this.getClass(), "Transaction " + transactionWrapper.getID() + " timed out. Making a new attempt in " + 10000L + "ms.");
        try {
            collectorContext.getEnvironment().sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private String readCurrentRevision(CollectorContext collectorContext) throws AueException {
        TransactionWrapper transactionWrapper = this.createTransaction(collectorContext);
        String string = this.revReader.readRevision(transactionWrapper.getCoordinator());
        this.commit(transactionWrapper, collectorContext);
        return string;
    }

    private TransactionWrapper createTransaction(CollectorContext collectorContext) throws AueException {
        TransactionWrapper transactionWrapper = collectorContext.getTransactionWrapperFactory().create();
        collectorContext.getLogger().trace(1, this.getClass(), "Created new transaction, id=" + transactionWrapper.getID());
        return transactionWrapper;
    }

    private void commit(TransactionWrapper transactionWrapper, CollectorContext collectorContext) throws AueException {
        transactionWrapper.commit();
        collectorContext.getLogger().trace(1, this.getClass(), "Committed transaction, id=" + transactionWrapper.getID());
    }
}

