/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.aueframework.converter;

import java.util.Iterator;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.common.DataCollectorMoConstants;
import se.ericsson.cello.aueframework.converter.CollectedDataNotFoundException;
import se.ericsson.cello.aueframework.converter.CollectedDataSource;
import se.ericsson.cello.aueframework.converter.CoreConverterContext;
import se.ericsson.cello.aueframework.converter.DataReader;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.transaction.Coordinator;

public class MoCollectedDataSource
implements DataReader,
CollectedDataSource,
DataCollectorMoConstants {
    private String identity = null;

    public MoCollectedDataSource(String string) {
        this.identity = string;
    }

    public Attribute getData(String string, CoreConverterContext coreConverterContext, Coordinator coordinator) throws AueException {
        MoDataWrapper moDataWrapper = this.findMo(coreConverterContext);
        if (moDataWrapper == null) {
            throw new AueException("MO DataCollector=" + this.identity + " doesn't exist. Maybe data " + "collection was unsuccessful.");
        }
        Attribute attribute = moDataWrapper.getAttribute(string);
        if (attribute == null) {
            throw new CollectedDataNotFoundException(string);
        }
        return attribute;
    }

    public void delete(CoreConverterContext coreConverterContext, Coordinator coordinator) throws AueException {
        MoDataWrapper moDataWrapper = this.findMo(coreConverterContext);
        if (moDataWrapper != null) {
            coreConverterContext.getMoDataAccessor().delete(moDataWrapper, coordinator);
        }
    }

    public DataReader getDataReader() {
        return this;
    }

    private MoDataWrapper findMo(CoreConverterContext coreConverterContext) {
        Iterator iterator = coreConverterContext.getMoDataAccessor().getByType("DataCollector").iterator();
        while (iterator.hasNext()) {
            MoDataWrapper moDataWrapper = (MoDataWrapper)iterator.next();
            if (!this.matchesIdentity(moDataWrapper)) continue;
            return moDataWrapper;
        }
        return null;
    }

    private boolean matchesIdentity(MoDataWrapper moDataWrapper) {
        return moDataWrapper.getLocalDistinguishedName().endsWith("=" + this.identity);
    }
}

