/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.aueframework.converter.actions;

import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.MoDataAction;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.transaction.Coordinator;

public class ConvertRefToSeqAttrAction
implements MoDataAction {
    private String attributeName;
    private boolean notification;

    public ConvertRefToSeqAttrAction(String string, boolean bl) {
        this.attributeName = string;
        this.notification = bl;
    }

    public void perform(MoDataWrapper moDataWrapper, ConverterContext converterContext, Coordinator coordinator) throws AueException {
        Attribute attribute = moDataWrapper.getAttribute(this.attributeName);
        if (attribute == null) {
            throw new AueException("Attribute " + this.attributeName + " does not exist in " + moDataWrapper.getMoTypeName());
        }
        if (!attribute.getClass().equals(SequenceAttribute.class)) {
            if (attribute.getClass().equals(ReferenceAttribute.class)) {
                SequenceAttribute sequenceAttribute = new SequenceAttribute(this.attributeName, this.notification);
                ReferenceAttribute referenceAttribute = (ReferenceAttribute)attribute;
                String string = referenceAttribute.getReferenceAsLDN();
                if (string != null) {
                    sequenceAttribute.addElement((Attribute)new ReferenceAttribute("", string, false));
                }
                moDataWrapper.deregisterAttribute(this.attributeName);
                moDataWrapper.registerPersistentAttr((Attribute)sequenceAttribute);
            } else {
                throw new AueException(this.attributeName + " is a " + attribute.getClass().getName());
            }
        }
    }
}

