/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.aueframework.converter.actions;

import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.MoDataAction;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.transaction.Coordinator;

public class RemoveReferencesToType
implements MoDataAction {
    private String typeName;
    private String attrName;

    public RemoveReferencesToType(String string, String string2) {
        this.typeName = string;
        this.attrName = string2;
    }

    public void perform(MoDataWrapper moDataWrapper, ConverterContext converterContext, Coordinator coordinator) throws AueException {
        Attribute attribute = moDataWrapper.getAttribute(this.attrName);
        if (attribute instanceof SequenceAttribute) {
            this.handleSequence((SequenceAttribute)attribute, coordinator);
        } else if (attribute instanceof ReferenceAttribute) {
            this.handleReference((ReferenceAttribute)attribute, moDataWrapper);
        } else {
            throw new AueException(this.typeName + "#" + this.attrName + (attribute == null ? " doesn't exist!" : " unsupported type :" + attribute.getClass().getName()));
        }
    }

    private void handleSequence(SequenceAttribute sequenceAttribute, Coordinator coordinator) throws AueException {
        Attribute[] attributeArray = sequenceAttribute.getValue(coordinator);
        for (int i = 0; i < attributeArray.length; ++i) {
            Attribute attribute = attributeArray[i];
            if (attribute instanceof ReferenceAttribute) {
                if (!this.isMatchingReference((ReferenceAttribute)attribute)) continue;
                sequenceAttribute.removeElement(attribute);
                continue;
            }
            throw new AueException(this.typeName + "#" + this.attrName + " contained bad element type: " + attribute.getClass().getName());
        }
    }

    private void handleReference(ReferenceAttribute referenceAttribute, MoDataWrapper moDataWrapper) {
        if (this.isMatchingReference(referenceAttribute)) {
            moDataWrapper.deregisterAttribute((Attribute)referenceAttribute);
            moDataWrapper.registerPersistentAttr((Attribute)new ReferenceAttribute(this.attrName, false));
        }
    }

    private boolean isMatchingReference(ReferenceAttribute referenceAttribute) {
        boolean bl = false;
        String string = referenceAttribute.getReferenceAsLDN();
        if (string != null) {
            int n = string.lastIndexOf(",") + 1;
            bl = string.substring(n).startsWith(this.typeName);
        }
        return bl;
    }
}

