/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.vls;

import enea.ose.io.SignalOutputStream;
import enea.ose.system.UnlinkedSignal;
import java.io.IOException;
import se.ericsson.cello.support.debug.Assert;
import se.ericsson.cello.vls.VLSException;

class IpomVlsjiValidateMibReq
extends UnlinkedSignal {
    private static final int IPOM_VLSJI_VALIDATE_MIB_REQ = 100736;
    private int operation;
    private String userName;
    private String userDN;
    private String typeDN;
    private String resourceName;

    protected void initReceive() {
    }

    protected void initSend() {
        int n = 0;
        SignalOutputStream signalOutputStream = this.getSignalOutputStream();
        try {
            signalOutputStream.writeS32(this.operation);
            if (this.userName != null) {
                signalOutputStream.writeS32(n);
                n = n + this.userName.length() + 1;
            } else {
                signalOutputStream.writeS32(-1);
            }
            if (this.userDN != null) {
                signalOutputStream.writeS32(n);
                n = n + this.userDN.length() + 1;
            } else {
                signalOutputStream.writeS32(-1);
            }
            signalOutputStream.writeS32(n);
            if (this.resourceName != null) {
                n = n + this.typeDN.length() + 1;
                signalOutputStream.writeS32(n);
            } else {
                signalOutputStream.writeS32(-1);
            }
            if (this.userName != null) {
                signalOutputStream.writeString(this.userName);
            }
            if (this.userDN != null) {
                signalOutputStream.writeString(this.userDN);
            }
            signalOutputStream.writeString(this.typeDN);
            if (this.resourceName != null) {
                signalOutputStream.writeString(this.resourceName);
            }
            signalOutputStream.flush();
        }
        catch (IOException iOException) {
            Assert.cppAssert(null, (String)iOException.toString());
        }
    }

    IpomVlsjiValidateMibReq(String string, String string2, String string3, int n, String string4) throws VLSException {
        super(100736);
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            throw new VLSException("Invalid MO operation");
        }
        if (string == null && string2 == null) {
            throw new VLSException("userName and userDN can't both be null");
        }
        if (string != null && string2 != null) {
            throw new VLSException("userName and userDN can't both set");
        }
        if (string3 == null) {
            throw new VLSException("typeDN isn't allowed to be null");
        }
        if (string4 == null && (n == 2 || n == 3)) {
            throw new VLSException("resourceName isn't allowed to be null when operation is set or action");
        }
        if (string4 != null && (n == 0 || n == 1)) {
            throw new VLSException("resourceName must be null when operation is create or delete");
        }
        this.userName = string;
        this.userDN = string2;
        this.typeDN = string3;
        this.resourceName = string4;
        this.operation = n;
    }
}

