/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.internaltransport;

import enea.ose.system.Signal;
import se.ericsson.cello.internaltransport.InternalLinkGroupMo;
import se.ericsson.cello.internaltransport.SwitchModuleMo;
import se.ericsson.cello.internaltransport.fropxy.SpasLinkGroupFroCreateRsp;
import se.ericsson.cello.internaltransport.fropxy.SpasLinkGroupFroDeleteRsp;
import se.ericsson.cello.internaltransport.fropxy.SpasLinkGroupFroProxy;
import se.ericsson.cello.internaltransport.fropxy.SpasLinkGroupFroSetAdmStateRsp;
import se.ericsson.cello.internaltransport.fropxy.SpasLinkGroupGetAttrRsp;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.AvailConverter;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;

public class InternalLinkGroupMoImpl
extends CelloMao
implements InternalLinkGroupMo {
    private MoData data;
    private IntegerAttribute resourceId;
    private StringAttribute userLabel;
    private ReferenceAttribute switchModuleNumber1;
    private ReferenceAttribute switchModuleNumber2;
    private static SpasLinkGroupFroProxy roProxy = SpasLinkGroupFroProxy.instance();
    private static final String PARENT_TYPE_NAME = "SwitchFabric";
    private static final String RESOURCE_ID = "resourceId";
    private static final int MO_DATA_REVISION_3_1 = 3000;
    private static final int MO_DATA_REVISION_LATEST = 3000;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)PARENT_TYPE_NAME);
        MoAttributeValidator.checkIdentity((String)"InternalLinkGroup", (String)string);
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"InternalLinkGroup", (int)128, (int)0);
        ManagedObject managedObject3 = InternalLinkGroupMoImpl.checkAndGetSwitchModuleNumber1(attrList);
        ManagedObject managedObject4 = InternalLinkGroupMoImpl.checkAndGetSwitchModuleNumber2(attrList, managedObject3);
        int n = MoAttributeValidator.checkAndGetIntegerAttribute((String)"administrativeState", (AttrList)attrList, (boolean)false, (int)1, (int)0, (int)2, (String)"InternalLinkGroup");
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"InternalLinkGroup");
        return new InternalLinkGroupMoImpl(managedObject, string, string2, managedObject3, managedObject4, n, coordinator);
    }

    private InternalLinkGroupMoImpl(ManagedObject managedObject, String string, String string2, ManagedObject managedObject2, ManagedObject managedObject3, int n, Coordinator coordinator) throws MoAccessException {
        super(managedObject, "InternalLinkGroup", string, coordinator);
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.userLabel = new StringAttribute("userLabel", true, string2);
        this.data.registerPersistentAttr((Attribute)this.userLabel);
        this.switchModuleNumber1 = new ReferenceAttribute("switchModuleNumber1", false, managedObject2);
        this.data.registerPersistentAttr((Attribute)this.switchModuleNumber1);
        this.switchModuleNumber2 = new ReferenceAttribute("switchModuleNumber2", false, managedObject3);
        this.data.registerPersistentAttr((Attribute)this.switchModuleNumber2);
        ((Reservable)this.switchModuleNumber1.getValue(coordinator)).reserve((ManagedObject)this, coordinator);
        ((Reservable)this.switchModuleNumber2.getValue(coordinator)).reserve((ManagedObject)this, coordinator);
        SpasLinkGroupFroCreateRsp spasLinkGroupFroCreateRsp = roProxy.sendSpasLinkGroupFroCreateReq(coordinator.getTransactionID(), ((SwitchModuleMo)managedObject2).getSwitchModuleNumber(coordinator), ((SwitchModuleMo)managedObject3).getSwitchModuleNumber(coordinator), n);
        this.checkSignal((Signal)spasLinkGroupFroCreateRsp);
        if (spasLinkGroupFroCreateRsp.getResult() != 1) {
            throw new FroRequestFailedException("InternalLinkGroup", "create FRO", roProxy.getResultMsg(spasLinkGroupFroCreateRsp.getResult()), spasLinkGroupFroCreateRsp.getResult());
        }
        this.resourceId = new IntegerAttribute(RESOURCE_ID, false, spasLinkGroupFroCreateRsp.getFroId());
        this.data.registerPersistentAttr((Attribute)this.resourceId);
        roProxy.registerForNotifications(coordinator, this, this.resourceId.getValue(coordinator));
        this.data.setRevision(3000);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public InternalLinkGroupMoImpl(MoData moData) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(3000);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("switchModuleNumber1");
        moDataRecoveryHelper.assertAttribute("switchModuleNumber2");
        moDataRecoveryHelper.assertAttribute(RESOURCE_ID);
        this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
        this.switchModuleNumber1 = (ReferenceAttribute)moData.getAttribute("switchModuleNumber1");
        this.switchModuleNumber2 = (ReferenceAttribute)moData.getAttribute("switchModuleNumber2");
        this.resourceId = (IntegerAttribute)moData.getAttribute(RESOURCE_ID);
        roProxy.registerForNotifications(null, this, this.resourceId.getValue(null));
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        SpasLinkGroupFroDeleteRsp spasLinkGroupFroDeleteRsp = roProxy.sendSpasLinkGroupFroDeleteReq(coordinator.getTransactionID(), this.resourceId.getValue(coordinator));
        this.checkSignal((Signal)spasLinkGroupFroDeleteRsp);
        if (spasLinkGroupFroDeleteRsp.getResult() != 1) {
            throw new FroRequestFailedException("InternalLinkGroup", "", roProxy.getResultMsg(spasLinkGroupFroDeleteRsp.getResult()), spasLinkGroupFroDeleteRsp.getResult());
        }
        ((Reservable)this.switchModuleNumber1.getValue(coordinator)).release((ManagedObject)this, coordinator);
        ((Reservable)this.switchModuleNumber2.getValue(coordinator)).release((ManagedObject)this, coordinator);
        roProxy.deregisterForNotifications(coordinator, this.resourceId.getValue(coordinator));
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public String getType() {
        return "InternalLinkGroup";
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"InternalLinkGroup", (int)128, (int)0);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public ManagedObject getSwitchModuleNumber1(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.switchModuleNumber1.getValue(coordinator);
    }

    public ManagedObject getSwitchModuleNumber2(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.switchModuleNumber2.getValue(coordinator);
    }

    public int getAdministrativeState(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        SpasLinkGroupGetAttrRsp spasLinkGroupGetAttrRsp = roProxy.sendSpasLinkGroupGetAttrReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), this.resourceId.getValue(coordinator));
        this.checkSignal((Signal)spasLinkGroupGetAttrRsp);
        if (spasLinkGroupGetAttrRsp.getResult() != 1) {
            throw new FroRequestFailedException("InternalLinkGroup", "get attributes", roProxy.getResultMsg(spasLinkGroupGetAttrRsp.getResult()), spasLinkGroupGetAttrRsp.getResult());
        }
        return spasLinkGroupGetAttrRsp.getAdmStateLinkGroup();
    }

    public int[] getPmPeakBwLevel(Coordinator coordinator) throws MoAccessException {
        return super.getPmIntArrayAttribute("pmPeakBwLevel", coordinator);
    }

    public String[] getCurrentPmRegister(Coordinator coordinator) throws MoAccessException {
        return super.getCurrentPmRegister(coordinator);
    }

    public void setAdministrativeState(int n, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (n == 2) {
            n = 0;
        }
        if (n != 0 && n != 1) {
            throw new ValueOutOfRangeException("administrativeState", "InternalLinkGroup");
        }
        SpasLinkGroupFroSetAdmStateRsp spasLinkGroupFroSetAdmStateRsp = roProxy.sendSpasLinkGroupFroSetAdmStateReq(coordinator.getTransactionID(), this.resourceId.getValue(coordinator), n);
        this.checkSignal((Signal)spasLinkGroupFroSetAdmStateRsp);
        if (spasLinkGroupFroSetAdmStateRsp.getResult() != 1) {
            throw new FroRequestFailedException("InternalLinkGroup", "set adminstate", roProxy.getResultMsg(spasLinkGroupFroSetAdmStateRsp.getResult()), spasLinkGroupFroSetAdmStateRsp.getResult());
        }
        String[] stringArray = new String[]{"administrativeState"};
        Object[] objectArray = new Object[]{new Integer(n)};
        InternalLinkGroupMoImpl.sendChangeNotification(this, stringArray, objectArray, coordinator);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        SpasLinkGroupGetAttrRsp spasLinkGroupGetAttrRsp = roProxy.sendSpasLinkGroupGetAttrReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), this.resourceId.getValue(coordinator));
        this.checkSignal((Signal)spasLinkGroupGetAttrRsp);
        if (spasLinkGroupGetAttrRsp.getResult() != 1) {
            throw new FroRequestFailedException("InternalLinkGroup", "get attributes", roProxy.getResultMsg(spasLinkGroupGetAttrRsp.getResult()), spasLinkGroupGetAttrRsp.getResult());
        }
        return spasLinkGroupGetAttrRsp.getOpStateLinkGroup();
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        SpasLinkGroupGetAttrRsp spasLinkGroupGetAttrRsp = roProxy.sendSpasLinkGroupGetAttrReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), this.resourceId.getValue(coordinator));
        this.checkSignal((Signal)spasLinkGroupGetAttrRsp);
        if (spasLinkGroupGetAttrRsp.getResult() != 1) {
            throw new FroRequestFailedException("InternalLinkGroup", "get attributes", roProxy.getResultMsg(spasLinkGroupGetAttrRsp.getResult()), spasLinkGroupGetAttrRsp.getResult());
        }
        return AvailConverter.convert((int)spasLinkGroupGetAttrRsp.getAvailStateLinkGroup());
    }

    public long[] actionGetRlgLinks(int n, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        SpasLinkGroupGetAttrRsp spasLinkGroupGetAttrRsp = roProxy.sendSpasLinkGroupGetAttrReq(coordinator.getTransactionID(), this.resourceId.getValue(coordinator));
        this.checkSignal((Signal)spasLinkGroupGetAttrRsp);
        if (spasLinkGroupGetAttrRsp.getResult() != 1) {
            throw new FroRequestFailedException("InternalLinkGroup", "spasFro", "actionGetRlgLinks ", spasLinkGroupGetAttrRsp.getResult());
        }
        return spasLinkGroupGetAttrRsp.getRlgLinks(n);
    }

    public int actionGetLinkStatus(int n, int n2, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        SpasLinkGroupGetAttrRsp spasLinkGroupGetAttrRsp = roProxy.sendSpasLinkGroupGetAttrReq(coordinator.getTransactionID(), this.resourceId.getValue(coordinator));
        this.checkSignal((Signal)spasLinkGroupGetAttrRsp);
        if (spasLinkGroupGetAttrRsp.getResult() != 1) {
            throw new FroRequestFailedException("InternalLinkGroup", "spasFro", "actionGetRlgLinks ", spasLinkGroupGetAttrRsp.getResult());
        }
        return spasLinkGroupGetAttrRsp.getLinkStatus(n, n2);
    }

    public int[] actionGetReliableLinkGroups(Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        SpasLinkGroupGetAttrRsp spasLinkGroupGetAttrRsp = roProxy.sendSpasLinkGroupGetAttrReq(coordinator.getTransactionID(), this.resourceId.getValue(coordinator));
        this.checkSignal((Signal)spasLinkGroupGetAttrRsp);
        if (spasLinkGroupGetAttrRsp.getResult() != 1) {
            throw new FroRequestFailedException("InternalLinkGroup", "spasFro", "actionGetRlgLinks ", spasLinkGroupGetAttrRsp.getResult());
        }
        return spasLinkGroupGetAttrRsp.getRlgroups();
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.resourceId.getValue(coordinator);
    }

    public int getResourceId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.resourceId.getValue(coordinator);
    }

    private void checkSignal(Signal signal) throws FroNotAccessibleException {
        if (signal == null) {
            throw new FroNotAccessibleException("InternalLinkGroup", "SPAS_SRI_SERVICE_NAME");
        }
    }

    private static ManagedObject checkAndGetSwitchModuleNumber1(AttrList attrList) throws MoAccessException {
        int n = attrList.indexOf("switchModuleNumber1");
        if (n == -1) {
            throw new AttrMissingAtCreateException("switchModuleNumber1", "InternalLinkGroup");
        }
        if (!(attrList.getValue(n) instanceof SwitchModuleMo)) {
            throw new WrongAttributeTypeException("switchModuleNumber1", "InternalLinkGroup");
        }
        ManagedObject managedObject = (ManagedObject)attrList.getValue(n);
        attrList.removeElementAt(n);
        return managedObject;
    }

    private static ManagedObject checkAndGetSwitchModuleNumber2(AttrList attrList, ManagedObject managedObject) throws MoAccessException {
        int n = attrList.indexOf("switchModuleNumber2");
        if (n == -1) {
            throw new AttrMissingAtCreateException("switchModuleNumber2", "InternalLinkGroup");
        }
        if (!(attrList.getValue(n) instanceof SwitchModuleMo)) {
            throw new WrongAttributeTypeException("switchModuleNumber2", "InternalLinkGroup");
        }
        if (managedObject == attrList.getValue(n)) {
            throw new ValueOutOfRangeException("switchModuleNumber2", "InternalLinkGroup");
        }
        ManagedObject managedObject2 = (ManagedObject)attrList.getValue(n);
        attrList.removeElementAt(n);
        return managedObject2;
    }

    private static void sendChangeNotification(ManagedObject managedObject, String[] stringArray, Object[] objectArray, Coordinator coordinator) {
        NotificationSender notificationSender = NotificationSender.instance();
        notificationSender.pushAVC(managedObject, stringArray, objectArray, coordinator);
    }
}

