/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.equipmentsupportfunction;

import se.ericsson.cello.managedelement.ManagedElementMo;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoHasChildrenException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.AttrListImpl;
import se.ericsson.crbs.omf.mao.commonmo.ProcessingFailureException;
import se.ericsson.crbs.omf.mao.genericmo.GenericMao;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.indications.avc.AvcSubscriber;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;
import se.ericsson.crbs.supsys.supportsystemconfiguration.helper.EquipmentSupportFunctionHelper;
import se.ericsson.crbs.supsys.supportsystemconfiguration.helper.ExternalNodeHelper;

public class EquipmentSupportFunctionMaoImpl
extends GenericMao
implements AvcSubscriber {
    private static final String ENERGY_MEASUREMENT = "energyMeasurement";
    private static final String HWUNIT = "HwUnit";
    protected static final String ATTRIBUTE_CABINET_PARAMETERS = "cabinetParameters";
    protected static final String ATTRIBUTE_CABINET_PARAMETERS_PROFILE_STANDARD = "cabinetParametersProfileStandard";
    protected static final String ATTRIBUTE_CABINET_PARAMETERS_PROFILE_EXTENDED = "cabinetParametersProfileExtended";
    protected static final int STANDARD_CLIMATE_SYSTEM = 0;
    protected static final int EXTENDED_CLIMATE_SYSTEM = 1;
    protected static final String ATTRIBUTE_CLIMATE_SYSTEM = "climateSystem";
    protected static final String ATTRIBUTE_LOGICAL_NAME = "logicalName";
    protected static final String ATTRIBUTE_PRODUCT_NAME = "productName";
    protected static final String ATTRIBUTE_PRODUCT_NAME_ME = "productNameME";
    protected static final String ATTRIBUTE_FULL_DISTINGUISHED_NAME = "fullDistinguishedName";
    protected static final String ATTRIBUTE_RADIO_ACCESS_TECHNOLOGY = "radioAccessTechnology";
    private static final String MO_TYPE_EQUIPMENT_SUPPORT_FUNCTION = "EquipmentSupportFunction";
    private static final String MO_TYPE_FAN_GROUP = "FanGroup";
    private static final String MO_TYPE_CABINET = "Cabinet";
    private static final String MO_TYPE_CLIMATE = "Climate";
    protected static final String ATTRIBUTE_SUPPORT_SYSTEM_CONTROL = "supportSystemControl";
    private static final Class THIS_CLASS = EquipmentSupportFunctionMaoImpl.class;
    private static final Integer RAT_NOT_AVAILABLE = new Integer(0);
    private static final Integer RAT_WCDMA = new Integer(2);
    private static final Integer RAT_LTE = new Integer(3);
    private static final AbstractLogger logger = LoggingService.getLogger((String)EquipmentSupportFunctionMaoImpl.class.getName());
    private static final String MANAGED_ELEMENT_TYPE = "ManagedElement";

    public EquipmentSupportFunctionMaoImpl(ManagedObject managedObject, AttrList attrList, String string, GenericMaoContext genericMaoContext, Integer n, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoAccessException {
        super(managedObject, attrList, string, MO_TYPE_EQUIPMENT_SUPPORT_FUNCTION, genericMaoContext, n, coordinator, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "EquipmentSupportFunctionMaoImpl() - constructor");
        if (!"TRUE".equalsIgnoreCase(System.getProperty("UNIT_TEST"))) {
            genericMaoContext.getAvcRegistratorFactory().getAvcRegistrator().registerForUpdate((AvcSubscriber)this, MANAGED_ELEMENT_TYPE, ATTRIBUTE_LOGICAL_NAME);
            genericMaoContext.getAvcRegistratorFactory().getAvcRegistrator().registerForUpdate((AvcSubscriber)this, MANAGED_ELEMENT_TYPE, ATTRIBUTE_PRODUCT_NAME);
        }
        logger.traceReturn(THIS_CLASS, "EquipmentSupportFunctionMaoImpl() - constructor");
    }

    public EquipmentSupportFunctionMaoImpl(MoDataWrapper moDataWrapper, String string, GenericMaoContext genericMaoContext, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException, MoAccessException {
        super(moDataWrapper, string, genericMaoContext, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "EquipmentSupportFunctionMaoImpl() - reconstructor");
        if (!"TRUE".equalsIgnoreCase(System.getProperty("UNIT_TEST"))) {
            genericMaoContext.getAvcRegistratorFactory().getAvcRegistrator().registerForUpdate((AvcSubscriber)this, MANAGED_ELEMENT_TYPE, ATTRIBUTE_LOGICAL_NAME);
            genericMaoContext.getAvcRegistratorFactory().getAvcRegistrator().registerForUpdate((AvcSubscriber)this, MANAGED_ELEMENT_TYPE, ATTRIBUTE_PRODUCT_NAME);
        }
        logger.traceReturn(THIS_CLASS, "EquipmentSupportFunctionMaoImpl() - reconstructor");
    }

    public AttrList addFroParametersAtCreate(AttrList attrList, AttrList attrList2, Coordinator coordinator) throws MoAccessException {
        ((AttrListImpl)attrList).addAttribute(ATTRIBUTE_LOGICAL_NAME, (Object)((ManagedElementMo)this.getParent()).getLogicalName(coordinator));
        ((AttrListImpl)attrList).addAttribute(ATTRIBUTE_PRODUCT_NAME_ME, (Object)((ManagedElementMo)this.getParent()).getProductName(coordinator));
        ((AttrListImpl)attrList).addAttribute(ATTRIBUTE_FULL_DISTINGUISHED_NAME, (Object)"");
        ((AttrListImpl)attrList).addAttribute(ATTRIBUTE_RADIO_ACCESS_TECHNOLOGY, (Object)RAT_NOT_AVAILABLE);
        return attrList;
    }

    public void delete(AttrList attrList, Coordinator coordinator) throws MoAccessException, ProcessingFailureException {
        if (!"TRUE".equalsIgnoreCase(System.getProperty("UNIT_TEST"))) {
            this.genericMaoContext.getAvcRegistratorFactory().getAvcRegistrator().unregisterForUpdate((AvcSubscriber)this, MANAGED_ELEMENT_TYPE, ATTRIBUTE_LOGICAL_NAME);
            this.genericMaoContext.getAvcRegistratorFactory().getAvcRegistrator().unregisterForUpdate((AvcSubscriber)this, MANAGED_ELEMENT_TYPE, ATTRIBUTE_PRODUCT_NAME);
        }
        super.delete(attrList, coordinator);
    }

    public void postCreate(AttrList attrList, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(((Object)((Object)this)).getClass(), "postCreate");
        super.postCreate(attrList, coordinator);
        int n = attrList.indexOf(ATTRIBUTE_SUPPORT_SYSTEM_CONTROL);
        if (n >= 0) {
            boolean bl = (Boolean)attrList.getValue(n);
            ExternalNodeHelper.supportSystemControlChanged(bl, this.genericMaoContext, coordinator);
        }
        logger.traceReturn(((Object)((Object)this)).getClass(), "postCreate");
    }

    public void postSet(String string, Object object, Coordinator coordinator) throws MoAccessException {
        if (string.equalsIgnoreCase(ATTRIBUTE_SUPPORT_SYSTEM_CONTROL)) {
            this.postSetSupportSystemControl((Boolean)object, coordinator);
            this.postSetSupportSystemControlCabinet(coordinator);
        }
    }

    private void postSetSupportSystemControl(Boolean bl, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException, MoHasChildrenException {
        if (!bl.booleanValue()) {
            ManagedObject managedObject;
            MoIterator moIterator;
            MoIterator moIterator2 = this.genericMaoContext.getMoRepositoryWrapper().lookupType(ENERGY_MEASUREMENT);
            if (moIterator2 != null) {
                while (moIterator2.hasMoreElements()) {
                    moIterator = moIterator2.nextMo();
                    moIterator.delete(coordinator);
                }
            }
            moIterator = this.getChildren();
            MoIterator moIterator3 = this.genericMaoContext.getMoRepositoryWrapper().lookupType(HWUNIT);
            if (moIterator3 != null) {
                while (moIterator3.hasMoreElements()) {
                    managedObject = moIterator3.nextMo();
                    managedObject.delete(coordinator);
                }
            }
            while (moIterator.hasMoreElements()) {
                managedObject = moIterator.nextMo();
                if (!managedObject.getType().equals(MO_TYPE_CLIMATE)) {
                    logger.traceDebug(THIS_CLASS, "Delete EquipmentSupportFunction child MO of type: " + managedObject.getType());
                    managedObject.delete(coordinator);
                    continue;
                }
                logger.traceDebug(THIS_CLASS, "Skip delete EquipmentSupportFunction child MO of type: " + managedObject.getType());
            }
        }
        ExternalNodeHelper.supportSystemControlChanged(bl, this.genericMaoContext, coordinator);
    }

    private void postSetSupportSystemControlCabinet(Coordinator coordinator) throws MoAccessException, MoHasChildrenException {
        logger.traceEnter(THIS_CLASS, "postSetSupportSystemControlCabinet()");
        if (!EquipmentSupportFunctionHelper.isSupportSystemControl(this.genericMaoContext, coordinator)) {
            this.deleteFanGroupFromCabinets(coordinator);
        }
        logger.traceReturn(THIS_CLASS, "postSetSupportSystemControlCabinet()");
    }

    private void deleteFanGroupFromCabinets(Coordinator coordinator) throws MoAccessException, MoHasChildrenException {
        logger.traceEnter(THIS_CLASS, "deleteFanGroupFromCabinets()");
        ManagedObject managedObject = null;
        MoIterator moIterator = this.genericMaoContext.getMoRepositoryWrapper().lookupType(MO_TYPE_CABINET);
        while (moIterator != null && moIterator.hasMoreElements()) {
            managedObject = moIterator.nextMo();
            MoIterator moIterator2 = managedObject.getChildren();
            while (moIterator2 != null && moIterator2.hasMoreElements()) {
                ManagedObject managedObject2 = moIterator2.nextMo();
                if (!managedObject2.getType().equals(MO_TYPE_FAN_GROUP)) continue;
                managedObject2.delete(coordinator);
            }
        }
        logger.traceReturn(THIS_CLASS, "deleteFanGroupFromCabinets()");
    }

    public static Thread startUpdateRATandFDNthread(MoRepositoryWrapper moRepositoryWrapper) {
        UpdateRATAndFDNthread updateRATAndFDNthread = new UpdateRATAndFDNthread(moRepositoryWrapper);
        updateRATAndFDNthread.start();
        return updateRATAndFDNthread;
    }

    public boolean updateRAT() {
        logger.traceEnter(THIS_CLASS, "updateRAT");
        Integer n = RAT_NOT_AVAILABLE;
        MoIterator moIterator = this.genericMaoContext.getMoRepositoryWrapper().lookupType("NodeBFunction");
        if (moIterator != null && moIterator.size() > 0) {
            n = RAT_WCDMA;
        } else {
            MoIterator moIterator2 = this.genericMaoContext.getMoRepositoryWrapper().lookupType("ENodeBFunction");
            if (moIterator2 != null && moIterator2.size() > 0) {
                n = RAT_LTE;
            }
        }
        boolean bl = this.updateEquipmentSupportFunction(ATTRIBUTE_RADIO_ACCESS_TECHNOLOGY, n);
        logger.traceReturn(THIS_CLASS, "updateRAT");
        return bl;
    }

    public String updateFDN(String string) {
        logger.traceEnter(THIS_CLASS, "updateFDN");
        String string2 = string;
        ManagedObject managedObject = this.genericMaoContext.getMoRepositoryWrapper().lookup("ManagedElement=1");
        if (managedObject != null) {
            string2 = managedObject.getFullDistinguishedName();
            if (string == null || !string.equals(string2)) {
                this.updateEquipmentSupportFunction(ATTRIBUTE_FULL_DISTINGUISHED_NAME, string2);
            }
        }
        logger.traceReturn(THIS_CLASS, "updateFDN");
        return string2;
    }

    private boolean updateEquipmentSupportFunction(String string, Object object) {
        boolean bl = false;
        try {
            Control control = this.genericMaoContext.getTransactionServicesFactory().getCppTransactionFactory().create(59);
            Coordinator coordinator = control.getCoordinator();
            try {
                this.setReadOnlyAttribute(string, object, coordinator);
                logger.traceDebug(THIS_CLASS, "Updated " + string + " with value " + object);
                control.getTerminator().commit();
                bl = true;
            }
            catch (Exception exception) {
                try {
                    control.getTerminator().rollback();
                }
                catch (InactiveTransactionException inactiveTransactionException) {
                    logger.traceDebug(THIS_CLASS, "Inactive transaction exception caught for transaction: " + control.getCoordinator().getTransactionID());
                }
                logger.traceAbnormal(THIS_CLASS, "Failed to update " + string + ", reason: " + exception);
            }
        }
        catch (Exception exception) {
            logger.traceAbnormal(THIS_CLASS, "Failed to update " + string + ", reason: " + exception);
        }
        return bl;
    }

    private ManagedObject getManagedElement() {
        MoIterator moIterator = this.genericMaoContext.getMoRepositoryWrapper().lookupType(MANAGED_ELEMENT_TYPE);
        return (ManagedObject)moIterator.nextElement();
    }

    public void reportAvc(String string, String string2, Object object, Coordinator coordinator) throws MoAccessException {
        logger.traceDebug(THIS_CLASS, "reportAvc " + string2 + " with value " + object);
        if (string2 == ATTRIBUTE_PRODUCT_NAME) {
            this.setReadOnlyAttribute(ATTRIBUTE_PRODUCT_NAME_ME, object, coordinator);
        } else {
            this.setReadOnlyAttribute(string2, object, coordinator);
        }
    }

    public void reportSubscriptionProblem(Coordinator coordinator) throws MoAccessException {
        Object object = this.getAttribute(ATTRIBUTE_LOGICAL_NAME, coordinator);
        Object object2 = this.getManagedElement().getAttribute(ATTRIBUTE_LOGICAL_NAME, null);
        if (object != null && !object.equals(object2)) {
            this.setReadOnlyAttribute(ATTRIBUTE_LOGICAL_NAME, object2, coordinator);
        }
        Object object3 = this.getAttribute(ATTRIBUTE_PRODUCT_NAME_ME, coordinator);
        String string = ((ManagedElementMo)this.getParent()).getProductName(coordinator);
        if (object3 != null && !object3.equals(string)) {
            this.setReadOnlyAttribute(ATTRIBUTE_PRODUCT_NAME_ME, string, coordinator);
        }
    }

    public void actionCollectEnergyMeasurementLogs(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "collectEnergyMeasurementLogs() - Deprecated action");
        logger.traceReturn(THIS_CLASS, "collectEnergyMeasurementLogs() - Deprecated action");
    }

    public static class UpdateRATAndFDNthread
    extends Thread {
        private final int ONE_HOUR = 3600000;
        private final int ONE_MINUTE = 60000;
        private final int TEN_SECONDS = 10000;
        private final MoRepositoryWrapper moRepositoryWrapper;
        private volatile boolean forever = true;

        UpdateRATAndFDNthread(MoRepositoryWrapper moRepositoryWrapper) {
            this.moRepositoryWrapper = moRepositoryWrapper;
            this.setName("UpdateRATAndFDNthread");
        }

        public void run() {
            EquipmentSupportFunctionMaoImpl equipmentSupportFunctionMaoImpl = null;
            ManagedObject managedObject = null;
            ManagedObject managedObject2 = null;
            while (this.forever && equipmentSupportFunctionMaoImpl == null && managedObject == null && managedObject2 == null) {
                try {
                    MoIterator moIterator = this.moRepositoryWrapper.lookupType(EquipmentSupportFunctionMaoImpl.MO_TYPE_EQUIPMENT_SUPPORT_FUNCTION);
                    managedObject = this.moRepositoryWrapper.lookup("ManagedElement=1,ENodeBFunction=1");
                    managedObject2 = this.moRepositoryWrapper.lookup("ManagedElement=1,NodeBFunction=1");
                    if (moIterator != null && moIterator.hasMoreElements()) {
                        equipmentSupportFunctionMaoImpl = (EquipmentSupportFunctionMaoImpl)moIterator.nextMo();
                        continue;
                    }
                    this.mywait(10000);
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    this.mywait(10000);
                }
            }
            boolean bl = false;
            String string = null;
            while (this.forever) {
                try {
                    if (bl) {
                        string = equipmentSupportFunctionMaoImpl.updateFDN(string);
                        this.mywait(3600000);
                        continue;
                    }
                    bl = equipmentSupportFunctionMaoImpl.updateRAT();
                    if (bl) continue;
                    this.mywait(60000);
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    this.mywait(60000);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void mywait(int n) {
            UpdateRATAndFDNthread updateRATAndFDNthread = this;
            synchronized (updateRATAndFDNthread) {
                try {
                    this.wait(n);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void killOnlyFroTest() {
            this.forever = false;
            UpdateRATAndFDNthread updateRATAndFDNthread = this;
            synchronized (updateRATAndFDNthread) {
                this.notifyAll();
            }
        }
    }
}

