/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.supportsystemconfiguration;

import java.io.IOException;
import se.ericsson.cello.managedelement.mom.ManagedElement;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMao;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;
import se.ericsson.crbs.supsys.supportsystemconfiguration.SupportSystemConfigurationFailedException;
import se.ericsson.crbs.supsys.supportsystemconfiguration.SupportSystemConfigurationMao;
import se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure.EcPortConnectionData;
import se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure.ExternalAlarmsData;
import se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure.ExternalNodeData;
import se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure.HwUnitData;
import se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure.PlugInUnitData;
import se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure.PowerSystemData;
import se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure.RadioEquipmentData;
import se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure.SupportSystemData;
import se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure.SupportSystemDataFinder;
import se.ericsson.crbs.supsys.supportsystemconfiguration.helper.CabinetHelper;
import se.ericsson.crbs.supsys.supportsystemconfiguration.helper.EcBusHelper;
import se.ericsson.crbs.supsys.supportsystemconfiguration.helper.PlugInUnitHelper;
import se.ericsson.crbs.supsys.supportsystemconfiguration.helper.PowerSystemHelper;
import se.ericsson.crbs.supsys.supportsystemconfiguration.helper.ReportLoggerHelper;
import se.ericsson.crbs.supsys.supportsystemconfiguration.reportlogger.SupportSystemConfigurationReportLogger;

public class SupportSystemConfigurationMaoImpl
extends GenericMao
implements SupportSystemConfigurationMao {
    private static final String MO_TYPE = "SupportSystemConfiguration";
    private static final Class THIS_CLASS = SupportSystemConfigurationMaoImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final GenericMaoContext aGenericMaoContext;
    private final PowerSystemHelper powerSystemHelper;
    private final MoRepositoryWrapper aMoRepository;
    private int xmlVersion;

    public SupportSystemConfigurationMaoImpl(ManagedObject managedObject, AttrList attrList, String string, GenericMaoContext genericMaoContext, Integer n, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoAccessException {
        super(managedObject, attrList, string, MO_TYPE, genericMaoContext, n, coordinator, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "SupportSystemConfigurationMaoImpl() - Constructor");
        this.aGenericMaoContext = genericMaoContext;
        this.aMoRepository = genericMaoContext.getMoRepositoryWrapper();
        this.powerSystemHelper = new PowerSystemHelper(this.aGenericMaoContext);
        logger.traceReturn(THIS_CLASS, "SupportSystemConfigurationMaoImpl() - Constructor");
    }

    public SupportSystemConfigurationMaoImpl(MoDataWrapper moDataWrapper, String string, GenericMaoContext genericMaoContext, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException, MoAccessException {
        super(moDataWrapper, string, genericMaoContext, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "SupportSystemConfigurationMaoImpl() - Recover constructor");
        this.aGenericMaoContext = genericMaoContext;
        this.aMoRepository = genericMaoContext.getMoRepositoryWrapper();
        this.powerSystemHelper = new PowerSystemHelper(this.aGenericMaoContext);
        logger.traceReturn(THIS_CLASS, "SupportSystemConfigurationMaoImpl() - Recover constructor");
    }

    public void registerReportLogger(SupportSystemConfigurationReportLogger supportSystemConfigurationReportLogger) {
        ReportLoggerHelper.getInstance().registerReportLogger(supportSystemConfigurationReportLogger);
    }

    public void actionConfigureSupportSystem(String string, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "actionConfigureSupportSystem() file: " + string);
        try {
            SupportSystemData supportSystemData = this.parseSupportSystemXmlFile(string);
            this.checkConfigurationMultiCabinet(supportSystemData);
            this.configureSupportSystemAlways(supportSystemData, coordinator);
            if (supportSystemData.supportSystemControl) {
                this.configureSupportSystemSupportControlTrue(supportSystemData, coordinator);
            } else if (supportSystemData.xmlVersion > 1) {
                if (supportSystemData.xmlVersion > 2 && supportSystemData.isMultiCab) {
                    this.createPlugInUnitsEcPortsMultiCabinet(supportSystemData.plugInUnits, coordinator);
                } else {
                    this.createPlugInUnitsEcPorts(supportSystemData.plugInUnits, coordinator);
                }
            } else {
                this.connectEcPorts(supportSystemData.ecPortConnectionData, coordinator, supportSystemData.supportSystemControl);
            }
            this.connectRRUAlarmPorts(supportSystemData.radioEquipments, coordinator);
        }
        catch (SupportSystemConfigurationFailedException supportSystemConfigurationFailedException) {
            SupportSystemConfigurationFailedException supportSystemConfigurationFailedException2 = new SupportSystemConfigurationFailedException("Support system configuration failed", "Not able to configure the support system.", (Exception)((Object)supportSystemConfigurationFailedException));
            supportSystemConfigurationFailedException2.setStackTrace(supportSystemConfigurationFailedException.getStackTrace());
            throw supportSystemConfigurationFailedException2;
        }
        logger.traceReturn(THIS_CLASS, "actionConfigureSupportSystem()");
    }

    public SupportSystemData parseSupportSystemXmlFile(String string) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "parseSupportSystemXmlFile()");
        SupportSystemDataFinder supportSystemDataFinder = new SupportSystemDataFinder(this.genericMaoContext.getParserFactory());
        SupportSystemData supportSystemData = null;
        try {
            supportSystemData = supportSystemDataFinder.parseSupportSystemXmlFile(string);
        }
        catch (IOException iOException) {
            throw new SupportSystemConfigurationFailedException("Error parsing file", "Could not parse Support System XML file.", iOException);
        }
        logger.traceReturn(THIS_CLASS, "parseSupportSystemXmlFile()");
        return supportSystemData;
    }

    private void configureEquipmentSupportFunction(boolean bl, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "configureEquipmentSupportFunction() supportSystemControl: " + bl);
        ManagedObject managedObject = this.aMoRepository.lookup("ManagedElement=1,EquipmentSupportFunction=1");
        if (managedObject == null) {
            throw new SupportSystemConfigurationFailedException("MO not found", "Could not find the system created MO with LDN: ManagedElement=1,EquipmentSupportFunction=1");
        }
        try {
            managedObject.setAttribute("supportSystemControl", (Object)bl, coordinator);
        }
        catch (MoAccessException moAccessException) {
            throw new SupportSystemConfigurationFailedException("Set failed", "Could not set the supportSystemControlattribute on " + managedObject.getLocalDistinguishedName() + ".", (Exception)((Object)moAccessException));
        }
        logger.traceReturn(THIS_CLASS, "configureEquipmentSupportFunction()");
    }

    protected void createAndConfigureCabinet(SupportSystemData supportSystemData, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createAndConfigureCabinet()");
        CabinetHelper cabinetHelper = new CabinetHelper(this.aGenericMaoContext);
        cabinetHelper.createAndConfigureCabinet(supportSystemData, coordinator);
        logger.traceReturn(THIS_CLASS, "createAndConfigureCabinet()");
    }

    protected void createAndConfigureClimate(Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createAndConfigureClimate()");
        CabinetHelper cabinetHelper = new CabinetHelper(this.aGenericMaoContext);
        cabinetHelper.createAndConfigureClimate(coordinator);
        logger.traceReturn(THIS_CLASS, "createAndConfigureClimate()");
    }

    protected void createAndConfigureClimateMultiCabinet(SupportSystemData supportSystemData, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createAndConfigureClimateMultiCabinet()");
        CabinetHelper cabinetHelper = new CabinetHelper(this.aGenericMaoContext);
        cabinetHelper.createAndConfigureClimateMultiCabinet(supportSystemData, coordinator);
        logger.traceReturn(THIS_CLASS, "createAndConfigureClimateMultiCabinet()");
    }

    private void createChildrenUnderPiu(Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createChildrenUnderPiu()");
        PlugInUnitHelper plugInUnitHelper = new PlugInUnitHelper(this.aGenericMaoContext);
        if (this.xmlVersion < 2) {
            plugInUnitHelper.prepareChildrenForAllPlugInUnits(coordinator);
        }
        logger.traceReturn(THIS_CLASS, "createChildrenUnderPiu()");
    }

    private void addPositionRefToExistsPluginUnit(SupportSystemData supportSystemData, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "addPositionRefToPluginUnit()");
        PlugInUnitHelper plugInUnitHelper = new PlugInUnitHelper(this.aGenericMaoContext);
        try {
            plugInUnitHelper.addPositionRef(supportSystemData, coordinator);
        }
        catch (MoAccessException moAccessException) {
            throw new SupportSystemConfigurationFailedException("PlugInUnit MO.", "For Multi Cabinet configuration positionRef is mandatory.");
        }
        logger.traceReturn(THIS_CLASS, "addPositionRefToPluginUnit()");
    }

    private void createPlugInUnitsEcPortsMultiCabinet(PlugInUnitData[] plugInUnitDataArray, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createPlugInUnitsEcPortsMultiCabinet()");
        if (plugInUnitDataArray != null) {
            this.powerSystemHelper.createEcPortsForPlugInUnitsMultiCabinet(plugInUnitDataArray, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "createPlugInUnitsEcPortsMultiCabinet()");
    }

    private void createPlugInUnitsEcPorts(PlugInUnitData[] plugInUnitDataArray, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createPlugInUnits()");
        if (plugInUnitDataArray != null) {
            this.powerSystemHelper.createEcPortsForPlugInUnits(plugInUnitDataArray, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "createPlugInUnits()");
    }

    private void createAndConfigurePowerSystem(HwUnitData[] hwUnitDataArray, ExternalNodeData[] externalNodeDataArray, int n, PowerSystemData powerSystemData, int n2, boolean bl, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createAndConfigurePowerSystem()");
        this.powerSystemHelper.createAndConfigurePowerSystem(hwUnitDataArray, powerSystemData, n2, bl, coordinator);
        if (n2 > 1) {
            if (n2 > 2 && bl) {
                this.powerSystemHelper.createExternalNodesXsdMultiCabinet(externalNodeDataArray, coordinator);
            } else {
                this.powerSystemHelper.createExternalNodesXsd(externalNodeDataArray, coordinator);
            }
        } else {
            this.powerSystemHelper.createExternalNodesDtd(n, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "createAndConfigurePowerSystem()");
    }

    private void createAndConfigureHwUnits(HwUnitData[] hwUnitDataArray, SupportSystemData supportSystemData, ExternalAlarmsData[] externalAlarmsDataArray, int n, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createAndConfigureHwUnits()");
        this.powerSystemHelper.createAndConfigureHwUnits(hwUnitDataArray, supportSystemData, externalAlarmsDataArray, n, coordinator);
        logger.traceReturn(THIS_CLASS, "createAndConfigureHwUnits()");
    }

    private void createAndConfigureEcBus(SupportSystemData supportSystemData, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createAndConfigureHwUnits()");
        EcBusHelper ecBusHelper = new EcBusHelper(this.aGenericMaoContext);
        ecBusHelper.createAndConfigureEcBusMultiCabinet(supportSystemData, coordinator);
        logger.traceReturn(THIS_CLASS, "createAndConfigureHwUnits()");
    }

    private void connectEcPorts(EcPortConnectionData[] ecPortConnectionDataArray, Coordinator coordinator, boolean bl) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "connectEcPorts()");
        this.powerSystemHelper.connectEcPorts(ecPortConnectionDataArray, coordinator, bl);
        logger.traceReturn(THIS_CLASS, "connectEcPorts()");
    }

    private void connectExternalAlarmPors(ExternalAlarmsData[] externalAlarmsDataArray, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "connectAlarmPors()");
        this.powerSystemHelper.connectExternalAlarmPorts(externalAlarmsDataArray, coordinator);
        logger.traceReturn(THIS_CLASS, "connectAlarmPors()");
    }

    private void connectRRUAlarmPorts(RadioEquipmentData[] radioEquipmentDataArray, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "connectRRUAlarmPorts()");
        this.powerSystemHelper.connectRRUAlarmPorts(radioEquipmentDataArray, coordinator);
        logger.traceReturn(THIS_CLASS, "connectRRUAlarmPorts()");
    }

    private void setProductNameOnManagedElement(SupportSystemData supportSystemData, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        ManagedElement managedElement = (ManagedElement)this.aMoRepository.lookup("ManagedElement=1");
        try {
            managedElement.setProductName(supportSystemData.cabinetType, coordinator);
        }
        catch (MoAccessException moAccessException) {
            throw new SupportSystemConfigurationFailedException("Cabinet configuration", "Unable to set ProductName on ManagedElement MO", (Exception)((Object)moAccessException));
        }
    }

    public void checkConfigurationMultiCabinet(SupportSystemData supportSystemData) throws SupportSystemConfigurationFailedException {
        if (supportSystemData.cabinetDataList != null && supportSystemData.isMultiCab) {
            int n = supportSystemData.cabinetDataList.length;
            if (supportSystemData.supportSystemControl && (supportSystemData.powerSystemDataList == null || supportSystemData.powerSystemDataList.length != n)) {
                throw new SupportSystemConfigurationFailedException("Wrong number of power systems for cabinets");
            }
            if (supportSystemData.climateSystemDataList == null || supportSystemData.climateSystemDataList.length != n) {
                throw new SupportSystemConfigurationFailedException("Wrong number of climate systems for cabinets");
            }
        }
    }

    private void configureSupportSystemAlways(SupportSystemData supportSystemData, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        this.setProductNameOnManagedElement(supportSystemData, coordinator);
        this.configureEquipmentSupportFunction(supportSystemData.supportSystemControl, coordinator);
        this.createAndConfigureCabinet(supportSystemData, coordinator);
        if (supportSystemData.xmlVersion > 2 && supportSystemData.isMultiCab) {
            this.createAndConfigureClimateMultiCabinet(supportSystemData, coordinator);
        } else {
            this.createAndConfigureClimate(coordinator);
        }
        this.createChildrenUnderPiu(coordinator);
        if (supportSystemData.plugInUnits != null && supportSystemData.xmlVersion > 2 && supportSystemData.isMultiCab) {
            this.addPositionRefToExistsPluginUnit(supportSystemData, coordinator);
        } else {
            PlugInUnitHelper plugInUnitHelper = new PlugInUnitHelper(this.aGenericMaoContext);
            plugInUnitHelper.updatePlugInUnitsCabinetReference("1", coordinator);
        }
        if (supportSystemData.ecBusDataList != null && supportSystemData.xmlVersion > 2) {
            this.createAndConfigureEcBus(supportSystemData, coordinator);
        }
    }

    private void configureSupportSystemSupportControlTrue(SupportSystemData supportSystemData, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        if (supportSystemData.xmlVersion > 2 && supportSystemData.isMultiCab) {
            for (int i = 0; i < supportSystemData.powerSystemDataList.length; ++i) {
                this.createAndConfigurePowerSystem(supportSystemData.hwUnits, supportSystemData.externalNodes, supportSystemData.noOfExternalNodes, supportSystemData.powerSystemDataList[i], supportSystemData.xmlVersion, supportSystemData.isMultiCab, coordinator);
            }
        } else {
            this.createAndConfigurePowerSystem(supportSystemData.hwUnits, supportSystemData.externalNodes, supportSystemData.noOfExternalNodes, supportSystemData.powerSystems, supportSystemData.xmlVersion, supportSystemData.isMultiCab, coordinator);
        }
        this.createAndConfigureHwUnits(supportSystemData.hwUnits, supportSystemData, supportSystemData.externalAlarmsData, supportSystemData.xmlVersion, coordinator);
        if (!supportSystemData.isMultiCab || supportSystemData.xmlVersion < 2) {
            this.createAndConfigureClimate(coordinator);
        }
        if (supportSystemData.xmlVersion > 1) {
            if (supportSystemData.xmlVersion > 2 && supportSystemData.isMultiCab) {
                this.createPlugInUnitsEcPortsMultiCabinet(supportSystemData.plugInUnits, coordinator);
            } else {
                this.createPlugInUnitsEcPorts(supportSystemData.plugInUnits, coordinator);
            }
        } else {
            this.connectEcPorts(supportSystemData.ecPortConnectionData, coordinator, supportSystemData.supportSystemControl);
            this.connectExternalAlarmPors(supportSystemData.externalAlarmsData, coordinator);
        }
        if (!supportSystemData.isMultiCab) {
            this.fillReferencesForSingleCabinet("1", supportSystemData, coordinator);
        }
    }

    private void fillReferencesForSingleCabinet(String string, SupportSystemData supportSystemData, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "fillReferencesForSingleCabinet()");
        this.powerSystemHelper.updatePowerSystemCabinetReference(string, coordinator);
        if (!supportSystemData.isCascadingOrder) {
            this.powerSystemHelper.updateHwUnitsCabinetReference(string, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "fillReferencesForSingleCabinets()");
    }
}

