/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.supportsystemconfiguration.helper;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;

public class EquipmentSupportFunctionHelper {
    private static final Class THIS_CLASS = EquipmentSupportFunctionHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String MO_TYPE_EQUIPMENT_SUPPORT_FUNCTION = "EquipmentSupportFunction";
    private static final String ATTRIBUTE_SUPPORT_SYSTEM_CONTROL = "supportSystemControl";

    public static boolean isSupportSystemControl(GenericMaoContext genericMaoContext, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "isSupportSystemControl()");
        boolean bl = true;
        MoIterator moIterator = genericMaoContext.getMoRepositoryWrapper().lookupType(MO_TYPE_EQUIPMENT_SUPPORT_FUNCTION);
        if (moIterator != null && moIterator.hasMoreElements()) {
            ManagedObject managedObject = moIterator.nextMo();
            bl = (Boolean)managedObject.getAttribute(ATTRIBUTE_SUPPORT_SYSTEM_CONTROL, coordinator);
            logger.traceDebug(THIS_CLASS, "SupportSystemControl attribute found: " + bl);
        } else {
            logger.traceAbnormal(THIS_CLASS, "SupportSystemControl attribute was not found.");
        }
        logger.traceReturn(THIS_CLASS, "isSupportSystemControl(), attribute: " + bl);
        return bl;
    }
}

