/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ipoam;

import [Ljava.lang.String;;
import java.util.Arrays;
import java.util.LinkedHashSet;
import se.ericsson.cello.ipoam.IpMo;
import se.ericsson.cello.ipoam.IpMoImpl;
import se.ericsson.cello.ipsec.mom.VpnInterface;
import se.ericsson.cello.iptransport.IpInterfaceMo;
import se.ericsson.cello.iptransport.VpnInterfaceBuildIF;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.mao.DomainNameFormatException;
import se.ericsson.cello.mao.DomainNameValidation;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.GetRequestContextImpl;
import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.mao.InvalidReferenceException;
import se.ericsson.cello.mao.IpAddressValidation;
import se.ericsson.cello.mao.MoGenUtil;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.mao.SetRequestContextImpl;
import se.ericsson.cello.maofro.framework.ArrayParameter;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;

public class DNSClientUtils {
    private static String[] ATTRIBUTES_TO_REQUEST_FROM_FRO = new String[]{"defDomainName", "dnsServerAddresses", "dnsServerAddress", "isDefDomainName", "isRecursiveSearch", "isSubDomainName", "noOfRetrans", "retransInterval", "useHostFile", "usedDnsServerAddresses", "usedDnsServerAddress"};
    private static String[] NON_READONLY_MOM_ATTRIBUTES = new String[]{"defDomainName", "dnsServerAddresses", "isDefDomainName", "isRecursiveSearch", "isSubDomainName", "noOfRetrans", "retransInterval", "useHostFile", "dnsAutoConfigInterfaceRef"};
    protected static final int DNS_CLIENT_FROID = 1;
    private static final String TYPE_NAME = "Ip (DNS-client)";

    private DNSClientUtils() {
    }

    protected static FroData create(Coordinator coordinator, FroProxy froProxy, AttrList attrList, MoData moData) throws MoAccessException {
        FroData froData;
        SetRequestContextImpl setRequestContextImpl = new SetRequestContextImpl(attrList, coordinator);
        setRequestContextImpl.assertNoDuplicateAttributes("Ip");
        setRequestContextImpl.assertAllowedAttributes(NON_READONLY_MOM_ATTRIBUTES, "Ip");
        ManagedObject managedObject = (ManagedObject)MoGenUtil.checkAndGetAttributeType((String)"dnsAutoConfigInterfaceRef", (AttrList)attrList, (Class)ManagedObject.class, (String)"Ip");
        DNSClientUtils.validateDnsAutoConfInterface(managedObject, setRequestContextImpl);
        int n = 0;
        if (managedObject != null) {
            n = ((FroInfo)managedObject).getFroId(coordinator);
            ((ReferenceAttribute)moData.getAttribute("dnsAutoConfigInterfaceRef")).setValue(managedObject);
        }
        setRequestContextImpl.addParameter(froProxy, (Parameter)new SignedIntParameter("dnsAutoConfigInterfaceRef", n));
        Integer n2 = (Integer)MoGenUtil.checkAndGetAttributeType((String)"noOfRetrans", (AttrList)attrList, (Class)Integer.class, (String)"Ip");
        int n3 = 5;
        if (n2 != null) {
            n3 = n2;
        }
        DNSClientUtils.validatenoOfRetrans(n3, setRequestContextImpl);
        setRequestContextImpl.addParameter(froProxy, (Parameter)new SignedIntParameter("noOfRetrans", n3));
        Integer n4 = (Integer)MoGenUtil.checkAndGetAttributeType((String)"retransInterval", (AttrList)attrList, (Class)Integer.class, (String)"Ip");
        int n5 = 4;
        if (n4 != null) {
            n5 = n4;
        }
        DNSClientUtils.validateRetransInterval(n5, setRequestContextImpl);
        setRequestContextImpl.addParameter(froProxy, (Parameter)new SignedIntParameter("retransInterval", n5));
        Boolean bl = (Boolean)MoGenUtil.checkAndGetAttributeType((String)"useHostFile", (AttrList)attrList, (Class)Boolean.class, (String)"Ip");
        boolean bl2 = true;
        if (bl != null) {
            bl2 = bl;
        }
        DNSClientUtils.validateUseHostFile(bl2, setRequestContextImpl);
        setRequestContextImpl.addParameter(froProxy, (Parameter)new SignedIntParameter("useHostFile", bl2));
        Boolean bl3 = (Boolean)MoGenUtil.checkAndGetAttributeType((String)"isRecursiveSearch", (AttrList)attrList, (Class)Boolean.class, (String)"Ip");
        boolean bl4 = true;
        if (bl3 != null) {
            bl4 = bl3;
        }
        DNSClientUtils.validateIsRecursiveSearch(bl4, setRequestContextImpl);
        setRequestContextImpl.addParameter(froProxy, (Parameter)new SignedIntParameter("isRecursiveSearch", bl4));
        String string = (String)MoGenUtil.checkAndGetAttributeType((String)"defDomainName", (AttrList)attrList, (Class)String.class, (String)"Ip");
        if (string == null) {
            string = "";
        }
        DNSClientUtils.validateDefDomainName(string);
        setRequestContextImpl.addParameter(froProxy, (Parameter)new StringParameter("defDomainName", string));
        Boolean bl5 = (Boolean)MoGenUtil.checkAndGetAttributeType((String)"isDefDomainName", (AttrList)attrList, (Class)Boolean.class, (String)"Ip");
        boolean bl6 = false;
        if (bl5 != null) {
            bl6 = bl5;
        }
        DNSClientUtils.validateIsDefDomainName(bl6, setRequestContextImpl);
        setRequestContextImpl.addParameter(froProxy, (Parameter)new SignedIntParameter("isDefDomainName", bl6));
        Boolean bl7 = (Boolean)MoGenUtil.checkAndGetAttributeType((String)"isSubDomainName", (AttrList)attrList, (Class)Boolean.class, (String)"Ip");
        boolean bl8 = true;
        if (bl7 != null) {
            bl8 = bl7;
        }
        DNSClientUtils.validateIsSubDomainName(bl8, setRequestContextImpl);
        setRequestContextImpl.addParameter(froProxy, (Parameter)new SignedIntParameter("isSubDomainName", bl8));
        String[] stringArray = (String[])MoGenUtil.checkAndGetAttributeType((String)"dnsServerAddresses", (AttrList)attrList, (Class)String;.class, (String)TYPE_NAME);
        if (stringArray == null) {
            stringArray = IpMo.DNS_SERVER_ADDRESSES_DEFAULT;
        }
        DNSClientUtils.validateDnsServerAddresses(stringArray, setRequestContextImpl);
        ArrayParameter arrayParameter = null;
        if (stringArray != null) {
            arrayParameter = new ArrayParameter("dnsServerAddresses");
            froData = null;
            for (int i = 0; i < stringArray.length; ++i) {
                froData = new StringParameter("dnsServerAddress", stringArray[i], 47);
                arrayParameter.add((Parameter)froData);
            }
        }
        setRequestContextImpl.addParameter(froProxy, arrayParameter);
        froData = setRequestContextImpl.sendCreateRequest(froProxy);
        return froData;
    }

    protected static AttrList extractDNSClientAttributes(AttrList attrList) throws MoAccessException {
        AttrListImpl attrListImpl = new AttrListImpl();
        attrListImpl.addElement("noOfRetrans", MoGenUtil.checkAndGetAttributeType((String)"noOfRetrans", (AttrList)attrList, (Class)Integer.class, (String)"Ip"));
        attrListImpl.addElement("retransInterval", MoGenUtil.checkAndGetAttributeType((String)"retransInterval", (AttrList)attrList, (Class)Integer.class, (String)"Ip"));
        attrListImpl.addElement("useHostFile", MoGenUtil.checkAndGetAttributeType((String)"useHostFile", (AttrList)attrList, (Class)Boolean.class, (String)"Ip"));
        attrListImpl.addElement("isRecursiveSearch", MoGenUtil.checkAndGetAttributeType((String)"isRecursiveSearch", (AttrList)attrList, (Class)Boolean.class, (String)"Ip"));
        attrListImpl.addElement("defDomainName", MoGenUtil.checkAndGetAttributeType((String)"defDomainName", (AttrList)attrList, (Class)String.class, (String)"Ip"));
        attrListImpl.addElement("isDefDomainName", MoGenUtil.checkAndGetAttributeType((String)"isDefDomainName", (AttrList)attrList, (Class)Boolean.class, (String)"Ip"));
        attrListImpl.addElement("isSubDomainName", MoGenUtil.checkAndGetAttributeType((String)"isSubDomainName", (AttrList)attrList, (Class)Boolean.class, (String)"Ip"));
        attrListImpl.addElement("dnsServerAddresses", MoGenUtil.checkAndGetAttributeType((String)"dnsServerAddresses", (AttrList)attrList, (Class)String;.class, (String)"Ip"));
        attrListImpl.addElement("dnsAutoConfigInterfaceRef", MoGenUtil.checkAndGetAttributeType((String)"dnsAutoConfigInterfaceRef", (AttrList)attrList, (Class)ManagedObject.class, (String)"Ip"));
        return attrListImpl;
    }

    protected static void delete(Coordinator coordinator, FroProxy froProxy, MoData moData) throws MoAccessException {
        froProxy.delete(coordinator, 1, null);
    }

    private static void validateDnsServerAddresses(String[] stringArray, SetRequestContextImpl setRequestContextImpl) throws MoAccessException {
        if (stringArray.length > 3) {
            throw new ValueOutOfRangeException("dnsServerAddresses", TYPE_NAME, "A maximum of 3 DNS server addresses is supported");
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(Arrays.asList(stringArray));
        if (stringArray.length != linkedHashSet.size()) {
            throw new IllegalAttributeValueException("dnsServerAddresses", "Duplicated DNS server address");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].trim().equals("")) continue;
            IpAddressValidation.validate((String)stringArray[i]);
        }
    }

    private static void validateIsSubDomainName(boolean bl, SetRequestContextImpl setRequestContextImpl) throws MoAccessException {
    }

    private static void validateIsDefDomainName(boolean bl, SetRequestContextImpl setRequestContextImpl) throws MoAccessException {
    }

    private static void validateDnsAutoConfInterface(ManagedObject managedObject, SetRequestContextImpl setRequestContextImpl) throws MoAccessException {
        if (managedObject != null) {
            if (managedObject instanceof VpnInterface) {
                int n = ((VpnInterfaceBuildIF)managedObject).getConfigurationMode(setRequestContextImpl.getCoordinator());
                if (n != 1) {
                    throw new InvalidReferenceException("Ip (DNS-client)If the referenced dnsAutoConfigInterfaceRef is VpnInterface then it should have configurationMethod=IKE", (Object)managedObject);
                }
            } else if (managedObject instanceof IpInterfaceMo) {
                int n = ((IpInterfaceMo)managedObject).getConfigurationMode(setRequestContextImpl.getCoordinator());
                if (n != 1) {
                    throw new InvalidReferenceException("Ip (DNS-client)If the referenced dnsAutoConfigInterfaceRef is IpInterface then it should have configurationMethod=DHCP", (Object)managedObject);
                }
            } else {
                throw new InvalidReferenceException("Ip (DNS-client). The attribute dnsAutoConfigInterfaceRef must refer to VpnInterface or IpInterface.", (Object)managedObject);
            }
        }
    }

    private static void validateDefDomainName(String string) throws MoAccessException {
        if (!string.equals("")) {
            MoGenUtil.checkStringWithLength((String)string, (String)"defDomainName", (int)255, (int)0, (String)TYPE_NAME);
            try {
                DomainNameValidation.validate((String)string);
            }
            catch (DomainNameFormatException domainNameFormatException) {
                throw new ValueOutOfRangeException("defDomainName", TYPE_NAME, string + " is not valid domain name");
            }
        }
    }

    private static void validateIsRecursiveSearch(boolean bl, SetRequestContextImpl setRequestContextImpl) throws MoAccessException {
    }

    private static void validateUseHostFile(boolean bl, SetRequestContextImpl setRequestContextImpl) throws MoAccessException {
    }

    private static void checkRelation(String string, boolean bl, String string2) throws IllegalAttributeValueException {
        boolean bl2 = false;
        if (string == null || string.length() == 0) {
            bl2 = true;
        }
        if (bl && bl2) {
            throw new IllegalAttributeValueException(string2, "defDomainName", TYPE_NAME);
        }
    }

    private static void checkRelation(int[] nArray, boolean bl, String string) throws IllegalAttributeValueException {
        boolean bl2 = false;
        if (nArray == null || nArray.length == 0 || nArray.length == 1 && nArray[0] == 0) {
            bl2 = true;
        }
        if (bl && bl2) {
            throw new IllegalAttributeValueException(string, "defDomainName", TYPE_NAME);
        }
    }

    private static void validateRetransInterval(int n, SetRequestContextImpl setRequestContextImpl) throws MoAccessException {
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{255};
        MoGenUtil.checkIntegerAttribute((String)"noOfRetrans", (int)n, (int[])nArray, (int[])nArray2, (String)"Ip");
    }

    private static void validatenoOfRetrans(int n, SetRequestContextImpl setRequestContextImpl) throws MoAccessException {
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{255};
        MoGenUtil.checkIntegerAttribute((String)"noOfRetrans", (int)n, (int[])nArray, (int[])nArray2, (String)"Ip");
    }

    protected static String[] getDnsServerAddresses(Coordinator coordinator, MoData moData, FroProxy froProxy) throws MoAccessException {
        return (String[])DNSClientUtils.getAttribute("dnsServerAddresses", coordinator, moData, froProxy);
    }

    protected static void setDnsServerAddresses(String[] stringArray, Coordinator coordinator, MoData moData, FroProxy froProxy, ManagedObject managedObject) throws MoAccessException {
        DNSClientUtils.setAttribute("dnsServerAddresses", stringArray, coordinator, moData, froProxy, managedObject);
    }

    protected static ManagedObject getDnsAutoConfigInterfaceRef(Coordinator coordinator, MoData moData, FroProxy froProxy) throws MoAccessException {
        return ((ReferenceAttribute)moData.getAttribute("dnsAutoConfigInterfaceRef")).getValue(coordinator);
    }

    protected static void setDnsAutoConfigInterfaceRef(ManagedObject managedObject, Coordinator coordinator, MoData moData, FroProxy froProxy, ManagedObject managedObject2) throws MoAccessException {
        DNSClientUtils.setAttribute("dnsAutoConfigInterfaceRef", managedObject, coordinator, moData, froProxy, managedObject2);
    }

    protected static String[] getUsedDnsServerAddresses(Coordinator coordinator, MoData moData, FroProxy froProxy) throws MoAccessException {
        return (String[])DNSClientUtils.getAttribute("usedDnsServerAddresses", coordinator, moData, froProxy);
    }

    protected static int getRetransInterval(Coordinator coordinator, MoData moData, FroProxy froProxy) throws MoAccessException {
        return (Integer)DNSClientUtils.getAttribute("retransInterval", coordinator, moData, froProxy);
    }

    protected static void setRetransInterval(int n, Coordinator coordinator, MoData moData, FroProxy froProxy, ManagedObject managedObject) throws MoAccessException {
        DNSClientUtils.setAttribute("retransInterval", new Integer(n), coordinator, moData, froProxy, managedObject);
    }

    protected static int getNoOfRetrans(Coordinator coordinator, MoData moData, FroProxy froProxy) throws MoAccessException {
        return (Integer)DNSClientUtils.getAttribute("noOfRetrans", coordinator, moData, froProxy);
    }

    protected static void setNoOfRetrans(int n, Coordinator coordinator, MoData moData, FroProxy froProxy, ManagedObject managedObject) throws MoAccessException {
        DNSClientUtils.setAttribute("noOfRetrans", new Integer(n), coordinator, moData, froProxy, managedObject);
    }

    protected static boolean getIsRecursiveSearch(Coordinator coordinator, MoData moData, FroProxy froProxy) throws MoAccessException {
        return (Boolean)DNSClientUtils.getAttribute("isRecursiveSearch", coordinator, moData, froProxy);
    }

    protected static void setIsRecursiveSearch(boolean bl, Coordinator coordinator, MoData moData, FroProxy froProxy, ManagedObject managedObject) throws MoAccessException {
        DNSClientUtils.setAttribute("isRecursiveSearch", bl, coordinator, moData, froProxy, managedObject);
    }

    protected static boolean getIsSubDomainName(Coordinator coordinator, MoData moData, FroProxy froProxy) throws MoAccessException {
        return (Boolean)DNSClientUtils.getAttribute("isSubDomainName", coordinator, moData, froProxy);
    }

    protected static void setIsSubDomainName(boolean bl, Coordinator coordinator, MoData moData, FroProxy froProxy, ManagedObject managedObject) throws MoAccessException {
        DNSClientUtils.setAttribute("isSubDomainName", bl, coordinator, moData, froProxy, managedObject);
    }

    protected static boolean getIsDefDomainName(Coordinator coordinator, MoData moData, FroProxy froProxy) throws MoAccessException {
        return (Boolean)DNSClientUtils.getAttribute("isDefDomainName", coordinator, moData, froProxy);
    }

    protected static void setIsDefDomainName(boolean bl, Coordinator coordinator, MoData moData, FroProxy froProxy, ManagedObject managedObject) throws MoAccessException {
        String string = DNSClientUtils.getDefDomainName(coordinator, moData, froProxy);
        DNSClientUtils.checkRelation(string, bl, "Failed in setting isDefDomainName.The defDomainName is either null or empty.");
        DNSClientUtils.setAttribute("isDefDomainName", bl, coordinator, moData, froProxy, managedObject);
    }

    protected static String getDefDomainName(Coordinator coordinator, MoData moData, FroProxy froProxy) throws MoAccessException {
        return (String)DNSClientUtils.getAttribute("defDomainName", coordinator, moData, froProxy);
    }

    protected static void setDefDomainName(String string, Coordinator coordinator, MoData moData, FroProxy froProxy, ManagedObject managedObject) throws MoAccessException {
        if (string == null || string.compareTo("") == 0) {
            int[] nArray = new int[]{0};
            DNSClientUtils.checkRelation(nArray, DNSClientUtils.getIsDefDomainName(coordinator, moData, froProxy), "Failed to set defDomainName.\nThe isDefDomainName attribute cannot be true while the defDomainName is null or empty.");
            DNSClientUtils.validateDefDomainName(string);
        }
        DNSClientUtils.setAttribute("defDomainName", string, coordinator, moData, froProxy, managedObject);
    }

    protected static boolean getUseHostFile(Coordinator coordinator, MoData moData, FroProxy froProxy) throws MoAccessException {
        return (Boolean)DNSClientUtils.getAttribute("useHostFile", coordinator, moData, froProxy);
    }

    protected static void setUseHostFile(boolean bl, Coordinator coordinator, MoData moData, FroProxy froProxy, ManagedObject managedObject) throws MoAccessException {
        DNSClientUtils.setAttribute("useHostFile", bl, coordinator, moData, froProxy, managedObject);
    }

    protected static Object getAttribute(String string, Coordinator coordinator, MoData moData, FroProxy froProxy) throws MoAccessException, NoSuchAttributeException {
        String[] stringArray = new String[]{string};
        Object[] objectArray = DNSClientUtils.getAttributes(stringArray, coordinator, moData, froProxy);
        return objectArray[0];
    }

    protected static Object[] getAttributes(String[] stringArray, Coordinator coordinator, MoData moData, FroProxy froProxy) throws MoAccessException {
        moData.handleTransaction(coordinator, MoData.READ_ACCESS);
        GetRequestContextImpl getRequestContextImpl = new GetRequestContextImpl(stringArray, coordinator);
        getRequestContextImpl.readAttributesFromProxy(froProxy, 1, ATTRIBUTES_TO_REQUEST_FROM_FRO);
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            StringParameter stringParameter;
            String string;
            String[] stringArray2;
            StringParameter stringParameter2;
            if (stringArray[i].equalsIgnoreCase("defDomainName")) {
                stringParameter2 = (StringParameter)getRequestContextImpl.getParameter("defDomainName");
                if (stringParameter2 == null) {
                    throw new FroRequestFailedException(TYPE_NAME, "Missing parameter from FRO:defDomainName", "getAttributes", -1);
                }
                objectArray[i] = stringParameter2.getValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("retransInterval")) {
                stringParameter2 = (SignedIntParameter)getRequestContextImpl.getParameter("retransInterval");
                if (stringParameter2 == null) {
                    throw new FroRequestFailedException(TYPE_NAME, "Missing parameter from FRO: retransInterval", "getAttributes", -1);
                }
                objectArray[i] = new Integer(stringParameter2.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("noOfRetrans")) {
                stringParameter2 = (SignedIntParameter)getRequestContextImpl.getParameter("noOfRetrans");
                if (stringParameter2 == null) {
                    throw new FroRequestFailedException(TYPE_NAME, "Missing parameter from FRO: noOfRetrans", "getAttributes", -1);
                }
                objectArray[i] = new Integer(stringParameter2.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("isRecursiveSearch")) {
                stringParameter2 = (SignedIntParameter)getRequestContextImpl.getParameter("isRecursiveSearch");
                if (stringParameter2 == null) {
                    throw new FroRequestFailedException(TYPE_NAME, "Missing parameter from FRO:isRecursiveSearch", "getAttributes", -1);
                }
                objectArray[i] = stringParameter2.getBoolean();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("isDefDomainName")) {
                stringParameter2 = (SignedIntParameter)getRequestContextImpl.getParameter("isDefDomainName");
                if (stringParameter2 == null) {
                    throw new FroRequestFailedException(TYPE_NAME, "Missing parameter from FRO:isDefDomainName", "getAttributes", -1);
                }
                objectArray[i] = stringParameter2.getBoolean();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("isSubDomainName")) {
                stringParameter2 = (SignedIntParameter)getRequestContextImpl.getParameter("isSubDomainName");
                if (stringParameter2 == null) {
                    throw new FroRequestFailedException(TYPE_NAME, "Missing parameter from FRO:isSubDomainName", "getAttributes", -1);
                }
                objectArray[i] = stringParameter2.getBoolean();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("useHostFile")) {
                stringParameter2 = (SignedIntParameter)getRequestContextImpl.getParameter("useHostFile");
                if (stringParameter2 == null) {
                    throw new FroRequestFailedException(TYPE_NAME, "Missing parameter from FRO:useHostFile", "getAttributes", -1);
                }
                objectArray[i] = stringParameter2.getBoolean();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("dnsServerAddresses")) {
                stringParameter2 = (ArrayParameter)getRequestContextImpl.getParameter("dnsServerAddresses");
                if (stringParameter2 == null) {
                    throw new FroRequestFailedException(TYPE_NAME, "Missing parameter from FRO: dnsServerAddresses", "getAttributes", -1);
                }
                stringArray2 = new String[stringParameter2.size()];
                string = null;
                stringParameter = null;
                for (n = 0; n < stringParameter2.size(); ++n) {
                    stringParameter = (StringParameter)stringParameter2.get(n);
                    stringArray2[n] = string = stringParameter.getValue();
                }
                objectArray[i] = stringArray2;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("usedDnsServerAddresses")) {
                stringParameter2 = (ArrayParameter)getRequestContextImpl.getParameter("usedDnsServerAddresses");
                if (stringParameter2 == null) {
                    throw new FroRequestFailedException(TYPE_NAME, "Missing parameter from FRO: usedDnsServerAddressesParam", "getAttributes", -1);
                }
                stringArray2 = new String[stringParameter2.size()];
                string = null;
                stringParameter = null;
                for (n = 0; n < stringParameter2.size(); ++n) {
                    stringParameter = (StringParameter)stringParameter2.get(n);
                    stringArray2[n] = string = stringParameter.getValue();
                }
                objectArray[i] = stringArray2;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("dnsAutoConfigInterfaceRef")) {
                objectArray[i] = ((ReferenceAttribute)moData.getAttribute("dnsAutoConfigInterfaceRef")).getValue(coordinator);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], TYPE_NAME);
        }
        return objectArray;
    }

    protected static void setAttribute(String string, Object object, Coordinator coordinator, MoData moData, FroProxy froProxy, ManagedObject managedObject) throws MoAccessException {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        DNSClientUtils.setAttributes(stringArray, objectArray, coordinator, moData, froProxy, managedObject);
    }

    protected static void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator, MoData moData, FroProxy froProxy, ManagedObject managedObject) throws MoAccessException {
        moData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        SetRequestContextImpl setRequestContextImpl = new SetRequestContextImpl(stringArray, objectArray, coordinator);
        String string = null;
        Object object = null;
        setRequestContextImpl.assertNoDuplicateAttributes(TYPE_NAME);
        for (int i = 0; i < stringArray.length; ++i) {
            ArrayParameter arrayParameter;
            ManagedObject managedObject2;
            string = stringArray[i];
            object = objectArray[i];
            if (string.equalsIgnoreCase("defDomainName")) {
                if (object instanceof String) {
                    managedObject2 = (ManagedObject)object;
                    DNSClientUtils.validateDefDomainName((String)managedObject2);
                    setRequestContextImpl.addParameter(froProxy, (Parameter)new StringParameter("defDomainName", (String)managedObject2));
                    setRequestContextImpl.addAvcNotification(string, object);
                    continue;
                }
                throw new WrongAttributeTypeException("defDomainName", TYPE_NAME);
            }
            if (string.equalsIgnoreCase("noOfRetrans")) {
                if (object instanceof Integer) {
                    int n = (Integer)object;
                    DNSClientUtils.validatenoOfRetrans(n, setRequestContextImpl);
                    setRequestContextImpl.addParameter(froProxy, (Parameter)new SignedIntParameter("noOfRetrans", n));
                    setRequestContextImpl.addAvcNotification(string, object);
                    continue;
                }
                throw new WrongAttributeTypeException("noOfRetrans", TYPE_NAME);
            }
            if (string.equalsIgnoreCase("retransInterval")) {
                if (object instanceof Integer) {
                    int n = (Integer)object;
                    DNSClientUtils.validatenoOfRetrans(n, setRequestContextImpl);
                    setRequestContextImpl.addParameter(froProxy, (Parameter)new SignedIntParameter("retransInterval", n));
                    setRequestContextImpl.addAvcNotification(string, object);
                    continue;
                }
                throw new WrongAttributeTypeException("retransInterval", TYPE_NAME);
            }
            if (string.equalsIgnoreCase("isRecursiveSearch")) {
                if (object instanceof Boolean) {
                    boolean bl = (Boolean)object;
                    DNSClientUtils.validateIsRecursiveSearch(bl, setRequestContextImpl);
                    setRequestContextImpl.addParameter(froProxy, (Parameter)new SignedIntParameter("isRecursiveSearch", bl));
                    setRequestContextImpl.addAvcNotification(string, object);
                    continue;
                }
                throw new WrongAttributeTypeException("isRecursiveSearch", TYPE_NAME);
            }
            if (string.equalsIgnoreCase("isDefDomainName")) {
                if (object instanceof Boolean) {
                    boolean bl = (Boolean)object;
                    DNSClientUtils.validateIsRecursiveSearch(bl, setRequestContextImpl);
                    setRequestContextImpl.addParameter(froProxy, (Parameter)new SignedIntParameter("isDefDomainName", bl));
                    setRequestContextImpl.addAvcNotification(string, object);
                    continue;
                }
                throw new WrongAttributeTypeException("isDefDomainName", TYPE_NAME);
            }
            if (string.equalsIgnoreCase("isSubDomainName")) {
                if (object instanceof Boolean) {
                    boolean bl = (Boolean)object;
                    DNSClientUtils.validateIsRecursiveSearch(bl, setRequestContextImpl);
                    setRequestContextImpl.addParameter(froProxy, (Parameter)new SignedIntParameter("isSubDomainName", bl));
                    setRequestContextImpl.addAvcNotification(string, object);
                    continue;
                }
                throw new WrongAttributeTypeException("isSubDomainName", TYPE_NAME);
            }
            if (string.equalsIgnoreCase("useHostFile")) {
                if (object instanceof Boolean) {
                    boolean bl = (Boolean)object;
                    DNSClientUtils.validateIsRecursiveSearch(bl, setRequestContextImpl);
                    setRequestContextImpl.addParameter(froProxy, (Parameter)new SignedIntParameter("useHostFile", bl));
                    setRequestContextImpl.addAvcNotification(string, object);
                    continue;
                }
                throw new WrongAttributeTypeException("useHostFile", TYPE_NAME);
            }
            if (string.equalsIgnoreCase("dnsServerAddresses")) {
                if (object instanceof String[]) {
                    managedObject2 = (String[])object;
                    DNSClientUtils.validateDnsServerAddresses((String[])managedObject2, setRequestContextImpl);
                    arrayParameter = null;
                    if (managedObject2 != null) {
                        arrayParameter = new ArrayParameter("dnsServerAddresses");
                        StringParameter stringParameter = null;
                        for (int j = 0; j < ((ManagedObject)managedObject2).length; ++j) {
                            stringParameter = new StringParameter("dnsServerAddress", (String)managedObject2[j], 47);
                            arrayParameter.add((Parameter)stringParameter);
                        }
                    }
                    setRequestContextImpl.addParameter(froProxy, arrayParameter);
                    setRequestContextImpl.addAvcNotification(string, object);
                    continue;
                }
                throw new WrongAttributeTypeException("dnsServerAddresses", TYPE_NAME);
            }
            if (string.equalsIgnoreCase("dnsAutoConfigInterfaceRef")) {
                if (object == null || object instanceof ManagedObject) {
                    managedObject2 = (ManagedObject)object;
                    DNSClientUtils.validateDnsAutoConfInterface(managedObject2, setRequestContextImpl);
                    arrayParameter = ((IpMoImpl)managedObject).getDnsAutoConfigInterfaceRef(setRequestContextImpl.getCoordinator());
                    if (arrayParameter == managedObject2) continue;
                    if (arrayParameter instanceof Reservable) {
                        ((Reservable)arrayParameter).release(managedObject, setRequestContextImpl.getCoordinator());
                    }
                    if (managedObject2 instanceof Reservable) {
                        ((Reservable)managedObject2).reserve(managedObject, setRequestContextImpl.getCoordinator());
                    }
                    ((ReferenceAttribute)moData.getAttribute("dnsAutoConfigInterfaceRef")).setValue(managedObject2);
                    int n = 0;
                    if (managedObject2 != null) {
                        n = ((FroInfo)managedObject2).getFroId(coordinator);
                    }
                    setRequestContextImpl.addParameter(froProxy, (Parameter)new SignedIntParameter("dnsAutoConfigInterfaceRef", n));
                    continue;
                }
                throw new WrongAttributeTypeException("dnsAutoConfigInterfaceRef", TYPE_NAME);
            }
            throw new NoSuchAttributeException(string, TYPE_NAME);
        }
        setRequestContextImpl.sendSetRequest(froProxy, 1);
        setRequestContextImpl.sendAvcNotifications(managedObject);
    }
}

