/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ipoam;

import enea.ose.system.UnlinkedSignal;
import se.ericsson.cello.common.fropxy.MoEventable;
import se.ericsson.cello.equipment.PlugInUnitMo;
import se.ericsson.cello.faultmanagement.AlarmManager;
import se.ericsson.cello.ipoam.IpAtmLinkMo;
import se.ericsson.cello.ipoam.IpMo;
import se.ericsson.cello.ipoam.IpMoImpl;
import se.ericsson.cello.ipoam.IpRoutingTableMoImpl;
import se.ericsson.cello.ipoam.IpValidationUtil;
import se.ericsson.cello.ipoam.NetworkMask;
import se.ericsson.cello.ipoam.fropxy.OsaAtmLinkEventInd;
import se.ericsson.cello.ipoam.fropxy.OsaIpLinkCreateAtmInterfaceConf;
import se.ericsson.cello.ipoam.fropxy.OsaIpLinkDeleteAtmInterfaceConf;
import se.ericsson.cello.ipoam.fropxy.OsaIpLinkGetAttributeConf;
import se.ericsson.cello.ipoam.fropxy.OsaIpLinkMgmntProxy;
import se.ericsson.cello.ipoam.fropxy.OsaIpLinkSetAttributeConf;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.AvailConverter;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.InvalidReferenceException;
import se.ericsson.cello.mao.IpAddress;
import se.ericsson.cello.mao.IpException;
import se.ericsson.cello.mao.IpFormatException;
import se.ericsson.cello.mao.MaoFroTypeConverter;
import se.ericsson.cello.mao.MaxNumberExceededException;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.ProcessorInfo;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.ManagedObjectBase;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;

public class IpAtmLinkMoImpl
extends ManagedObjectBase
implements IpAtmLinkMo,
MoEventable,
Reservable {
    private ReferenceAttribute aal5TpVccTpId;
    private IntegerAttribute ipOverAtmFroId;
    private StringAttribute userLabel;
    private ReferenceAttribute reservedBy;
    private MoData data;
    private static final String RESERVED_BY_OSPF = "reservedByOspf";
    private static OsaIpLinkMgmntProxy proxy = OsaIpLinkMgmntProxy.getInstance();
    private static final int OK = 0;
    private static final String IP_ATM_LINK_FRO_ID = "IpOverAtmFroId";
    private static final int MTU_SIZE_MIN = 576;
    private static final int MTU_SIZE_MAX = 2040;
    private static final int MTU_SIZE_DEFAULT = 1500;
    private static final int METRIC_MIN = 1;
    private static final int METRIC_MAX = Short.MAX_VALUE;
    private static final int METRIC_DEFAULT = 1;
    private static final int MONITOR_INTERVAL_MIN = 1;
    private static final int MONITOR_INTERVAL_MAX = 60;
    private static final int MONITOR_INTERVAL_DEFAULT = 10;
    private static final int MONITOR_RETRIES_MIN = 1;
    private static final int MONITOR_RETRIES_MAX = 255;
    private static final int MONITOR_RETRIES_DEFAULT = 10;
    private static final int PIU_ROLE_MP = 1;
    private static final int NO_PREFERENCE = 0;
    private static final int LOCAL_MP_SELECT_VCC_AT_LINK_UP = 1;
    private static final int LOCAL_MP_PEER_SELECTION_VCC = 2;
    private static final int LOCAL_MP_ACTIVE_RESELECTION = 3;
    private static final int ONLY_LOCAL_MP = 4;
    private static final int OSA_ATMLINK_SUPERVISION_FAIL = 0;
    private static final int OSA_ATMLINK_SUPERVISION_RECOVER = 1;
    private static String[] aal5ClassName = new String[]{"se.ericsson.cello.atm.terminations.Aal5TpVccTpMoImpl"};
    private static final String MAX_NUMBER_OF_IP_ATMLINKS = "max_number_of_ip_atmlinks";
    private static final String[] reservedClasses = new String[]{"se.ericsson.cello.ipoam.OspfInterfaceMoImpl"};
    private static final int MO_DATA_REVISION_50 = 5000;
    private static final int MO_DATA_REVISION_LATEST = 5000;

    static IpAtmLinkMoImpl create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        IpAtmLinkMoImpl.checkParent(managedObject);
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"IpAtmLink", (String)string);
        if (((IpMo)managedObject).checkAtmLinks(coordinator)) {
            IpAddress ipAddress = IpAtmLinkMoImpl.checkAndGetAddressAttribute("ipAddress", attrList);
            int n = ipAddress.toInt();
            IpAddress ipAddress2 = IpAtmLinkMoImpl.checkAndGetAddressAttribute("subnetMask", attrList);
            int n2 = NetworkMask.calculateIpV4Prefix(ipAddress2.toString());
            int n3 = ipAddress2.toInt();
            IpAtmLinkMoImpl.checkSubnetMask(n3);
            IpValidationUtil.checkIpAdressUniqueness(managedObject, ipAddress.toString(), n2, null, "IpAtmLink", coordinator);
            int n4 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"mtuSize", (AttrList)attrList, (boolean)false, (int)1500, (int)576, (int)2040, (String)"IpAtmLink");
            int n5 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"metric", (AttrList)attrList, (boolean)false, (int)1, (int)1, (int)Short.MAX_VALUE, (String)"IpAtmLink");
            boolean bl = MoAttributeValidator.checkAndGetBooleanAttribute((String)"monitor", (AttrList)attrList, (boolean)false, (boolean)false, (String)"IpAtmLink");
            int n6 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"monitorInterval", (AttrList)attrList, (boolean)false, (int)10, (int)1, (int)60, (String)"IpAtmLink");
            int n7 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"monitorRetries", (AttrList)attrList, (boolean)false, (int)10, (int)1, (int)255, (String)"IpAtmLink");
            String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"IpAtmLink", (int)128, (int)0);
            ManagedObject managedObject3 = MoAttributeValidator.checkAndGetReferenceAttribute((String)"aal5TpVccTpId", (AttrList)attrList, (boolean)true, (String[])aal5ClassName, (String)"IpAtmLink");
            IpAtmLinkMoImpl.checkAal5TpVccTpId(coordinator, managedObject3);
            MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"IpAtmLink");
            MoRepository moRepository = MoRepository.instance();
            MoIterator moIterator = moRepository.lookupType("IpRoutingTable");
            int n8 = 0;
            if (!moIterator.hasMoreElements()) {
                throw new IpException("IpAtmLink: can not find IpRoutingTable Mo");
            }
            n8 = ((IpRoutingTableMoImpl)moIterator.nextElement()).getFroId(coordinator);
            return new IpAtmLinkMoImpl((IpMo)managedObject, n, n3, n4, n5, bl, n6, n7, string2, string, n8, managedObject3, coordinator);
        }
        throw new MaxNumberExceededException(MAX_NUMBER_OF_IP_ATMLINKS, "IpAtmLink");
    }

    private IpAtmLinkMoImpl(IpMo ipMo, int n, int n2, int n3, int n4, boolean bl, int n5, int n6, String string, String string2, int n7, ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        super((ManagedObject)ipMo, "IpAtmLink", string2, coordinator);
        this.data = new MoData(this.getLocalDistinguishedName(), "IpAtmLink", true, coordinator);
        this.data.setRevision(5000);
        this.reservedBy = new ReferenceAttribute(RESERVED_BY_OSPF, false);
        this.reservedBy.setValue(null);
        this.data.registerPersistentAttr((Attribute)this.reservedBy);
        this.userLabel = new StringAttribute("userLabel", true, string);
        this.data.registerPersistentAttr((Attribute)this.userLabel);
        int n8 = ((IpMoImpl)ipMo).getIpFroId(coordinator);
        int n9 = this.createIpOverAtmFro(coordinator, n, n2, n3, n4, bl, n5, n6, n8, n7, managedObject);
        this.ipOverAtmFroId = new IntegerAttribute(IP_ATM_LINK_FRO_ID, false, n9);
        this.data.registerPersistentAttr((Attribute)this.ipOverAtmFroId);
        ((Reservable)managedObject).reserve((ManagedObject)this, coordinator);
        this.aal5TpVccTpId = new ReferenceAttribute("aal5TpVccTpId", false, managedObject);
        this.data.registerPersistentAttr((Attribute)this.aal5TpVccTpId);
        proxy.registerForNotifications(coordinator, this, this.ipOverAtmFroId.getValue(coordinator));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public IpAtmLinkMoImpl(MoData moData) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(5000);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute(IP_ATM_LINK_FRO_ID);
        moDataRecoveryHelper.assertAttribute("aal5TpVccTpId");
        moDataRecoveryHelper.assertAttribute(RESERVED_BY_OSPF);
        this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
        this.ipOverAtmFroId = (IntegerAttribute)moData.getAttribute(IP_ATM_LINK_FRO_ID);
        this.aal5TpVccTpId = (ReferenceAttribute)moData.getAttribute("aal5TpVccTpId");
        this.reservedBy = (ReferenceAttribute)moData.getAttribute(RESERVED_BY_OSPF);
        proxy.registerForNotifications(null, this, this.ipOverAtmFroId.getValue(null));
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (this.reservedBy.getValue(coordinator) != null) {
            throw new MoReservedNotDeletableException("IpAtmLink");
        }
        ((Reservable)this.aal5TpVccTpId.getValue(coordinator)).release((ManagedObject)this, coordinator);
        OsaIpLinkDeleteAtmInterfaceConf osaIpLinkDeleteAtmInterfaceConf = proxy.sendIpLinkDeleteReq(coordinator.getTransactionID(), this.ipOverAtmFroId.getValue(coordinator));
        if (osaIpLinkDeleteAtmInterfaceConf == null) {
            throw new FroNotAccessibleException("IpAtmLink", "IP Over Atm Fro");
        }
        if (osaIpLinkDeleteAtmInterfaceConf.getResult() != 1) {
            throw new FroRequestFailedException("IpAtmLink", "IpAtmLink", "DeleteFroReq: " + proxy.getResultMsg(osaIpLinkDeleteAtmInterfaceConf.getResult()), osaIpLinkDeleteAtmInterfaceConf.getResult());
        }
        proxy.deregisterForNotifications(coordinator, this.ipOverAtmFroId.getValue(coordinator));
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    private int createIpOverAtmFro(Coordinator coordinator, int n, int n2, int n3, int n4, boolean bl, int n5, int n6, int n7, int n8, ManagedObject managedObject) throws MoAccessException {
        int n9 = ((FroInfo)managedObject).getFroId(coordinator);
        OsaIpLinkCreateAtmInterfaceConf osaIpLinkCreateAtmInterfaceConf = proxy.sendOsaAtmLinkCreateReq(coordinator, n, n2, n3, n4, this.localBoolean2int(bl), n5, n6, n7, n8, n9);
        if (osaIpLinkCreateAtmInterfaceConf == null) {
            throw new FroNotAccessibleException("IpAtmLink", "Ip Over Atm Fro");
        }
        if (osaIpLinkCreateAtmInterfaceConf.getResult() != 1) {
            throw new FroRequestFailedException("IpAtmLink", "IpAtmLink", "CreateFroReq: " + proxy.getResultMsg(osaIpLinkCreateAtmInterfaceConf.getResult()), osaIpLinkCreateAtmInterfaceConf.getResult());
        }
        return osaIpLinkCreateAtmInterfaceConf.getFroId();
    }

    public ManagedObject getReservedBy(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.reservedBy.getValue(coordinator);
    }

    public String getType() {
        return "IpAtmLink";
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"IpAtmLink", (int)128, (int)0);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public int getIpOverAtmFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.ipOverAtmFroId.getValue(coordinator);
    }

    public int getIpFroId(Coordinator coordinator) throws MoAccessException {
        return ((IpMoImpl)this.getParent()).getIpFroId(coordinator);
    }

    public String getIdentity(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.getNamingAttributeValue();
    }

    public ManagedObject getAal5TpVccTpId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.aal5TpVccTpId.getValue(coordinator);
    }

    public String getIpAddress(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        int n = this.getIpLinkAttributes(0, coordinator).getIpAddress();
        return new IpAddress((long)n).toString();
    }

    public String getSubnetMask(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        int n = this.getIpLinkAttributes(1, coordinator).getSubnetMask();
        return new IpAddress((long)n).toString();
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.reservedBy = ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (String)"IpAtmLink", (MoData)this.data, (ReferenceAttribute)this.reservedBy, (String[])reservedClasses);
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.reservedBy = ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (String)"IpAtmLink", (MoData)this.data, (ReferenceAttribute)this.reservedBy, (String[])reservedClasses);
    }

    public void actionAssignIpAddress(String string, String string2, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        long l = MaoFroTypeConverter.ipAddrString2Long((String)string);
        if (l >= MaoFroTypeConverter.ipAddrString2Long((String)"224.0.0.0") && l <= MaoFroTypeConverter.ipAddrString2Long((String)"239.255.255.255")) {
            throw new ValueOutOfRangeException("Ip Addresses 224.0.0.0 to 239.255.255.255 are reserved", "IpAtmLink");
        }
        if (string.equals("0.0.0.0") || string.equals("255.255.255.255")) {
            throw new ValueOutOfRangeException("IP Address is not valid .", "IpAtmLink");
        }
        if (string2.equals("255.255.255.254") || string2.equals("255.255.255.255") || string2.equals("0.0.0.0")) {
            throw new ValueOutOfRangeException("SubNet Mask is not valid .", "IpAtmLink");
        }
        IpValidationUtil.checkIpAdressUniqueness(this.getParent(), string, NetworkMask.calculateIpV4Prefix(string2), this, "IpAtmLink", coordinator);
        int[] nArray = new int[]{0, new IpAddress(string).toInt(), 1, new IpAddress(string2).toInt()};
        IpAtmLinkMoImpl.checkSubnetMask(nArray[3]);
        this.setIpLinkAttributes(nArray, coordinator);
        String[] stringArray = new String[]{"ipAddress"};
        Object[] objectArray = new Object[]{string};
        IpAtmLinkMoImpl.sendChangeNotification(this, stringArray, objectArray, coordinator);
        String[] stringArray2 = new String[]{"subnetMask"};
        Object[] objectArray2 = new Object[]{string2};
        IpAtmLinkMoImpl.sendChangeNotification(this, stringArray2, objectArray2, coordinator);
    }

    public int getMetric(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.getIpLinkAttributes(3, coordinator).getMetric();
    }

    public void setMetric(int n, Coordinator coordinator) throws MoAccessException, ValueOutOfRangeException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        int[] nArray = new int[2];
        if (n < 1 || n > Short.MAX_VALUE) {
            throw new ValueOutOfRangeException("metric", "IpAtmLink");
        }
        nArray[0] = 3;
        nArray[1] = n;
        this.setIpLinkAttributes(nArray, coordinator);
        String[] stringArray = new String[]{"metric"};
        Object[] objectArray = new Object[]{new Integer(n)};
        IpAtmLinkMoImpl.sendChangeNotification(this, stringArray, objectArray, coordinator);
    }

    public boolean getMonitor(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        int n = this.getIpLinkAttributes(16, coordinator).getMonitor();
        return MaoFroTypeConverter.int2boolean((int)n);
    }

    public void setMonitor(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        int[] nArray = new int[]{16, this.localBoolean2int(bl)};
        this.setIpLinkAttributes(nArray, coordinator);
        String[] stringArray = new String[]{"monitor"};
        Object[] objectArray = new Object[]{bl};
        IpAtmLinkMoImpl.sendChangeNotification(this, stringArray, objectArray, coordinator);
    }

    public int getMonitorInterval(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.getIpLinkAttributes(17, coordinator).getMonitorInterval();
    }

    public void setMonitorInterval(int n, Coordinator coordinator) throws MoAccessException, ValueOutOfRangeException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        int[] nArray = new int[2];
        if (n < 1 || n > 60) {
            throw new ValueOutOfRangeException("monitorInterval", "IpAtmLink");
        }
        nArray[0] = 17;
        nArray[1] = n;
        this.setIpLinkAttributes(nArray, coordinator);
        String[] stringArray = new String[]{"monitorInterval"};
        Object[] objectArray = new Object[]{new Integer(n)};
        IpAtmLinkMoImpl.sendChangeNotification(this, stringArray, objectArray, coordinator);
    }

    public int getMonitorRetries(Coordinator coordinator) throws MoAccessException {
        return this.getIpLinkAttributes(18, coordinator).getMonitorRetries();
    }

    public void setMonitorRetries(int n, Coordinator coordinator) throws MoAccessException, ValueOutOfRangeException {
        int[] nArray = new int[2];
        if (n < 1 || n > 255) {
            throw new ValueOutOfRangeException("monitorRetries", "IpAtmLink");
        }
        nArray[0] = 18;
        nArray[1] = n;
        this.setIpLinkAttributes(nArray, coordinator);
        String[] stringArray = new String[]{"monitorRetries"};
        Object[] objectArray = new Object[]{new Integer(n)};
        IpAtmLinkMoImpl.sendChangeNotification(this, stringArray, objectArray, coordinator);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        return this.getIpLinkAttributes(4, coordinator).getOperationalState();
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        return AvailConverter.convert((int)this.getIpLinkAttributes(9, coordinator).getAvailabilityStatus());
    }

    public int getMtuSize(Coordinator coordinator) throws MoAccessException {
        return this.getIpLinkAttributes(2, coordinator).getMtuSize();
    }

    public void setMtuSize(int n, Coordinator coordinator) throws MoAccessException, ValueOutOfRangeException {
        if (n < 576 || n > 2040) {
            throw new ValueOutOfRangeException("mtuSize", "IpAtmLink");
        }
        int[] nArray = new int[]{2, n};
        this.setIpLinkAttributes(nArray, coordinator);
        String[] stringArray = new String[]{"mtuSize"};
        Object[] objectArray = new Object[]{new Integer(n)};
        IpAtmLinkMoImpl.sendChangeNotification(this, stringArray, objectArray, coordinator);
    }

    public String getInterfaceName(Coordinator coordinator) throws MoAccessException {
        int n = 5;
        return this.getIpLinkAttributes(n, coordinator).getInterfaceName();
    }

    public int getPmNoOfIfInUcastPkts(Coordinator coordinator) throws MoAccessException {
        int n = 10;
        return this.getIpLinkAttributes(n, coordinator).getPmNoOfIfInUcastPkts();
    }

    public int getPmNoOfIfInNUcastPkts(Coordinator coordinator) throws MoAccessException {
        int n = 11;
        return this.getIpLinkAttributes(n, coordinator).getPmNoOfIfInNUcastPkts();
    }

    public int getPmNoOfIfOutUcastPkts(Coordinator coordinator) throws MoAccessException {
        int n = 12;
        return this.getIpLinkAttributes(n, coordinator).getPmNoOfIfOutUcastPkts();
    }

    public int getPmNoOfIfOutNUcastPkts(Coordinator coordinator) throws MoAccessException {
        int n = 13;
        return this.getIpLinkAttributes(n, coordinator).getPmNoOfIfOutNUcastPkts();
    }

    public int getPmNoOfIfInErrors(Coordinator coordinator) throws MoAccessException {
        int n = 14;
        return this.getIpLinkAttributes(n, coordinator).getPmNoOfIfInErrors();
    }

    public int getPmNoOfIfInDiscards(Coordinator coordinator) throws MoAccessException {
        int n = 15;
        return this.getIpLinkAttributes(n, coordinator).getPmNoOfIfInDiscards();
    }

    public int getPmNoOfIfOutDiscards(Coordinator coordinator) throws MoAccessException {
        int n = 19;
        return this.getIpLinkAttributes(n, coordinator).getPmNoOfIfOutDiscards();
    }

    public synchronized void eventRaised(UnlinkedSignal unlinkedSignal, String string) {
        int n = ((OsaAtmLinkEventInd)unlinkedSignal).getSpecificEvent();
        if (n == 0) {
            AlarmManager.getReporter().reportEvent(13, (ManagedObject)this, "", "", null);
        } else if (n == 1) {
            AlarmManager.getReporter().reportEvent(14, (ManagedObject)this, "", "", null);
        } else {
            MessageLog.traceError(this.getClass(), (String)("Unknown event received " + n));
            return;
        }
    }

    private int setIpLinkAttributes(int[] nArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        int n = nArray.length + 1;
        int[] nArray2 = new int[n];
        for (int i = 0; i < n - 1; ++i) {
            nArray2[i] = nArray[i];
        }
        nArray2[n - 1] = -1;
        OsaIpLinkSetAttributeConf osaIpLinkSetAttributeConf = proxy.sendIpLinkSetAttributeReq(coordinator.getTransactionID(), this.getIpOverAtmFroId(coordinator), nArray2);
        if (osaIpLinkSetAttributeConf == null) {
            throw new FroNotAccessibleException("IpAtmLink", "Ip Over Atm Fro");
        }
        if (osaIpLinkSetAttributeConf.getResult() != 1) {
            throw new FroRequestFailedException("IpAtmLink", "IpAtmLink", "SetAttrReq: " + proxy.getResultMsg(osaIpLinkSetAttributeConf.getResult()), osaIpLinkSetAttributeConf.getResult());
        }
        return 0;
    }

    private OsaIpLinkGetAttributeConf getIpLinkAttributes(int n, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        int[] nArray = new int[]{n, -1};
        OsaIpLinkGetAttributeConf osaIpLinkGetAttributeConf = proxy.sendIpLinkGetAttributeReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), this.getIpOverAtmFroId(coordinator), nArray);
        if (osaIpLinkGetAttributeConf == null) {
            throw new FroNotAccessibleException("IpAtmLink", "IpAtmLink Fro");
        }
        if (osaIpLinkGetAttributeConf.getResult() == 100) {
            osaIpLinkGetAttributeConf.setPmCountersUnavailable();
        } else if (osaIpLinkGetAttributeConf.getResult() != 1) {
            throw new FroRequestFailedException("IpAtmLink", "IpAtmLink", "GetAttrReq: " + proxy.getResultMsg(osaIpLinkGetAttributeConf.getResult()), osaIpLinkGetAttributeConf.getResult());
        }
        return osaIpLinkGetAttributeConf;
    }

    private static void checkAal5TpVccTpId(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        ManagedObject managedObject2 = ((ProcessorInfo)managedObject).getProcessorId(coordinator);
        if (managedObject2 == null) {
            return;
        }
        if (managedObject2 != null && managedObject2.getType().equals("PlugInUnit")) {
            if (((PlugInUnitMo)managedObject2).getRole(coordinator) != 1) {
                throw new InvalidReferenceException("IpAtmLink", (Object)managedObject);
            }
        } else {
            throw new InvalidReferenceException("IpAtmLink", (Object)managedObject);
        }
    }

    private static IpAddress checkAndGetAddressAttribute(String string, AttrList attrList) throws NotHandledAttributeTypeException, AttrMissingAtCreateException, WrongAttributeTypeException, MoNotFoundException, FroNotAccessibleException, FroRequestFailedException, IpFormatException {
        int n = attrList.indexOf(string);
        if (n == -1) {
            throw new AttrMissingAtCreateException(string, "IpAtmLink");
        }
        if (!(attrList.getValue(n) instanceof String)) {
            throw new WrongAttributeTypeException(string, "IpAtmLink");
        }
        String string2 = (String)attrList.getValue(n);
        attrList.removeElementAt(n);
        return new IpAddress(string2);
    }

    private int localBoolean2int(boolean bl) {
        return bl ? 1 : 2;
    }

    private static void checkSubnetMask(int n) throws IpFormatException {
        if (n == 0) {
            return;
        }
        int n2 = 0;
        long l = n < 0 ? 0x100000000L + (long)n : (long)n;
        while ((l & 1L) == 0L) {
            l >>>= 1;
            ++n2;
        }
        if (0xFFFFFFFFL >>> n2 != l) {
            throw new IpFormatException("Wrong subnet mask for IpAtmLink");
        }
    }

    private static void checkParent(ManagedObject managedObject) throws IllegalParentException {
        if (!(managedObject instanceof IpMo)) {
            throw new IllegalParentException("IpAtmLinkcheck parent!");
        }
    }

    private static void sendChangeNotification(ManagedObject managedObject, String[] stringArray, Object[] objectArray, Coordinator coordinator) {
        NotificationSender notificationSender = NotificationSender.instance();
        notificationSender.pushAVC(managedObject, stringArray, objectArray, coordinator);
    }
}

