/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.crypto.asn1;

import com.maverick.crypto.asn1.ASN1OctetString;
import com.maverick.crypto.asn1.ASN1TaggedObject;
import com.maverick.crypto.asn1.DERObject;
import com.maverick.crypto.asn1.DEROutputStream;
import com.maverick.crypto.asn1.DERString;
import java.io.IOException;

public class DERT61String
extends DERObject
implements DERString {
    String ib;

    public static DERT61String getInstance(Object object) {
        if (object == null || object instanceof DERT61String) {
            return (DERT61String)object;
        }
        if (object instanceof ASN1OctetString) {
            return new DERT61String(((ASN1OctetString)object).getOctets());
        }
        if (object instanceof ASN1TaggedObject) {
            return DERT61String.getInstance(((ASN1TaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERT61String getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DERT61String.getInstance(aSN1TaggedObject.getObject());
    }

    public DERT61String(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        for (int k = 0; k != cArray.length; ++k) {
            cArray[k] = (char)(byArray[k] & 0xFF);
        }
        this.ib = new String(cArray);
    }

    public DERT61String(String string) {
        this.ib = string;
    }

    public String getString() {
        return this.ib;
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.b(20, this.getOctets());
    }

    public byte[] getOctets() {
        char[] cArray = this.ib.toCharArray();
        byte[] byArray = new byte[cArray.length];
        for (int k = 0; k != cArray.length; ++k) {
            byArray[k] = (byte)cArray[k];
        }
        return byArray;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DERT61String)) {
            return false;
        }
        return this.getString().equals(((DERT61String)object).getString());
    }
}

