/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.crypto.asn1.x509;

import com.maverick.crypto.asn1.ASN1TaggedObject;
import com.maverick.crypto.asn1.DEREncodable;
import com.maverick.crypto.asn1.DERGeneralizedTime;
import com.maverick.crypto.asn1.DERObject;
import com.maverick.crypto.asn1.DERUTCTime;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;

public class Time
implements DEREncodable {
    DERObject t;

    public static Time getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return Time.getInstance(aSN1TaggedObject.getObject());
    }

    public Time(DERObject dERObject) {
        if (!(dERObject instanceof DERUTCTime) && !(dERObject instanceof DERGeneralizedTime)) {
            throw new IllegalArgumentException("unknown object passed to Time");
        }
        this.t = dERObject;
    }

    public Time(Date date) {
        SimpleTimeZone simpleTimeZone = new SimpleTimeZone(0, "Z");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        simpleDateFormat.setTimeZone(simpleTimeZone);
        String string = simpleDateFormat.format(date) + "Z";
        int n = Integer.parseInt(string.substring(0, 4));
        this.t = n < 1950 || n > 2049 ? new DERGeneralizedTime(string) : new DERUTCTime(string.substring(2));
    }

    public static Time getInstance(Object object) {
        if (object instanceof Time) {
            return (Time)object;
        }
        if (object instanceof DERUTCTime) {
            return new Time((DERUTCTime)object);
        }
        if (object instanceof DERGeneralizedTime) {
            return new Time((DERGeneralizedTime)object);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public String getTime() {
        if (this.t instanceof DERUTCTime) {
            return ((DERUTCTime)this.t).getAdjustedTime();
        }
        return ((DERGeneralizedTime)this.t).getTime();
    }

    public Date getDate() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmssz");
        return simpleDateFormat.parse(this.getTime(), new ParsePosition(0));
    }

    public DERObject getDERObject() {
        return this.t;
    }
}

