/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh;

import com.maverick.ssh.Packet;
import com.maverick.ssh.SshChannel;
import com.maverick.ssh.SshException;
import com.maverick.ssh.SshIOException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Vector;

public class SubsystemChannel {
    DataInputStream c;
    DataOutputStream d;
    Vector f = new Vector();
    int g = Integer.parseInt(System.getProperty("maverick.sftp.maxPacketSize", "1024000"));
    protected SshChannel channel;
    _c b = new _c();
    _b e = new _b();

    public SubsystemChannel(SshChannel sshChannel) throws SshException {
        this.channel = sshChannel;
        try {
            this.c = new DataInputStream(sshChannel.getInputStream());
            this.d = new DataOutputStream(sshChannel.getOutputStream());
        }
        catch (SshIOException sshIOException) {
            throw sshIOException.getRealException();
        }
        catch (IOException iOException) {
            throw new SshException(iOException.getMessage(), 6);
        }
    }

    public boolean isClosed() {
        return this.channel.isClosed();
    }

    public void close() throws IOException {
        this.f.removeAllElements();
        this.channel.close();
    }

    public byte[] nextMessage() throws SshException {
        return this.b.b(this.c);
    }

    protected void sendMessage(Packet packet) throws SshException {
        this.e.b(packet);
    }

    protected void sendMessage(byte[] byArray) throws SshException {
        try {
            Packet packet = this.createPacket();
            packet.write(byArray);
            this.sendMessage(packet);
        }
        catch (IOException iOException) {
            throw new SshException(1, (Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Packet createPacket() throws IOException {
        Vector vector = this.f;
        synchronized (vector) {
            if (this.f.size() == 0) {
                return new Packet();
            }
            Packet packet = (Packet)this.f.elementAt(0);
            this.f.removeElementAt(0);
            return packet;
        }
    }

    class _c {
        _c() {
        }

        synchronized byte[] b(DataInputStream dataInputStream) throws SshException {
            int n = -1;
            try {
                n = dataInputStream.readInt();
                if (n < 0) {
                    throw new SshException("Negative message length in SFTP protocol.", 3);
                }
                if (n > SubsystemChannel.this.g) {
                    throw new SshException("Invalid message length in SFTP protocol [" + n + "]", 3);
                }
                byte[] byArray = new byte[n];
                dataInputStream.readFully(byArray);
                return byArray;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw new SshException("Invalid message length in SFTP protocol [" + n + "]", 3);
            }
            catch (EOFException eOFException) {
                try {
                    SubsystemChannel.this.close();
                }
                catch (SshIOException sshIOException) {
                    throw sshIOException.getRealException();
                }
                catch (IOException iOException) {
                    throw new SshException(iOException.getMessage(), 6);
                }
                throw new SshException("The channel unexpectedly terminated", 6);
            }
            catch (IOException iOException) {
                if (iOException instanceof SshIOException) {
                    throw ((SshIOException)iOException).getRealException();
                }
                try {
                    SubsystemChannel.this.close();
                }
                catch (SshIOException sshIOException) {
                    throw sshIOException.getRealException();
                }
                catch (IOException iOException2) {
                    throw new SshException(iOException2.getMessage(), 6);
                }
                throw new SshException(6, (Throwable)iOException);
            }
        }
    }

    class _b {
        _b() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void b(Packet packet) throws SshException {
            try {
                packet.finish();
                SubsystemChannel.this.d.write(packet.array(), 0, packet.size());
            }
            catch (SshIOException sshIOException) {
                throw sshIOException.getRealException();
            }
            catch (EOFException eOFException) {
                try {
                    SubsystemChannel.this.close();
                }
                catch (SshIOException sshIOException) {
                    throw sshIOException.getRealException();
                }
                catch (IOException iOException) {
                    throw new SshException(iOException.getMessage(), 6);
                }
                throw new SshException("The channel unexpectedly terminated", 6);
            }
            catch (IOException iOException) {
                try {
                    SubsystemChannel.this.close();
                }
                catch (SshIOException sshIOException) {
                    throw sshIOException.getRealException();
                }
                catch (IOException iOException2) {
                    throw new SshException(iOException2.getMessage(), 6);
                }
                throw new SshException("Unknown channel IO failure: " + iOException.getMessage(), 6);
            }
            finally {
                packet.reset();
                Vector vector = SubsystemChannel.this.f;
                synchronized (vector) {
                    SubsystemChannel.this.f.addElement(packet);
                }
            }
        }
    }
}

