/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh.components.jce;

import com.maverick.ssh.SshException;
import com.maverick.ssh.SshKeyFingerprint;
import com.maverick.ssh.components.SshDsaPublicKey;
import com.maverick.ssh.components.SshPublicKey;
import com.maverick.ssh.components.jce.JCEProvider;
import com.maverick.util.ByteArrayReader;
import com.maverick.util.ByteArrayWriter;
import com.maverick.util.SimpleASNWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;

public class Ssh2DsaPublicKey
implements SshDsaPublicKey {
    protected DSAPublicKey pubkey;

    public Ssh2DsaPublicKey() {
    }

    public Ssh2DsaPublicKey(DSAPublicKey dSAPublicKey) {
        this.pubkey = dSAPublicKey;
    }

    public Ssh2DsaPublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = JCEProvider.getProviderForAlgorithm("DSA") == null ? KeyFactory.getInstance("DSA") : KeyFactory.getInstance("DSA", JCEProvider.getProviderForAlgorithm("DSA"));
        DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(bigInteger4, bigInteger, bigInteger2, bigInteger3);
        this.pubkey = (DSAPublicKey)keyFactory.generatePublic(dSAPublicKeySpec);
    }

    public String getAlgorithm() {
        return "ssh-dss";
    }

    public int getBitLength() {
        return this.pubkey.getParams().getP().bitLength();
    }

    public byte[] getEncoded() throws SshException {
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeString(this.getAlgorithm());
            byteArrayWriter.writeBigInteger(this.pubkey.getParams().getP());
            byteArrayWriter.writeBigInteger(this.pubkey.getParams().getQ());
            byteArrayWriter.writeBigInteger(this.pubkey.getParams().getG());
            byteArrayWriter.writeBigInteger(this.pubkey.getY());
            return byteArrayWriter.toByteArray();
        }
        catch (IOException iOException) {
            throw new SshException("Failed to encoded DSA key", 5, iOException);
        }
    }

    public String getFingerprint() throws SshException {
        return SshKeyFingerprint.getFingerprint(this.getEncoded());
    }

    public void init(byte[] byArray, int n, int n2) throws SshException {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray, n, n2);
            String string = byteArrayReader.readString();
            if (!string.equals(this.getAlgorithm())) {
                throw new SshException("The encoded key is not DSA", 5);
            }
            BigInteger bigInteger = byteArrayReader.readBigInteger();
            BigInteger bigInteger2 = byteArrayReader.readBigInteger();
            BigInteger bigInteger3 = byteArrayReader.readBigInteger();
            BigInteger bigInteger4 = byteArrayReader.readBigInteger();
            DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(bigInteger4, bigInteger, bigInteger2, bigInteger3);
            KeyFactory keyFactory = JCEProvider.getProviderForAlgorithm("DSA") == null ? KeyFactory.getInstance("DSA") : KeyFactory.getInstance("DSA", JCEProvider.getProviderForAlgorithm("DSA"));
            this.pubkey = (DSAPublicKey)keyFactory.generatePublic(dSAPublicKeySpec);
        }
        catch (Exception exception) {
            throw new SshException("Failed to obtain DSA key instance from JCE", 5, exception);
        }
    }

    public boolean verifySignature(byte[] byArray, byte[] byArray2) throws SshException {
        try {
            Object object;
            Object object2;
            Closeable closeable;
            if (byArray.length != 40) {
                closeable = new ByteArrayReader(byArray);
                object2 = ((ByteArrayReader)closeable).readBinaryString();
                object = new String((byte[])object2);
                if (!((String)object).equals("ssh-dss")) {
                    throw new SshException("The encoded signature is not DSA", 5);
                }
                byArray = ((ByteArrayReader)closeable).readBinaryString();
            }
            closeable = new ByteArrayOutputStream();
            object2 = new ByteArrayOutputStream();
            object = new SimpleASNWriter();
            ((SimpleASNWriter)object).writeByte(2);
            if ((byArray[0] & 0x80) == 128 && byArray[0] != 0) {
                ((ByteArrayOutputStream)closeable).write(0);
                ((ByteArrayOutputStream)closeable).write(byArray, 0, 20);
            } else {
                ((ByteArrayOutputStream)closeable).write(byArray, 0, 20);
            }
            ((SimpleASNWriter)object).writeData(((ByteArrayOutputStream)closeable).toByteArray());
            ((SimpleASNWriter)object).writeByte(2);
            if ((byArray[20] & 0x80) == 128 && byArray[20] != 0) {
                object2.write(0);
                object2.write(byArray, 20, 20);
            } else {
                object2.write(byArray, 20, 20);
            }
            ((SimpleASNWriter)object).writeData(object2.toByteArray());
            SimpleASNWriter simpleASNWriter = new SimpleASNWriter();
            simpleASNWriter.writeByte(48);
            simpleASNWriter.writeData(((SimpleASNWriter)object).toByteArray());
            byte[] byArray3 = simpleASNWriter.toByteArray();
            Signature signature = JCEProvider.getProviderForAlgorithm("SHA1WithDSA") == null ? Signature.getInstance("SHA1WithDSA") : Signature.getInstance("SHA1WithDSA", JCEProvider.getProviderForAlgorithm("SHA1WithDSA"));
            signature.initVerify(this.pubkey);
            signature.update(byArray2);
            return signature.verify(byArray3);
        }
        catch (Exception exception) {
            throw new SshException(16, (Throwable)exception);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof SshDsaPublicKey) {
            try {
                return ((SshPublicKey)object).getFingerprint().equals(this.getFingerprint());
            }
            catch (SshException sshException) {
                // empty catch block
            }
        }
        return false;
    }

    public int hashCode() {
        try {
            return this.getFingerprint().hashCode();
        }
        catch (SshException sshException) {
            return 0;
        }
    }

    public BigInteger getG() {
        return this.pubkey.getParams().getG();
    }

    public BigInteger getP() {
        return this.pubkey.getParams().getP();
    }

    public BigInteger getQ() {
        return this.pubkey.getParams().getQ();
    }

    public BigInteger getY() {
        return this.pubkey.getY();
    }
}

