/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh.components.standalone;

import com.maverick.crypto.security.SecureRandom;
import com.maverick.ssh.SshException;
import com.maverick.ssh.components.ComponentManager;
import com.maverick.ssh.components.Digest;
import com.maverick.ssh.components.SshKeyExchangeClient;
import com.maverick.util.ByteArrayReader;
import com.maverick.util.ByteArrayWriter;
import java.io.IOException;
import java.math.BigInteger;

public class DiffieHellmanGroupExchangeSha1
extends SshKeyExchangeClient {
    public static final String DIFFIE_HELLMAN_GROUP_EXCHANGE_SHA1 = "diffie-hellman-group-exchange-sha1";
    BigInteger vc;
    BigInteger tc;
    static BigInteger sc = BigInteger.valueOf(1L);
    BigInteger xc = null;
    BigInteger wc = null;
    BigInteger ad = null;
    BigInteger zc = null;
    String rc;
    String uc;
    byte[] yc;
    byte[] bd;

    public DiffieHellmanGroupExchangeSha1() {
        super("SHA-1");
    }

    public boolean isKeyExchangeMessage(int n) {
        switch (n) {
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                return true;
            }
        }
        return false;
    }

    public String getAlgorithm() {
        return DIFFIE_HELLMAN_GROUP_EXCHANGE_SHA1;
    }

    public void performClientExchange(String string, String string2, byte[] byArray, byte[] byArray2) throws SshException {
        try {
            this.rc = string;
            this.uc = string2;
            this.yc = byArray;
            this.bd = byArray2;
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.write(30);
            byteArrayWriter.writeInt(1024);
            this.transport.sendMessage(byteArrayWriter.toByteArray(), true);
            byte[] byArray3 = this.transport.nextMessage();
            if (byArray3[0] != 31) {
                this.transport.disconnect(3, "Expected SSH_MSG_KEX_GEX_GROUP");
                throw new SshException("Key exchange failed: Expected SSH_MSG_KEX_GEX_GROUP [id=" + byArray3[0] + "]", 5);
            }
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray3, 1, byArray3.length - 1);
            this.tc = byteArrayReader.readBigInteger();
            this.vc = byteArrayReader.readBigInteger();
            BigInteger bigInteger = this.tc.subtract(sc).divide(BigInteger.valueOf(2L));
            do {
                this.ad = new BigInteger(this.tc.bitLength(), SecureRandom.getInstance());
            } while (this.ad.compareTo(sc) < 0 || this.ad.compareTo(bigInteger) > 0);
            this.xc = this.vc.modPow(this.ad, this.tc);
            if (this.xc.compareTo(sc) < 0 || this.xc.compareTo(this.tc.subtract(sc)) > 0) {
                this.transport.disconnect(3, "Failed to generate key exchange value");
                throw new SshException("Key exchange failed to generate e value", 5);
            }
            byteArrayWriter.reset();
            byteArrayWriter.write(32);
            byteArrayWriter.writeBigInteger(this.xc);
            this.transport.sendMessage(byteArrayWriter.toByteArray(), true);
            byArray3 = this.transport.nextMessage();
            if (byArray3[0] != 33) {
                this.transport.disconnect(3, "Expected SSH_MSG_KEXDH_GEX_REPLY");
                throw new SshException("Key exchange failed: Expected SSH_MSG_KEXDH_GEX_REPLY [id=" + byArray3[0] + "]", 5);
            }
            byteArrayReader = new ByteArrayReader(byArray3, 1, byArray3.length - 1);
            this.hostKey = byteArrayReader.readBinaryString();
            this.wc = byteArrayReader.readBigInteger();
            this.signature = byteArrayReader.readBinaryString();
            this.secret = this.wc.modPow(this.ad, this.tc);
            this.calculateExchangeHash();
        }
        catch (IOException iOException) {
            throw new SshException(iOException, 5);
        }
    }

    protected void calculateExchangeHash() throws SshException {
        Digest digest = (Digest)ComponentManager.getInstance().supportedDigests().getInstance("SHA-1");
        digest.putString(this.rc);
        digest.putString(this.uc);
        digest.putInt(this.yc.length);
        digest.putBytes(this.yc);
        digest.putInt(this.bd.length);
        digest.putBytes(this.bd);
        digest.putInt(this.hostKey.length);
        digest.putBytes(this.hostKey);
        digest.putInt(1024);
        digest.putBigInteger(this.tc);
        digest.putBigInteger(this.vc);
        digest.putBigInteger(this.xc);
        digest.putBigInteger(this.wc);
        digest.putBigInteger(this.secret);
        this.exchangeHash = digest.doFinal();
    }
}

