/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh2;

import com.maverick.events.EventLog;
import com.maverick.ssh.ChannelEventListener;
import com.maverick.ssh.ChannelOpenException;
import com.maverick.ssh.ForwardingRequestListener;
import com.maverick.ssh.PasswordAuthentication;
import com.maverick.ssh.PublicKeyAuthentication;
import com.maverick.ssh.SshAuthentication;
import com.maverick.ssh.SshClient;
import com.maverick.ssh.SshConnector;
import com.maverick.ssh.SshContext;
import com.maverick.ssh.SshException;
import com.maverick.ssh.SshSession;
import com.maverick.ssh.SshTransport;
import com.maverick.ssh.SshTunnel;
import com.maverick.ssh.components.SshKeyExchangeClient;
import com.maverick.ssh.message.SshAbstractChannel;
import com.maverick.ssh2.AuthenticationClient;
import com.maverick.ssh2.AuthenticationProtocol;
import com.maverick.ssh2.ChannelFactory;
import com.maverick.ssh2.GlobalRequest;
import com.maverick.ssh2.GlobalRequestHandler;
import com.maverick.ssh2.KBIAuthentication;
import com.maverick.ssh2.KBIPrompt;
import com.maverick.ssh2.KBIRequestHandler;
import com.maverick.ssh2.Ssh2Channel;
import com.maverick.ssh2.Ssh2Context;
import com.maverick.ssh2.Ssh2PasswordAuthentication;
import com.maverick.ssh2.Ssh2PublicKeyAuthentication;
import com.maverick.ssh2.Ssh2Session;
import com.maverick.ssh2.TransportProtocol;
import com.maverick.ssh2.b;
import com.maverick.ssh2.c;
import com.maverick.util.ByteArrayReader;
import com.maverick.util.ByteArrayWriter;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

public class Ssh2Client
implements SshClient {
    TransportProtocol kb;
    SshTransport pb;
    AuthenticationProtocol ob;
    b gb;
    String lb;
    String qb;
    String[] nb;
    String mb;
    Hashtable tb = new Hashtable();
    Hashtable sb = new Hashtable();
    _b rb = new _b();
    SshAuthentication hb;
    SshConnector jb;
    boolean fb = false;
    boolean ib;

    public void connect(SshTransport sshTransport, SshContext sshContext, SshConnector sshConnector, String string, String string2, String string3, boolean bl) throws SshException {
        if (sshConnector == null || !sshConnector.isLicensed()) {
            throw new SshException("You cannot create Ssh2Client instances directly", 4);
        }
        this.pb = sshTransport;
        this.lb = string2;
        this.qb = string3;
        this.mb = string;
        this.ib = bl;
        this.jb = sshConnector;
        if (string == null) {
            try {
                sshTransport.close();
            }
            catch (IOException iOException) {
                EventLog.LogEvent(this, "RECIEVED IOException IN Ssh2Client.connect:" + iOException.getMessage());
            }
            throw new SshException("You must supply a valid username!", 4);
        }
        if (!(sshContext instanceof Ssh2Context)) {
            try {
                sshTransport.close();
            }
            catch (IOException iOException) {
                EventLog.LogEvent(this, "RECIEVED IOException IN Ssh2Client.connect:" + iOException.getMessage());
            }
            throw new SshException("Ssh2Context required!", 4);
        }
        EventLog.LogEvent(this, "Connecting " + string + "@" + sshTransport.getHost() + ":" + sshTransport.getPort());
        EventLog.LogDebugEvent(this, "Remote identification is " + string3);
        this.kb = new TransportProtocol();
        EventLog.LogDebugEvent(this, "Starting transport protocol");
        this.kb.startTransportProtocol(sshTransport, (Ssh2Context)sshContext, string2, string3, this);
        EventLog.LogDebugEvent(this, "Starting authentication protocol");
        this.ob = new AuthenticationProtocol(this.kb);
        this.ob.setBannerDisplay(((Ssh2Context)sshContext).getBannerDisplay());
        this.gb = new b(this.kb, sshContext, bl);
        this.gb.b(this.rb);
        this.getAuthenticationMethods(string);
        EventLog.LogEvent(this, "SSH connection established");
    }

    public String[] getAuthenticationMethods(String string) throws SshException {
        this.b(false);
        if (this.nb == null) {
            EventLog.LogEvent(this, "Requesting authentication methods");
            String string2 = this.ob.getAuthenticationMethods(string, "ssh-connection");
            EventLog.LogEvent(this, "Available authentications are " + string2);
            Vector<String> vector = new Vector<String>();
            while (string2 != null) {
                int n = string2.indexOf(44);
                if (n > -1) {
                    vector.addElement(string2.substring(0, n));
                    string2 = string2.substring(n + 1);
                    continue;
                }
                vector.addElement(string2);
                string2 = null;
            }
            this.nb = new String[vector.size()];
            vector.copyInto(this.nb);
            if (this.isAuthenticated()) {
                this.gb.start();
            }
        }
        return this.nb;
    }

    private SshAuthentication b(SshAuthentication sshAuthentication) {
        boolean bl = false;
        for (int k = 0; k < this.nb.length; ++k) {
            if (this.nb[k].equals("password")) {
                return sshAuthentication;
            }
            if (!this.nb[k].equals("keyboard-interactive")) continue;
            bl = true;
        }
        if (bl) {
            KBIAuthentication kBIAuthentication = new KBIAuthentication();
            kBIAuthentication.setUsername(((PasswordAuthentication)sshAuthentication).getUsername());
            kBIAuthentication.setKBIRequestHandler(new _c((PasswordAuthentication)sshAuthentication));
            return kBIAuthentication;
        }
        return sshAuthentication;
    }

    public int authenticate(SshAuthentication sshAuthentication) throws SshException {
        int n;
        this.b(false);
        if (this.isAuthenticated()) {
            throw new SshException("User is already authenticated! Did you check isAuthenticated?", 4);
        }
        if (sshAuthentication.getUsername() == null) {
            sshAuthentication.setUsername(this.mb);
        }
        if (sshAuthentication instanceof PasswordAuthentication || sshAuthentication instanceof Ssh2PasswordAuthentication) {
            sshAuthentication = this.b(sshAuthentication);
        }
        EventLog.LogEvent(this, "Authenticating with " + sshAuthentication.getMethod());
        if (sshAuthentication instanceof PasswordAuthentication && !(sshAuthentication instanceof Ssh2PasswordAuthentication)) {
            Ssh2PasswordAuthentication ssh2PasswordAuthentication = new Ssh2PasswordAuthentication();
            ssh2PasswordAuthentication.setUsername(((PasswordAuthentication)sshAuthentication).getUsername());
            ssh2PasswordAuthentication.setPassword(((PasswordAuthentication)sshAuthentication).getPassword());
            n = this.ob.authenticate(ssh2PasswordAuthentication, "ssh-connection");
            if (ssh2PasswordAuthentication.requiresPasswordChange()) {
                this.disconnect();
                throw new SshException("Password change required!", 8);
            }
        } else if (sshAuthentication instanceof PublicKeyAuthentication && !(sshAuthentication instanceof Ssh2PublicKeyAuthentication)) {
            Ssh2PublicKeyAuthentication ssh2PublicKeyAuthentication = new Ssh2PublicKeyAuthentication();
            ssh2PublicKeyAuthentication.setUsername(((PublicKeyAuthentication)sshAuthentication).getUsername());
            ssh2PublicKeyAuthentication.setPublicKey(((PublicKeyAuthentication)sshAuthentication).getPublicKey());
            ssh2PublicKeyAuthentication.setPrivateKey(((PublicKeyAuthentication)sshAuthentication).getPrivateKey());
            n = this.ob.authenticate(ssh2PublicKeyAuthentication, "ssh-connection");
        } else if (sshAuthentication instanceof AuthenticationClient) {
            n = this.ob.authenticate((AuthenticationClient)sshAuthentication, "ssh-connection");
        } else {
            throw new SshException("Invalid authentication client", 4);
        }
        if (n == 1) {
            this.hb = sshAuthentication;
            this.gb.start();
        }
        switch (n) {
            case 1: {
                EventLog.LogEvent(this, "Authentication complete");
                break;
            }
            case 2: {
                EventLog.LogEvent(this, "Authentication failed");
                break;
            }
            case 3: {
                EventLog.LogEvent(this, "Authentication successful but further authentication required");
                break;
            }
            case 4: {
                EventLog.LogEvent(this, "Authentication cancelled");
                break;
            }
            case 5: {
                EventLog.LogEvent(this, "Server accepts the public key provided");
                break;
            }
            default: {
                EventLog.LogErrorEvent(this, "Unknown authentication result " + n);
            }
        }
        return n;
    }

    public boolean isAuthenticated() {
        return this.ob.isAuthenticated();
    }

    public void disconnect() {
        try {
            EventLog.LogEvent(this, "Disconnecting");
            this.gb.signalClosingState();
            this.kb.disconnect(11, "The user disconnected the application");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        EventLog.LogEvent(this, "Disconnected");
    }

    public void exit() {
        try {
            EventLog.LogEvent(this, "Disconnecting");
            this.gb.signalClosingState();
            this.kb.disconnect(11, "The user disconnected the application");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        EventLog.LogEvent(this, "Disconnected");
    }

    public boolean isConnected() {
        return this.kb.isConnected();
    }

    public void forceKeyExchange() throws SshException {
        EventLog.LogEvent(this, "Forcing key exchange");
        this.kb.b(false);
    }

    public SshSession openSessionChannel() throws SshException, ChannelOpenException {
        return this.openSessionChannel(32768, 32768, null);
    }

    public SshSession openSessionChannel(ChannelEventListener channelEventListener) throws SshException, ChannelOpenException {
        return this.openSessionChannel(32768, 32768, channelEventListener);
    }

    public Ssh2Session openSessionChannel(int n, int n2, ChannelEventListener channelEventListener) throws ChannelOpenException, SshException {
        this.b(true);
        EventLog.LogEvent(this, "Opening session channel windowspace=" + n + " packetsize=" + n2);
        Ssh2Session ssh2Session = new Ssh2Session(n, n2, this);
        if (channelEventListener != null) {
            ssh2Session.addChannelEventListener(channelEventListener);
        }
        this.gb.b(ssh2Session, null);
        EventLog.LogEvent(this, "Channel has been opened channelid=" + ssh2Session.getChannelId());
        if (this.gb.e().getX11Display() != null) {
            String string = this.gb.e().getX11Display();
            int n3 = string.indexOf(58);
            int n4 = 0;
            if (n3 != -1) {
                string = string.substring(n3 + 1);
            }
            if ((n3 = string.indexOf(46)) > -1) {
                n4 = Integer.parseInt(string.substring(n3 + 1));
            }
            byte[] byArray = this.gb.e().getX11AuthenticationCookie();
            StringBuffer stringBuffer = new StringBuffer();
            for (int k = 0; k < 16; ++k) {
                String string2 = Integer.toHexString(byArray[k] & 0xFF);
                if (string2.length() == 1) {
                    string2 = "0" + string2;
                }
                stringBuffer.append(string2);
            }
            if (ssh2Session.b(false, "MIT-MAGIC-COOKIE-1", stringBuffer.toString(), n4)) {
                this.fb = true;
            }
        }
        return ssh2Session;
    }

    public SshClient openRemoteClient(String string, int n, String string2, SshConnector sshConnector) throws SshException, ChannelOpenException {
        EventLog.LogEvent(this, "Opening a remote SSH client from " + this.pb.getHost() + " to " + string2 + "@" + string + ":" + n);
        SshTunnel sshTunnel = this.openForwardingChannel(string, n, "127.0.0.1", 22, "127.0.0.1", 22, null, null);
        return sshConnector.connect((SshTransport)sshTunnel, string2, this.ib);
    }

    public SshClient openRemoteClient(String string, int n, String string2) throws SshException, ChannelOpenException {
        return this.openRemoteClient(string, n, string2, this.jb);
    }

    public SshTunnel openForwardingChannel(String string, int n, String string2, int n2, String string3, int n3, SshTransport sshTransport, ChannelEventListener channelEventListener) throws SshException, ChannelOpenException {
        try {
            EventLog.LogEvent(this, "Opening forwarding channel from " + string2 + ":" + n2 + " to " + string + ":" + n);
            c c2 = new c("direct-tcpip", 32768, 32768, string, n, string2, n2, string3, n3, sshTransport);
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeString(string);
            byteArrayWriter.writeInt(n);
            byteArrayWriter.writeString(string3);
            byteArrayWriter.writeInt(n3);
            c2.addChannelEventListener(channelEventListener);
            this.openChannel(c2, byteArrayWriter.toByteArray());
            return c2;
        }
        catch (IOException iOException) {
            throw new SshException(iOException, 5);
        }
    }

    public boolean requestRemoteForwarding(String string, int n, String string2, int n2, ForwardingRequestListener forwardingRequestListener) throws SshException {
        try {
            if (forwardingRequestListener == null) {
                throw new SshException("You must specify a listener to receive connection requests", 4);
            }
            EventLog.LogEvent(this, "Requesting remote forwarding from " + string + ":" + n + " to " + string2 + ":" + n2);
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeString(string);
            byteArrayWriter.writeInt(n);
            GlobalRequest globalRequest = new GlobalRequest("tcpip-forward", byteArrayWriter.toByteArray());
            if (this.sendGlobalRequest(globalRequest, true)) {
                this.tb.put(string + ":" + String.valueOf(n), forwardingRequestListener);
                this.sb.put(string + ":" + String.valueOf(n), string2 + ":" + String.valueOf(n2));
                return true;
            }
            return false;
        }
        catch (IOException iOException) {
            throw new SshException(iOException, 5);
        }
    }

    public boolean cancelRemoteForwarding(String string, int n) throws SshException {
        try {
            EventLog.LogEvent(this, "Cancelling remote forwarding from " + string + ":" + n);
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeString(string);
            byteArrayWriter.writeInt(n);
            GlobalRequest globalRequest = new GlobalRequest("cancel-tcpip-forward", byteArrayWriter.toByteArray());
            if (this.sendGlobalRequest(globalRequest, true)) {
                this.tb.remove(string + ":" + String.valueOf(n));
                this.sb.remove(string + ":" + String.valueOf(n));
                return true;
            }
            return false;
        }
        catch (IOException iOException) {
            throw new SshException(iOException, 5);
        }
    }

    public void openChannel(Ssh2Channel ssh2Channel, byte[] byArray) throws SshException, ChannelOpenException {
        this.b(true);
        this.gb.b(ssh2Channel, byArray);
    }

    public void openChannel(SshAbstractChannel sshAbstractChannel) throws SshException, ChannelOpenException {
        this.b(true);
        if (!(sshAbstractChannel instanceof Ssh2Channel)) {
            throw new SshException("The channel is not an SSH2 channel!", 4);
        }
        this.gb.b((Ssh2Channel)sshAbstractChannel, null);
    }

    public void addChannelFactory(ChannelFactory channelFactory) throws SshException {
        this.gb.b(channelFactory);
    }

    public SshContext getContext() {
        return this.kb.pb;
    }

    public void addRequestHandler(GlobalRequestHandler globalRequestHandler) throws SshException {
        String string = "";
        for (int k = 0; k < globalRequestHandler.supportedRequests().length; ++k) {
            string = string + globalRequestHandler.supportedRequests()[k] + " ";
        }
        EventLog.LogEvent(this, "Installing global request handler for " + string.trim());
        this.gb.b(globalRequestHandler);
    }

    public boolean sendGlobalRequest(GlobalRequest globalRequest, boolean bl) throws SshException {
        this.b(true);
        return this.gb.b(globalRequest, bl);
    }

    public String getRemoteIdentification() {
        return this.qb;
    }

    void b(boolean bl) throws SshException {
        if (this.ob == null || this.kb == null || this.gb == null) {
            throw new SshException("Not connected!", 4);
        }
        if (!this.kb.isConnected()) {
            throw new SshException("The connection has been terminated!", 2);
        }
        if (!this.ob.isAuthenticated() && bl) {
            throw new SshException("The connection is not authenticated!", 4);
        }
    }

    public String getUsername() {
        return this.mb;
    }

    public SshClient duplicate() throws SshException {
        if (this.mb == null || this.hb == null) {
            throw new SshException("Cannot duplicate! The existing connection does not have a set of credentials", 4);
        }
        try {
            EventLog.LogEvent(this, "Duplicating SSH client");
            SshClient sshClient = this.jb.connect(this.pb.duplicate(), this.mb, this.ib, this.kb.pb);
            if (sshClient.authenticate(this.hb) != 1) {
                sshClient.disconnect();
                throw new SshException("Duplication attempt failed to authenicate user!", 5);
            }
            return sshClient;
        }
        catch (IOException iOException) {
            throw new SshException(iOException, 10);
        }
    }

    public int getChannelCount() {
        return this.gb.getChannelCount();
    }

    public int getVersion() {
        return 2;
    }

    public boolean isBuffered() {
        return this.ib;
    }

    public String getKeyExchangeInUse() {
        return this.kb.lc == null ? "none" : this.kb.lc.getAlgorithm();
    }

    public SshKeyExchangeClient getKeyExchangeInstanceInUse() {
        return this.kb.lc;
    }

    public String getHostKeyInUse() {
        return this.kb.y == null ? "none" : this.kb.y.getAlgorithm();
    }

    public String getCipherInUseCS() {
        return this.kb.bc == null ? "none" : this.kb.bc.getAlgorithm();
    }

    public String getCipherInUseSC() {
        return this.kb.wb == null ? "none" : this.kb.wb.getAlgorithm();
    }

    public String getMacInUseCS() {
        return this.kb.eb == null ? "none" : this.kb.eb.getAlgorithm();
    }

    public String getMacInUseSC() {
        return this.kb.sb == null ? "none" : this.kb.sb.getAlgorithm();
    }

    public String getCompressionInUseCS() {
        return this.kb.jc == null ? "none" : this.kb.jc.getAlgorithm();
    }

    public String getCompressionInUseSC() {
        return this.kb.mb == null ? "none" : this.kb.mb.getAlgorithm();
    }

    public String toString() {
        return "SSH2 " + this.pb.getHost() + ":" + this.pb.getPort() + " [kex=" + (this.kb.lc == null ? "none" : this.kb.lc.getAlgorithm()) + " hostkey=" + (this.kb.y == null ? "none" : this.kb.y.getAlgorithm()) + " client->server=" + (this.kb.bc == null ? "none" : this.kb.bc.getAlgorithm()) + "," + (this.kb.eb == null ? "none" : this.kb.eb.getAlgorithm()) + "," + (this.kb.jc == null ? "none" : this.kb.jc.getAlgorithm()) + " server->client=" + (this.kb.wb == null ? "none" : this.kb.wb.getAlgorithm()) + "," + (this.kb.sb == null ? "none" : this.kb.sb.getAlgorithm()) + "," + (this.kb.mb == null ? "none" : this.kb.mb.getAlgorithm()) + "]";
    }

    class _b
    implements ChannelFactory {
        String[] b = new String[]{"forwarded-tcpip", "x11"};

        _b() {
        }

        public String[] supportedChannelTypes() {
            return this.b;
        }

        public Ssh2Channel createChannel(String string, byte[] byArray) throws SshException, ChannelOpenException {
            if (string.equals("forwarded-tcpip")) {
                try {
                    ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
                    String string2 = byteArrayReader.readString();
                    int n = (int)byteArrayReader.readInt();
                    String string3 = byteArrayReader.readString();
                    int n2 = (int)byteArrayReader.readInt();
                    String string4 = string2 + ":" + String.valueOf(n);
                    if (Ssh2Client.this.tb.containsKey(string4)) {
                        ForwardingRequestListener forwardingRequestListener = (ForwardingRequestListener)Ssh2Client.this.tb.get(string4);
                        String string5 = (String)Ssh2Client.this.sb.get(string4);
                        String string6 = string5.substring(0, string5.indexOf(58));
                        int n3 = Integer.parseInt(string5.substring(string5.indexOf(58) + 1));
                        EventLog.LogEvent(this, "Creating remote forwarding channel from " + string2 + ":" + n + " to " + string6 + ":" + n3);
                        c c2 = new c("forwarded-tcpip", 32768, 32768, string6, n3, string2, n, string3, n2, forwardingRequestListener.createConnection(string6, n3));
                        forwardingRequestListener.initializeTunnel(c2);
                        return c2;
                    }
                    throw new ChannelOpenException("Forwarding had not previously been requested", 1);
                }
                catch (IOException iOException) {
                    throw new ChannelOpenException(iOException.getMessage(), 4);
                }
                catch (SshException sshException) {
                    throw new ChannelOpenException(sshException.getMessage(), 2);
                }
            }
            if (string.equals("x11")) {
                if (!Ssh2Client.this.fb) {
                    throw new ChannelOpenException("X Forwarding had not previously been requested", 1);
                }
                try {
                    int n;
                    String string7;
                    ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
                    String string8 = byteArrayReader.readString();
                    int n4 = (int)byteArrayReader.readInt();
                    String string9 = Ssh2Client.this.gb.e().getX11Display();
                    int n5 = string9.indexOf(":");
                    int n6 = 0;
                    int n7 = 0;
                    if (n5 != -1) {
                        string7 = string9.substring(0, n5);
                        if ((n5 = (string9 = string9.substring(n5 + 1)).indexOf(46)) > -1) {
                            n6 = Integer.parseInt(string9.substring(0, n5));
                            n7 = Integer.parseInt(string9.substring(n5 + 1));
                        } else {
                            n6 = Integer.parseInt(string9);
                        }
                        n = n6;
                    } else {
                        string7 = string9;
                        n = 6000;
                    }
                    if (n <= 10) {
                        n += 6000;
                    }
                    EventLog.LogEvent(this, "Creating X11 forwarding channel for display " + string7 + ":" + n7);
                    ForwardingRequestListener forwardingRequestListener = Ssh2Client.this.gb.e().getX11RequestListener();
                    c c3 = new c("x11", 32768, 32768, string7, n, string7, n7, string8, n4, forwardingRequestListener.createConnection(string7, n));
                    forwardingRequestListener.initializeTunnel(c3);
                    return c3;
                }
                catch (Throwable throwable) {
                    throw new ChannelOpenException(throwable.getMessage(), 2);
                }
            }
            throw new ChannelOpenException(string + " is not supported", 3);
        }
    }

    private static class _c
    implements KBIRequestHandler {
        private String b;

        public _c(PasswordAuthentication passwordAuthentication) {
            this.b = passwordAuthentication.getPassword();
        }

        public boolean showPrompts(String string, String string2, KBIPrompt[] kBIPromptArray) {
            for (int k = 0; k < kBIPromptArray.length; ++k) {
                kBIPromptArray[k].setResponse(this.b);
            }
            return true;
        }
    }
}

