/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.moproperties;

import java.awt.Image;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JFrame;
import se.ericsson.cello.emt.moproperties.LdnMvcContainer;
import se.ericsson.cello.emt.moproperties.LdnMvcContainerFactory;
import se.ericsson.cello.emt.moproperties.LdnMvcContainerListener;
import se.ericsson.cello.emt.moproperties.MoPropConfigImplFactory;
import se.ericsson.cello.emt.moproperties.MoPropConfiguration;
import se.ericsson.cello.emt.moproperties.MoPropLog;
import se.ericsson.cello.emt.moproperties.MoPropertiesTool;
import se.ericsson.cello.emt.motools.common.config.ifc.Configuration;
import se.ericsson.cello.emt.motools.common.toolservices.ToolServices;
import se.ericsson.cello.emt.motools.common.toolservices.ToolServicesFactory;
import se.ericsson.cello.emt.nodeservices.NodeServices;
import se.ericsson.cello.emt.userpreferences.UserPreferencesI;
import se.ericsson.cello.emt.utils.guihelper.IconHelper;
import se.ericsson.cello.emt.utils.guihelper.MessageDialog;
import se.ericsson.cello.emt.utils.guihelper.MessageDialogFactory;
import se.ericsson.cello.mimparser.MomAction;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.launcher.LauncherInterface;

public class MoPropertiesToolImpl
implements MoPropertiesTool,
LdnMvcContainerListener {
    private static final String ADDRESS = "address";
    private static final String PORT = "httpPort";
    private LauncherInterface launcher;
    private static String myAddress = null;
    private static String myPort = null;
    private int myNrOfRunCalls = 0;
    private int myNrOfReuseCalls = 0;
    private LinkedHashMap<String, LdnMvcContainer> myLdnMvcContainerMap = null;
    private LdnMvcContainer myActiveLdnMvcContainer = null;
    private NodeServices myNodeServices = null;
    private UserPreferencesI myUsersPreferences = null;
    private Configuration myConfigurationHandler = null;
    private Properties myParameters = null;
    private JFrame myInvisibleFrame = null;
    private String myContainerKey = "";
    private boolean isToolStarted = false;

    public void exit() {
        MoPropLog.logger().info("");
        try {
            if (this.myLdnMvcContainerMap != null) {
                MoPropLog.logger().info("MoProperties mvcContainer size= " + this.myLdnMvcContainerMap.size());
                LdnMvcContainer mvcContainer = null;
                Object[] keys = this.myLdnMvcContainerMap.keySet().toArray();
                for (int n = 0; n < keys.length; ++n) {
                    MoPropLog.logger().info("MoProperties mvcContainer keys[" + n + "]=" + keys[n].toString());
                    mvcContainer = this.myLdnMvcContainerMap.get(keys[n]);
                    mvcContainer.doStop();
                }
                this.myLdnMvcContainerMap = null;
            }
        }
        catch (Exception x) {
            MoPropLog.logger().severe("Failed to close down MoProperties. Stacktrace:" + MoPropLog.stackToString(x));
        }
        this.launcher.onExit((Launchable)this);
    }

    public boolean reconnect(String arg0, Properties arg1) {
        return true;
    }

    public String toString() {
        String name = "";
        name = this.isToolStarted && this.myConfigurationHandler != null ? this.myConfigurationHandler.getManagerTitle() + " - " + this.myConfigurationHandler.getCustomApplName() : "Element Manager - MO Properties";
        return name;
    }

    public void run(String hostName, Properties parameters, LauncherInterface launcher, Launchable parent) {
        MoPropLog.logger().info("MoProperties called with properties: " + parameters == null ? "null" : parameters.toString());
        ++this.myNrOfRunCalls;
        MoPropLog.logger().log(Level.INFO, "myNrOfRunCalls=" + this.myNrOfRunCalls);
        this.launcher = launcher;
        this.myParameters = parameters;
        if (this.myLdnMvcContainerMap != null) {
            for (LdnMvcContainer mvcContainer : this.myLdnMvcContainerMap.values()) {
                mvcContainer.doStop();
            }
            this.myLdnMvcContainerMap = null;
        }
        this.myLdnMvcContainerMap = new LinkedHashMap();
        this.myConfigurationHandler = MoPropConfigImplFactory.createConfigurationHandler(parameters);
        myAddress = this.myConfigurationHandler.getAddress();
        myPort = this.myConfigurationHandler.getPort();
        ToolServices tmpToolServices = ToolServicesFactory.createToolServices((Launchable)this, launcher, this.myConfigurationHandler);
        try {
            this.myUsersPreferences = tmpToolServices.getUserPreferenceServices();
        }
        catch (Exception ex) {
            MoPropLog.logger().warning("MO Properties could not get hold of user preferences. No user preferences like window sizes will be used.\n" + ex.toString());
        }
        try {
            this.myNodeServices = tmpToolServices.getNodeServices();
            this.myNodeServices.getNode();
            this.myNodeServices.getMimModel();
            List<String> ldnList = this.myConfigurationHandler.getLdns();
            if (ldnList == null || ldnList.isEmpty()) {
                throw new RuntimeException("No LDN was submitted as input.");
            }
            for (String ldn : ldnList) {
                try {
                    LdnMvcContainer ldnMvcContainer = LdnMvcContainerFactory.createLdnMvcContainer(ldn, this.myNodeServices, this.myUsersPreferences, this.myConfigurationHandler, parent, launcher, this);
                    this.myContainerKey = this.getContainerKey(ldn, this.myConfigurationHandler);
                    this.myLdnMvcContainerMap.put(this.myContainerKey, ldnMvcContainer);
                    this.myActiveLdnMvcContainer = ldnMvcContainer;
                    this.myActiveLdnMvcContainer.doStart();
                }
                catch (Exception re) {
                    MoPropLog.logger().warning("MO Properties could not start for LDN: " + ldn + ", error:" + re.getMessage());
                    this.displayErrorMsg("MO Properties could not start for \n" + ldn, "", re);
                    if (this.myLdnMvcContainerMap.containsKey(this.myContainerKey)) {
                        this.myLdnMvcContainerMap.remove(this.myContainerKey);
                    }
                    if (this.myLdnMvcContainerMap.size() != 0) continue;
                    MoPropLog.logger().fine("All MVCs are closed. Exiting.");
                    this.exit();
                    return;
                }
            }
            this.isToolStarted = true;
        }
        catch (Exception e) {
            this.displayErrorMsg("MO Properties could not start", "An error occured while trying to initiate contact with the node.", e);
            this.exit();
        }
    }

    public void reuse(String hostName, Properties parameters, LauncherInterface launcher, Launchable parent) {
        Configuration configurationHandler;
        List<String> ldnList;
        MoPropLog.logger().log(Level.INFO, "MoProperties called with properties: " + (parameters == null ? "null" : parameters.toString()));
        ++this.myNrOfReuseCalls;
        MoPropLog.logger().log(Level.INFO, "myNrOfReuseCalls=" + this.myNrOfReuseCalls);
        String reuseAddress = parameters.getProperty(ADDRESS);
        String reusePort = parameters.getProperty(PORT);
        if (!reuseAddress.equals(myAddress) || !reusePort.equals(myPort)) {
            StringBuffer sb = new StringBuffer();
            sb.append(reuseAddress);
            sb.append(":");
            sb.append(reusePort);
            sb.append("is not equal to: ");
            sb.append(myAddress);
            sb.append(":");
            sb.append(myPort);
            RuntimeException e = new RuntimeException("Host name is not the same as firstly supplied in run:\n" + sb.toString());
            if (null != parameters) {
                String ldn = parameters.getProperty("LDNs", "");
                this.displayErrorMsg("MO Properties could not start for \n" + ldn, "", e);
            }
            return;
        }
        Properties copyOfProps = new Properties();
        copyOfProps.putAll((Map<?, ?>)this.myParameters);
        this.removeTemporaryProperties(copyOfProps);
        if (null != parameters) {
            copyOfProps.putAll((Map<?, ?>)parameters);
        }
        if (this.myLdnMvcContainerMap == null) {
            this.myLdnMvcContainerMap = new LinkedHashMap();
        }
        if ((ldnList = (configurationHandler = MoPropConfigImplFactory.createConfigurationHandler(copyOfProps)).getLdns()) == null || ldnList.isEmpty()) {
            MessageDialog message = MessageDialogFactory.createMessageDialog((String)"MO Properties could not start", (String)"No LDN was submitted as input.", (boolean)false, (JFrame)this.getInvisibleFrame());
            message.setVisible(true);
            return;
        }
        LdnMvcContainer ldnMvcContainer = null;
        for (String ldn : ldnList) {
            try {
                this.myContainerKey = this.getContainerKey(ldn, configurationHandler);
                ldnMvcContainer = this.myLdnMvcContainerMap.get(this.myContainerKey);
                if (ldnMvcContainer == null) {
                    ldnMvcContainer = LdnMvcContainerFactory.createLdnMvcContainer(ldn, this.myNodeServices, this.myUsersPreferences, configurationHandler, parent, launcher, this);
                    this.myLdnMvcContainerMap.put(this.myContainerKey, ldnMvcContainer);
                }
                this.myActiveLdnMvcContainer = ldnMvcContainer;
                this.myActiveLdnMvcContainer.doStart();
            }
            catch (Exception re) {
                this.displayErrorMsg("MO Properties could not start for \n" + ldn, "", re);
                MoPropLog.logger().warning("MO Properties could not start for \n" + ldn + " error:" + re.getMessage());
                if (this.myLdnMvcContainerMap.containsKey(this.myContainerKey)) {
                    this.myLdnMvcContainerMap.remove(this.myContainerKey);
                }
                if (this.myLdnMvcContainerMap.size() != 0) continue;
                MoPropLog.logger().fine("All MVCs are closed. Exiting.");
                this.exit();
                return;
            }
        }
    }

    private void removeTemporaryProperties(Properties prop) {
        List<String> attributesToRemove = MoPropConfiguration.getTemporaryPropertyKeys();
        for (String key : attributesToRemove) {
            prop.remove(key);
        }
    }

    public MomAction[] getActions(String aLdn) {
        return null;
    }

    public NameValue[] getAttributes(String aLdn) {
        return null;
    }

    public void onLdnMvcContainerExit(LdnMvcContainer aContainer) {
        String theClosingLdn = aContainer.getLdn();
        if (this.myLdnMvcContainerMap != null) {
            if (this.myLdnMvcContainerMap.containsKey(theClosingLdn)) {
                this.myLdnMvcContainerMap.remove(theClosingLdn);
            }
            if (this.myLdnMvcContainerMap.size() == 0) {
                MoPropLog.logger().fine("All MVCs are closed. Exiting.");
                this.exit();
            }
        }
    }

    private JFrame getInvisibleFrame() {
        String iconPath;
        if (null == this.myInvisibleFrame && null != (iconPath = this.myParameters.getProperty("TOOL_ICON")) && iconPath.length() > 0) {
            Image im = new IconHelper().getIconImage(iconPath);
            this.myInvisibleFrame = new JFrame();
            this.myInvisibleFrame.setIconImage(im);
        }
        return this.myInvisibleFrame;
    }

    private void displayErrorMsg(String heading, String msg, Exception e) {
        MessageDialogFactory.createMessageDialog((String)heading, (String)msg, (Exception)e, (boolean)true, (JFrame)this.getInvisibleFrame()).setVisible(true);
    }

    private String getContainerKey(String aLdn, Configuration cfg) {
        if (this.myConfigurationHandler.getSelectedAttrNames() != null || this.myConfigurationHandler.getSelectedActionName() != null) {
            StringBuilder myContainerKeyBuffer = new StringBuilder();
            myContainerKeyBuffer.append(aLdn + " ");
            if (cfg.getSelectedActionName() != null) {
                myContainerKeyBuffer.append(cfg.getSelectedActionName() + " ");
            }
            if (cfg.getSelectedAttrNames() != null) {
                ListIterator<String> it = cfg.getSelectedAttrNames().listIterator();
                while (it.hasNext()) {
                    String attr = it.next();
                    if (attr == null) continue;
                    myContainerKeyBuffer.append(attr + " ");
                }
            }
            return myContainerKeyBuffer.toString();
        }
        return aLdn;
    }
}

