/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.moproperties.view.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import se.ericsson.cello.emt.moproperties.MoPropLog;
import se.ericsson.cello.emt.moproperties.controller.MoPropertiesController;
import se.ericsson.cello.emt.moproperties.controller.ProgressAttributeChangeListener;
import se.ericsson.cello.emt.moproperties.controller.ProgressController;
import se.ericsson.cello.emt.moproperties.model.MoPropertiesModel;
import se.ericsson.cello.emt.moproperties.view.gui.DataTypeGUICreator;
import se.ericsson.cello.emt.moproperties.view.gui.IndeterminateProgressBarUtil;
import se.ericsson.cello.emt.motools.common.gui.components.GUI_Container;
import se.ericsson.cello.emt.motools.common.toolservices.StartFailureException;
import se.ericsson.cello.emt.motools.common.toolservices.ToolServices;
import se.ericsson.cello.emt.utils.guihelper.MessageDialogFactory;
import se.ericsson.cello.emt.utils.guitestsupport.GuiTestEventTypes;
import se.ericsson.cello.neal.cm.NameValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgressGui
implements GUI_Container,
ProgressAttributeChangeListener {
    private static final String MO_PROPERTIES = "MO Properties";
    private static final int PROGRESS_TEXT_EDGE_SPACE = 30;
    private static final int NUM_DOTS = 3;
    private MoPropertiesController controller = null;
    private ProgressController progressController = null;
    private MoPropertiesModel model;
    private ToolServices toolServices = null;
    private int nrOfProgressAttrs = 0;
    private List<String> listOfAttrNames;
    private JPanel myPanel = new JPanel();
    private JProgressBar progressBar;
    private IndeterminateProgressBarUtil indeterminateProgressBar;
    private JLabel myStartLabel;
    private JLabel myStopLabel;
    private JPanel attrPanel = null;
    private Map<String, DataTypeGUICreator> dataTypeGUICreators = null;
    private Map<String, Integer> creatorGuiIndexMap = null;

    public ProgressGui(MoPropertiesController c) {
        MoPropLog.logger().finer("Entering ProgressGui Constructor");
        this.controller = c;
        this.model = this.controller.getModel();
        this.toolServices = this.model.getToolServices();
        MoPropLog.logger().finer("finished makingg a new ProgressGui");
    }

    private JPanel buildSelectedAttributesAreaForMoActionGui() {
        MoPropLog.logger().entering(this.getClass().getName(), "buildSelectedAttributesAreaForMoActionGui");
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProgressGui.this.buildSelectedAttributesAreaForMoActionGui();
                }
            });
        } else {
            MoPropLog.logger().finer("building progress attribute area for MoActionGui");
            this.progressController = this.controller.getProgressController();
            if (null == this.progressController) {
                MoPropLog.logger().info("Can not build progress panel. ProgressController is missing.");
                return null;
            }
            this.listOfAttrNames = this.progressController.getProgressSupervisionAttributes();
            if (null == this.listOfAttrNames || this.listOfAttrNames.size() <= 0) {
                MoPropLog.logger().finer("Will not build panel for progress attribute display. No progress attributes specified.");
                return null;
            }
            this.attrPanel = new JPanel();
            this.attrPanel.setLayout(new BoxLayout(this.attrPanel, 1));
            if (null != this.listOfAttrNames) {
                this.nrOfProgressAttrs = this.listOfAttrNames.size();
            }
            if (this.nrOfProgressAttrs > 0) {
                this.dataTypeGUICreators = new HashMap<String, DataTypeGUICreator>();
                this.creatorGuiIndexMap = new HashMap<String, Integer>();
                DataTypeGUICreator aCreator = null;
                String attrName = null;
                Iterator<String> iter = this.listOfAttrNames.iterator();
                int attrIndex = 0;
                while (iter.hasNext()) {
                    attrName = iter.next();
                    aCreator = new DataTypeGUICreator(this.controller, true, this, this.myPanel, null, false, this.toolServices, attrName);
                    aCreator.readAttribute();
                    this.dataTypeGUICreators.put(attrName, aCreator);
                    this.creatorGuiIndexMap.put(attrName, attrIndex);
                    ++attrIndex;
                    JPanel op = aCreator.getPanel();
                    op.setAlignmentX(0.0f);
                    this.attrPanel.add(op);
                }
            }
        }
        MoPropLog.logger().finer("finished building progress attribute area for MoActionGui");
        return this.attrPanel;
    }

    private JPanel buildProgressBarPanel() {
        MoPropLog.logger().entering(this.getClass().getName(), "buildProgressBarPanel");
        JPanel progressContainerPanel = null;
        JPanel progressBarPanel = null;
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProgressGui.this.buildProgressBarPanel();
                }
            });
        } else {
            MoPropLog.logger().finer("building buildProgressBarPanel attribute area for MoActionGui");
            this.progressController = this.controller.getProgressController();
            if (null == this.progressController) {
                MoPropLog.logger().info("Can not build progress panel. Unable to make ProgressController");
                return null;
            }
            progressContainerPanel = new JPanel(new BorderLayout(5, 5));
            JLabel progressLabel = new JLabel("Progress: ");
            progressLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            progressContainerPanel.add((Component)progressLabel, "North");
            progressContainerPanel.setName("Progress_Name");
            progressBarPanel = new JPanel();
            progressContainerPanel.add((Component)progressBarPanel, "Center");
            progressBarPanel.setLayout(new FlowLayout(1, 6, 2));
            if (this.progressController.isPreparedForProgressInNumber()) {
                int progressStart = this.progressController.getProgressStartNumber();
                int progressStop = this.progressController.getProgressTotalNumber();
                progressBarPanel.setBorder(new EmptyBorder(0, 10, 0, 0));
                this.myStartLabel = new JLabel(Integer.toString(progressStart));
                progressBarPanel.add(this.myStartLabel);
                this.progressBar = new JProgressBar(progressStart, progressStop);
                this.progressBar.setStringPainted(true);
                this.progressBar.setString("");
                this.progressBar.setToolTipText(this.progressController.getProgressCountAttributeName());
                this.myStartLabel.setName("ProgressStart");
                this.progressBar.setName("Progress_Value");
                progressBarPanel.add(this.progressBar);
                this.myStopLabel = new JLabel(Integer.toString(progressStop));
                this.myStopLabel.setName("ProgressStop");
                progressBarPanel.add(this.myStopLabel);
            } else {
                this.progressBar = new JProgressBar();
                this.indeterminateProgressBar = new IndeterminateProgressBarUtil(this.progressBar);
                this.progressBar.setStringPainted(true);
                this.progressBar.setString("");
                int height = (int)this.progressBar.getPreferredSize().getHeight();
                this.progressBar.setPreferredSize(new Dimension(500, height));
                progressBarPanel.add(this.progressBar);
            }
            this.progressController.addMoAttributeProgressListener(this);
        }
        MoPropLog.logger().exiting(this.getClass().getName(), "buildProgressBarPanel");
        return progressContainerPanel;
    }

    @Override
    public void updateProgress(final int progress, final String progressText) {
        MoPropLog.logger().entering(this.getClass().getName(), "updateProgress");
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProgressGui.this.updateProgress(progress, progressText);
                }
            });
        } else {
            MoPropLog.logger().finer("In GUI thread updating progress:" + progress);
            MoPropLog.logger().finer("ProgressBar Update:" + progressText);
            this.progressBar.setString(progressText);
            this.progressBar.setValue(progress);
            this.toolServices.sendEmNotification(GuiTestEventTypes.MO_ACTION_PROGRESS_UPDATED, this.getClass().getSimpleName() + " updateProgress", progress, GuiTestEventTypes.claimSeqNum(), System.currentTimeMillis(), this);
        }
    }

    @Override
    public void progressStop() {
        MoPropLog.logger().entering(this.getClass().getName(), "progressStop()");
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProgressGui.this.progressStop();
                }
            });
        } else if (this.indeterminateProgressBar != null && this.indeterminateProgressBar.isStarted()) {
            this.indeterminateProgressBar.stop();
            this.progressBar.setString("");
            this.progressBar.setToolTipText("");
            this.toolServices.sendEmNotification(GuiTestEventTypes.MO_ACTION_PROGRESS_UPDATED, this.getClass().getSimpleName() + " progressStop()", "", GuiTestEventTypes.claimSeqNum(), System.currentTimeMillis(), this);
        }
    }

    @Override
    public void progressStart(final String progressToDisplay) {
        MoPropLog.logger().entering(this.getClass().getName(), "progressStart()");
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProgressGui.this.progressStart(progressToDisplay);
                }
            });
        } else if (this.indeterminateProgressBar != null && !this.indeterminateProgressBar.isStarted()) {
            this.indeterminateProgressBar.start();
            this.progressBar.setString(this.getProgressTextToShow(progressToDisplay));
            this.progressBar.setToolTipText(progressToDisplay);
            this.toolServices.sendEmNotification(GuiTestEventTypes.MO_ACTION_PROGRESS_UPDATED, this.getClass().getSimpleName() + " progressStart()", "", GuiTestEventTypes.claimSeqNum(), System.currentTimeMillis(), this);
        }
    }

    @Override
    public void updateProgressText(final String progressText) {
        MoPropLog.logger().entering(this.getClass().getName(), "updateProgressText");
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProgressGui.this.updateProgressText(progressText);
                }
            });
        } else {
            MoPropLog.logger().finer("In GUI thread updating progress text:" + progressText);
            this.progressBar.setToolTipText(progressText);
            this.progressBar.setString(this.getProgressTextToShow(progressText));
            this.toolServices.sendEmNotification(GuiTestEventTypes.MO_ACTION_PROGRESS_UPDATED, this.getClass().getSimpleName() + " updateProgressText", progressText, GuiTestEventTypes.claimSeqNum(), System.currentTimeMillis(), this);
        }
    }

    private String getProgressTextToShow(String progressText) {
        FontMetrics metrics = this.progressBar.getFontMetrics(this.progressBar.getFont());
        int wantedWidth = metrics.stringWidth(progressText);
        int actualWidth = this.progressBar.getWidth() - 30;
        String result = progressText;
        if (wantedWidth >= actualWidth) {
            StringBuilder strBuilder = new StringBuilder(progressText);
            int index = 0;
            while (metrics.stringWidth(strBuilder.substring(0, index)) <= actualWidth - 3 && ++index < progressText.length()) {
            }
            if (index < progressText.length()) {
                result = strBuilder.substring(0, index);
                result = result + "...";
            }
        }
        return result;
    }

    @Override
    public void updateAttributes(final Collection<NameValue> nameValuesToUpdate) {
        MoPropLog.logger().entering(this.getClass().getName(), "updateAttributes");
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProgressGui.this.updateAttributes(nameValuesToUpdate);
                }
            });
        } else {
            Iterator<NameValue> iter = nameValuesToUpdate.iterator();
            MoPropLog.logger().finer("ProgressGui, updateAttributes");
            NameValue nv = null;
            while (iter.hasNext()) {
                nv = iter.next();
                this.refreshProgressDataTypeGui(nv);
            }
            MoPropLog.logger().finer("ProgressGui, updateAttributes, ready");
        }
    }

    @Override
    public void updateProgressStartNumber(final int newProgressStart) {
        MoPropLog.logger().entering(this.getClass().getName(), "updateProgressStartNumber(final int newProgressStart)", newProgressStart);
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProgressGui.this.updateProgressStartNumber(newProgressStart);
                }
            });
        } else {
            MoPropLog.logger().finer("updateProgressStartNumber, Setting minimum: " + newProgressStart);
            this.progressBar.setMinimum(newProgressStart);
            this.myStartLabel.setText(Integer.toString(this.progressController.getProgressStartNumber()));
            this.toolServices.sendEmNotification(GuiTestEventTypes.MO_ACTION_PROGRESS_UPDATED, this.getClass().getSimpleName() + " updateProgressStart", null, GuiTestEventTypes.claimSeqNum(), System.currentTimeMillis(), this);
            MoPropLog.logger().finer("updateProgressStartNumber ready");
        }
    }

    @Override
    public void updateProgressTotalNumber(final int newProgressTotal) {
        MoPropLog.logger().entering(this.getClass().getName(), "updateProgressTotalNumber(final int newProgressTotal)", newProgressTotal);
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProgressGui.this.updateProgressTotalNumber(newProgressTotal);
                }
            });
        } else {
            MoPropLog.logger().finer("updateProgressTotalNumber, Setting maximum: " + newProgressTotal);
            this.progressBar.setMaximum(newProgressTotal);
            this.myStopLabel.setText(Integer.toString(this.progressController.getProgressTotalNumber()));
            this.toolServices.sendEmNotification(GuiTestEventTypes.MO_ACTION_PROGRESS_UPDATED, this.getClass().getSimpleName() + " updateProgressStop", null, GuiTestEventTypes.claimSeqNum(), System.currentTimeMillis(), this);
            MoPropLog.logger().finer("updateProgressTotalNumber ready");
        }
    }

    @Override
    public void updateNeeded() {
        MoPropLog.logger().entering(this.getClass().getName(), "updateNeeded");
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProgressGui.this.updateNeeded();
                }
            });
        } else {
            MoPropLog.logger().finer("updateNeeded, calling validate");
            this.myPanel.validate();
        }
    }

    @Override
    public void valueChanged() {
    }

    private void refreshProgressDataTypeGui(NameValue nv) {
        MoPropLog.logger().entering(this.getClass().getName(), "refreshProgressDataTypeGui(NameValue nv", nv);
        String attrName = null;
        DataTypeGUICreator oldCreator = null;
        boolean isAttributeOfPrimitiveType = true;
        attrName = nv.getName();
        Object value = nv.getValue();
        oldCreator = this.dataTypeGUICreators.get(attrName);
        if (null == oldCreator) {
            MoPropLog.logger().finer("refreshProgressDataTypeGui, oldCreator was null. Returning");
            return;
        }
        try {
            isAttributeOfPrimitiveType = oldCreator.isAttributeOfPrimitiveType();
            if (isAttributeOfPrimitiveType) {
                oldCreator.updateGuiValueForPrimitives(value.toString());
            } else {
                this.replaceOldDataTypeGuiWithNewGui(attrName);
            }
        }
        catch (IllegalStateException e) {
            String reason = e.getMessage();
            MoPropLog.logger().info(reason);
        }
        MoPropLog.logger().exiting(this.getClass().getName(), "refreshProgressDataTypeGui");
    }

    private void replaceOldDataTypeGuiWithNewGui(String attrName) {
        MoPropLog.logger().entering(this.getClass().getName(), "replaceOldDataTypeGuiWithNewGui(String attrName)", attrName);
        DataTypeGUICreator oldCreator = this.dataTypeGUICreators.get(attrName);
        JPanel oldPanel = oldCreator.getPanel();
        int compIndex = this.creatorGuiIndexMap.get(attrName);
        boolean found = false;
        try {
            found = this.containsTheCoponent(oldPanel);
            if (found) {
                this.attrPanel.remove(oldPanel);
            }
        }
        catch (IndexOutOfBoundsException z) {
            String reason = "replaceOldDataTypeGuiWithNewGui, No such child: " + compIndex;
            MoPropLog.logger().fine(reason);
        }
        DataTypeGUICreator attrCreator = this.createDataTypeGui(attrName);
        this.dataTypeGUICreators.put(attrName, attrCreator);
        this.creatorGuiIndexMap.put(attrName, compIndex);
        JPanel op = attrCreator.getPanel();
        op.setAlignmentX(0.0f);
        this.attrPanel.add((Component)op, compIndex);
        this.attrPanel.repaint();
        MoPropLog.logger().exiting(this.getClass().getName(), "replaceOldDataTypeGuiWithNewGui(String attrName)");
    }

    private boolean containsTheCoponent(JPanel p) {
        Component[] component;
        MoPropLog.logger().entering(this.getClass().getName(), "containsTheCoponent(JPanel p)" + p);
        boolean result = false;
        for (Component components : component = this.attrPanel.getComponents()) {
            if (!components.equals(p)) continue;
            result = true;
            break;
        }
        MoPropLog.logger().exiting(this.getClass().getName(), "containsTheCoponent(JPanel p)", result);
        return result;
    }

    private DataTypeGUICreator createDataTypeGui(String attributeName) {
        MoPropLog.logger().entering(this.getClass().getName(), "createDataTypeGui(String attributeName)", attributeName);
        DataTypeGUICreator attrCreator = new DataTypeGUICreator(this.controller, true, this, this.myPanel, null, false, this.toolServices, attributeName);
        attrCreator.readAttribute();
        MoPropLog.logger().exiting(this.getClass().getName(), "createDataTypeGui(String attributeName)", attrCreator);
        return attrCreator;
    }

    public JButton buildProgressAdditionalArea() {
        JButton additionalActionBtn = null;
        String additionalAction = null;
        try {
            additionalAction = this.controller.getModel().getConfiguration().getProgressAdditionalAction();
        }
        catch (Exception e) {
            MoPropLog.logger().warning("Could not retrieve the attribute progress additional action from the configuration.");
        }
        if (additionalAction != null) {
            additionalActionBtn = new JButton(additionalAction + "...");
            additionalActionBtn.setActionCommand(additionalAction);
            additionalActionBtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    if (event.getSource() instanceof JButton) {
                        Properties props = ProgressGui.this.controller.getModel().getConfiguration().getSupersedingProperties();
                        props.setProperty("LDNs", ProgressGui.this.controller.getModel().getLDN());
                        props.setProperty("MOACTION", ((JButton)event.getSource()).getActionCommand());
                        try {
                            ProgressGui.this.toolServices.startHyperTool(ProgressGui.MO_PROPERTIES, props);
                        }
                        catch (StartFailureException e) {
                            MessageDialogFactory.createMessageDialog((String)"It was not possible to start MO Properties", (Exception)e, (boolean)false, null).setVisible(true);
                        }
                    }
                }
            });
        }
        return additionalActionBtn;
    }

    public JPanel buildProgressBarAreaForMoActionGui() {
        MoPropLog.logger().entering(this.getClass().getName(), "buildProgressBarAreaForMoActionGui()");
        JPanel pbar = null;
        if (this.controller.shouldDisplayProgressBarForExecTheAction()) {
            pbar = this.buildProgressBarPanel();
        }
        MoPropLog.logger().exiting(this.getClass().getName(), "buildProgressBarAreaForMoActionGui()", pbar);
        return pbar;
    }

    public JPanel buildProgressAttributesAreaForMoActionGui() {
        MoPropLog.logger().entering(this.getClass().getName(), "buildProgressAttributesAreaForMoActionGui");
        JPanel progressPanel = null;
        if (this.controller.shouldDisplayAttributesProgressForExecTheAction()) {
            progressPanel = this.buildSelectedAttributesAreaForMoActionGui();
        }
        MoPropLog.logger().exiting(this.getClass().getName(), "buildProgressAttributesAreaForMoActionGui", progressPanel);
        return progressPanel;
    }
}

