/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.mosearch.view.gui;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import se.ericsson.cello.emt.mosearch.view.gui.SearchResultTableModel;
import se.ericsson.cello.neal.cm.Mo;

public class ColumnHeaderListener
extends MouseAdapter {
    private boolean ascending = true;
    private SearchResultTableModel myModel;

    public void mouseReleased(MouseEvent event) {
    }

    public void mouseClicked(MouseEvent evt) {
        JTable table = ((JTableHeader)evt.getSource()).getTable();
        TableColumnModel colModel = table.getColumnModel();
        int vColIndex = colModel.getColumnIndexAtX(evt.getX());
        if (vColIndex == -1) {
            return;
        }
        this.sortAllRowsBy((SearchResultTableModel)table.getModel(), vColIndex, this.ascending);
        this.ascending = !this.ascending;
    }

    public void sortAllRowsBy(SearchResultTableModel model, int colIndex, boolean ascending) {
        this.myModel = model;
        List<Mo> data = model.getModelData();
        Collections.sort(data, new ColumnSorter(colIndex, ascending));
        model.fireTableStructureChanged();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ColumnSorter
    implements Comparator<Mo> {
        int colIndex;
        boolean ascending;

        ColumnSorter(int colIndex, boolean ascending) {
            this.colIndex = colIndex;
            this.ascending = ascending;
        }

        @Override
        public int compare(Mo a, Mo b) {
            String v1 = a.getLdn();
            String v2 = b.getLdn();
            int result = 0;
            if (this.colIndex == 0) {
                result = this.ascending ? v1.compareTo(v2) : -1 * v1.compareTo(v2);
            } else if (this.colIndex == 1) {
                String aAttrName = ColumnHeaderListener.this.myModel.getAttrName();
                if (aAttrName == null || aAttrName.length() <= 0) {
                    return 0;
                }
                String attr1 = "";
                String attr2 = "";
                attr1 = (String)ColumnHeaderListener.this.myModel.getMoAttrMap().get(a);
                attr2 = (String)ColumnHeaderListener.this.myModel.getMoAttrMap().get(b);
                if (attr1 == null && attr2 == null) {
                    return 0;
                }
                if (attr1 == null) {
                    return 1;
                }
                if (attr2 == null) {
                    return -1;
                }
                result = this.ascending ? attr1.compareTo(attr2) : -1 * attr1.compareTo(attr2);
            }
            return result;
        }
    }
}

