/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.motools.common.momodel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Level;
import se.ericsson.cello.emt.moadd.MoAddLog;
import se.ericsson.cello.emt.moproperties.MoPropLog;
import se.ericsson.cello.emt.motools.common.momodel.AttributeModel;
import se.ericsson.cello.emt.motools.common.momodel.MoTemplate;
import se.ericsson.cello.emt.motools.common.momodel.MoTemplateImpl;
import se.ericsson.cello.emt.motools.common.momodel.StartMo;
import se.ericsson.cello.emt.nodeservices.NodeServices;
import se.ericsson.cello.mimparser.MimModel;
import se.ericsson.cello.mimparser.MomClass;
import se.ericsson.cello.neal.Node;
import se.ericsson.cello.neal.cm.CmException;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.cm.Transaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartMoImpl
implements StartMo {
    private NodeServices nodeServices;
    private Mo mo;
    private List<MoTemplate> moTemplates = null;
    private ArrayList<MomClass> searchableMoClasses = null;
    private MimModel myMimModel = null;
    private Node myNode = null;
    private final int TRANSACTION_TIMEOUT = 1800000;

    public StartMoImpl(NodeServices nodeServices, String ldn) {
        this.nodeServices = nodeServices;
        this.mo = nodeServices.getNode().getCmService().getMo(ldn);
        this.myMimModel = nodeServices.getMimModel();
        this.myNode = nodeServices.getNode();
    }

    private void getSearchableMoClasses(String momClass) {
        Iterator children = this.nodeServices.getMimModel().getClass(momClass).getContainmentChildren();
        while (children.hasNext()) {
            MomClass child = (MomClass)children.next();
            if (this.searchableMoClasses.contains(child)) continue;
            this.searchableMoClasses.add(child);
            this.getSearchableMoClasses(child.getName());
            this.moTemplates.add(new MoTemplateImpl(child, this.nodeServices.getNode().getCmService()));
        }
    }

    @Override
    public Mo getMoRef() {
        return this.mo;
    }

    @Override
    public MomClass getMomClass(String momClass) {
        if (this.nodeServices.getMimModel().findClasses(momClass).hasNext()) {
            return (MomClass)this.nodeServices.getMimModel().findClasses(momClass).next();
        }
        return null;
    }

    @Override
    public void setLdn(String ldn) {
        this.mo = this.nodeServices.getNode().getCmService().getMo(ldn);
        if (!this.mo.exists()) {
            this.mo = this.nodeServices.getNode().getCmService().getMo("ManagedElement=1");
        }
    }

    @Override
    public void updateLdn(String ldn) {
        this.mo = this.nodeServices.getNode().getCmService().getMo(ldn);
    }

    @Override
    public List<MoTemplate> getSearchableMOs() {
        this.searchableMoClasses = new ArrayList();
        this.moTemplates = new ArrayList<MoTemplate>();
        if (this.mo.exists()) {
            this.getSearchableMoClasses(this.mo.getType());
        }
        return this.moTemplates;
    }

    @Override
    public List<MoTemplate> getPossibleChildrenMOs() {
        MoAddLog.logger().log(Level.FINE, "Get the possible children");
        TreeMap<String, MoTemplateImpl> sortedAttrMap = new TreeMap<String, MoTemplateImpl>();
        this.moTemplates = new ArrayList<MoTemplate>();
        if (this.mo.exists()) {
            Iterator children = this.myMimModel.getClass(this.mo.getType()).getContainmentChildren();
            while (children.hasNext()) {
                MomClass child = (MomClass)children.next();
                MoTemplateImpl newMoTemplate = new MoTemplateImpl(child, this.myNode.getCmService());
                sortedAttrMap.put(newMoTemplate.getName(), newMoTemplate);
            }
            this.moTemplates.addAll(sortedAttrMap.values());
        }
        return this.moTemplates;
    }

    @Override
    public Mo createChild(MoTemplate moTemplate, String moToCreateId) {
        String type = moTemplate.getName();
        List<AttributeModel> attributeModelList = moTemplate.getDefaultAttributeModels();
        NameValue[] nameValueArray = null;
        ArrayList<NameValue> nameValueList = new ArrayList<NameValue>();
        for (AttributeModel currentAttributeModel : attributeModelList) {
            if (currentAttributeModel.getMomAttribute().isMandatory()) {
                nameValueList.add(currentAttributeModel.getTypeValue().getNameValue());
                continue;
            }
            if (currentAttributeModel.getMomAttribute().isRestricted() && currentAttributeModel.getTypeValue().isUpdated()) {
                nameValueList.add(currentAttributeModel.getTypeValue().getNameValue());
                continue;
            }
            if (currentAttributeModel.isReadOnly() || !currentAttributeModel.getTypeValue().isUpdated()) continue;
            nameValueList.add(currentAttributeModel.getTypeValue().getNameValue());
        }
        if (null != nameValueList) {
            nameValueArray = nameValueList.toArray(new NameValue[0]);
        }
        Mo child = null;
        Transaction tx = this.myNode.getCmService().createTransaction(1800000);
        try {
            child = this.mo.createChild(moToCreateId, type, nameValueArray, tx);
            tx.commit();
        }
        catch (Exception e) {
            MoPropLog.logger().log(Level.INFO, " failed to set attributes for updated attributes. e.getMessage=" + e.getMessage());
            try {
                tx.rollback();
            }
            catch (CmException cmEx) {
                MoPropLog.logger().log(Level.INFO, " not possible to perform transaction rollback");
            }
            throw new RuntimeException(e);
        }
        return child;
    }
}

