/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.helpservice;

import java.util.logging.Level;
import se.ericsson.cello.emt.helpservice.HelpServiceLog;
import se.ericsson.cello.emt.helpservice.HtmlBrowser;
import se.ericsson.cello.emt.helpservice.ToolService;
import se.ericsson.cello.emt.nodeservices.NodeServices;
import se.ericsson.cello.emt.utils.guihelper.MessageDialogFactory;
import se.ericsson.cello.emt.utils.helpers.EmasUtilities;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;

public class AlexBrowser {
    private static final String AC_SEARCHEXT_ST_TITLE_PA = "&AC=SEARCHEXT&ST=TITLE&PA=";
    private static final String QUOTE = "%22";
    private NodeServices myNodeServices = null;
    private String myIconPath = "";
    private HtmlBrowser myHtmlBrowser = null;
    private ToolService myToolService;

    public AlexBrowser(NodeServices ns, String iconPath, HtmlBrowser htmlBrowser, ToolService toolservice) {
        this.myNodeServices = ns;
        this.myIconPath = iconPath;
        this.myHtmlBrowser = htmlBrowser;
        this.myToolService = toolservice;
    }

    public void showALEXdoc(String title, String chapterTag) {
        this.showAlexUrl(this.constructLibraryAndChapterTags(title, chapterTag));
    }

    public void showAlexUrl(String alexUrl) {
        String attrMissingMsg = "Either the ALEX library, or the URL to the ALEX server itself, was not found. ";
        String seeMoreMsg = "See more information below. ";
        String setAttrMsg = "Set the documentServerAddress, and the docLibUserDefined, in the properties of the ManagedElementData MO. ";
        String path = "";
        try {
            path = this.getAlexServerAndLib();
            path = path + alexUrl;
            this.myHtmlBrowser.browseHtml(path);
        }
        catch (Exception e) {
            HelpServiceLog.logger().log(Level.WARNING, "It was not possible to display the help.\n" + HelpServiceLog.stackToString(e));
            this.openMoPropsForManagedElementData();
            MessageDialogFactory.createMessageDialog("The help cannot be displayed.", attrMissingMsg + seeMoreMsg + setAttrMsg, e, this.myIconPath, false).setVisible(true);
        }
    }

    private String constructLibraryAndChapterTags(String docTitle, String chapterTag) {
        StringBuilder liAndCh = new StringBuilder();
        if (null == docTitle) {
            HelpServiceLog.logger().info("No docTitle, displaying the ALEX library first page");
        } else if (!docTitle.equals("Contents & Index") && !docTitle.equals("System Library")) {
            liAndCh.append("&AC=SEARCHEXT&ST=TITLE&PA=%22" + docTitle.replace(' ', '+') + QUOTE);
            if (chapterTag != null && chapterTag.length() > 0) {
                liAndCh.append("&CH=" + chapterTag);
            }
            if (EmasUtilities.runningOnWindows()) {
                liAndCh.insert(0, "\"");
                liAndCh.append("\"");
            }
        }
        return liAndCh.toString();
    }

    private String getAlexServerAndLib() throws Exception {
        Mo dataMo = this.myNodeServices.getNode().getCmService().getMo("ManagedElement=1,ManagedElementData=1");
        String[] attrNames = new String[]{"documentServerAddress", "docLibUserDefined", "docLibSystemDefined"};
        NameValue[] nameValues = dataMo.getAttributes(attrNames, null);
        StringBuilder documentAddress = new StringBuilder(nameValues[0].getStringValue());
        if (documentAddress.toString().equals("")) {
            throw new Exception("The attribute documentServerAddress, in the ManagedElementData MO,\nhad no path to the ALEX server.\nSet a path to the alexserv.\nExample format:http://calstore.ericsson.se/alexserv");
        }
        if (documentAddress.toString().toUpperCase().indexOf("LI=") == -1) {
            if (!documentAddress.toString().endsWith("?")) {
                documentAddress.append("?");
            }
            StringBuilder docLibUserDefined = new StringBuilder(nameValues[1].getStringValue());
            StringBuilder docLibSystemDefined = new StringBuilder(nameValues[2].getStringValue());
            if (docLibUserDefined.length() > 0) {
                documentAddress.append("LI=");
                documentAddress.append((CharSequence)docLibUserDefined);
            } else if (docLibSystemDefined.length() > 0) {
                documentAddress.append("LI=");
                documentAddress.append((CharSequence)docLibSystemDefined);
            } else {
                throw new Exception("Neither the attribute docLibUserDefined, nor docLibSystemDefined,\nin the ManagedElementData MO, had any value.\nSet the correct ALEX library.\nExample format: EN/LZN7720009R2K");
            }
        }
        return documentAddress.toString();
    }

    private void openMoPropsForManagedElementData() {
        if (null != this.myToolService) {
            this.myToolService.launchManagedElementDataProperties();
        }
    }
}

