/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.logservices.view;

import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Log {
    private Logger logger;
    private Level level;
    private FileHandler fileHandler = null;
    private ConsoleHandler consoleHandler = null;

    public Log(Logger logger) {
        this.logger = logger;
        logger.setLevel(this.getLoggerLevel());
        this.level = logger.getLevel();
        Handler[] handlers = logger.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            if (handlers[i] instanceof ConsoleHandler) {
                this.consoleHandler = (ConsoleHandler)handlers[i];
                continue;
            }
            if (!(handlers[i] instanceof FileHandler)) continue;
            this.fileHandler = (FileHandler)handlers[i];
        }
        logger.setUseParentHandlers(false);
    }

    public String getLevel() {
        return this.level.getName();
    }

    private Level getLoggerLevel() {
        Logger probedLogger = this.logger;
        Level level = probedLogger.getLevel();
        while (level == null) {
            probedLogger = probedLogger.getParent();
            level = probedLogger.getLevel();
        }
        return level;
    }

    public void setLevel(String level) {
        this.level = Level.parse(level);
    }

    public void set() {
        this.logger.setLevel(this.level);
        if (this.consoleHandler != null) {
            this.logger.addHandler(this.consoleHandler);
        }
        if (this.fileHandler != null) {
            this.logger.addHandler(this.fileHandler);
        }
    }

    public void setFileHandler(FileHandler handler) {
        if (this.fileHandler != null) {
            this.removeFileHandler();
        }
        this.fileHandler = handler;
    }

    public void removeFileHandler() {
        if (this.fileHandler != null) {
            this.logger.removeHandler(this.fileHandler);
        }
        this.fileHandler = null;
    }

    public void setConsoleHandler(ConsoleHandler handler) {
        if (this.consoleHandler != null) {
            this.removeConsoleHandler();
        }
        this.consoleHandler = handler;
    }

    public void removeConsoleHandler() {
        if (this.consoleHandler != null) {
            this.logger.removeHandler(this.consoleHandler);
        }
        this.consoleHandler = null;
    }

    public Logger getLogger() {
        return this.logger;
    }
}

