/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.nodeservicestool;

import se.ericsson.cello.emt.nodeservicestool.Configuration;
import se.ericsson.cello.emt.nodeservicestool.MomDownloader;
import se.ericsson.cello.emt.nodeservicestool.MomDownloaderImpl;
import se.ericsson.security.launcher.LauncherInterface;
import se.ericsson.security.launcher.testmode.TmProperty;
import se.ericsson.security.launcher.testmode.TmStarterInterface;
import se.ericsson.security.launcher.testmode.TmUtilities;
import se.ericsson.security.utils.EmLogger;

public abstract class MomDownloaderFactory {
    private static final EmLogger LOG = EmLogger.NODE_SERVICE;
    private static MomDownloader myStubbedMomDownloader = null;

    public static MomDownloader createMomDownloader(Configuration aConfig, LauncherInterface launcher) {
        if (myStubbedMomDownloader != null) {
            return myStubbedMomDownloader;
        }
        if (TmUtilities.isTmPropertiesLoaded()) {
            LOG.finest(TmUtilities.getLogMessage((String)"Using stubbed MOM downloader"), new Object[0]);
            return new MomDownloaderStub(aConfig, launcher);
        }
        LOG.finest(TmUtilities.getLogMessage((String)"Using real MOM downloader"), new Object[0]);
        return new MomDownloaderImpl(aConfig, launcher);
    }

    public static void setStubbedMomDownloader(MomDownloader aMomDownloader) {
        myStubbedMomDownloader = aMomDownloader;
    }

    private static class MomDownloaderStub
    extends MomDownloaderImpl {
        public MomDownloaderStub(Configuration aConfig, LauncherInterface launcher) {
            super(aConfig, launcher);
        }

        public String getMomLocalFilePath() {
            TmStarterInterface stubStarter;
            String momFileName = TmProperty.MOM.getValue();
            if (momFileName == null) {
                momFileName = super.getMomLocalFilePath();
                TmProperty.MOM.setValue(false, momFileName);
            }
            if ((stubStarter = TmUtilities.getStubStarter()) != null) {
                stubStarter.initStubbedNodeWithMom(momFileName);
            }
            LOG.info(TmUtilities.getLogMessage((String)("Using MOM: " + momFileName)), new Object[0]);
            return momFileName;
        }
    }
}

