/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.nodeservicestool;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.Enumeration;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import se.ericsson.cello.emt.nodeservicestool.Configuration;
import se.ericsson.cello.emt.nodeservicestool.MomDownloader;
import se.ericsson.security.launcher.LauncherInterface;
import se.ericsson.security.launcher.eprops.EKEY;
import se.ericsson.security.launcher.eprops.EProps;
import se.ericsson.security.launcher.testmode.TmProperty;
import se.ericsson.security.launcher.testmode.TmUtilities;
import se.ericsson.security.utils.EmLogger;

public class MomDownloaderImpl
implements MomDownloader {
    private static final EmLogger LOG = EmLogger.NODE_SERVICE;
    private Configuration myConfiguration = null;
    private String readFrom = "dummy default";
    private static final String ERICSSON_CACHE = "Ericsson";
    private static final String MOM_CACHE = "MOM";
    private static final String JAR_FILE_INDICATOR = "jar:file:";
    private static final String JAR_XML_SUFFIX = "!/";
    private static final String MOM_ENCODING = "ISO-8859-1";
    private String myMomFileInsideJar = null;
    private LauncherInterface myLauncher;
    private boolean useNative = false;

    public MomDownloaderImpl(Configuration myConfiguration, LauncherInterface launcher) {
        this.myConfiguration = myConfiguration;
        this.myLauncher = launcher;
    }

    public String getMomLocalFilePath() {
        EProps ep = new EProps();
        String momVersion = "dummy, not set";
        String xmlFileUrl = null;
        String dtdFileUrl = null;
        File cachedMom = null;
        File cachedDtd = null;
        String momLocalFilePath = null;
        try {
            xmlFileUrl = this.myConfiguration.getMomFileUrl();
            dtdFileUrl = this.myConfiguration.getDtdFileUrl();
            ep.set(EKEY.MOM_URL, (Object)xmlFileUrl);
            ep.set(EKEY.DTD_URL, (Object)dtdFileUrl);
            momVersion = this.getMomVersionFromNode();
            ep.set(EKEY.MOM_VER, (Object)momVersion);
            LOG.info("getMomVersionFromNode succeeded, momVersion=" + momVersion, new Object[0]);
            File cache = this.getMomVersionCache(momVersion);
            ep.set(EKEY.MOM_PATH, (Object)cache);
            LOG.info("getMomVersionCache succeeded, cache.getAbsolutePath()" + cache.getAbsolutePath(), new Object[0]);
            cachedMom = this.cacheIfNotCached(xmlFileUrl, cache);
            momLocalFilePath = cachedMom.getAbsolutePath();
            ep.set(EKEY.MOM_PATH, (Object)momLocalFilePath);
            LOG.info("cacheIfNotCached succeeded, momLocalFilePath=" + momLocalFilePath, new Object[0]);
            if (momLocalFilePath.toLowerCase().endsWith(".jar")) {
                momLocalFilePath = JAR_FILE_INDICATOR + momLocalFilePath + JAR_XML_SUFFIX + this.myMomFileInsideJar;
                ep.set(EKEY.MOM_PATH, (Object)momLocalFilePath);
                LOG.info("adapted file path for mom inside a jar file, momLocalFilePath=" + momLocalFilePath, new Object[0]);
            } else {
                cachedDtd = this.cacheIfNotCached(dtdFileUrl, cache);
                ep.set(EKEY.DTD_PATH, (Object)cachedDtd);
                LOG.info("cacheIfNotCached succeeded, cachedDtd.getAbsolutePath()=" + cachedDtd.getAbsolutePath(), new Object[0]);
            }
            EProps revProps = EProps.getRevisionProperties();
            revProps.putAll((Map)ep);
            if (TmUtilities.isSemlaActive() && !TmProperty.MOM.isSet()) {
                TmProperty.MOM.setValue(false, momLocalFilePath);
            }
            return momLocalFilePath;
        }
        catch (Exception e) {
            String NL = "\n   ";
            StringBuilder sb = new StringBuilder(256);
            sb.append("Download MOM/DTD failed.").append("\n   ");
            sb.append("MOM URL    = ").append(xmlFileUrl).append("\n   ");
            sb.append("DTD URL    = ").append(dtdFileUrl).append("\n   ");
            sb.append("MOM Cache  = ").append(momLocalFilePath).append("\n   ");
            sb.append("DTD Cache  = ").append(cachedDtd);
            LOG.info(sb.toString() + "\n   " + "e.getMessage()=" + e.getMessage() + "\n   " + e.getStackTrace(), new Object[0]);
            throw new RuntimeException(sb.toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    public void removeCachedMomFile() {
        LOG.info("Going to remove the locally cached MOM files", new Object[0]);
        try {
            String dtdFileName;
            File cachedDtd;
            String xmlFileUrl = this.myConfiguration.getMomFileUrl();
            String dtdFileUrl = this.myConfiguration.getDtdFileUrl();
            String momVersion = this.getMomVersionFromNode();
            File cache = this.useNative ? this.getMomVersionUserCache(momVersion) : this.getMomVersionCache(momVersion);
            String momFileName = xmlFileUrl.substring(xmlFileUrl.lastIndexOf("/"));
            File cachedMom = new File(cache, momFileName);
            String momLocalFilePath = cachedMom.getAbsolutePath();
            if (!momLocalFilePath.toLowerCase().endsWith(".jar") && (cachedDtd = new File(cache, dtdFileName = dtdFileUrl.substring(dtdFileUrl.lastIndexOf("/")))).exists()) {
                cachedDtd.delete();
            }
            if ((cachedMom = new File(momLocalFilePath)).exists()) {
                cachedMom.delete();
            }
            LOG.info("Have removed the locally cached MOM files", new Object[0]);
        }
        catch (Exception e) {
            LOG.info("Removal of locally cached MOM/DTD files failed, e.getMessage()=" + e.getMessage(), new Object[0]);
            throw new RuntimeException("Remove local cached MOM/DTD failed.", e);
        }
    }

    private String getMomVersionFromNode() throws Exception {
        Charset charset;
        String momVersion = "No_version";
        String momName = "No_name";
        String momRelease = "-";
        InputStream is = this.getMomXmlFromNode();
        ReadableByteChannel channel = Channels.newChannel(is);
        ByteBuffer buffer = ByteBuffer.allocate(24576);
        channel.read(buffer);
        buffer.flip();
        if (Charset.isSupported(MOM_ENCODING)) {
            charset = Charset.forName(MOM_ENCODING);
        } else {
            LOG.info("Could not find char set for encoding ISO-8859-1, will try with default instead", new Object[0]);
            charset = Charset.defaultCharset();
        }
        CharsetDecoder decoder = charset.newDecoder();
        CharBuffer charBuffer = decoder.decode(buffer);
        StringBuffer xmlContents = new StringBuffer(charBuffer.toString());
        int idxBegin = 0;
        int idxEnd = 0;
        idxBegin = xmlContents.indexOf("<mim name");
        if (idxBegin > -1) {
            idxEnd = xmlContents.indexOf(">", idxBegin);
            String mimNameTag = xmlContents.substring(idxBegin, ++idxEnd);
            int i1 = mimNameTag.indexOf("\"", 0) + 1;
            int i2 = mimNameTag.indexOf("\"", i1) + 1;
            int i3 = mimNameTag.indexOf("\"", i2) + 1;
            int i4 = mimNameTag.indexOf("\"", i3) + 1;
            int i5 = mimNameTag.indexOf("\"", i4) + 1;
            int i6 = mimNameTag.indexOf("\"", i5) + 1;
            momName = mimNameTag.substring(i1, i2 - 1);
            momVersion = mimNameTag.substring(i3, i4 - 1);
            momRelease = mimNameTag.substring(i5, i6 - 1);
        }
        LOG.info("MOM name is " + momName + ", version is " + momVersion + ", release is " + momRelease, new Object[0]);
        is.close();
        return momName + "." + momVersion + "." + momRelease;
    }

    private InputStream getMomXmlFromNode() throws Exception {
        InputStream xmlStream = null;
        LOG.info("Trying to read XML file directly from the node.", new Object[0]);
        String fileRef = this.myConfiguration.getMomFileUrl();
        if (fileRef.endsWith(".xml")) {
            xmlStream = new URL(fileRef).openStream();
            LOG.info("Using XML file stored on node: " + fileRef, new Object[0]);
            this.readFrom = fileRef;
            return xmlStream;
        }
        fileRef = "jar:" + fileRef + JAR_XML_SUFFIX;
        URL jarUrl = new URL(fileRef);
        JarURLConnection jarConnection = (JarURLConnection)jarUrl.openConnection();
        JarFile jarFile = jarConnection.getJarFile();
        LOG.info("Looking for XML file in: " + fileRef, new Object[0]);
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (!entry.getName().endsWith(".xml")) continue;
            this.myMomFileInsideJar = entry.toString();
            LOG.info("Using XML file stored in jar file on node: " + fileRef, new Object[0]);
            this.readFrom = fileRef + entry;
            return jarFile.getInputStream(entry);
        }
        LOG.info("No XML file was found on node: " + this.readFrom, new Object[0]);
        throw new FileNotFoundException(this.readFrom);
    }

    private File getMomVersionUserCache(String version) {
        File home = new File(System.getProperty("user.home"));
        File ericssoncachedir = new File(home, ERICSSON_CACHE);
        File momcachedir = new File(ericssoncachedir, MOM_CACHE);
        File momversiondir = new File(momcachedir, version);
        if (!momversiondir.exists()) {
            momversiondir.mkdirs();
        }
        LOG.info("Cache name=" + momversiondir.toString(), new Object[0]);
        return momversiondir;
    }

    private File getMomVersionCache(String version) {
        String home = System.getProperty("user.home");
        String defaultCache = home + System.getProperty("file.separator") + ERICSSON_CACHE;
        String ericssoncachedir = System.getProperties().getProperty("se.ericsson.security.launcher.cachedirname", defaultCache);
        File momcachedir = new File(ericssoncachedir, MOM_CACHE);
        File momversiondir = new File(momcachedir, version);
        if (!momversiondir.exists()) {
            momversiondir.mkdirs();
        }
        LOG.info("Cache name=" + momversiondir.toString(), new Object[0]);
        return momversiondir;
    }

    private File nativeCacheIfNotCached(String xmlFileUri, File cache) throws Exception {
        String momFileName = xmlFileUri.substring(xmlFileUri.lastIndexOf("/"));
        File cachedMom = new File(cache, momFileName);
        if (!cachedMom.exists()) {
            FileOutputStream fos = null;
            InputStream is = null;
            LOG.info("" + cachedMom + " needs to be created", new Object[0]);
            try {
                is = new URL(xmlFileUri).openStream();
                ReadableByteChannel readChannel = Channels.newChannel(is);
                ByteBuffer buffer = ByteBuffer.allocateDirect(131072);
                fos = new FileOutputStream(cachedMom);
                FileChannel fileChannel = fos.getChannel();
                while (readChannel.read(buffer) != -1) {
                    buffer.flip();
                    fileChannel.write(buffer);
                    buffer.clear();
                }
                fileChannel.close();
                readChannel.close();
                LOG.info("" + cachedMom + " written and closed", new Object[0]);
            }
            catch (Exception iox) {
                LOG.info("Downloading " + xmlFileUri + " failed", new Object[0]);
                throw new Exception(iox.getMessage());
            }
            finally {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception xx) {}
            }
        }
        LOG.info("" + cachedMom + " already existing", new Object[0]);
        return cachedMom;
    }

    private File cacheIfNotCached(String xmlFileUri, File cache) throws Exception {
        File cachedMom = null;
        LinkageError throwable = null;
        try {
            URL url = new URL(xmlFileUri);
            LauncherInterface.RevC newInterface = (LauncherInterface.RevC)this.myLauncher;
            cachedMom = newInterface.getAndChmodFile(cache, url);
        }
        catch (NoClassDefFoundError e) {
            throwable = e;
            LOG.warning("Couldn't find function getAndChmodFile in launcher. Will continue with native code.", new Object[0]);
            cachedMom = this.nativeCacheIfNotCached(xmlFileUri, this.getMomVersionUserCache(this.getMomVersionFromNode()));
            this.useNative = true;
        }
        catch (AbstractMethodError e) {
            throwable = e;
            LOG.warning("Couldn't find function getAndChmodFile in launcher. Will continue with native code.", new Object[0]);
            cachedMom = this.nativeCacheIfNotCached(xmlFileUri, this.getMomVersionUserCache(this.getMomVersionFromNode()));
            this.useNative = true;
        }
        catch (Exception e) {
            String msg = "Failed using launcher to cache MOM : \n   From URI : " + xmlFileUri + "\n   To Cache : " + cache;
            LOG.severe(msg + "\n   Message:" + e.getMessage(), new Object[0]);
            throw new RuntimeException(msg, e);
        }
        if (!this.useNative && cachedMom != null) {
            this.chmodDirs(cachedMom, 2);
        }
        if (cachedMom == null) {
            String msg = "Failed using launcher to cache MOM : \n   From URI : " + xmlFileUri + "\n   To Cache : " + cache;
            LOG.severe(msg + "\n   Message:" + throwable, new Object[0]);
            throw new RuntimeException(msg, throwable);
        }
        return cachedMom;
    }

    private void chmodDirs(File file, int level) throws IOException {
        File dirToChmod = file;
        for (int i = 0; i < level; ++i) {
            if ((dirToChmod = dirToChmod.getParentFile()) != null && dirToChmod.exists() && dirToChmod.isDirectory()) {
                try {
                    ((LauncherInterface.RevD)this.myLauncher).chmodFile(dirToChmod);
                }
                catch (Throwable e) {
                    LOG.warning("Could not change permission of directory due to: " + e.getMessage(), new Object[0]);
                }
                continue;
            }
            LOG.warning("Could not change permission of directory since the file did not meet the requirements", new Object[0]);
        }
    }
}

