/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.sshsftpservice.maverickfacade.impl;

import com.maverick.ssh.SshException;
import com.maverick.ssh.components.SshPublicKey;
import com.sshtools.publickey.AbstractKnownHostsKeyVerification;

public class EmKnownHostsKeyVerification
extends AbstractKnownHostsKeyVerification {
    private static final String HOST_DOES_NOT_MATCH_KEY = "The host does not match the key.";
    private static final String USER_HOME = System.getProperty("user.home");
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final String KNOWN_HOSTS_FILE_LOCATION = USER_HOME + FILE_SEPARATOR + ".ssh" + FILE_SEPARATOR + "known_hosts";

    public EmKnownHostsKeyVerification(String hostName) throws SshException {
    }

    public void onHostKeyMismatch(String hostName, SshPublicKey arg1, SshPublicKey arg2) throws SshException {
        String message = "The host does not match the key.\nPlease remove the entry for " + hostName + " from " + KNOWN_HOSTS_FILE_LOCATION + " and try again.";
        throw new SimpleSshException(message, 9);
    }

    public void onUnknownHost(String arg0, SshPublicKey arg1) throws SshException {
        this.allowHost(arg0, arg1, false);
    }

    private class SimpleSshException
    extends SshException {
        private static final long serialVersionUID = 1L;
        private String message;

        public SimpleSshException(String message, int key) {
            super(message, key);
            this.message = message;
        }

        public String getMessage() {
            if (this.getCause() != null || this.message == null) {
                return super.getMessage();
            }
            return this.message;
        }
    }
}

