/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.sshsftpservice.maverickfacade.impl;

import com.maverick.sftp.SftpFile;
import com.maverick.sftp.SftpFileAttributes;
import com.maverick.sftp.SftpStatusException;
import com.maverick.ssh.SshException;
import java.text.DateFormat;
import java.util.Date;
import java.util.EnumSet;
import se.ericsson.cello.emt.sshsftpservice.FileAttributes;
import se.ericsson.cello.emt.sshsftpservice.FileType;
import se.ericsson.cello.emt.sshsftpservice.Permission;
import se.ericsson.cello.emt.sshsftpservice.exception.EmSshException;
import se.ericsson.security.utils.EmLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileAttributesMav
implements FileAttributes {
    private static final EmLogger LOG = EmLogger.SSH_SFTP_SERVICE;
    private static final String INITIALIZATION_EXCEPTION = "Exception when reading file attributes.";
    private Date created = null;
    private String gid = null;
    private Date modified = null;
    private String name = null;
    private EnumSet<Permission> permissions = null;
    private long size;
    private FileType type = null;
    private String uid = null;

    public FileAttributesMav(SftpFile file) throws EmSshException {
        this.name = file.getFilename();
        try {
            SftpFileAttributes fileAttr = file.getAttributes();
            this.created = fileAttr.getCreationDateTime();
            if (fileAttr.hasGID()) {
                this.gid = fileAttr.getGID();
            }
            this.modified = fileAttr.getModifiedDateTime();
            long longPermission = fileAttr.getPermissions().longValue();
            this.permissions = this.convertLongPermission2EnumSetPermission(longPermission);
            if (fileAttr.hasSize()) {
                this.size = fileAttr.getSize().longValue();
            }
            this.type = this.convertIntFileType2EnumFileType(longPermission);
            if (fileAttr.hasUID()) {
                this.uid = fileAttr.getUID();
            }
        }
        catch (SftpStatusException e) {
            LOG.warning(INITIALIZATION_EXCEPTION, new Object[0]);
            throw new EmSshException(INITIALIZATION_EXCEPTION, e);
        }
        catch (SshException e) {
            LOG.warning(INITIALIZATION_EXCEPTION, new Object[0]);
            throw new EmSshException(INITIALIZATION_EXCEPTION, e);
        }
    }

    @Override
    public Date getCreated() {
        return this.created;
    }

    @Override
    public String getGid() {
        return this.gid;
    }

    @Override
    public Date getModified() {
        return this.modified;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public EnumSet<Permission> getPermissions() {
        return this.permissions;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public FileType getType() {
        return this.type;
    }

    @Override
    public String getTypeAndPermissionsAsString() {
        String strFileType = "";
        FileType fileType = this.getType();
        if (fileType != null) {
            strFileType = fileType.STR_NOTATION;
        }
        String permissions = this.convertPermissions2String();
        StringBuilder strB = new StringBuilder("");
        if (null != strFileType) {
            strB.append(strFileType);
        } else {
            LOG.fine("FileType as String was null", new Object[0]);
        }
        strB.append(permissions);
        return strB.toString();
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public String toString() {
        String typeAndPermissions = this.getTypeAndPermissionsAsString();
        String uid = this.getUid();
        String gid = this.getGid();
        Long size = this.getSize();
        Date modified = this.getModified();
        String name = this.getName();
        StringBuilder strB = new StringBuilder("");
        if (typeAndPermissions != null) {
            strB.append(typeAndPermissions);
        }
        if (uid != null) {
            strB.append(" ");
            strB.append(uid);
        }
        if (gid != null) {
            strB.append(" ");
            strB.append(gid);
        }
        if (size != null) {
            strB.append(" ");
            strB.append(size);
        }
        if (modified != null) {
            strB.append(" ");
            strB.append(DateFormat.getInstance().format(modified));
        }
        if (name != null) {
            strB.append(" ");
            strB.append(name);
        }
        return strB.toString();
    }

    private FileType convertIntFileType2EnumFileType(long longPermission) {
        for (FileType fileType : FileType.values()) {
            if ((longPermission & (long)fileType.BIT_MASK) != (long)fileType.BIT_MASK) continue;
            return fileType;
        }
        return null;
    }

    private EnumSet<Permission> convertLongPermission2EnumSetPermission(long longPermission) {
        EnumSet<Permission> permissions = EnumSet.noneOf(Permission.class);
        for (Permission permission : Permission.values()) {
            if ((longPermission & (long)permission.BIT_MASK) != (long)permission.BIT_MASK) continue;
            permissions.add(permission);
        }
        return permissions;
    }

    private String convertPermissions2String() {
        StringBuilder sb = new StringBuilder();
        if (this.permissions != null) {
            for (Permission permission : Permission.values()) {
                sb.append(this.permissions.contains((Object)permission) ? permission.STR_NOTATION : "-");
            }
        }
        return sb.toString();
    }
}

