/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.cmaaue.from;

import se.ericsson.cello.aueframework.collector.CollectorContext;
import se.ericsson.cello.aueframework.collector.DataCollectorAction;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.cmaaue.from.Constants;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StructAttribute;
import se.ericsson.cello.transaction.Coordinator;

public class SaveActiveSwAllocationAction
implements DataCollectorAction,
Constants {
    private static final String ACTIVE_SWA_CAPITALIZED = "ActiveSwAllocation";

    public void perform(CollectorContext collectorContext, Coordinator coordinator, String string) throws AueException {
        collectorContext.getLogger().trace(4, this.getClass(), "Running action");
        SequenceAttribute sequenceAttribute = new SequenceAttribute("activeSwAllocMos", false);
        MoIterator moIterator = collectorContext.getMoAccessor().lookupType("Slot");
        if (moIterator != null) {
            ManagedObject managedObject = null;
            ManagedObject managedObject2 = null;
            collectorContext.getLogger().trace(4, this.getClass(), "Collecting Slot Mos data");
            while (moIterator.hasMoreElements()) {
                try {
                    managedObject = moIterator.nextMo();
                    try {
                        managedObject2 = (ManagedObject)managedObject.getAttribute(ACTIVE_SWA_CAPITALIZED, coordinator);
                    }
                    catch (NoSuchAttributeException noSuchAttributeException) {
                        managedObject2 = (ManagedObject)managedObject.getAttribute("SwAllocation", coordinator);
                    }
                }
                catch (MoAccessException moAccessException) {
                    throw new AueException("Exception caught while trying to get activeSwAllocation for slot " + managedObject.getLocalDistinguishedName() + ", Transaction=" + coordinator.getTransactionID(), (Throwable)moAccessException);
                }
                this.collectData(managedObject, managedObject2, sequenceAttribute);
            }
        }
        collectorContext.getDataWriter().writeData((Attribute)sequenceAttribute, collectorContext, coordinator);
        collectorContext.getLogger().trace(4, this.getClass(), "Done.");
    }

    private void collectData(ManagedObject managedObject, ManagedObject managedObject2, SequenceAttribute sequenceAttribute) {
        StructAttribute structAttribute = new StructAttribute("", false);
        structAttribute.addElement((Attribute)new ReferenceAttribute("Slot", managedObject.getLocalDistinguishedName(), false));
        structAttribute.addElement((Attribute)new ReferenceAttribute("SwAllocation", managedObject2 != null ? managedObject2.getLocalDistinguishedName() : null, false));
        sequenceAttribute.addElement((Attribute)structAttribute);
    }
}

