/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.AbstractAntennaSystemCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.AntennaSystemCIComponent;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.RetProfilesRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.RetRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.resource.AretuCascadeRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.resource.AretuRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.util.UniqueHwIdCasecadeParamUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.util.AIRUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.SectorUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterImpl;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterServer;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.StringParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.StringRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.YesNoCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.AtfProvider;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.exception.BemRuntimeException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAuxPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRetDevice;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRetDeviceSet;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRetuDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.moi.ChildWithAttributeValues;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public class RetCIComponent
extends AntennaSystemCIComponent {
    private static final String AUTO_CREATED_RDNID_1 = "1";
    private static final String AUTO_CREATED_RDNID_2 = "2";
    private static final String AUTO_CREATED_RDNID_AUXPIU_AIR = "AIR-1";
    private static final String AUTO_CREATED_RDNID_DeviceGroup_AIR = "AIR";
    protected static final String NONE = "NONE";
    protected static final String ARETU = "ARETU";
    protected static final String RETU = "RETU";
    protected static final String ARET = "ARET";
    public static final String ARETU_CASCADE = "ARETU_CASCADE";
    public static final String NONE_RET_FOR_AIR = "ARETU";
    public static final String UNIQUEHWID_VALUE_A1 = "A1";
    public static final String UNIQUEHWID_VALUE_LINE = "-";
    public static final String UNIQUEHWID_VALUE_B1 = "B1";
    public static final String UNIQUEHWID_VALUE_B2 = "B2";
    public static final String UNIQUEHWID_VALUE_P1 = "P1";
    public static final String UNIQUEHWID_VALUE_P2 = "P2";
    public static final String UNIQUEHWID_VALUE_P3 = "P3";
    public static final String UNIQUEHWID_VALUE_P4 = "P4";
    public static final String UNIQUEHWID_VALUE_P5 = "P5";
    public static final String UNIQUEHWID_VALUE_BLANK = "";
    private ParameterRestriction[] retRestriction;
    private ParameterRestriction[][] eAntennaTiltRestriction;
    private ParameterRestriction[][] uniqueHwIdRestriction;
    private ParameterRestriction[][] maxTiltRestriction;
    private ParameterRestriction[][] minTiltRestriction;
    private ParameterRestriction[][] rangeRetRestriction;
    private final String[] retTypeRangeComplete = new String[]{"NONE", "ARETU", "RETU", "ARETU_CASCADE"};
    private final String[] retTypeRange = new String[]{"NONE", "ARETU", "RETU"};
    private final String[] retTypeRangeCompleteWithATMA = new String[]{"NONE", "ARETU", "ARETU_CASCADE"};
    private final String[] retTypeRangeWithATMA = new String[]{"NONE", "ARETU"};
    private final String[] retTypeRangeWithPSI = new String[]{"NONE", "ARETU"};
    private final String[] retTypeRangeWithAIR = new String[]{"ARETU", "ARETU_CASCADE"};
    private final String[] uniqueHwIdRangeForAir = new String[]{"A1", "P1", "B1", "B2", "-"};
    private final String[] uniqueHwIdRangeForAir_ActiveRet = new String[]{"", "A1", "B1", "B2", "-"};
    private final String[] uniqueHwIdRangeForAir_PassiveRet = new String[]{"", "P1", "P2", "P3", "P4", "P5", "B1", "B2"};
    private RetRI[][] ret;
    private RetRI[][] aretu;
    public AretuCascadeRI[][][] aretuCascade;
    private RetProfilesRI retProfile;
    private YesNoCustomerParameter[] retParam;
    private IntegerParameter[][] elTiltParam;
    private Enumeration[][] uniqueHwIdParam;
    public IntegerParameter[][][] elTiltCascadedParam;
    public CustomerParameterImpl[][][] uniqueHwIdCascadedParam;
    public Enumeration[][] typeOfRetParam;
    public IntegerParameter[][] maxTiltParam;
    public IntegerParameter[][] minTiltParam;
    private String[][] retuMois;
    private String[][] retMois;
    private String[][] aretuMois;
    private String[][] aretMois;
    private String[][][] aretuCascadeMois;
    private String[][][] aretCascadeMois;
    private Map isAirConfiguredMap = new HashMap();
    private final int maxSequenceNumber = this.rbs.getMaxNumberOfSequences();
    private int maxNoOfSectorAntennasPerSector = this.as.getMaxNoOfSectorAntennasPerSector();
    private static final int ANTENNA_TYPE_VALUE_CFG = 50;
    static /* synthetic */ Class class$se$ericsson$wcdma$rbs$bem$common$config$custparam$Enumeration;
    static /* synthetic */ Class class$se$ericsson$wcdma$rbs$bem$common$config$custparam$StringParameter;

    public RetCIComponent(AbstractAntennaSystemCI abstractAntennaSystemCI, boolean bl) {
        this(abstractAntennaSystemCI, bl, 1);
    }

    public RetCIComponent(AbstractAntennaSystemCI abstractAntennaSystemCI, boolean bl, int n) {
        super(abstractAntennaSystemCI, bl, n);
        this.initCustomerParams();
    }

    private void initCustomerParams() {
        if (!this.isThisCicSupported) {
            return;
        }
        this.retRestriction = new ParameterRestriction[this.maxNoOfSectors];
        this.eAntennaTiltRestriction = new ParameterRestriction[this.maxNoOfSectors][this.maxNoOfSectorAntennasPerSector];
        this.uniqueHwIdRestriction = new ParameterRestriction[this.maxNoOfSectors][this.maxNoOfSectorAntennasPerSector];
        this.maxTiltRestriction = new ParameterRestriction[this.maxNoOfSectors][this.maxNoOfSectorAntennasPerSector];
        this.minTiltRestriction = new ParameterRestriction[this.maxNoOfSectors][this.maxNoOfSectorAntennasPerSector];
        this.retParam = new YesNoCustomerParameter[this.maxNoOfSectors];
        this.elTiltParam = new IntegerParameter[this.maxNoOfSectors][this.maxNoOfSectorAntennasPerSector];
        this.uniqueHwIdParam = new Enumeration[this.maxNoOfSectors][this.maxNoOfSectorAntennasPerSector];
        this.elTiltCascadedParam = new IntegerParameter[this.maxNoOfSectors][this.maxNoOfSectorAntennasPerSector][this.maxSequenceNumber];
        this.uniqueHwIdCascadedParam = new CustomerParameterImpl[this.maxNoOfSectors][this.maxNoOfSectorAntennasPerSector][this.maxSequenceNumber];
        this.typeOfRetParam = new Enumeration[this.maxNoOfSectors][this.maxNoOfSectorAntennasPerSector];
        this.rangeRetRestriction = new ParameterRestriction[this.maxNoOfSectors][this.maxNoOfSectorAntennasPerSector];
        this.maxTiltParam = new IntegerParameter[this.maxNoOfSectors][this.maxNoOfSectorAntennasPerSector];
        this.minTiltParam = new IntegerParameter[this.maxNoOfSectors][this.maxNoOfSectorAntennasPerSector];
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            this.retRestriction[i] = new ParameterRestriction("RET does not exist", 1);
            for (int j = 0; j < this.maxNoOfSectorAntennasPerSector; ++j) {
                this.eAntennaTiltRestriction[i][j] = new ParameterRestriction("RET is not used", 1);
                this.uniqueHwIdRestriction[i][j] = new ParameterRestriction("CASCADED_RET is not used for AIR", 1);
                this.maxTiltRestriction[i][j] = new ParameterRestriction("max tilt", 1);
                this.minTiltRestriction[i][j] = new ParameterRestriction("min tilt", 1);
                this.rangeRetRestriction[i][j] = new ParameterRestriction("Range for ret type");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setElectricalAntennaTiltRestriction(String string, int n, int n2) {
        int n3;
        block3: {
            block2: {
                n3 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
                if (string.equals(RETU) || string.equals("ARETU")) break block2;
                if (!AIRUtil.getInstance(this.rbs).isAirConfigured(n)) break block3;
                if (!string.equals("ARETU")) break block3;
            }
            this.eAntennaTiltRestriction[n3][n2].setAccessLevel(3);
            return;
        }
        this.eAntennaTiltRestriction[n3][n2].setAccessLevel(1);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setUniqueHwIdRestriction(String string, int n, int n2) {
        int n3 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        if (AIRUtil.getInstance(this.rbs).isAirConfigured(n)) {
            if (string.equals("ARETU")) {
                this.uniqueHwIdRestriction[n3][n2].setAccessLevel(3);
                return;
            }
        }
        this.uniqueHwIdRestriction[n3][n2].setAccessLevel(1);
    }

    protected void setMaxAndMinTiltRestriction(String string, int n, int n2, int n3) {
        int n4 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        if (string.equals("ARETU") && n3 > 50) {
            this.maxTiltRestriction[n4][n2].setAccessLevel(2);
            this.minTiltRestriction[n4][n2].setAccessLevel(2);
        } else {
            this.maxTiltRestriction[n4][n2].setAccessLevel(1);
            this.minTiltRestriction[n4][n2].setAccessLevel(1);
        }
    }

    private void setAntennaTypeRestriction(String string, int n, int n2) {
        int n3 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        if (string.equals(ARETU_CASCADE)) {
            this.as.setAntennaTypeRestriction(n3, n2, 1);
        } else {
            this.as.setAntennaTypeRestriction(n3, n2, 3);
        }
    }

    private void setMechanicalTiltRestriction(String string, int n, int n2) {
        int n3 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        if (string.equals(ARETU_CASCADE)) {
            this.as.setMechanicalTiltRestriction(n3, n2, 1);
        } else {
            this.as.setMechanicalTiltRestriction(n3, n2, 3);
        }
    }

    public void createCustomerParameters(String string, int n) throws BemException {
        if (!this.isThisCicSupported) {
            return;
        }
        if (this.as.radioEP.isExternalOutputPowerUsed()) {
            this.retRestriction[n].setAccessLevel(1);
        } else {
            this.retRestriction[n].setAccessLevel(3);
        }
        this.createRetCP(string, n);
        this.createCascadedRetCP(n);
        for (int i = 0; i < this.maxNoOfSectorAntennasPerSector; ++i) {
            if (this.as.tmaParam[n][i] == null) continue;
            this.as.tmaParam[n][i].addCustomerParameterListener(new TmaListener(SectorUtil.getSectorNumberFromSectorIndex(n, this.startingSectorNumber), i + 1));
        }
    }

    public void createRetCP(String string, int n) {
        if (!this.isThisCicSupported) {
            return;
        }
        String string2 = UNIQUEHWID_VALUE_BLANK;
        string2 = string + "configureRet";
        this.retParam[n] = new YesNoCustomerParameter(string2);
        this.retParam[n].setDefaultValue("NO");
        this.retParam[n].addRestriction(this.as.sectorUsedRestriction[n]);
        this.retParam[n].addRestriction(this.retRestriction[n]);
        this.as.addParameter(this.retParam[n]);
        for (int i = 0; i < this.maxNoOfSectorAntennasPerSector; ++i) {
            int n2 = i + 1;
            string2 = BemUtil.getCustomerParameterName(string, "electricalTilt", n2);
            IntegerRange integerRange = new IntegerRange(MimRetDevice.MIN_ELECTRICALANTENNATILT, MimRetDevice.MAX_ELECTRICALANTENNATILT);
            this.elTiltParam[n][i] = new IntegerParameter(string2, integerRange);
            this.elTiltParam[n][i].setDefaultValue(MimRetDevice.DEFAULT_ELECTRICALANTENNATILT.toString());
            this.elTiltParam[n][i].addRestriction(this.as.sectorUsedRestriction[n]);
            this.elTiltParam[n][i].addRestriction(this.eAntennaTiltRestriction[n][i]);
            this.as.addParameter(this.elTiltParam[n][i]);
            string2 = BemUtil.getCustomerParameterName(string, "uniqueHwId", n2);
            this.uniqueHwIdParam[n][i] = new Enumeration(string2, Enumeration.newEnumeratedValueRange(this.uniqueHwIdRangeForAir));
            this.uniqueHwIdParam[n][i].setDefaultValue(UNIQUEHWID_VALUE_A1);
            this.uniqueHwIdParam[n][i].addRestriction(this.as.sectorUsedRestriction[n]);
            this.uniqueHwIdParam[n][i].addRestriction(this.uniqueHwIdRestriction[n][i]);
            this.as.addParameter(this.uniqueHwIdParam[n][i]);
            string2 = BemUtil.getCustomerParameterName(string, "typeOfRet", n2);
            this.typeOfRetParam[n][i] = new Enumeration(string2, Enumeration.newEnumeratedValueRange(this.retTypeRangeComplete));
            int n3 = SectorUtil.getSectorNumberFromSectorIndex(n, this.startingSectorNumber);
            if (AIRUtil.getInstance(this.rbs).isAirConfigured(n3) && i == 0) {
                this.typeOfRetParam[n][i].setDefaultValue("ARETU");
                this.typeOfRetParam[n][i].setLoadedValue("ARETU");
            } else {
                this.typeOfRetParam[n][i].setDefaultValue(NONE);
                this.typeOfRetParam[n][i].setLoadedValue(NONE);
            }
            this.typeOfRetParam[n][i].addRestriction(this.rangeRetRestriction[n][i]);
            this.typeOfRetParam[n][i].addRestriction(this.as.sectorUsedRestriction[n]);
            this.typeOfRetParam[n][i].addCustomerParameterListener(new TypeOfRetListener(this, n, i));
            this.as.addParameter(this.typeOfRetParam[n][i]);
            string2 = BemUtil.getCustomerParameterName(string, "maxTilt", n2);
            integerRange = new IntegerRange(MimRetDevice.MIN_MAXTILT, MimRetDevice.MAX_MAXTILT);
            this.maxTiltParam[n][i] = new IntegerParameter(string2, integerRange);
            this.maxTiltParam[n][i].addRestriction(this.as.sectorUsedRestriction[n]);
            this.maxTiltParam[n][i].addRestriction(this.maxTiltRestriction[n][i]);
            this.maxTiltParam[n][i].setDefaultValue("-1");
            this.maxTiltParam[n][i].addCustomerParameterListener(new TypeOfRetListener(this, n, i));
            this.as.addParameter(this.maxTiltParam[n][i]);
            string2 = BemUtil.getCustomerParameterName(string, "minTilt", n2);
            integerRange = new IntegerRange(MimRetDevice.MIN_MINTILT, MimRetDevice.MAX_MINTILT);
            this.minTiltParam[n][i] = new IntegerParameter(string2, integerRange);
            this.minTiltParam[n][i].addRestriction(this.as.sectorUsedRestriction[n]);
            this.minTiltParam[n][i].addRestriction(this.minTiltRestriction[n][i]);
            this.minTiltParam[n][i].setDefaultValue("-1");
            this.minTiltParam[n][i].addCustomerParameterListener(new TypeOfRetListener(this, n, i));
            this.as.addParameter(this.minTiltParam[n][i]);
        }
    }

    protected void createCascadedRetCP(int n) {
        for (int i = 0; i < this.maxNoOfSectorAntennasPerSector; ++i) {
            this.createCascadedRetCPForSectorAntenna(n, i);
        }
    }

    protected void createCascadedRetCPForSectorAntenna(int n, int n2) {
        String string = AbstractAntennaSystemCI.getSectorPrefix(SectorUtil.getSectorNumberFromSectorIndex(n, this.startingSectorNumber));
        String string2 = string + "configureRet";
        for (int i = 1; i <= this.maxSequenceNumber; ++i) {
            string2 = string + AbstractAntennaSystemCI.getSequencePrefix(i) + "electricalTilt" + (n2 == 0 ? UNIQUEHWID_VALUE_BLANK : String.valueOf(n2 + 1));
            IntegerRange integerRange = new IntegerRange(MimRetDevice.MIN_ELECTRICALANTENNATILT, MimRetDevice.MAX_ELECTRICALANTENNATILT);
            this.elTiltCascadedParam[n][n2][i - 1] = new IntegerParameter(string2, integerRange);
            this.as.addParameter(this.elTiltCascadedParam[n][n2][i - 1]);
            string2 = string + AbstractAntennaSystemCI.getSequencePrefix(i) + "uniqueHwId" + (n2 == 0 ? UNIQUEHWID_VALUE_BLANK : String.valueOf(n2 + 1));
            this.createUniqueHwIdCasecadeParam(string2, n, i, n2);
            this.as.addParameter(this.uniqueHwIdCascadedParam[n][n2][i - 1]);
        }
    }

    private void createUniqueHwIdCasecadeParam(String string, int n, int n2, int n3) {
        Boolean bl = (Boolean)this.isAirConfiguredMap.get(new Integer(n));
        if (Boolean.TRUE.equals(bl)) {
            String[] stringArray = n2 == 1 ? this.uniqueHwIdRangeForAir_ActiveRet : this.uniqueHwIdRangeForAir_PassiveRet;
            this.uniqueHwIdCascadedParam[n][n3][n2 - 1] = new Enumeration(string, stringArray);
        } else {
            StringRange stringRange = new StringRange(MimAuxPlugInUnit.MINLEN_UNIQUEHWID, MimAuxPlugInUnit.MAXLEN_UNIQUEHWID);
            this.uniqueHwIdCascadedParam[n][n3][n2 - 1] = new StringParameter(string, stringRange);
        }
        UniqueHwIdCasecadeParamUtil.addCustomerParameter(n, n3, n2 - 1, this.uniqueHwIdCascadedParam[n][n3][n2 - 1]);
    }

    public void setUniqueHwIdCasecadeParamRange(int n, int n2, boolean bl) throws BemException {
        int n3 = SectorUtil.getSectorIndexFromSectorNumber(n2, this.startingSectorNumber);
        this.isAirConfiguredMap.put(new Integer(n3), bl);
        for (int i = 0; i < n; ++i) {
            for (int j = 1; j <= this.maxSequenceNumber; ++j) {
                CustomerParameter customerParameter;
                if (this.uniqueHwIdCascadedParam[n3][i][j - 1] == null) continue;
                String string = this.uniqueHwIdCascadedParam[n3][i][j - 1].getName();
                if (bl) {
                    if (!(this.uniqueHwIdCascadedParam[n3][i][j - 1] instanceof Enumeration)) {
                        this.as.removeParameter(this.uniqueHwIdCascadedParam[n3][i][j - 1]);
                        customerParameter = UniqueHwIdCasecadeParamUtil.getCustomerParameter(n3, i, j - 1, class$se$ericsson$wcdma$rbs$bem$common$config$custparam$Enumeration == null ? RetCIComponent.class$("se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration") : class$se$ericsson$wcdma$rbs$bem$common$config$custparam$Enumeration);
                        if (customerParameter != null) {
                            this.uniqueHwIdCascadedParam[n3][i][j - 1] = (CustomerParameterImpl)customerParameter;
                        } else {
                            this.createUniqueHwIdCasecadeParam(string, n3, j, i);
                        }
                    }
                } else if (!(this.uniqueHwIdCascadedParam[n3][i][j - 1] instanceof StringParameter)) {
                    this.as.removeParameter(this.uniqueHwIdCascadedParam[n3][i][j - 1]);
                    customerParameter = UniqueHwIdCasecadeParamUtil.getCustomerParameter(n3, i, j - 1, class$se$ericsson$wcdma$rbs$bem$common$config$custparam$StringParameter == null ? RetCIComponent.class$("se.ericsson.wcdma.rbs.bem.common.config.custparam.StringParameter") : class$se$ericsson$wcdma$rbs$bem$common$config$custparam$StringParameter);
                    if (customerParameter != null) {
                        this.uniqueHwIdCascadedParam[n3][i][j - 1] = (CustomerParameterImpl)customerParameter;
                    } else {
                        this.createUniqueHwIdCasecadeParam(string, n3, j, i);
                    }
                }
                if (this.as.isParameterSupported(string)) continue;
                this.as.addParameter(this.uniqueHwIdCascadedParam[n3][i][j - 1]);
            }
        }
    }

    protected void deleteCascadedRetCP(int n, int n2) {
        int n3 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        for (int i = 1; i <= this.maxSequenceNumber; ++i) {
            if (this.elTiltCascadedParam[n3][n2 - 1][i - 1] != null) {
                this.as.removeParameter(this.elTiltCascadedParam[n3][n2 - 1][i - 1]);
                this.elTiltCascadedParam[n3][n2 - 1][i - 1] = null;
            }
            if (this.uniqueHwIdCascadedParam[n3][n2 - 1][i - 1] == null) continue;
            this.as.removeParameter(this.uniqueHwIdCascadedParam[n3][n2 - 1][i - 1]);
            this.uniqueHwIdCascadedParam[n3][n2 - 1][i - 1] = null;
            UniqueHwIdCasecadeParamUtil.removeCustomerParameter(n3, n2 - 1, i - 1);
        }
    }

    public boolean checkConsistency(int n) throws CustomerParameterException {
        if (!this.isThisCicSupported) {
            return true;
        }
        try {
            if (this.as.sectorExist(n) && this.as.sectorEquipped(n)) {
                boolean bl;
                int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
                boolean bl2 = false;
                if (this.retParam[n2] != null) {
                    String string = this.retParam[n2].getValue();
                    String string2 = this.retParam[n2].getLoadedValue();
                    if (!string2.equals(string)) {
                        bl2 = true;
                    }
                }
                if (bl2 && !(bl = this.as.cellCarrP.areCellsOffline(n))) {
                    return false;
                }
            }
        }
        catch (BemException bemException) {
            throw new CustomerParameterException(bemException.toString(), null);
        }
        return true;
    }

    public void checkConsistency(List list) throws CustomerParameterException, BemException {
        boolean bl = true;
        String string = null;
        CustomerParameterServer customerParameterServer = null;
        int[] nArray = this.as.radioEP.getEquippedSectors();
        for (int i = 0; i < nArray.length && bl; ++i) {
            if (!this.as.cellCarrP.isSectorInUse(nArray[i])) continue;
            String string2 = AbstractAntennaSystemCI.getSectorPrefix(nArray[i]);
            try {
                int n;
                int n2;
                String string3 = null;
                String string4 = null;
                String string5 = null;
                int[] nArray2 = new int[this.maxNoOfSectorAntennasPerSector];
                int[] nArray3 = new int[this.maxNoOfSectorAntennasPerSector];
                int[] nArray4 = new int[this.maxNoOfSectorAntennasPerSector];
                for (n2 = 0; n2 < this.maxNoOfSectorAntennasPerSector; ++n2) {
                    n = n2 + 1;
                    string3 = BemUtil.getCustomerParameterName(string2, "maxTilt", n);
                    string4 = BemUtil.getCustomerParameterName(string2, "minTilt", n);
                    string5 = BemUtil.getCustomerParameterName(string2, "antennaType", n);
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (list.contains(string3)) {
                        customerParameterServer = this.rbs.getCustomerParameterServerObject(string3);
                        if (!((String)customerParameterServer.getValueMom()).equals("##UNDEFINED")) {
                            nArray2[n2] = Integer.valueOf((String)customerParameterServer.getValueMom());
                        }
                        bl2 = customerParameterServer.hasValueChanged();
                    }
                    if (list.contains(string4)) {
                        customerParameterServer = this.rbs.getCustomerParameterServerObject(string4);
                        if (!((String)customerParameterServer.getValueMom()).equals("##UNDEFINED")) {
                            nArray3[n2] = Integer.valueOf((String)customerParameterServer.getValueMom());
                        }
                        bl3 = customerParameterServer.hasValueChanged();
                    }
                    if (!bl2 && !bl3 || !list.contains(string5)) continue;
                    customerParameterServer = this.rbs.getCustomerParameterServerObject(string5);
                    Integer n3 = Integer.valueOf((String)customerParameterServer.getValueMom());
                    if (n3 <= 50) {
                        bl = false;
                        string = "Value of " + string5 + "should be above 50, while " + string3 + " and " + string4 + " are configured.";
                        break;
                    }
                    nArray4[n2] = Integer.valueOf((String)customerParameterServer.getValueMom());
                }
                if (!bl) break;
                for (n2 = 0; n2 < this.maxNoOfSectorAntennasPerSector; ++n2) {
                    for (n = n2 + 1; n < this.maxNoOfSectorAntennasPerSector; ++n) {
                        if (nArray2[n2] == nArray2[n] && nArray3[n2] == nArray3[n] || nArray4[n2] != nArray4[n]) continue;
                        bl = false;
                        string = "Value of antennaType should be different in sector= " + nArray[i] + ", antenna= " + n2 + " and in sector= " + nArray[i] + ", antenna= " + n;
                        break;
                    }
                    if (!bl) break;
                }
                if (bl) continue;
                break;
            }
            catch (BemException bemException) {
                throw new CustomerParameterException(string, (CustomerParameter)((Object)customerParameterServer));
            }
        }
        if (!bl) {
            throw new CustomerParameterException(string, (CustomerParameter)((Object)customerParameterServer));
        }
    }

    public void checkUniqueHwIdConsistency() throws BemException {
        if (this.uniqueHwIdCascadedParam != null) {
            for (int i = 0; i < this.maxNoOfSectors; ++i) {
                int n = i + 1;
                boolean bl = AIRUtil.getInstance(this.rbs).isNodeConfiguredWithAir(n);
                Vector<String> vector = new Vector<String>();
                String string = null;
                for (int j = 1; j < this.rbs.getAntennaSystemProvider().getNumOfSectorAntennas(n); ++j) {
                    if (this.typeOfRetParam != null && this.typeOfRetParam[i][j].getValue().equals(ARETU_CASCADE)) {
                        for (int k = 1; k <= this.maxSequenceNumber; ++k) {
                            if (this.uniqueHwIdCascadedParam[i][j][k - 1] == null) continue;
                            string = this.uniqueHwIdCascadedParam[i][j][k - 1].getValue();
                            this.checkUniquHwidConsistencyForAir(bl, n, j, k, string);
                            if (vector.contains(string)) {
                                BemException bemException = new BemException();
                                bemException.setProperty("Problem", "The value uniqueHwId in sector " + SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber) + ", sequence " + k + " already exists.\nAll uniqueHwIds needs to be different in one sector.");
                                throw bemException;
                            }
                            if (string.equals("##UNDEFINED") || string.equals(UNIQUEHWID_VALUE_BLANK)) continue;
                            vector.add(string);
                        }
                        continue;
                    }
                    if (this.uniqueHwIdParam[i][j] == null) continue;
                    string = this.uniqueHwIdParam[i][j].getValue();
                    this.checkUniquHwidConsistencyForAir(bl, n, j, 1, string);
                }
            }
        }
    }

    public void createRIs(int n) throws BemException {
        if (!this.isThisCicSupported) {
            return;
        }
        this.createRetRI(n);
    }

    public void createRetRI(int n) throws BemException {
        if (!this.isThisCicSupported) {
            return;
        }
        if (this.ret == null) {
            this.ret = new RetRI[this.maxNoOfSectors][this.maxNoOfSectorAntennasPerSector];
        }
        if (this.aretu == null) {
            this.aretu = new RetRI[this.maxNoOfSectors][this.maxNoOfSectorAntennasPerSector];
        }
        if (this.aretuCascade == null) {
            this.aretuCascade = new AretuCascadeRI[this.maxNoOfSectors][this.maxNoOfSectorAntennasPerSector][this.maxSequenceNumber];
        }
        String string = this.getRetAtfRole(n);
        int n2 = this.as.getNumOfSectorAntennas(n);
        int n3 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        for (int i = 0; i < n2; ++i) {
            this.ret[n3][i] = new RetRI(this.rbs, n, this.retuMois[n3][i], this.retMois[n3][i], string, i + 1);
            this.ret[n3][i].setLoadedValues();
            this.aretu[n3][i] = new AretuRI(this.rbs, n, this.aretuMois[n3][i], this.aretMois[n3][i], string, i + 1);
            this.aretu[n3][i].setLoadedValues();
            if (i == 0 || i == 1 && SectorUtil.isRrus32WithRbb441d(this.rbs, n)) {
                this.createCascadedRetRIs(n, i);
            }
            String string2 = this.typeOfRetParam[n3][i].getValue();
            int n4 = 0;
            if (this.as.antennaTypeParam[n3][i] != null) {
                Integer n5 = Integer.valueOf(this.as.antennaTypeParam[n3][i].getValue());
                n4 = n5;
            }
            this.setUniqueHwIdRestriction(string2, n, i);
            this.setElectricalAntennaTiltRestriction(string2, n, i);
            this.setAntennaTypeRestriction(string2, n, i);
            this.setMechanicalTiltRestriction(string2, n, i);
            this.setMaxAndMinTiltRestriction(string2, n, i, n4);
        }
    }

    protected void createCascadedRetRIs(int n, int n2) {
        for (int i = 1; i <= this.maxSequenceNumber; ++i) {
            String string = AbstractAntennaSystemCI.getSequencePrefix(i);
            try {
                String string2 = this.getRetAtfRole(n);
                int n3 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
                if (i == 1) {
                    this.aretuCascade[n3][n2][i - 1] = new AretuCascadeRI(this.rbs, n, this.aretuMois[n3][n2], this.aretMois[n3][n2], string2, false, n2 + 1);
                    this.aretuCascade[n3][n2][i - 1].setLoadedValues();
                    continue;
                }
                this.aretuCascade[n3][n2][i - 1] = new AretuCascadeRI(this.rbs, n, string, this.aretuCascadeMois[n3][n2][i - 2], this.aretCascadeMois[n3][n2][i - 2], string2, true, n2 + 1);
                this.aretuCascade[n3][n2][i - 1].setLoadedValues();
                continue;
            }
            catch (BemException bemException) {
                throw new BemRuntimeException("Error while creating cascaded RETs for sector " + n + ", sequence " + i + ". Customer Parameter UniqueHwId might not have ben created.", bemException);
            }
        }
    }

    public void createRetProfileRI() throws BemException {
        if (!this.isThisCicSupported) {
            return;
        }
        this.retProfile = new RetProfilesRI(this.rbs);
        this.retProfile.updateLoadedValues();
        this.addRetProfileParameters();
    }

    private void addRetProfileParameters() {
        List list = this.retProfile.getLoadedCustomerParameters();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.as.addParameter((CustomerParameter)iterator.next());
        }
    }

    public void importRetProfiles(ServiceValue serviceValue) {
        if (this.retProfile != null) {
            this.retProfile.importRetProfiles(serviceValue);
        }
    }

    public List getRIsToInstall() throws BemException {
        ArrayList<AbstractResourceItem> arrayList = new ArrayList<AbstractResourceItem>();
        if (!this.isThisCicSupported) {
            return arrayList;
        }
        int[] nArray = this.as.radioEP.getEquippedSectors();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
            if (!this.as.cellCarrP.isSectorInUse(n)) continue;
            if (this.ret == null || this.ret[n2] == null || this.aretu == null || this.aretu[n2] == null || this.aretuCascade == null || this.aretuCascade[n2] == null || AIRUtil.getInstance(this.rbs).isAirConfigured(n) != AIRUtil.getInstance(this.rbs).isNodeConfiguredWithAir(n)) {
                this.initialiseMoiResources(n2, false);
                try {
                    this.createRetRI(n);
                }
                catch (Exception exception) {
                    throw new BemException("RetCIComponent.getNeededRIs", (Throwable)exception);
                }
            }
            for (int j = 0; j < this.as.getNumOfSectorAntennas(n); ++j) {
                RetRI retRI;
                String string;
                block13: {
                    block12: {
                        string = this.typeOfRetParam[n2][j].getValue();
                        if (string.equals(RETU) || string.equals("RET")) break block12;
                        if (!AIRUtil.getInstance(this.rbs).isAirConfigured(n)) break block13;
                        if (string.equals(ARETU_CASCADE)) break block13;
                    }
                    retRI = this.ret[n2][j];
                    arrayList.add(retRI);
                    continue;
                }
                if (string.equals("ARETU")) {
                    retRI = this.aretu[n2][j];
                    arrayList.add(retRI);
                    continue;
                }
                if (!string.equals(ARETU_CASCADE)) continue;
                for (int k = 1; k <= this.maxSequenceNumber; ++k) {
                    if (this.as.checkExternalAntennaValidation(n, k, j) == 1) continue;
                    retRI = this.aretuCascade[n2][j][k - 1];
                    arrayList.add(retRI);
                }
            }
        }
        if (this.retProfile != null) {
            RetProfilesRI retProfilesRI = this.retProfile;
            arrayList.add(retProfilesRI);
        }
        return arrayList;
    }

    /*
     * Unable to fully structure code
     */
    public List getRIsToUninstall() throws BemException {
        var1_1 = new ArrayList<RetRI>();
        if (!this.isThisCicSupported) {
            return var1_1;
        }
        var2_2 = false;
        for (var4_3 = 0; var4_3 < this.maxNoOfSectors; ++var4_3) {
            var5_5 = SectorUtil.getSectorNumberFromSectorIndex(var4_3, this.startingSectorNumber);
            if (this.as.sectorExist(var5_5) && !this.as.sectorEquipped(var5_5)) {
                for (var6_6 = 0; var6_6 < this.as.getLoadedNumOfSectorAntennas(var5_5); ++var6_6) {
                    if (this.as.sectorAntenna[var4_3][var6_6] == null) continue;
                    var7_7 = this.typeOfRetParam[var4_3][var6_6].getLoadedValue();
                    if (var7_7.equals("NONE")) continue;
                    if (!AIRUtil.getInstance(this.rbs).isNodeConfiguredWithAir(var5_5)) {
                        var3_4 = this.aretu[var4_3][var6_6];
                        var1_1.add(var3_4);
                        var3_4 = this.ret[var4_3][var6_6];
                        var1_1.add(var3_4);
                    }
                    for (var8_9 = 1; var8_9 <= this.maxSequenceNumber && (var6_6 == 0 || var6_6 == 1); ++var8_9) {
                        if (AIRUtil.getInstance(this.rbs).isNodeConfiguredWithAir(var5_5) && var8_9 == 1) continue;
                        var3_4 = this.aretuCascade[var4_3][var6_6][var8_9 - 1];
                        var1_1.add(var3_4);
                    }
                }
                continue;
            }
            if (!this.as.sectorExist(var5_5) || !this.as.sectorEquipped(var5_5)) continue;
            var6_6 = this.as.getLoadedNumOfSectorAntennas(var5_5);
            for (var7_8 = 0; var7_8 < var6_6; ++var7_8) {
                block16: {
                    block15: {
                        if (this.as.sectorAntenna[var4_3][var7_8] == null || this.typeOfRetParam[var4_3][var7_8] == null) continue;
                        var8_11 = this.typeOfRetParam[var4_3][var7_8].getLoadedValue();
                        var9_12 = this.typeOfRetParam[var4_3][var7_8].getValue();
                        if (!var8_11.equals("ARETU")) break block15;
                        if (!var9_12.equals("NONE")) break block15;
                        var3_4 = this.aretu[var4_3][var7_8];
                        var1_1.add(var3_4);
                        break block16;
                    }
                    if (!var8_11.equals("RETU")) ** GOTO lbl-1000
                    if (var9_12.equals("NONE")) {
                        var3_4 = this.ret[var4_3][var7_8];
                        var1_1.add(var3_4);
                    } else if (var8_11.equals("ARETU_CASCADE")) {
                        if (var9_12.equals("NONE")) {
                            var3_4 = this.aretu[var4_3][var7_8];
                            var1_1.add(var3_4);
                            for (var10_14 = 1; var10_14 <= this.maxSequenceNumber; ++var10_14) {
                                var3_4 = this.aretuCascade[var4_3][var7_8][var10_14 - 1];
                                if (var3_4 == null) continue;
                                var1_1.add(var3_4);
                            }
                        }
                    }
                }
                if (var8_11.equals(var9_12)) continue;
                var2_2 = true;
            }
            var7_7 = (CustomerParameterImpl[])this.as.cellCarrP.getNumOfRxBranchesPerCarrierParameter(var5_5);
            for (var8_9 = 0; var8_9 < ((CustomerParameterImpl[])var7_7).length; ++var8_9) {
                var7_7[var8_9];
                if (var7_7[var8_9].getLoadedValue().equals("##UNDEFINED") || (var9_13 = Integer.parseInt(var7_7[var8_9].getLoadedValue())) <= (var10_14 = Integer.parseInt(var7_7[var8_9].getValue()))) continue;
                for (var11_15 = var10_14 / 2; var11_15 < var9_13 / 2; ++var11_15) {
                    if (this.as.sectorAntenna[var4_3][var11_15] == null) continue;
                    var12_16 = this.typeOfRetParam[var4_3][var11_15].getLoadedValue();
                    if (var12_16.equals("NONE")) continue;
                    var3_4 = this.aretu[var4_3][var11_15];
                    var1_1.add(var3_4);
                    var3_4 = this.ret[var4_3][var11_15];
                    var1_1.add(var3_4);
                    for (var13_17 = 1; var13_17 <= this.maxSequenceNumber && var11_15 == 0; ++var13_17) {
                        var3_4 = this.aretuCascade[var4_3][var11_15][var13_17 - 1];
                        var1_1.add(var3_4);
                    }
                }
            }
            if (!var2_2) continue;
            this.as.cellCarrP.requestUninitiateSector(var5_5, this);
            var2_2 = false;
        }
        return var1_1;
    }

    public void initialiseMoiResources() {
        if (!this.isThisCicSupported) {
            return;
        }
        this.retMois = new String[this.maxNoOfSectors][this.maxNoOfSectorAntennasPerSector];
        this.retuMois = new String[this.maxNoOfSectors][this.maxNoOfSectorAntennasPerSector];
        this.aretuMois = new String[this.maxNoOfSectors][this.maxNoOfSectorAntennasPerSector];
        this.aretMois = new String[this.maxNoOfSectors][this.maxNoOfSectorAntennasPerSector];
        this.aretuCascadeMois = new String[this.maxNoOfSectors][this.maxNoOfSectorAntennasPerSector][this.maxSequenceNumber];
        this.aretCascadeMois = new String[this.maxNoOfSectors][this.maxNoOfSectorAntennasPerSector][this.maxSequenceNumber];
    }

    public void initialiseMoiResources(int n) throws BemException {
        this.initialiseMoiResources(n, false);
    }

    public void initialiseMoiResources(int n, boolean bl) throws BemException {
        String string = null;
        String string2 = null;
        String string3 = null;
        if (!this.isThisCicSupported) {
            return;
        }
        for (int i = 0; i < this.maxNoOfSectorAntennasPerSector; ++i) {
            int n2;
            int n3;
            int n4 = SectorUtil.getSectorNumberFromSectorIndex(n, this.startingSectorNumber);
            MoInstance moInstance = this.as.sectorAntennaMois[n][i];
            if (AIRUtil.getInstance(this.rbs).isAirConfigured(n4) && !bl || bl && AIRUtil.getInstance(this.rbs).isNodeConfiguredWithAir(n4)) {
                string = MimDeviceGroup.MOTYPENAME;
                string2 = AUTO_CREATED_RDNID_AUXPIU_AIR;
                string3 = AUTO_CREATED_RDNID_DeviceGroup_AIR;
                n3 = 26;
                n2 = 26;
            } else {
                string = MimRetuDeviceGroup.MOTYPENAME;
                string2 = AUTO_CREATED_RDNID_2;
                string3 = AUTO_CREATED_RDNID_1;
                n3 = 7;
                n2 = 18;
            }
            ChildWithAttributeValues childWithAttributeValues = new ChildWithAttributeValues(moInstance, MimAuxPlugInUnit.MOTYPENAME, "auType", new Integer(n3), string2);
            ChildWithAttributeValues childWithAttributeValues2 = new ChildWithAttributeValues(moInstance, MimAuxPlugInUnit.MOTYPENAME, "auType", new Integer(n2), string2);
            SingleChildMoi singleChildMoi = new SingleChildMoi(childWithAttributeValues, string, string3);
            SingleChildMoi singleChildMoi2 = new SingleChildMoi(singleChildMoi, MimRetDeviceSet.MOTYPENAME, AUTO_CREATED_RDNID_1);
            SingleChildMoi singleChildMoi3 = new SingleChildMoi(singleChildMoi2, MimRetDevice.MOTYPENAME, AUTO_CREATED_RDNID_1);
            SingleChildMoi singleChildMoi4 = new SingleChildMoi(childWithAttributeValues2, string, string3);
            SingleChildMoi singleChildMoi5 = new SingleChildMoi(singleChildMoi4, MimRetDeviceSet.MOTYPENAME, AUTO_CREATED_RDNID_1);
            SingleChildMoi singleChildMoi6 = new SingleChildMoi(singleChildMoi5, MimRetDevice.MOTYPENAME, AUTO_CREATED_RDNID_1);
            this.retuMois[n][i] = singleChildMoi.getLdn();
            this.aretuMois[n][i] = singleChildMoi4.getLdn();
            this.retMois[n][i] = singleChildMoi3.getLdn();
            this.aretMois[n][i] = singleChildMoi6.getLdn();
            for (int j = 2; j <= this.maxSequenceNumber; ++j) {
                MoInstance moInstance2 = this.as.externalAntennaMois[n][i][j - 2];
                SingleChildMoi singleChildMoi7 = new SingleChildMoi(moInstance2, MimAuxPlugInUnit.MOTYPENAME, AUTO_CREATED_RDNID_2);
                SingleChildMoi singleChildMoi8 = new SingleChildMoi(singleChildMoi7, MimRetuDeviceGroup.MOTYPENAME, AUTO_CREATED_RDNID_1);
                SingleChildMoi singleChildMoi9 = new SingleChildMoi(singleChildMoi8, MimRetDeviceSet.MOTYPENAME, AUTO_CREATED_RDNID_1);
                SingleChildMoi singleChildMoi10 = new SingleChildMoi(singleChildMoi9, MimRetDevice.MOTYPENAME, AUTO_CREATED_RDNID_1);
                this.aretuCascadeMois[n][i][j - 2] = singleChildMoi8.getLdn();
                this.aretCascadeMois[n][i][j - 2] = singleChildMoi10.getLdn();
            }
        }
    }

    public void setRetTypeRangeRestriction(int n) {
        int n2 = this.as.getNumOfSectorAntennas(n);
        for (int i = 0; i < n2; ++i) {
            String string;
            boolean bl = false;
            int n3 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
            if (this.as.tmaParam[n3][i] != null && (string = this.as.tmaParam[n3][i].getValue()).equalsIgnoreCase("ATMA")) {
                bl = true;
            }
            this.setRetTypeRangeRestriction(n, i + 1, bl);
        }
    }

    public void setRetTypeRangeRestriction(int n, int n2, boolean bl) {
        if (!this.isThisCicSupported) {
            return;
        }
        int n3 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        if (this.as.isPsiConfiguration(n3)) {
            if (bl) {
                this.rangeRetRestriction[n3][n2 - 1].setRange(Enumeration.newEnumeratedValueRange(this.retTypeRangeWithATMA), true);
            } else {
                this.rangeRetRestriction[n3][n2 - 1].setRange(Enumeration.newEnumeratedValueRange(this.retTypeRangeWithPSI), true);
            }
        } else {
            if (bl) {
                if (n2 == 1 || SectorUtil.isRrus32WithRbb441d(this.rbs, n)) {
                    this.rangeRetRestriction[n3][n2 - 1].setRange(Enumeration.newEnumeratedValueRange(this.retTypeRangeCompleteWithATMA), true);
                } else {
                    this.rangeRetRestriction[n3][n2 - 1].setRange(Enumeration.newEnumeratedValueRange(this.retTypeRangeWithATMA), true);
                }
            } else if (n2 == 1 || SectorUtil.isRrus32WithRbb441d(this.rbs, n)) {
                this.rangeRetRestriction[n3][n2 - 1].setRange(Enumeration.newEnumeratedValueRange(this.retTypeRangeComplete), true);
            } else {
                this.rangeRetRestriction[n3][n2 - 1].setRange(Enumeration.newEnumeratedValueRange(this.retTypeRange), true);
            }
            boolean bl2 = AIRUtil.getInstance(this.rbs).isAirConfigured(n);
            if (bl2 && n2 == 1) {
                this.rangeRetRestriction[n3][n2 - 1].setRange(Enumeration.newEnumeratedValueRange(this.retTypeRangeWithAIR), true);
            }
        }
    }

    protected String getRetAtfRole(int n) throws BemException {
        return AtfProvider.ALL_CONTROLLERS_OF_RET_INDEXED_BY_SECTOR[n];
    }

    public void checkUniquHwidConsistencyForAir(boolean bl, int n, int n2, int n3, String string) throws BemException {
        if (bl) {
            boolean bl2;
            if (n3 == 1) {
                boolean bl3 = this.checkUniquHwidConsistencyForAir_ActiveRet(string);
                if (!bl3) {
                    BemException bemException = new BemException();
                    bemException.setProperty("Problem", "The value uniqueHwId=\"" + string + "\" in sector " + n + (n2 > 0 ? ", antenna " + n2 : UNIQUEHWID_VALUE_BLANK) + (n3 > 0 ? ", sequence " + n3 : UNIQUEHWID_VALUE_BLANK) + " is invalid, the value of the Active RET shall be \"A1\",\"P1\",\"B1\",\"B2\" or \"-\"  if the radio unit type is AIR.");
                    throw bemException;
                }
            } else if (!"##UNDEFINED".equals(string) && !(bl2 = this.checkUniquHwidConsistencyForAir_PassiveRet(string))) {
                BemException bemException = new BemException();
                bemException.setProperty("Problem", "The value uniqueHwId=\"" + string + "\" in sector " + n + (n2 > 0 ? ", antenna " + n2 : UNIQUEHWID_VALUE_BLANK) + ", sequence " + n3 + " is invalid, the value of the Passive RET shall be \"P1\", \"P2\" ... \"P5\",\"B1\",\"B2\" if the radio unit type is AIR.");
                throw bemException;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkUniquHwidConsistencyForAir_ActiveRet(String string) {
        if (UNIQUEHWID_VALUE_A1.equalsIgnoreCase(string)) return true;
        if (UNIQUEHWID_VALUE_LINE.equalsIgnoreCase(string)) return true;
        if (UNIQUEHWID_VALUE_B1.equalsIgnoreCase(string)) return true;
        if (!UNIQUEHWID_VALUE_B2.equalsIgnoreCase(string)) return false;
        return true;
    }

    private boolean checkUniquHwidConsistencyForAir_PassiveRet(String string) {
        int n;
        String[] stringArray = new String[]{AUTO_CREATED_RDNID_1, AUTO_CREATED_RDNID_2, "3", "4", "5"};
        String[] stringArray2 = new String[]{AUTO_CREATED_RDNID_1, AUTO_CREATED_RDNID_2};
        boolean bl = false;
        if (null == string) {
            return bl;
        }
        if ((string.startsWith("P") || string.startsWith("p")) && string.length() <= 2) {
            for (n = 0; n < stringArray.length; ++n) {
                if (!string.endsWith(stringArray[n])) continue;
                bl = true;
                break;
            }
        }
        if ((string.startsWith("B") || string.startsWith("b")) && string.length() <= 2) {
            for (n = 0; n < stringArray2.length; ++n) {
                if (!string.endsWith(stringArray[n])) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private class TmaListener
    implements CustomerParameterListener {
        private final int sectorNumber;
        private final int antennaNumber;

        public TmaListener(int n, int n2) {
            this.sectorNumber = n;
            this.antennaNumber = n2;
        }

        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            int n;
            String string = customerParameter.getName();
            if (parameterEvent.isValueChanged() && RetCIComponent.this.as.isOpen() && string.equalsIgnoreCase(RetCIComponent.this.as.tmaParam[n = SectorUtil.getSectorIndexFromSectorNumber(this.sectorNumber, RetCIComponent.this.startingSectorNumber)][this.antennaNumber - 1].getName())) {
                String string2 = RetCIComponent.this.as.tmaParam[n][this.antennaNumber - 1].getValue();
                RetCIComponent.this.setRetTypeRangeRestriction(this.sectorNumber, this.antennaNumber, string2.equalsIgnoreCase("ATMA"));
            }
        }
    }

    private class TypeOfRetListener
    implements CustomerParameterListener {
        private final int sectorIndex;
        private final int antennaIndex;
        private final RetCIComponent retCIComponent;

        public TypeOfRetListener(RetCIComponent retCIComponent2, int n, int n2) {
            this.retCIComponent = retCIComponent2;
            this.sectorIndex = n;
            this.antennaIndex = n2;
        }

        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            if (parameterEvent.isValueChanged() && RetCIComponent.this.as.isOpen()) {
                int n = SectorUtil.getSectorNumberFromSectorIndex(this.sectorIndex, RetCIComponent.this.startingSectorNumber);
                RetCIComponent.this.as.updateRiuRestriction(n, this.antennaIndex + 1);
                RetCIComponent.this.as.cellCarrP.requestUninitiateSector(n, this);
                RetCIComponent.this.as.cellCarrP.requestInitiateSector(n, this);
                String string = customerParameter.getName();
                if (string.equalsIgnoreCase(RetCIComponent.this.typeOfRetParam[this.sectorIndex][this.antennaIndex].getName())) {
                    Object object;
                    String string2 = RetCIComponent.this.typeOfRetParam[this.sectorIndex][this.antennaIndex].getValue();
                    if (string2.equalsIgnoreCase(RetCIComponent.ARETU_CASCADE)) {
                        String string3 = MessageFormat.format("S{0}_", new Integer(n));
                        object = BemUtil.getCustomerParameterName(string3 = string3 + MessageFormat.format("SEQ{0}_", new Integer(1)), "antennaType", this.antennaIndex + 1);
                        if (!RetCIComponent.this.as.isParameterSupported((String)object)) {
                            RetCIComponent.this.as.createAntennaTypeCP(n, this.antennaIndex + 1, true);
                            RetCIComponent.this.as.createUserLabelAretuCP(n, this.antennaIndex + 1, true);
                            RetCIComponent.this.as.createSectorAntennaCP(string3, n, this.antennaIndex + 1);
                            try {
                                RetCIComponent.this.as.createSectorAntennaRI(n, true);
                            }
                            catch (BemException bemException) {
                                Nal.getLog().nalTrace(1, this.getClass(), "BemException caught. Failed in TypeOfRetListener.createSectorAntennaRI, sector=" + n, bemException);
                            }
                        }
                    }
                    int n2 = 0;
                    if (RetCIComponent.this.as.antennaTypeParam[this.sectorIndex][this.antennaIndex] != null) {
                        object = Integer.valueOf(RetCIComponent.this.as.antennaTypeParam[this.sectorIndex][this.antennaIndex].getValue());
                        n2 = (Integer)object;
                    }
                    this.retCIComponent.setUniqueHwIdRestriction(string2, n, this.antennaIndex);
                    this.retCIComponent.setElectricalAntennaTiltRestriction(string2, n, this.antennaIndex);
                    this.retCIComponent.setAntennaTypeRestriction(string2, n, this.antennaIndex);
                    this.retCIComponent.setMechanicalTiltRestriction(string2, n, this.antennaIndex);
                    this.retCIComponent.setMaxAndMinTiltRestriction(string2, n, this.antennaIndex, n2);
                }
            }
        }
    }
}

