/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem;

import java.text.MessageFormat;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.AbstractAntennaSystemCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.util.AIRUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterImpl;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterServer;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractDbControlledAuxillaryUnitRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public class RetRI
extends AbstractDbControlledAuxillaryUnitRI {
    public static final String name = "RetuDeviceGroup";
    public static final String piuTypeProductName = "RETU";
    public static final int auType = 7;
    protected boolean isExternal = false;
    protected final int antNo;
    protected final String ldn;
    protected final String retLdn;
    protected final int sectorNumber;
    protected String prefix;
    private final String piuTypeName;
    private final String retTypeName;

    public RetRI(Rbs rbs, int n, String string, String string2, String string3, String string4, int n2, String string5, String string6, int n3) {
        super(string4, rbs, n2, string5, string3);
        this.ldn = string;
        this.retLdn = string2;
        this.sectorNumber = n;
        this.prefix = AbstractAntennaSystemCI.getSectorPrefix(this.sectorNumber);
        this.piuTypeName = string5;
        this.retTypeName = string6;
        this.antNo = n3;
    }

    public RetRI(Rbs rbs, int n, String string, String string2, String string3, String string4, int n2, String string5, int n3) {
        this(rbs, n, string, string2, string3, string4, n2, string5, string5, n3);
    }

    public RetRI(Rbs rbs, int n, String string, String string2, String string3, int n2) {
        this(rbs, n, string, string2, string3, name, 7, piuTypeProductName, piuTypeProductName, n2);
    }

    public boolean isInstalled() throws BemException {
        return super.isExisting(this.ldn);
    }

    public void install(String string) throws BemException {
        CustomerParameter customerParameter;
        String string2;
        Object object;
        Object object2;
        Object object3;
        if (super.containsPhase(this.getInstallationPhases(), string)) {
            object3 = AbstractAntennaSystemCI.getSectorPrefix(this.sectorNumber);
            object2 = BemUtil.getCustomerParameterName((String)object3, "typeOfRet", this.antNo);
            object = this.rbs.getCustomerParameterObject((String)object2).getValue();
            boolean bl = AIRUtil.getInstance(this.rbs).isAirConfigured(this.sectorNumber);
            if (!this.isExternal) {
                string2 = (String)object3 + MessageFormat.format("SEQ{0}_", new Integer(1)) + "uniqueHwId";
                if (this.antNo > 1) {
                    string2 = string2 + this.antNo;
                }
                if ((customerParameter = this.rbs.getCustomerParameterObject(string2)) != null && customerParameter.getAccessLevel() != 1 && customerParameter.hasValueChanged()) {
                    String string3 = customerParameter.getValue();
                    super.setUniqueHwId(string3);
                }
            }
            if (!bl || bl && "ARETU_CASCADE".equals(object) && this.isExternal) {
                super.install(string);
            }
        }
        if (string.equals("ElectricalTiltSettingsPhase")) {
            object3 = this.rbs.getCustomerParameterServerObject(this.prefix + "electricalTilt" + (this.antNo > 1 ? "" + this.antNo : ""));
            object2 = Integer.valueOf((String)object3.getValueMom());
            object = this.getMo(this.retLdn);
            Object object4 = this.getAttribute((BemMo)object, "electricalAntennaTilt");
            if (!object3.equals(object4)) {
                this.setAttribute((BemMo)object, "electricalAntennaTilt", object2);
            }
            string2 = this.prefix;
            if (!this.isExternal && this.retTypeName.equalsIgnoreCase("ARETU_CASCADE")) {
                string2 = string2 + MessageFormat.format("SEQ{0}_", new Integer(1));
            }
            if ((customerParameter = this.rbs.getCustomerParameterObject(string2 = string2 + "electricalTilt" + (this.antNo > 1 ? "" + this.antNo : ""))) != null && customerParameter.getAccessLevel() != 1 && customerParameter.hasValueChanged()) {
                object2 = Integer.valueOf(customerParameter.getValue());
                this.setAttribute((BemMo)object, "electricalAntennaTilt", object2);
            }
        }
    }

    public void setLoadedValues() throws BemException {
        BemMo bemMo = this.getMo(this.retLdn);
        boolean bl = AIRUtil.getInstance(this.rbs).isAirConfigured(this.sectorNumber);
        String string = this.antNo > 1 ? "" + this.antNo : "";
        String string2 = AbstractAntennaSystemCI.getSectorPrefix(this.sectorNumber);
        CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(string2 + "configureRet");
        CustomerParameterServer customerParameterServer2 = this.rbs.getCustomerParameterServerObject(string2 + "typeOfRet" + string);
        if (bemMo.isExisting()) {
            if (!this.isExternal) {
                if (AIRUtil.getInstance(this.rbs).isNodeConfiguredWithAir(this.sectorNumber)) {
                    customerParameterServer.setLoadedValue("YES");
                } else {
                    customerParameterServer.setLoadedValue("NO");
                }
                if (AIRUtil.getInstance(this.rbs).isAirConfigured(this.sectorNumber)) {
                    ((CustomerParameterImpl)customerParameterServer).setValue("NO");
                }
                if (AIRUtil.getInstance(this.rbs).isNodeConfiguredWithAir(this.sectorNumber)) {
                    customerParameterServer2.setLoadedValue("ARETU");
                } else {
                    customerParameterServer2.setLoadedValue(this.piuTypeName);
                }
            } else {
                customerParameterServer2.setLoadedValue(this.retTypeName);
            }
            CustomerParameterServer customerParameterServer3 = this.rbs.getCustomerParameterServerObject(this.prefix + "electricalTilt" + string);
            Object object = this.getAttribute(bemMo, "electricalAntennaTilt");
            customerParameterServer3.setLoadedValue(object);
            if (AIRUtil.getInstance(this.rbs).isNodeConfiguredWithAir(this.sectorNumber)) {
                customerParameterServer3 = this.rbs.getCustomerParameterServerObject(this.prefix + "uniqueHwId" + string);
                Object object2 = this.getAttribute(bemMo.getParent().getParent().getParent(), "uniqueHwId");
                customerParameterServer3.setLoadedValue(object2);
            }
        } else if (!this.isExternal) {
            customerParameterServer.setLoadedValue("NO");
            if (bl) {
                ((CustomerParameterImpl)customerParameterServer2).setDefaultValue("ARETU");
            }
        }
    }

    public String getLdn() {
        return this.ldn;
    }

    public String getDisplayName() {
        return "RetuDeviceGroup: " + this.getLdn();
    }
}

