/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem;

import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractDbControlledAuxillaryUnitRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAuxPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRruDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSector;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.SectorAntennaMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;

public class RruRI
extends AbstractDbControlledAuxillaryUnitRI {
    public static final String name = "RRU";
    private static final String WIZARD_SWALLOC_ROLE_RRU = "RBS_RRU";
    private static final String WIZARD_REPERTOIRE_RRU = "RBS_RRU";
    private static final String piuTypeProductName = "RRU";
    private MoInstance sectorMoi;
    private MoInstance sectorAntennaMoi;
    private MoInstance auxPiuMoi;
    private MoInstance boardMoi;
    private String auxPiuLdn;
    private final String ldn;
    private static final int UNCHANGED = 0;
    private static final int RRB02 = 2;
    private int setTrDevice = 0;
    private static final String[] SECTOR_RDN = new String[]{"1", "2", "3", "4", "5", "6"};

    public RruRI(Rbs rbs, String string, String string2) {
        super("RRU", rbs, 10, "RRU", string2);
        this.setSwLoadable(true);
        this.setRoleForSwAllocation("RBS_RRU");
        this.addRepertoiresToInstall("RBS_RRU");
        this.ldn = string;
    }

    public void install(String string) throws BemException {
        super.install(string);
        if (string.equals("AuxUnitDbControlledCreationPhase")) {
            this.setTrDeviceAttribute();
        }
    }

    private void setTrDeviceAttribute() throws BemException {
        if (this.setTrDevice == 2) {
            this.createMoIfNotExisting(this.ldn + ",TrDeviceSet=1,TrDevice=2");
        }
    }

    public RruRI(Rbs rbs, String string, String string2, int n) throws BemException {
        super("RRU", rbs, 10, "RRU", string2);
        this.setSwLoadable(true);
        this.setRoleForSwAllocation("RBS_RRU");
        this.addRepertoiresToInstall("RBS_RRU");
        this.sectorMoi = new FixedRdnMoi(rbs.getNodeBFunctionMoi(), MimSector.MOTYPENAME, SECTOR_RDN[n - 1]);
        this.sectorAntennaMoi = new SectorAntennaMoi(rbs.getEquipmentMoi(), this.sectorMoi, n, 1);
        this.auxPiuMoi = new FixedRdnMoi(this.sectorAntennaMoi, MimAuxPlugInUnit.MOTYPENAME, "RRU" + string);
        this.auxPiuLdn = this.auxPiuMoi.getLdn();
        this.boardMoi = new SingleChildMoi(this.auxPiuMoi, MimRruDeviceGroup.MOTYPENAME, "1");
        this.ldn = this.boardMoi.getLdn();
    }

    public boolean isInstalled() throws BemException {
        return super.isExisting(this.ldn);
    }

    public String getLdn() {
        return this.ldn;
    }

    public String getAuxPiuLdn() {
        return this.auxPiuLdn;
    }

    public String getDisplayName() {
        return "RRU: " + this.getLdn();
    }

    public void setTrDevice(int n) {
        this.setTrDevice = n;
    }
}

