/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem;

import java.text.MessageFormat;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterServer;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.util.AntennaSystemUtil;

public class SectorRI
extends AbstractResourceItem {
    public static final String name = "Sector";
    private final String ldn;
    private final String prefix;
    private int sectorNumber;
    private static final String[] PSEUDOS = new String[]{"geoDatum", "height", "latHemisphere", "latitude", "longitude", "band", "noiseFigure", "sectorGroup"};
    private static final String[] attributeNames = new String[]{"geoDatum", "height", "latHemisphere", "latitude", "longitude", "band", "noiseFigure", "sectorGroup"};

    public SectorRI(Rbs rbs, String string, int n) {
        super(name, rbs, new String[]{"SectorAntennaSettingsPhase"});
        this.ldn = string;
        this.sectorNumber = n;
        String string2 = "S{0}_";
        this.prefix = MessageFormat.format(string2, new Integer(n));
    }

    public void install(String string) throws BemException {
        if (super.containsPhase(this.getInstallationPhases(), string)) {
            BemMo bemMo = this.getMo(this.ldn);
            if (bemMo.isExisting()) {
                String string2;
                Vector<NalNameValue> vector = new Vector<NalNameValue>();
                CustomerParameterServer customerParameterServer = null;
                if (!AntennaSystemUtil.isPsiSector(this.rbs, this.sectorNumber)) {
                    customerParameterServer = this.rbs.getCustomerParameterServerObject(this.prefix + "beamDirection");
                    string2 = (String)customerParameterServer.getValueMom();
                    if (customerParameterServer.hasValueChanged()) {
                        vector.add(Nal.getFactory().getNameValue("beamDirection", string2));
                    }
                } else {
                    vector.add(Nal.getFactory().getNameValue("beamDirection", "N/A"));
                }
                customerParameterServer = this.rbs.getCustomerParameterServerObject(this.prefix + "geoDatum");
                string2 = (String)customerParameterServer.getValueMom();
                if (customerParameterServer.hasValueChanged()) {
                    vector.add(Nal.getFactory().getNameValue("geoDatum", string2));
                }
                customerParameterServer = this.rbs.getCustomerParameterServerObject(this.prefix + "height");
                String string3 = (String)customerParameterServer.getValueMom();
                if (customerParameterServer.hasValueChanged()) {
                    vector.add(Nal.getFactory().getNameValue("height", string3));
                }
                customerParameterServer = this.rbs.getCustomerParameterServerObject(this.prefix + "latHemisphere");
                Integer n = (Integer)customerParameterServer.getValueMom();
                if (customerParameterServer.hasValueChanged()) {
                    vector.add(Nal.getFactory().getNameValue("latHemisphere", n));
                }
                customerParameterServer = this.rbs.getCustomerParameterServerObject(this.prefix + "latitude");
                Integer n2 = Integer.valueOf((String)customerParameterServer.getValueMom());
                if (customerParameterServer.hasValueChanged()) {
                    vector.add(Nal.getFactory().getNameValue("latitude", n2));
                }
                customerParameterServer = this.rbs.getCustomerParameterServerObject(this.prefix + "longitude");
                Integer n3 = Integer.valueOf((String)customerParameterServer.getValueMom());
                if (customerParameterServer.hasValueChanged()) {
                    vector.add(Nal.getFactory().getNameValue("longitude", n3));
                }
                customerParameterServer = this.rbs.getCustomerParameterServerObject(this.prefix + "noiseFigure");
                Integer n4 = Integer.valueOf((String)customerParameterServer.getValueMom());
                if (customerParameterServer.hasValueChanged()) {
                    vector.add(Nal.getFactory().getNameValue("noiseFigure", n4));
                }
                customerParameterServer = this.rbs.getCustomerParameterServerObject(this.prefix + "sectorGroup");
                Integer n5 = Integer.valueOf((String)customerParameterServer.getValueMom());
                if (customerParameterServer.hasValueChanged()) {
                    vector.add(Nal.getFactory().getNameValue("sectorGroup", n5));
                }
                if (vector.size() > 0) {
                    this.setAttributes(bemMo, vector);
                }
            } else {
                throw new BemException("Sector RI: " + this.ldn + " dont exist.\n");
            }
        }
    }

    public void setLoadedValues() throws BemException {
        BemMo bemMo = this.getMo(this.ldn);
        if (this.isExisting(bemMo)) {
            Object object;
            Object object2;
            for (int i = 0; i < PSEUDOS.length; ++i) {
                object2 = this.prefix + PSEUDOS[i];
                object = this.rbs.getCustomerParameterServerObject((String)object2);
                Object object3 = this.getAttribute(bemMo, attributeNames[i]);
                if (attributeNames[i].equals("band") && object3.toString().equals("0")) {
                    object3 = object.getDefaultValue();
                }
                object.setLoadedValue(object3);
            }
            if (!AntennaSystemUtil.isPsiSector(this.rbs, this.sectorNumber)) {
                String string = this.prefix + "beamDirection";
                object2 = this.rbs.getCustomerParameterServerObject(string);
                object = this.getAttribute(bemMo, "beamDirection");
                object2.setLoadedValue(object);
            }
        }
    }

    public String getLdn() {
        return this.ldn;
    }

    public String getDisplayName() {
        return "Sector:" + this.ldn;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SectorRI)) {
            return false;
        }
        SectorRI sectorRI = (SectorRI)object;
        String string = this.getLdn();
        String string2 = sectorRI.getLdn();
        return string.equals(string2);
    }

    public int hashCode() {
        return this.getLdn().hashCode() * 11;
    }

    public String getPrefix() {
        return this.prefix;
    }
}

