/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.AbstractEtmBoardManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.RIAndCPWrapper;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.AtmPortParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.EtbSlotParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.PhysicalLineParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.TerminationParameterList;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.TerminationTypeParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.UninstallParameterList;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.mapping.Mapping;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource.AbstractTerminationRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource.AtmPortRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource.CbuTerminationRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource.DuwTerminationRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource.Etm1TerminationRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource.Etm3TerminationRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource.Etm4TerminationRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource.Etmc1TerminationRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource.Etmc41TerminationRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource.FractionalRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource.ImaRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EtmBoardProvider;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterImpl;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimCbu;
import se.ericsson.wcdma.rbs.bem.common.mim.MimExchangeTerminal;

public class RIManager {
    private Rbs rbs = null;
    private EtmBoardProvider etmBoardProvider = null;
    private AbstractEtmBoardManager boardManager = null;

    public RIManager(Rbs rbs, EtmBoardProvider etmBoardProvider, AbstractEtmBoardManager abstractEtmBoardManager) {
        this.rbs = rbs;
        this.etmBoardProvider = etmBoardProvider;
        this.boardManager = abstractEtmBoardManager;
    }

    private Rbs getRbs() {
        return this.rbs;
    }

    public RIAndCPWrapper createRIsForTermination(TerminationParameterList terminationParameterList, String string, String string2, String string3, String[] stringArray, String[] stringArray2) throws BemException {
        Object object;
        HashMap hashMap = new HashMap();
        String[] stringArray3 = this.etmBoardProvider.getSupportedEtmBoardTypesForAtm();
        for (int i = 0; i < stringArray3.length; ++i) {
            object = this.getEtmTerminationRIs(stringArray3[i], terminationParameterList, stringArray, stringArray2);
            hashMap.putAll(object);
        }
        FractionalRI fractionalRI = new FractionalRI(this.getRbs(), string2, terminationParameterList);
        object = new ImaRI(this.getRbs(), string3, this.boardManager, terminationParameterList);
        AtmPortRI atmPortRI = new AtmPortRI(this.getRbs(), string, fractionalRI, (ImaRI)object, this.boardManager, terminationParameterList);
        RIAndCPWrapper rIAndCPWrapper = new RIAndCPWrapper(hashMap, atmPortRI, (ImaRI)object, fractionalRI, terminationParameterList);
        return rIAndCPWrapper;
    }

    private RIAndCPWrapper getAtmPortRI(List list, String string) throws BemException {
        for (int i = 0; i < list.size(); ++i) {
            RIAndCPWrapper rIAndCPWrapper = (RIAndCPWrapper)list.get(i);
            AtmPortRI atmPortRI = rIAndCPWrapper.getAtmPortRI();
            String string2 = atmPortRI.getAtmPortRdnId();
            if (!string.equals(string2)) continue;
            return rIAndCPWrapper;
        }
        return null;
    }

    public ArrayList getNeededRIs(List list) throws BemException {
        ArrayList<AbstractResourceItem> arrayList = new ArrayList<AbstractResourceItem>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            AbstractResourceItem abstractResourceItem;
            RIAndCPWrapper rIAndCPWrapper = (RIAndCPWrapper)iterator.next();
            Map map = rIAndCPWrapper.getTerminationRIs();
            TerminationParameterList terminationParameterList = rIAndCPWrapper.getParamList();
            boolean bl = terminationParameterList.isValidValue();
            if (!bl) {
                throw new BemException(this.getClass().getName() + ": Customer parameters are not valid");
            }
            EtbSlotParameter etbSlotParameter = terminationParameterList.getSlotParameter();
            String string = etbSlotParameter.getValue();
            if (string.equals("##UNDEFINED") || string.equals("None")) continue;
            AbstractTerminationRI abstractTerminationRI = (AbstractTerminationRI)map.get(string);
            arrayList.add(abstractTerminationRI);
            TerminationTypeParameter terminationTypeParameter = terminationParameterList.getTerminationTypeParameter();
            String string2 = terminationTypeParameter.getValue();
            if (this.boardManager.isFractional(string, string2)) {
                abstractResourceItem = rIAndCPWrapper.getFractionalRI();
                arrayList.add(abstractResourceItem);
            }
            if (this.boardManager.isIma(string, string2)) {
                abstractResourceItem = rIAndCPWrapper.getImaRI();
                arrayList.add(abstractResourceItem);
            }
            if (!terminationParameterList.hasAtmPort()) continue;
            abstractResourceItem = rIAndCPWrapper.getAtmPortRI();
            arrayList.add(abstractResourceItem);
        }
        return arrayList;
    }

    public ArrayList getRIsToUninstall(List list) throws BemException {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            RIAndCPWrapper rIAndCPWrapper = (RIAndCPWrapper)iterator.next();
            if (!rIAndCPWrapper.isToBeUninstalled()) continue;
            ArrayList arrayList2 = rIAndCPWrapper.getRIsToUninstall();
            arrayList.addAll(arrayList2);
        }
        return arrayList;
    }

    public void checkRIsToBeUninstalled(List list, List list2) throws BemException {
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            CustomerParameterImpl customerParameterImpl;
            Object e = iterator.next();
            if (e instanceof UninstallParameterList) {
                customerParameterImpl = (UninstallParameterList)e;
                this.prepareUnInstallPhysPathTerm(list, (UninstallParameterList)customerParameterImpl);
                continue;
            }
            if (!(e instanceof AtmPortParameter)) continue;
            customerParameterImpl = (AtmPortParameter)e;
            this.prepareUnInstallAtmPort(list, (AtmPortParameter)customerParameterImpl);
        }
    }

    private void prepareUnInstallPhysPathTerm(List list, UninstallParameterList uninstallParameterList) throws BemException {
        EtbSlotParameter etbSlotParameter = uninstallParameterList.getSlotParameter();
        PhysicalLineParameter physicalLineParameter = uninstallParameterList.getLineParameter();
        String string = etbSlotParameter.getValue();
        String[] stringArray = physicalLineParameter.getAllLines();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            PhysicalLineParameter physicalLineParameter2;
            String[] stringArray2;
            RIAndCPWrapper rIAndCPWrapper = (RIAndCPWrapper)iterator.next();
            TerminationParameterList terminationParameterList = rIAndCPWrapper.getParamList();
            String string2 = terminationParameterList.getSlotParameter().getValue();
            if (!string2.equals(string) || (stringArray2 = (physicalLineParameter2 = terminationParameterList.getLineParameter()).getAllLines()) == null || stringArray2.length < 1) continue;
            for (int i = 0; i < stringArray2.length; ++i) {
                for (int j = 0; j < stringArray.length; ++j) {
                    String[] stringArray3;
                    if (!stringArray2[i].equals(stringArray[j])) continue;
                    TerminationTypeParameter terminationTypeParameter = terminationParameterList.getTerminationTypeParameter();
                    String string3 = terminationTypeParameter.getValue();
                    Map map = rIAndCPWrapper.getTerminationRIs();
                    AbstractTerminationRI abstractTerminationRI = (AbstractTerminationRI)map.get(string2);
                    Mapping mapping = abstractTerminationRI.getMapping();
                    String string4 = rIAndCPWrapper.getAtmPortRI().getAtmPortRdnId();
                    if (terminationParameterList.hasAtmPort()) {
                        throw new BemException(this.getClass().getName() + "\n\n The selected PhysPathTerm at etbSlot=\"" + string + "\"" + "\n and physicalLine=\"" + stringArray[j] + "\" for deletion is used by an AtmPort" + "\n with rdnId=\"" + string4 + "\"." + "\n It can therefore NOT be deleted!");
                    }
                    if (mapping.isIma(string3)) {
                        throw new BemException(this.getClass().getName() + "\n\n The selected PhysPathTerm at etbSlot=\"" + string + "\"" + "\n and physicalLine=\"" + stringArray[j] + "\" for deletion is used by Ima." + "\n It can therefore NOT be deleted!");
                    }
                    if (mapping.isFractional(string3)) {
                        stringArray3 = rIAndCPWrapper.getFractionalRI();
                        stringArray3.setToBeUnInstalled();
                    }
                    abstractTerminationRI.setToBeUnInstalled();
                    stringArray3 = abstractTerminationRI.getAllLines();
                    abstractTerminationRI.setLinesToUnInstall(stringArray3);
                    rIAndCPWrapper.setToBeUninstalled(true);
                }
            }
        }
    }

    private void prepareUnInstallAtmPort(List list, AtmPortParameter atmPortParameter) throws BemException {
        String string = atmPortParameter.getValue();
        RIAndCPWrapper rIAndCPWrapper = this.getAtmPortRI(list, string);
        if (rIAndCPWrapper == null) {
            throw new BemException(this.getClass().getName() + "\n\n The value of specified rdnId=\"" + string + "\" does NOT exist for any AtmPort." + "\n It can therefore NOT be deleted!");
        }
        AtmPortRI atmPortRI = rIAndCPWrapper.getAtmPortRI();
        atmPortRI.setToBeUnInstalled();
        rIAndCPWrapper.setToBeUninstalled(true);
        TerminationParameterList terminationParameterList = rIAndCPWrapper.getParamList();
        String string2 = terminationParameterList.getSlotParameter().getValue();
        ImaRI imaRI = rIAndCPWrapper.getImaRI();
        imaRI.setToBeUnInstalled();
        FractionalRI fractionalRI = rIAndCPWrapper.getFractionalRI();
        fractionalRI.setToBeUnInstalled();
        Map map = rIAndCPWrapper.getTerminationRIs();
        AbstractTerminationRI abstractTerminationRI = (AbstractTerminationRI)map.get(string2);
        abstractTerminationRI.setToBeUnInstalled();
        String[] stringArray = abstractTerminationRI.getAllLoadedLines();
        abstractTerminationRI.setLinesToUnInstall(stringArray);
    }

    private Map getEtmTerminationRIs(String string, TerminationParameterList terminationParameterList, String[] stringArray, String[] stringArray2) {
        HashMap<String, Etm1TerminationRI> hashMap = new HashMap<String, Etm1TerminationRI>();
        AbstractTerminationRI abstractTerminationRI = null;
        if (string.equals("Etm1")) {
            abstractTerminationRI = new Etm1TerminationRI(this.getRbs(), this.boardManager, terminationParameterList, stringArray, stringArray2);
        } else if (string.equals("Etmc1")) {
            abstractTerminationRI = new Etmc1TerminationRI(this.getRbs(), this.boardManager, terminationParameterList, stringArray, stringArray2);
        } else if (string.equals("Etm3")) {
            abstractTerminationRI = new Etm3TerminationRI(this.getRbs(), this.boardManager, terminationParameterList, stringArray, stringArray2);
        } else if (string.equals("Etm4")) {
            abstractTerminationRI = new Etm4TerminationRI(this.getRbs(), this.boardManager, terminationParameterList, stringArray, stringArray2);
        } else if (string.equals("Etmc41")) {
            abstractTerminationRI = new Etmc41TerminationRI(this.getRbs(), this.boardManager, terminationParameterList, stringArray, stringArray2);
        } else if (string.equals(MimCbu.MOTYPENAME)) {
            abstractTerminationRI = new CbuTerminationRI(this.getRbs(), this.boardManager, terminationParameterList, stringArray, stringArray2);
        } else if (string.equals(MimExchangeTerminal.MOTYPENAME) || string.equals("Duw")) {
            abstractTerminationRI = new DuwTerminationRI(this.getRbs(), this.boardManager, terminationParameterList, stringArray, stringArray2);
        }
        String[] stringArray3 = this.boardManager.getSlotsForBoardType(string);
        for (int i = 0; i < stringArray3.length; ++i) {
            hashMap.put(stringArray3[i], (Etm1TerminationRI)abstractTerminationRI);
        }
        return hashMap;
    }
}

