/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource;

import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.AbstractEtmBoardManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.EtbSlotParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.TerminationParameterList;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.TerminationTypeParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.mapping.Mapping;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource.AbstractTerminationRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource.FractionalRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource.ImaRI;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.exception.ExceptionProperties;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAtmPort;
import se.ericsson.wcdma.rbs.bem.common.mim.MimDs0Bundle;
import se.ericsson.wcdma.rbs.bem.common.mim.MimE1Ttp;
import se.ericsson.wcdma.rbs.bem.common.mim.MimExchangeTerminal;
import se.ericsson.wcdma.rbs.bem.common.mim.MimImaGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSts1SpeTtp;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSts3CspeTtp;
import se.ericsson.wcdma.rbs.bem.common.mim.MimT1Ttp;
import se.ericsson.wcdma.rbs.bem.common.mim.MimTransportNetwork;
import se.ericsson.wcdma.rbs.bem.common.mim.MimVc4Ttp;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class AtmPortRI
extends AbstractResourceItem {
    private static final String NAME = "AtmPort";
    private static final String[] myInstallationPhases = new String[]{"AtmPortCreationPhase", "UnlockUsedTerminationsPhase", "AtmPortDeletionPhase"};
    private AbstractTerminationRI terminationRI = null;
    private String loadedLdn = null;
    private FractionalRI fractionalRI = null;
    private ImaRI imaRI = null;
    private EtbSlotParameter slotParameter = null;
    private TerminationTypeParameter terminationTypeParameter = null;
    private AbstractEtmBoardManager boardManager = null;
    private MoHandler theMoHandler = null;
    private boolean isCreated = false;
    private String ldn = null;
    private boolean isToBeInstalled = true;

    public AtmPortRI(Rbs rbs, String string, FractionalRI fractionalRI, ImaRI imaRI, AbstractEtmBoardManager abstractEtmBoardManager, TerminationParameterList terminationParameterList) {
        super(NAME, rbs, myInstallationPhases);
        this.loadedLdn = string;
        this.fractionalRI = fractionalRI;
        this.imaRI = imaRI;
        this.boardManager = abstractEtmBoardManager;
        this.slotParameter = terminationParameterList.getSlotParameter();
        this.terminationTypeParameter = terminationParameterList.getTerminationTypeParameter();
        this.theMoHandler = rbs.getMoHandler();
    }

    public void setTerminationRI(AbstractTerminationRI abstractTerminationRI) {
        this.terminationRI = abstractTerminationRI;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void install(String string) throws BemException {
        if (string.equals("AtmPortCreationPhase")) {
            if (this.terminationRI == null) throw new BemException(this.getClass().getName() + " install()");
            if (!this.isToBeInstalled()) return;
            this.createAtmPort();
            return;
        } else {
            if (!string.equals("UnlockUsedTerminationsPhase") || !this.isCreated) return;
            this.unlockAtmPort();
        }
    }

    private void unlockAtmPort() throws BemException {
        try {
            Object object;
            BemMo bemMo = this.theMoHandler.getMo(this.ldn);
            if (bemMo == null) {
                Nal.getFactory().getLog().nalTrace(7, this.getClass(), this.ldn + " is null");
                return;
            }
            BemMo bemMo2 = (BemMo)this.theMoHandler.getAttribute(bemMo, "uses");
            Vector vector = new Vector();
            if (bemMo2.getType().equalsIgnoreCase(MimImaGroup.MOTYPENAME)) {
                object = (BemMo[])this.theMoHandler.getAttribute(bemMo2, "physicalPortList");
                for (int i = 0; i < ((BemMo[])object).length; ++i) {
                    vector.addAll(this.findUnlockables(object[i]));
                }
            } else {
                vector = this.findUnlockables(bemMo2);
            }
            Nal.getFactory().getLog().nalTrace(7, this.getClass(), "The following MO:s will be unlocked: ");
            Nal.getFactory().getLog().nalTrace(7, this.getClass(), " " + vector.toString());
            object = vector.elements();
            while (object.hasMoreElements()) {
                this.theMoHandler.setAttribute((BemMo)object.nextElement(), "administrativeState", new Integer(1));
            }
            this.isCreated = false;
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException(moHandlerException.getMessage());
        }
    }

    private Vector findUnlockables(BemMo bemMo) throws MoHandlerException {
        Vector<BemMo> vector = new Vector<BemMo>();
        while (bemMo != null && !bemMo.getType().startsWith(MimExchangeTerminal.MOTYPENAME)) {
            if (!(bemMo.getType().equals(MimSts3CspeTtp.MOTYPENAME) || bemMo.getType().equals(MimSts1SpeTtp.MOTYPENAME) || bemMo.getType().equals(MimVc4Ttp.MOTYPENAME) || bemMo.getType().equals(MimE1Ttp.MOTYPENAME) || bemMo.getType().equals(MimT1Ttp.MOTYPENAME) || bemMo.getType().equals(MimDs0Bundle.MOTYPENAME))) {
                vector.add(bemMo);
            }
            bemMo = this.theMoHandler.getParent(bemMo);
        }
        return vector;
    }

    private void createAtmPort() throws BemException {
        ExceptionProperties exceptionProperties = new ExceptionProperties();
        exceptionProperties.setProperty("ResourceItem  (RI)", this);
        exceptionProperties.setProperty("Failing Method", this.getClass().getName() + "createAtmPort()");
        try {
            Object object;
            String string = this.getSelectedTerminationType();
            exceptionProperties.setProperty("Failing Method  - Additional info", "terminationType=" + string);
            if (string.equals("##UNDEFINED")) {
                return;
            }
            Mapping mapping = this.terminationRI.getMapping();
            boolean bl = mapping.isFractional(string);
            boolean bl2 = mapping.isIma(string);
            String string2 = null;
            if (bl) {
                string2 = this.fractionalRI.getFractionalLdn();
            } else if (bl2) {
                string2 = this.imaRI.generateImaGroupLdn();
            } else {
                object = this.terminationRI.getTerminationLdns();
                string2 = object[0];
            }
            exceptionProperties.appendProperty("Failing Method  - Additional info", ", ", "usesLdn=" + string2);
            object = this.generateAtmPortLdn();
            exceptionProperties.appendProperty("Failing Method  - Additional info", ", ", "atmPortLdn=" + (String)object);
            BemMo bemMo = this.theMoHandler.getMo(string2);
            Vector<NalNameValue> vector = new Vector<NalNameValue>(0, 1);
            vector.add(Nal.getFactory().getNameValue("uses", bemMo));
            exceptionProperties.appendProperty("Failing Method  - Additional info", ", ", "attributes=" + vector);
            this.createMoIfNotExisting((String)object, vector);
            this.isCreated = true;
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException("Failed in createAtmPort()", exceptionProperties, (Throwable)moHandlerException);
        }
    }

    public void uninstall(String string) throws BemException {
        if (string.equals("AtmPortDeletionPhase")) {
            if (this.terminationRI != null) {
                if (this.isToBeUnInstalled()) {
                    this.deleteAtmPort();
                }
            } else {
                throw new BemException(this.getClass().getName() + " uninstall()");
            }
        }
    }

    private void deleteAtmPort() throws BemException {
        this.deleteMoIfNotExisting(this.loadedLdn);
    }

    public boolean isToBeInstalled() {
        return this.isToBeInstalled;
    }

    public boolean isToBeUnInstalled() {
        return !this.isToBeInstalled;
    }

    public void setToBeInstalled() {
        this.isToBeInstalled = true;
    }

    public void setToBeUnInstalled() {
        this.isToBeInstalled = false;
    }

    public String generateAtmPortLdn() throws MoHandlerException, BemException {
        return this.generateAtmPortLdn(false);
    }

    public String generateAtmPortLdn(boolean bl) throws MoHandlerException, BemException {
        String string = this.loadedLdn;
        if (string == null || !bl) {
            Object object;
            String string2;
            Mapping mapping;
            String string3 = this.getSelectedSlot(bl);
            String string4 = this.boardManager.getSubrackId(string3);
            if (string4 == null) {
                return null;
            }
            String string5 = this.terminationRI.getLineId();
            String string6 = string4 + "-" + string3 + "-" + string5;
            String string7 = this.terminationRI.getSubLineId();
            if (string7 != null) {
                string6 = string6 + "-" + string7;
            }
            if ((mapping = this.terminationRI.getMapping()).isIma(this.getSelectedTerminationType())) {
                string2 = this.imaRI.generateImaGroupLdn();
                object = this.theMoHandler.getMo(string2);
                string6 = object.getId();
            }
            string2 = MimAtmPort.MOTYPENAME + "=" + string6;
            object = this.getTransportNetworkLdn();
            string = (String)object + "," + string2;
        }
        this.ldn = string;
        return string;
    }

    public String getAtmPortRdnId() {
        String string;
        int n;
        String string2 = this.loadedLdn;
        if (string2 != null && (n = string2.indexOf(string = MimAtmPort.MOTYPENAME)) != -1) {
            return string2.substring(n + string.length() + 1);
        }
        return null;
    }

    public boolean hasChildren() throws BemException {
        boolean bl = false;
        try {
            BemMo bemMo = this.theMoHandler.getMo(this.loadedLdn);
            BemMo[] bemMoArray = this.theMoHandler.getChildren(bemMo, 2, "", "");
            if (bemMoArray != null && bemMoArray.length > 1) {
                bl = true;
            }
        }
        catch (MoHandlerException moHandlerException) {
            // empty catch block
        }
        return bl;
    }

    protected String getSelectedSlot() {
        return this.getSelectedSlot(false);
    }

    protected String getSelectedSlot(boolean bl) {
        return bl ? this.slotParameter.getLoadedValue() : this.slotParameter.getValue();
    }

    protected String getSelectedTerminationType() {
        return this.terminationTypeParameter.getValue();
    }

    protected String getTransportNetworkLdn() throws MoHandlerException {
        BemMo bemMo = this.theMoHandler.getRoot();
        BemMo[] bemMoArray = this.theMoHandler.getChildren(bemMo, 1, MimTransportNetwork.MOTYPENAME, "");
        String string = bemMoArray[0].getDN();
        return string;
    }

    public String getDisplayName() {
        return this.getName();
    }

    public String getLdn() {
        return "";
    }
}

