/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource.duwterminationutil;

import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.mapping.DuwEtm4Mapping;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.mapping.Mapping;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource.AbstractTerminationRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource.DuwTerminationRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource.duwterminationutil.DuwTerminationHandler;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource.util.Etm4TerminationUtil;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;

public class DuwEtm4TerminationHandler
implements DuwTerminationHandler {
    private DuwTerminationRI terminationRi;
    private Mapping mapping;
    private Rbs rbs;

    public DuwEtm4TerminationHandler(DuwTerminationRI duwTerminationRI, Rbs rbs) {
        this.terminationRi = duwTerminationRI;
        this.mapping = new DuwEtm4Mapping();
        this.rbs = rbs;
    }

    public void createTermination() throws BemException {
        Etm4TerminationUtil.createTermination(this.terminationRi, this.getMapping());
    }

    public void deleteTermination() throws BemException {
        MoHandler moHandler = this.rbs.getMoHandler();
        Etm4TerminationUtil.deleteTermination(this.terminationRi, moHandler);
    }

    public String[] getTerminationLdns() {
        String[] stringArray = Etm4TerminationUtil.getTerminationLdns(this.terminationRi);
        return stringArray;
    }

    public String[] getSupportedTerminationTypes() {
        String[] stringArray = this.mapping.getSupportedTerminationTypes();
        return stringArray;
    }

    public String generateTerminationLdn(String string) {
        String string2 = Etm4TerminationUtil.generateTerminationLdn(this.terminationRi, string);
        return string2;
    }

    public String generateSynchTerminationLdn(String string) throws BemException {
        String string2 = ((AbstractTerminationRI)this.terminationRi).generateSynchTerminationLdn(string);
        return string2;
    }

    public String getLineId() throws BemException {
        String string = this.terminationRi.getLineIdFromBaseClass();
        return string;
    }

    public String getSubLineId() throws BemException {
        String string = this.terminationRi.getSubLineIdFromBaseClass();
        return string;
    }

    public String getSynchTerminationMoType() throws BemException {
        String string = Etm4TerminationUtil.getSynchTerminationMoType();
        return string;
    }

    public String[] getSynchTerminations(String[] stringArray) throws BemException {
        String[] stringArray2 = this.terminationRi.getSynchTerminationsFromBaseClass(stringArray);
        return stringArray2;
    }

    public Mapping getMapping() {
        return this.mapping;
    }
}

