/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource.duwterminationutil;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.AbstractEtmBoardManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.TerminationParameterList;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.mapping.Mapping;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource.DuwTerminationRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource.duwterminationutil.DuwEtm4TerminationHandler;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource.duwterminationutil.DuwEtmc1TerminationHandler;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource.duwterminationutil.DuwEtmc41TerminationHandler;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource.duwterminationutil.DuwTerminationHandler;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public class DuwTerminationHandlerManager {
    private TerminationParameterList aParameterList;
    private List terminationHandlers = new ArrayList();

    public DuwTerminationHandlerManager(DuwTerminationRI duwTerminationRI, Rbs rbs, AbstractEtmBoardManager abstractEtmBoardManager, TerminationParameterList terminationParameterList, String[] stringArray, String[] stringArray2) {
        this.aParameterList = terminationParameterList;
        this.terminationHandlers.add(new DuwEtmc1TerminationHandler(duwTerminationRI));
        this.terminationHandlers.add(new DuwEtmc41TerminationHandler(duwTerminationRI, rbs));
        this.terminationHandlers.add(new DuwEtm4TerminationHandler(duwTerminationRI, rbs));
    }

    public void createTermination() throws BemException {
        DuwTerminationHandler duwTerminationHandler = this.getDuwTerminationHandler();
        duwTerminationHandler.createTermination();
    }

    private DuwTerminationHandler getDuwTerminationHandler() throws BemException {
        return this.getDuwTerminationHandler(false);
    }

    private DuwTerminationHandler getDuwTerminationHandler(boolean bl) throws BemException {
        DuwTerminationHandler duwTerminationHandler = null;
        String string = bl ? this.aParameterList.getTerminationTypeParameter().getLoadedValue() : this.aParameterList.getTerminationTypeParameter().getValue();
        for (int i = 0; i < this.terminationHandlers.size(); ++i) {
            DuwTerminationHandler duwTerminationHandler2 = (DuwTerminationHandler)this.terminationHandlers.get(i);
            String[] stringArray = duwTerminationHandler2.getSupportedTerminationTypes();
            if (!BemUtil.isStringInArray(string, stringArray)) continue;
            duwTerminationHandler = duwTerminationHandler2;
            break;
        }
        if (duwTerminationHandler == null) {
            throw new BemException("Given termination=" + string + " is not supported in a DUW equipped RBS");
        }
        return duwTerminationHandler;
    }

    public void deleteTermination() throws BemException {
        DuwTerminationHandler duwTerminationHandler = this.getDuwTerminationHandler(true);
        duwTerminationHandler.deleteTermination();
    }

    public String[] getTerminationLdns() throws BemException {
        DuwTerminationHandler duwTerminationHandler = this.getDuwTerminationHandler();
        String[] stringArray = duwTerminationHandler.getTerminationLdns();
        return stringArray;
    }

    public String generateTerminationLdn(String string) throws BemException {
        DuwTerminationHandler duwTerminationHandler = this.getDuwTerminationHandler();
        String string2 = duwTerminationHandler.generateTerminationLdn(string);
        return string2;
    }

    public String generateSynchTerminationLdn(String string) throws BemException {
        DuwTerminationHandler duwTerminationHandler = this.getDuwTerminationHandler();
        String string2 = duwTerminationHandler.generateSynchTerminationLdn(string);
        return string2;
    }

    public String getLineId() throws BemException {
        DuwTerminationHandler duwTerminationHandler = this.getDuwTerminationHandler();
        String string = duwTerminationHandler.getLineId();
        return string;
    }

    public String getSubLineId() throws BemException {
        DuwTerminationHandler duwTerminationHandler = this.getDuwTerminationHandler();
        String string = duwTerminationHandler.getSubLineId();
        return string;
    }

    public String getSynchTerminationMoType() throws BemException {
        DuwTerminationHandler duwTerminationHandler = this.getDuwTerminationHandler();
        String string = duwTerminationHandler.getSynchTerminationMoType();
        return string;
    }

    public String[] getSynchTerminations(String[] stringArray) throws BemException {
        DuwTerminationHandler duwTerminationHandler = this.getDuwTerminationHandler();
        String[] stringArray2 = duwTerminationHandler.getSynchTerminations(stringArray);
        return stringArray2;
    }

    public Mapping getMapping() {
        Mapping mapping = null;
        try {
            DuwTerminationHandler duwTerminationHandler = this.getDuwTerminationHandler();
            mapping = duwTerminationHandler.getMapping();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mapping;
    }
}

