/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.autointegration;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.AbstractConfigurationItem;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.autointegration.custparam.AutoIntegrateParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.AutoIntegrationProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EtmBoardProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterImpl;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.InputFileParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.StringParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.StringRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.TrueFalseCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.YesNoCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpInterface;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;

public class AutoIntegrationCI
extends AbstractConfigurationItem
implements AutoIntegrationProvider {
    public static final String name = "AutoIntegrationCI";
    private boolean isOpen = false;
    TrueFalseCustomerParameter enableVlanParam = null;
    IntegerParameter vidParam = null;
    Enumeration gigabitEthernetPortParam = null;
    private ParameterRestriction disableVlan = null;
    private ParameterRestriction autoIntegrationIpRestriction = null;
    private ParameterRestriction autoIntegrationRestriction = null;
    private ParameterRestriction manualIntegrationRestriction = null;
    private ParameterRestriction disableFtpReport = null;
    private ParameterRestriction disableClientReport = null;
    private EtmBoardProvider etmBoardProvider = null;
    private AutoIntegrateParameter autoIntegrationParam;
    private List autoParameters;
    private List clientParameters;
    private List otherParameters;

    public AutoIntegrationCI(Rbs rbs) {
        super(rbs);
    }

    public boolean open() throws BemException {
        if (this.isOpen) {
            return true;
        }
        this.isOpen = true;
        this.createCustomerParameters();
        return true;
    }

    public boolean open(ServiceValue serviceValue) {
        return true;
    }

    public String getName() {
        return name;
    }

    public void setCustomerParameters(ServiceValue serviceValue) {
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public ArrayList getNeededRIs() throws BemException {
        if (!this.isOpen) {
            throw new BemException("AutoIntegrationCI is not open.");
        }
        return null;
    }

    public List getRIsToUninstall() {
        return null;
    }

    protected void createCustomerParameters() throws BemException {
        Object object;
        this.autoIntegrationIpRestriction = new ParameterRestriction("Automatic Configuration not possible whithout ET-MFX board", 1);
        this.autoIntegrationRestriction = new ParameterRestriction("Automatic Configuration not selected/possible", 3);
        this.manualIntegrationRestriction = new ParameterRestriction("Manual configuration not selected", 1);
        this.disableVlan = new ParameterRestriction("Node not configured to use VLAN", 3);
        this.disableFtpReport = new ParameterRestriction("Store configuration report on FTP server not selected", 1);
        this.disableClientReport = new ParameterRestriction("Store configuration report on client not selected", 1);
        this.autoIntegrationParam = new AutoIntegrateParameter("AI_autoIntegrate");
        this.autoIntegrationParam.addCustomerParameterListener(new AutoIntegrationListener());
        if (!this.isIpCapableBoards()) {
            this.autoIntegrationParam.setDefaultValue("Obtain configuration data from configuration files on client");
            this.autoIntegrationParam.setValue("Obtain configuration data from configuration files on client");
            this.autoIntegrationParam.addRestriction(this.autoIntegrationIpRestriction);
            this.autoIntegrationIpRestriction.setAccessLevel(3);
            this.autoIntegrationIpRestriction.setRange(Enumeration.newEnumeratedValueRange(new String[]{"Obtain configuration data from configuration files on client"}), true);
        } else {
            this.autoIntegrationParam.setDefaultValue("Obtain configuration data automatically");
        }
        this.addParameter(this.autoIntegrationParam);
        StringRange stringRange = new StringRange(new Integer(1), new Integer(128));
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object2 = new StringParameter("AI_logicalName", stringRange);
        ((CustomerParameterImpl)object2).addRestriction(this.autoIntegrationRestriction);
        arrayList.add(object2);
        Object object3 = new StringParameter("AI_user_name", stringRange);
        ((CustomerParameterImpl)object3).addRestriction(this.autoIntegrationRestriction);
        arrayList.add(object3);
        CustomerParameterImpl customerParameterImpl = new StringParameter("AI_password", stringRange);
        customerParameterImpl.addRestriction(this.autoIntegrationRestriction);
        arrayList.add(customerParameterImpl);
        if (DuwUtil.hasDuw()) {
            object = new EnumeratedRange(new String[]{"TNA", "TNB", "TNC"});
            this.gigabitEthernetPortParam = new Enumeration("AI_gigabitEthernetPort", (EnumeratedRange)object);
            this.gigabitEthernetPortParam.setDefaultValue("TNA");
            this.gigabitEthernetPortParam.addRestriction(this.autoIntegrationRestriction);
            arrayList.add(this.gigabitEthernetPortParam);
        }
        this.enableVlanParam = new TrueFalseCustomerParameter("AI_vlan");
        this.enableVlanParam.setDefaultValue("FALSE");
        this.enableVlanParam.addRestriction(this.autoIntegrationRestriction);
        arrayList.add(this.enableVlanParam);
        object = new IntegerRange(MimIpInterface.MIN_VID, MimIpInterface.MAX_VID);
        this.vidParam = new IntegerParameter("AI_vid", (IntegerRange)object);
        this.vidParam.setDefaultValue("900");
        this.vidParam.addRestriction(this.autoIntegrationRestriction);
        this.vidParam.addRestriction(this.disableVlan);
        arrayList.add(this.vidParam);
        this.addAllParametes(arrayList);
        this.autoParameters = arrayList;
        this.autoParameters.add(this.autoIntegrationParam);
        arrayList = new ArrayList();
        object2 = new StringRange(new Integer(1), new Integer(254));
        object3 = new InputFileParameter("AI_oamFilePath", (StringRange)object2);
        ((CustomerParameterImpl)object3).addRestriction(this.manualIntegrationRestriction);
        arrayList.add(object3);
        customerParameterImpl = new InputFileParameter("AI_siteFilePath", (StringRange)object2);
        customerParameterImpl.addRestriction(this.manualIntegrationRestriction);
        arrayList.add(customerParameterImpl);
        this.addAllParametes(arrayList);
        this.clientParameters = arrayList;
        this.clientParameters.add(this.autoIntegrationParam);
        arrayList = new ArrayList();
        object2 = new YesNoCustomerParameter("AI_waitForOss");
        ((YesNoCustomerParameter)object2).setDefaultValue("YES");
        arrayList.add(object2);
        object3 = new StringRange(new Integer(1), new Integer(254));
        customerParameterImpl = new YesNoCustomerParameter("AI_ftpStoreReport");
        ((YesNoCustomerParameter)customerParameterImpl).setDefaultValue("NO");
        customerParameterImpl.addCustomerParameterListener(new FtpListener());
        arrayList.add(customerParameterImpl);
        object = new StringParameter("AI_ftpStoreReportAddress", (StringRange)object3);
        ((CustomerParameterImpl)object).addRestriction(this.disableFtpReport);
        arrayList.add(object);
        StringParameter stringParameter = new StringParameter("AI_ftpStoreReportFilePath", (StringRange)object3);
        stringParameter.addRestriction(this.disableFtpReport);
        arrayList.add(stringParameter);
        StringParameter stringParameter2 = new StringParameter("AI_ftpStoreReportUserName", stringRange);
        stringParameter2.addRestriction(this.disableFtpReport);
        arrayList.add(stringParameter2);
        StringParameter stringParameter3 = new StringParameter("AI_ftpStoreReportPassword", stringRange);
        stringParameter3.addRestriction(this.disableFtpReport);
        arrayList.add(stringParameter3);
        YesNoCustomerParameter yesNoCustomerParameter = new YesNoCustomerParameter("AI_clientStoreReport");
        yesNoCustomerParameter.setDefaultValue("YES");
        yesNoCustomerParameter.addCustomerParameterListener(new ClientListener());
        arrayList.add(yesNoCustomerParameter);
        StringParameter stringParameter4 = new StringParameter("AI_clientStoreReportFilePath", (StringRange)object3);
        stringParameter4.addRestriction(this.disableClientReport);
        arrayList.add(stringParameter4);
        this.addAllParametes(arrayList);
        this.otherParameters = arrayList;
    }

    private boolean isIpCapableBoards() {
        MoInstance moInstance;
        if (this.etmBoardProvider == null) {
            this.etmBoardProvider = (EtmBoardProvider)this.getRbs().getProvider(EtmBoardProvider.class);
        }
        return (moInstance = this.etmBoardProvider.getExchangeTerminalIpMoi()) != null;
    }

    public void checkConsistency() throws BemException {
        String string = this.autoIntegrationParam.getValue();
        if ("Obtain configuration data automatically".equals(string)) {
            this.checkConsistency(this.autoParameters);
        } else {
            this.checkConsistency(this.clientParameters);
        }
        this.checkConsistency(this.otherParameters);
    }

    public void checkConsistency(List list) throws BemException {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            CustomerParameter customerParameter = (CustomerParameter)e;
            if (customerParameter.isValidValue()) continue;
            throw new CustomerParameterException(customerParameter);
        }
    }

    public CustomerParameter getOamVidCP() {
        return this.vidParam;
    }

    public CustomerParameter getOamVlanCP() {
        return this.enableVlanParam;
    }

    public CustomerParameter getGigabitEthernetPortCP() {
        return this.gigabitEthernetPortParam;
    }

    private class ClientListener
    implements CustomerParameterListener {
        private ClientListener() {
        }

        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            if (parameterEvent.isValueChanged()) {
                String string = customerParameter.getValue();
                if (string.equals("YES")) {
                    AutoIntegrationCI.this.disableClientReport.setAccessLevel(3);
                } else {
                    AutoIntegrationCI.this.disableClientReport.setAccessLevel(1);
                }
            }
        }
    }

    private class FtpListener
    implements CustomerParameterListener {
        private FtpListener() {
        }

        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            if (parameterEvent.isValueChanged()) {
                String string = customerParameter.getValue();
                if (string.equals("YES")) {
                    AutoIntegrationCI.this.disableFtpReport.setAccessLevel(3);
                } else {
                    AutoIntegrationCI.this.disableFtpReport.setAccessLevel(1);
                }
            }
        }
    }

    private class AutoIntegrationListener
    implements CustomerParameterListener {
        private AutoIntegrationListener() {
        }

        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            if (parameterEvent.isValueChanged()) {
                String string = customerParameter.getValue();
                if (string.equals("Obtain configuration data automatically")) {
                    AutoIntegrationCI.this.autoIntegrationRestriction.setAccessLevel(3);
                    AutoIntegrationCI.this.manualIntegrationRestriction.setAccessLevel(1);
                } else {
                    AutoIntegrationCI.this.autoIntegrationRestriction.setAccessLevel(1);
                    AutoIntegrationCI.this.manualIntegrationRestriction.setAccessLevel(3);
                }
            }
        }
    }
}

